/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.common.VolGroupAdjuster;
import org.eclipse.aperi.TStorm.common.VolGroupGrapher;
import org.eclipse.aperi.TStorm.gui.DisplaysChartPopupInterface;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.TStorm.server.guireq.RespVolGroup;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.MutableShort;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class VolGroupTable
extends JPanel
implements GuiRequestor,
DisplaysChartPopupInterface,
HistoryChoiceInterface {
    private MegaTable table = new MegaTable();
    private RespVolGroup[] volGroups;
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private VolGroupAdjuster adjuster;
    private VolGroupGrapher grapher;
    private VolGroupTableModel vgModel;
    private TJCTableMouseAdapter myMouseListener = new selectListener();

    public VolGroupTable(GuiReportReq grr, ReportingDDI ddi) {
        this.grr = grr;
        this.ddi = ddi;
        GuiReportRequest request = new GuiReportRequest(grr);
        GuiClient.doRequest(this, request);
        this.setLayout(new BorderLayout());
        this.adjuster = new VolGroupAdjuster(grr);
        this.grapher = new VolGroupGrapher();
    }

    public void handleResponse(short status, Response response) {
        this.volGroups = status <= 4 ? (RespVolGroup[])response.responseData : null;
        int cnt = this.volGroups != null ? this.volGroups.length : 0;
        if (cnt == 0) {
            this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            this.ddi.jumpToChart = false;
            return;
        }
        this.adjuster.adjust(this.volGroups, false);
        this.volGroups = (RespVolGroup[])this.adjuster.getArray();
        this.vgModel = new VolGroupTableModel();
        this.table.setMouseListener(new selectListener());
        this.table.setFrozenColumns(this.adjuster.getFrozenColumns());
        this.table.setFrozenRows(this.adjuster.frozenRows);
        this.table.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.table.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.table.setCellRenderer(Date.class, TableCellRenderers.date);
        this.table.setCellRenderer(MutableShort.class, TableCellRenderers.percent);
        this.table.setBaseTableModel(this.vgModel);
        this.table.iconChanger = this.vgModel;
        this.table.setRowIcon(13, true);
        if (!this.adjuster.columnsAreCustomized()) {
            this.table.setAsFirstColumn(this.adjuster.firstColumn);
        }
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.table, "Center");
        if (this.ddi.jumpToChart) {
            this.ddi.jumpToChart = false;
            this.showJumpChart();
        }
    }

    public TJCTableMouseInterface getShowsPopup() {
        return this.myMouseListener;
    }

    public void showJumpChart() {
        ActionEvent event = new ActionEvent(this, 777, "STG1294T");
        ((ActionListener)((Object)this.myMouseListener)).actionPerformed(event);
    }

    public VolGroupTable(String a, String b, String c, String d) {
    }

    public Object[] getChoices(int reportType, int reportSubtype) {
        Object[] array = new Object[3];
        String[] messageArray = new String[]{"STG7530L", "STG7531L", "STG7539L", "STG6207L"};
        byte[] labelArray = new byte[]{1, 8, 1, 6};
        byte[] reportArray = new byte[]{1, 2, 5, 0};
        array[0] = messageArray;
        array[1] = labelArray;
        array[2] = reportArray;
        return array;
    }

    public Object[] getCharts(int reportType, int reportSubtype) {
        Object[] array = new Object[2];
        String[] messageArray = new String[]{"STG1294T"};
        byte[] reportArray = new byte[]{101};
        array[0] = messageArray;
        array[1] = reportArray;
        return array;
    }

    public int[] getGraphID(String selectedCommand) {
        int[] array = new int[2];
        array[0] = selectedCommand == "STG5556T" ? 101 : (selectedCommand == "STG1294T" ? 102 : (selectedCommand == "STG5105L" ? 1 : (selectedCommand == "STG5106L" ? 2 : (selectedCommand == "STG5109L" ? 5 : 0))));
        return array;
    }

    public class selectListener
    extends TJCTableMouseAdapter
    implements ActionListener {
        public boolean select(int viewRow, int viewCol) {
            return true;
        }

        public void doubleClick(int dataRow, int dataCol) {
            String title;
            String tooltip;
            RespVolGroup volNode = VolGroupTable.this.volGroups[dataRow];
            volNode.vgFreeSpace /= 512L;
            volNode.vgTotalSpace /= 512L;
            if (volNode.vgType == 2 || volNode.vgType == 4 || volNode.vgType == 5) {
                tooltip = MessageLog.getMessageNoID("SAG0032L");
                title = MessageLog.getMessageNoID("SAG0060I");
            } else if (volNode.vgType == 3 || volNode.vgType == 6) {
                if (volNode.rvgComputerOsType == 21) {
                    tooltip = MessageLog.getMessageNoID("SAG0063I");
                    title = MessageLog.getMessageNoID("SAG0028L");
                } else {
                    tooltip = MessageLog.getMessageNoID("SAG0053I");
                    title = MessageLog.getMessageNoID("SAG0060I");
                }
            } else if (volNode.vgType == 1) {
                tooltip = MessageLog.getMessageNoID("STG6101L");
                title = MessageLog.getMessageNoID("SAG0061I");
            } else {
                tooltip = MessageLog.getMessageNoID("STG6208L");
                title = MessageLog.getMessageNoID("SAG0028L");
            }
            tooltip = tooltip + Util.getString("COLON") + volNode.vgName;
            VolGroupTable.this.ddi.addObject(VolGroupTable.this.grr, "org.eclipse.aperi.TStorm.gui.VolGroupData", volNode, title, tooltip);
            volNode.vgFreeSpace *= 512L;
            volNode.vgTotalSpace *= 512L;
        }

        public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
            boolean rowsSelected = VolGroupTable.this.table.rowsSelected();
            JPopupMenu menu = new JPopupMenu();
            JMenuItem mi = menu.add(MessageLog.getMessageNoID("STG5556T"));
            mi.setActionCommand("STG5556T");
            mi.setEnabled(rowsSelected);
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG1294T"));
            mi.setActionCommand("STG1294T");
            if (((VolGroupTable)VolGroupTable.this).adjuster.volGroups == null) {
                mi.setEnabled(false);
            } else {
                mi.setEnabled(true);
            }
            mi.addActionListener(this);
            menu.addSeparator();
            mi = menu.add(MessageLog.getMessageNoID("STG5105L"));
            mi.setActionCommand("STG5105L");
            mi.setEnabled(rowsSelected);
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG5106L"));
            mi.setActionCommand("STG5106L");
            mi.setEnabled(rowsSelected);
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG5109L"));
            mi.setActionCommand("STG5109L");
            mi.setEnabled(rowsSelected);
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG6207L"));
            mi.setActionCommand("STG6207L");
            mi.setEnabled(rowsSelected);
            mi.addActionListener(this);
            menu.show(c, x, y);
            menu.requestFocus();
        }

        public void actionPerformed(ActionEvent e) {
            int[] rows;
            String actionCommand = e.getActionCommand();
            if (actionCommand == "STG1294T") {
                rows = new int[((VolGroupTable)VolGroupTable.this).adjuster.volGroups.length];
                for (int i = 0; i < rows.length; ++i) {
                    rows[i] = VolGroupTable.this.table.getDataRow(i);
                }
            } else {
                rows = VolGroupTable.this.table.getSelectedRows();
            }
            if (actionCommand == "STG1294T" || actionCommand == "STG5556T") {
                int[] ix = VolGroupTable.this.getGraphID(actionCommand);
                ((VolGroupTable)VolGroupTable.this).grr.chartSubtype = (byte)ix[0];
                VolGroupTable.this.grapher.createChart(VolGroupTable.this.grr, VolGroupTable.this.volGroups, rows, VolGroupTable.this.adjuster, VolGroupTable.this.ddi, null);
            } else {
                this.createHistory(rows, actionCommand);
            }
        }

        public void showDefaultChart(int dataRow) {
            int[] rows = new int[]{dataRow};
            this.createHistory(rows, "STG5105L");
        }

        private void createHistory(int[] rows, String actionCommand) {
            GuiReportReq newGrr = VolGroupTable.this.grapher.createHistory(VolGroupTable.this.grr, VolGroupTable.this.volGroups, rows, actionCommand, VolGroupTable.this.adjuster);
            VolGroupTable.this.ddi.addObject(VolGroupTable.this.grr, "org.eclipse.aperi.TStorm.gui.SpaceHistChart", newGrr, MessageLog.getMessageNoID("STG1279T"), newGrr.historyTitle, VolGroupTable.this);
        }

        public void addActionListener(ActionListener l) {
            VolGroupTable.this.listenerList.add(ActionListener.class, l);
        }
    }

    private class VolGroupTableModel
    extends BaseTableModel
    implements AskForRowIconInterface {
        VolGroupTableModel() {
            this.rowCount = ((VolGroupTable)VolGroupTable.this).adjuster.volGroups.length;
            this.columnNames = ((VolGroupTable)VolGroupTable.this).adjuster.columnNameList;
            this.commonAdjuster = VolGroupTable.this.adjuster;
        }

        public Object getTableDataItem(int row, int col) {
            return VolGroupTable.this.adjuster.getCellData(row, VolGroupTable.this.adjuster.translateColumn(col));
        }

        public boolean changeIcon(int row) {
            return row == 0 && VolGroupTable.this.adjuster.hasTotalsRow();
        }
    }
}

