/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.event.TreeExpansionEvent;
import org.eclipse.aperi.TStorm.common.Rank;
import org.eclipse.aperi.TStorm.gui.VolumeGroupTreeNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class VolumeGroupTreeLabel
extends BaseTreeNode
implements GuiRequestor {
    public NameList computer;
    public Rank rank;

    public VolumeGroupTreeLabel(NameList element) {
        String msgID;
        switch (element.nlID2) {
            case 2: {
                msgID = "STG6100L";
                break;
            }
            case 21: {
                msgID = "STG4502L";
                break;
            }
            case 8: {
                msgID = "SAG0031L";
                break;
            }
            case 25: 
            case 27: {
                msgID = "STG6213L";
                break;
            }
            default: {
                msgID = "STG6209L";
            }
        }
        this.setUserObject(MessageLog.getMessageNoID(msgID));
        this.computer = element;
    }

    public VolumeGroupTreeLabel(NameList element, Rank r) {
        String msgID;
        switch (element.nlID2) {
            case 2: {
                msgID = "STG6100L";
                break;
            }
            case 21: {
                msgID = "STG4502L";
                break;
            }
            case 8: {
                msgID = "SAG0031L";
                break;
            }
            case 25: 
            case 27: {
                msgID = "STG6213L";
                break;
            }
            default: {
                msgID = "STG6209L";
            }
        }
        this.setUserObject(MessageLog.getMessageNoID(msgID));
        this.computer = element;
        this.rank = r;
    }

    public void expand(TreeExpansionEvent event) {
        if (this.getChildCount() == 0) {
            Request request = new Request();
            if (this.rank != null) {
                GuiRequest.volumegroupList(request, this.rank.rankVolGroupID, this.getQualifier(), this.rank.rankID, this.computer.nlID);
            } else {
                GuiRequest.volumegroupList(request, this.computer.nlID, this.getQualifier());
            }
            GuiClient.doRequest(this, request);
        }
    }

    public void handleResponse(short status, Response response) {
        NameList vgList = (NameList)response.responseData;
        while (vgList != null) {
            this.add(this.makeNode(vgList));
            vgList = vgList.nlNext;
        }
        BaseTree.MyTree.nodeStructureChanged(this);
    }

    protected BaseTreeNode makeNode(NameList vg) {
        return new VolumeGroupTreeNode(this.computer, vg);
    }

    protected int getQualifier() {
        return -1;
    }
}

