/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.Component;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.TimestampWidget;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditorDialog;
import org.eclipse.aperi.TStorm.gui.rptfilter.WidgetListener;
import org.eclipse.aperi.common.MutableLong;

public class DateEditor
implements ValueEditor,
WidgetListener {
    private ColumnFilter filter;
    private TimestampWidget widget;
    private Component panel;
    private ValueEditorDialog dialog;

    public static TimestampWidget makeTimestampWidget(ColumnFilter pFilter, ColumnFilterValue value, WidgetListener listener) {
        long number;
        short scale;
        if (value == null) {
            scale = 1;
            Date date = new Date();
            number = date.getTime();
        } else if (pFilter.clfDataType == 3) {
            scale = 1;
            Date date = (Date)value.fvValue;
            number = date.getTime();
        } else {
            scale = 0;
            MutableLong offset = (MutableLong)value.fvValue;
            number = offset.value;
        }
        return new TimestampWidget(number / 1000L, scale, listener);
    }

    public static ColumnFilterValue makeValue(TimestampWidget pWidget, ColumnFilter pFilter) {
        Comparable obj;
        if (pWidget.scale == 0) {
            pFilter.clfDataType = (short)6;
            obj = new MutableLong(pWidget.number * 1000L);
        } else {
            pFilter.clfDataType = (short)3;
            obj = new Date(pWidget.number * 1000L);
        }
        return new ColumnFilterValue(obj);
    }

    public DateEditor(ColumnFilter pFilter, ValueEditorDialog pDialog) {
        this.filter = pFilter;
        this.dialog = pDialog;
        this.widget = DateEditor.makeTimestampWidget(this.filter, this.filter.clfValueList, this);
        this.panel = this.widget.makeSwitchable(false);
    }

    public Component getWholeComponent() {
        return this.panel;
    }

    public void getData() {
        this.filter.clfValueList = DateEditor.makeValue(this.widget, this.filter);
    }

    public void setFocus() {
        this.widget.setFocus();
    }

    public void valueChanged(int delta) {
        if (delta != 0) {
            this.dialog.setOKEnabled(delta > 0);
        }
    }

    public void notifyEnterStruck() {
    }
}

