/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.MutableComboBoxModel;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionDriver;
import org.eclipse.aperi.TStorm.gui.rptfilter.DateFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.EnumeratedFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.EnumeratedMultipleFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.FreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.IntegerFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.IntegerMultipleFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.SimpleMindedTable;
import org.eclipse.aperi.TStorm.gui.rptfilter.StorageFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.StorageMultipleFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.StringFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.StringMultipleFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.TableDataSource;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditorDialog;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportFilterDialog
implements TableDataSource,
ActionListener {
    private CustomReportDataAdjuster adjuster;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private static final short ENUMERATED = 0;
    private static final int[] VALID_OPERATORS = new int[]{12483, 16383, 15615, 15423, 15423, 15420, 15423};
    private static final int[] HAS_EDITOR = new int[]{192, 960, 192, 3135, 3135, 3135, 3135};
    private static final String[] OPERATOR_NAMES = new String[]{"=", "<>", "<=", "<", ">=", ">", "IN", "NOT IN", "LIKE", "NOT LIKE", "BETWEEN", "NOT BETWEEN", "IS NULL", "NOT NULL"};
    private static final String[] COLUMN_NAMES = new String[]{null, "STG3274L", "STG3275L", "STG3280L", "STG3281L", "GUI0046L"};
    private static final int DELETE_COLUMN = 0;
    private static final int COLUMN_COLUMN = 1;
    private static final int OPERATOR_COLUMN = 2;
    private static final int VALUE1_COLUMN = 3;
    private static final int VALUE2_COLUMN = 4;
    private static final int EDIT_COLUMN = 5;
    private static final char ADD = '+';
    private static final char DELETE_ALL = 'A';
    private static final char OK = 'K';
    private static final char CANCEL = 'X';
    private GuiReportReq grr;
    private int[] idMap;
    private ColumnDescriptor[] descriptorArray;
    private boolean[] columnUsed;
    private NameList[] columnComboElements;
    private NameList[] operatorComboElements;
    private TableRow[] filterSpecs;
    private int nFilters;
    private JCheckBox caseSensitive;
    private JRadioButton orFilters;
    private JButton addButton;
    private JButton okButton;
    private SimpleMindedTable table;
    private JDialog dialog;
    private String editButtonText;
    private String[] columnNames;
    private short operator;
    private int selectedIndex;
    private FreeForm invalidField;

    private static short getDataType(ColumnFilter filter) {
        short result = filter.clfColumn.cdValidValue != null ? (short)0 : filter.clfDataType;
        return result;
    }

    private static ColumnFilter newFilter(ColumnDescriptor descriptor) {
        ColumnFilter result = new ColumnFilter(descriptor);
        short dataType = ReportFilterDialog.getDataType(result);
        switch (dataType) {
            case 0: {
                result.clfCondition = (short)7;
                break;
            }
            case 1: {
                result.clfCondition = (short)9;
                break;
            }
            default: {
                result.clfCondition = (short)5;
            }
        }
        return result;
    }

    private static boolean hasEditButton(ColumnFilter filter) {
        int nShift;
        int mask;
        short dataType = ReportFilterDialog.getDataType(filter);
        return (HAS_EDITOR[dataType] & (mask = 1 << (nShift = filter.clfCondition - 1))) != 0;
    }

    private static boolean isMultiple(int operator) {
        boolean result = false;
        switch (operator) {
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                result = true;
            }
        }
        return result;
    }

    private static JButton makeDelIconButton() {
        String toolTipText = MessageLog.getMessageNoID("GUI0106L");
        ImageIcon icon = IconFactory.getRaggedBlackXIcon();
        JButton result = new JButton(icon);
        result.setMargin(new Insets(1, 0, 0, 0));
        result.setVerticalTextPosition(3);
        result.setHorizontalTextPosition(0);
        result.setToolTipText(toolTipText);
        return result;
    }

    private static FreeForm constructFreeForm(ColumnFilter filter, boolean adjustForRounding) {
        FreeForm result = null;
        short op = filter.clfCondition;
        if (op == 13 || op == 14) {
            return result;
        }
        short dataType = ReportFilterDialog.getDataType(filter);
        switch (dataType) {
            case 0: {
                if (ReportFilterDialog.isMultiple(op)) {
                    result = new EnumeratedMultipleFreeForm(filter);
                    break;
                }
                result = new EnumeratedFreeForm(filter);
                break;
            }
            case 1: {
                if (ReportFilterDialog.isMultiple(op)) {
                    result = new StringMultipleFreeForm(filter);
                    break;
                }
                result = new StringFreeForm(filter);
                break;
            }
            case 2: {
                if (ReportFilterDialog.isMultiple(op)) {
                    result = new IntegerMultipleFreeForm(filter);
                    break;
                }
                result = new IntegerFreeForm(filter);
                break;
            }
            case 5: {
                if (ReportFilterDialog.isMultiple(op)) {
                    result = new StorageMultipleFreeForm(filter);
                    break;
                }
                result = new StorageFreeForm(filter);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                result = new DateFreeForm(filter);
            }
        }
        if (result != null) {
            if (result instanceof StorageFreeForm) {
                ((StorageFreeForm)result).refresh(adjustForRounding);
            } else {
                ((FreeForm)result).refresh();
            }
        }
        return result;
    }

    private int idToSorted(int columnID) {
        int result = -1;
        try {
            result = this.idMap[columnID];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    private Vector getOperatorComboItems(ColumnFilter filter) {
        this.selectedIndex = -1;
        Vector<NameList> result = new Vector<NameList>(14);
        short dataType = ReportFilterDialog.getDataType(filter);
        int mask = VALID_OPERATORS[dataType];
        this.operator = 1;
        while (this.operator <= 14 && result != null) {
            if ((mask & 1) != 0) {
                if (this.operator == filter.clfCondition) {
                    this.selectedIndex = result.size();
                }
                result.add(this.operatorComboElements[this.operator - 1]);
            } else if (this.operator == filter.clfCondition) {
                result = null;
                continue;
            }
            mask >>= 1;
            this.operator = (short)(this.operator + 1);
        }
        return result;
    }

    private void makeOperatorComboFromItems(TableRow spec, Vector items) {
        TComboBox combo = new TComboBox(items);
        combo.setSelectedIndex(this.selectedIndex);
        combo.addItemListener(spec);
        spec.operatorCombo = combo;
    }

    private Vector getColumnComboItems(int selectedColumn) {
        this.selectedIndex = -1;
        int nColumns = this.columnUsed.length;
        Vector<NameList> result = new Vector<NameList>(nColumns);
        for (int j = 0; j < nColumns; ++j) {
            boolean include;
            if (j != selectedColumn) {
                include = !this.columnUsed[j];
            } else {
                include = true;
                this.selectedIndex = result.size();
            }
            if (!include) continue;
            result.add(this.columnComboElements[j]);
        }
        return result;
    }

    private void makeColumnComboFromItems(TableRow spec, Vector items) {
        spec.columnCombo = new TComboBox(items);
        spec.columnCombo.setSelectedIndex(this.selectedIndex);
        spec.columnCombo.addItemListener(spec);
    }

    private void createColumnCombos(int[] columnNumberArray) {
        for (int i = 0; i < this.nFilters; ++i) {
            Vector items = this.getColumnComboItems(columnNumberArray[i]);
            if (this.selectedIndex < 0) {
                throw new RuntimeException();
            }
            this.makeColumnComboFromItems(this.filterSpecs[i], items);
        }
    }

    private void makeFilterSpecDelButton(TableRow spec) {
        spec.deleteButton = ReportFilterDialog.makeDelIconButton();
        spec.deleteButton.addActionListener(spec);
    }

    private void handleEditButton(TableRow spec) {
        if (!ReportFilterDialog.hasEditButton(spec.filter)) {
            spec.editButton = null;
        } else {
            spec.editButton = new JButton(this.editButtonText);
            spec.editButton.addActionListener(spec);
        }
    }

    public ReportFilterDialog(GuiReportReq pGRR, CustomReportDataAdjuster adjuster) {
        int i;
        this.grr = pGRR;
        this.adjuster = adjuster;
        ColumnDescriptor descriptors = adjuster.getColumnDescriptors();
        int nColumns = 0;
        short highestColumnID = -1;
        ColumnDescriptor desc = descriptors;
        boolean adjustForRounding = false;
        while (desc != null) {
            ++nColumns;
            if (desc.cdID > highestColumnID) {
                highestColumnID = desc.cdID;
            }
            desc = desc.cdNext;
        }
        this.descriptorArray = new ColumnDescriptor[nColumns];
        this.columnComboElements = new NameList[nColumns];
        this.idMap = new int[highestColumnID + 1];
        Arrays.fill(this.idMap, -1);
        nColumns = 0;
        desc = descriptors;
        while (desc != null) {
            this.descriptorArray[nColumns] = desc;
            this.idMap[desc.cdID] = nColumns;
            NameList element = new NameList();
            element.nlName = desc.cdReportName;
            element.nlID = nColumns;
            this.columnComboElements[nColumns] = element;
            ++nColumns;
            desc = desc.cdNext;
        }
        this.editButtonText = MessageLog.getMessageNoID("GUI0105L");
        this.operatorComboElements = new NameList[14];
        for (int i2 = 1; i2 <= 14; ++i2) {
            NameList element = new NameList();
            element.nlName = OPERATOR_NAMES[i2 - 1];
            element.nlID = i2;
            this.operatorComboElements[i2 - 1] = element;
        }
        this.columnUsed = new boolean[nColumns];
        this.filterSpecs = new TableRow[nColumns];
        this.nFilters = 0;
        ColumnFilter[] columnFilters = this.grr.columnFilters;
        int max = columnFilters == null ? 0 : columnFilters.length;
        if (max == 0) {
            columnFilters = new ColumnFilter[]{ReportFilterDialog.newFilter(this.descriptorArray[0])};
            max = 1;
        }
        int[] columnNumberArray = new int[max];
        for (int i3 = 0; i3 < max; ++i3) {
            ColumnFilter filter = columnFilters[i3];
            String msgID = null;
            short columnID = filter.clfColumnID;
            int column = this.idToSorted(columnID);
            if (column < 0) {
                msgID = "STG3276E";
            } else if (this.columnUsed[column]) {
                msgID = "STG3277E";
            }
            if (msgID != null) {
                Object[] parms = new Object[]{new Integer(i3), new Integer(columnID)};
                String s = MessageLog.getMessageNoTS(msgID, parms);
                GuiUtil.displayErrorMessage(s);
                continue;
            }
            TableRow spec = new TableRow();
            spec.filter = (ColumnFilter)filter.clone();
            spec.filter.clfValueList = (ColumnFilterValue)Packer.unpack(spec.filter.clfValue);
            spec.filter.clfValue = null;
            spec.filter.clfColumn = this.descriptorArray[column];
            this.columnUsed[column] = true;
            columnNumberArray[this.nFilters] = column;
            Vector items = this.getOperatorComboItems(spec.filter);
            if (items == null) {
                msgID = "STG3278E";
            } else if (this.selectedIndex < 0) {
                msgID = "STG3279E";
                this.operator = filter.clfCondition;
            }
            if (msgID != null) {
                short dataType = ReportFilterDialog.getDataType(spec.filter);
                Object[] parms = new Object[]{new Integer(i3), new Integer(this.operator), new Integer(dataType)};
                String s = MessageLog.getMessageNoTS(msgID, parms);
                GuiUtil.displayErrorMessage(s);
                continue;
            }
            this.makeOperatorComboFromItems(spec, items);
            if (filter.clfCondition == 4 || filter.clfCondition == 5 || filter.clfCondition == 11) {
                adjustForRounding = true;
            }
            spec.lowerLimit = ReportFilterDialog.constructFreeForm(spec.filter, adjustForRounding);
            if (filter.clfCondition == 11 || filter.clfCondition == 12) {
                ColumnFilterValue secondValue;
                ColumnFilter copy = (ColumnFilter)spec.filter.clone();
                if (copy.clfValueList == null) {
                    secondValue = null;
                } else {
                    secondValue = copy.clfValueList.fvNext;
                    spec.filter.clfValueList.fvNext = null;
                }
                copy.clfValueList = secondValue;
                spec.upperLimit = ReportFilterDialog.constructFreeForm(copy, false);
            }
            this.makeFilterSpecDelButton(spec);
            this.handleEditButton(spec);
            this.filterSpecs[this.nFilters] = spec;
            ++this.nFilters;
        }
        this.createColumnCombos(columnNumberArray);
        String s = MessageLog.getMessageNoID("STG3287L");
        AbstractButton button = new JRadioButton(s);
        button.setSelected(!this.grr.orFilters);
        s = MessageLog.getMessageNoID("STG3273L");
        this.orFilters = new JRadioButton(s);
        this.orFilters.setSelected(this.grr.orFilters);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(button);
        buttonGroup.add(this.orFilters);
        JPanel subPanel = new JPanel(new GridBagLayout());
        s = MessageLog.getMessageNoID("STG3286L");
        subPanel.setBorder(GuiUtil.getBorder(s));
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 17;
        c.insets.left = 4;
        subPanel.add((Component)button, c);
        c.insets.bottom = 4;
        c.weightx = 1.0;
        c.gridheight = 0;
        subPanel.add((Component)this.orFilters, c);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)subPanel, "Center");
        s = MessageLog.getMessageNoID("GUI0043L");
        this.addButton = new JButton(s);
        if (this.nFilters >= nColumns) {
            this.addButton.setEnabled(false);
        }
        s = ReportingSelectionDriver.charToString('+');
        this.addButton.setActionCommand(s);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        c = new GridBagConstraints();
        c.insets.bottom = 5;
        c.anchor = 17;
        c.gridheight = 0;
        buttonPanel.add((Component)this.addButton, c);
        this.addButton.addActionListener(this);
        s = MessageLog.getMessageNoID("GUI0062L");
        button = new JButton(s);
        s = ReportingSelectionDriver.charToString('A');
        button.setActionCommand(s);
        c.weightx = 1.0;
        c.insets.left = 5;
        c.gridwidth = 0;
        buttonPanel.add((Component)button, c);
        button.addActionListener(this);
        subPanel = new JPanel(new GridBagLayout());
        c.insets.bottom = 0;
        c.insets.right = 0;
        c.gridheight = 1;
        subPanel.add((Component)buttonPanel, c);
        s = MessageLog.getMessageNoID("STG3282L");
        this.caseSensitive = new JCheckBox(s);
        this.caseSensitive.setSelected(!this.grr.filtersIgnoreCase);
        c.weightx = 0.0;
        c.gridheight = 0;
        subPanel.add((Component)this.caseSensitive, c);
        panel.add((Component)subPanel, "West");
        this.columnNames = new String[COLUMN_NAMES.length];
        for (int i4 = 0; i4 < COLUMN_NAMES.length; ++i4) {
            this.columnNames[i4] = COLUMN_NAMES[i4] != null ? MessageLog.getMessageNoID(COLUMN_NAMES[i4]) : "";
        }
        Dimension[] templateRow = new Dimension[this.columnNames.length];
        Component component = ReportFilterDialog.makeDelIconButton();
        templateRow[0] = component.getPreferredSize();
        Vector<NameList> vector = new Vector<NameList>(50);
        for (i = 0; i < this.columnComboElements.length; ++i) {
            vector.add(this.columnComboElements[i]);
        }
        component = new TComboBox((Vector)vector);
        templateRow[1] = component.getPreferredSize();
        vector.clear();
        for (i = 0; i < this.operatorComboElements.length; ++i) {
            vector.add(this.operatorComboElements[i]);
        }
        component = new TComboBox((Vector)vector);
        templateRow[2] = component.getPreferredSize();
        vector = null;
        ColumnFilter tempFilter = new ColumnFilter();
        StorageFreeForm temp = new StorageFreeForm(tempFilter);
        component = temp.getComponent();
        templateRow[3] = component.getPreferredSize();
        templateRow[4] = new Dimension(100, templateRow[3].height);
        temp = null;
        tempFilter = null;
        component = new JButton(this.editButtonText);
        templateRow[5] = component.getPreferredSize();
        component = null;
        this.table = new SimpleMindedTable(this, this.columnNames, nColumns, templateRow, 3);
        JScrollPane scrollPane = new JScrollPane(this.table);
        s = MessageLog.getMessageNoID("STG3169L");
        this.dialog = new JDialog(this.guiMain.getFrame(), s, true);
        Container pane = this.dialog.getContentPane();
        pane.setLayout(new GridBagLayout());
        c.fill = 1;
        c.anchor = 10;
        c.gridheight = 1;
        c.insets.top = 6;
        c.insets.left = 6;
        c.insets.right = 6;
        pane.add((Component)panel, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        pane.add((Component)scrollPane, c);
        buttonPanel = new JPanel(new GridBagLayout());
        s = MessageLog.getMessageNoID("GUI0113L");
        this.okButton = new JButton(s);
        s = ReportingSelectionDriver.charToString('K');
        this.okButton.setActionCommand(s);
        c.gridheight = 0;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.insets.top = 20;
        c.insets.bottom = 20;
        buttonPanel.add((Component)this.okButton, c);
        this.okButton.addActionListener(this);
        s = MessageLog.getMessageNoID("GUI0114L");
        button = new JButton(s);
        s = ReportingSelectionDriver.charToString('X');
        button.setActionCommand(s);
        c.gridwidth = 0;
        buttonPanel.add((Component)button, c);
        button.addActionListener(this);
        c.insets.top = 0;
        c.insets.bottom = 0;
        c.gridwidth = 0;
        pane.add((Component)buttonPanel, c);
    }

    public void show() {
        this.dialog.pack();
        this.table.fixNonWeighted();
        Dimension size = this.dialog.getSize();
        size.width = size.width * 21 / 20;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int targetHeight = screenSize.height * 9 / 10;
        if (size.height > targetHeight) {
            size.height = targetHeight;
        }
        if (size.width > screenSize.width) {
            size.width = screenSize.width;
        }
        this.dialog.setSize(size);
        GuiUtil.centerDialog(this.dialog);
        this.dialog.show();
    }

    private void undeceive(TableRow spec) {
        ColumnFilter copy = spec.upperLimit.getFilter();
        ColumnFilterValue obj = copy.clfValueList;
        if (spec.filter.clfValueList != null) {
            spec.filter.clfValueList.fvNext = obj;
        }
    }

    public int getRowCount() {
        return this.nFilters;
    }

    public Component getComponentAt(int row, int column) {
        Component result = null;
        TableRow spec = this.filterSpecs[row];
        if (spec == null) {
            return result;
        }
        switch (column) {
            case 0: {
                result = spec.deleteButton;
                break;
            }
            case 1: {
                result = spec.columnCombo;
                break;
            }
            case 2: {
                result = spec.operatorCombo;
                break;
            }
            case 3: {
                if (spec.lowerLimit == null) break;
                result = spec.lowerLimit.getComponent();
                break;
            }
            case 4: {
                if (spec.upperLimit == null) break;
                result = spec.upperLimit.getComponent();
                break;
            }
            case 5: {
                result = spec.editButton;
            }
        }
        return result;
    }

    private int rowFromSpec(TableRow spec) {
        int result;
        for (result = 0; result < this.nFilters && this.filterSpecs[result] != spec; ++result) {
        }
        return result;
    }

    private void newTableRow(ColumnDescriptor descriptor, TableRow spec) {
        ColumnFilter filter;
        spec.filter = filter = ReportFilterDialog.newFilter(descriptor);
        Vector items = this.getOperatorComboItems(filter);
        this.makeOperatorComboFromItems(spec, items);
        spec.lowerLimit = ReportFilterDialog.constructFreeForm(spec.filter, false);
        spec.upperLimit = null;
        this.handleEditButton(spec);
    }

    private void columnChanged(TableRow spec) {
        int oldColumn = this.idToSorted(spec.filter.clfColumnID);
        NameList obj = (NameList)spec.columnCombo.getSelectedItem();
        int newColumn = obj.nlID;
        if (newColumn == oldColumn) {
            return;
        }
        this.columnUsed[oldColumn] = false;
        this.columnUsed[newColumn] = true;
        for (int i = 0; i < this.nFilters; ++i) {
            TableRow other = this.filterSpecs[i];
            if (other == spec) continue;
            JComboBox combo = other.columnCombo;
            MutableComboBoxModel model = (MutableComboBoxModel)combo.getModel();
            model.removeElement(this.columnComboElements[newColumn]);
            int length = model.getSize();
            int j = 0;
            boolean going = true;
            while (going && j < length) {
                NameList element = (NameList)model.getElementAt(j);
                if (element.nlID < oldColumn) {
                    ++j;
                    continue;
                }
                going = false;
            }
            model.insertElementAt(this.columnComboElements[oldColumn], j);
        }
        ColumnDescriptor descriptor = this.descriptorArray[newColumn];
        this.newTableRow(descriptor, spec);
        this.table.refresh();
    }

    public void getData(TableRow spec) throws GeneralException {
        this.invalidField = spec.lowerLimit;
        if (this.invalidField == null) {
            return;
        }
        this.invalidField.getData();
        this.invalidField = spec.upperLimit;
        if (this.invalidField != null) {
            this.invalidField.getData();
            this.invalidField = null;
        }
    }

    public void getAdjustedData(TableRow spec) throws GeneralException {
        double adjAmtLow = 0.0;
        double adjAmtHigh = 0.0;
        switch (spec.filter.clfCondition) {
            case 11: 
            case 12: {
                adjAmtLow = StorageFreeForm.subAmt;
                adjAmtHigh = StorageFreeForm.addAmt;
                break;
            }
            case 4: 
            case 5: {
                adjAmtLow = StorageFreeForm.subAmt;
                break;
            }
            case 3: 
            case 6: {
                adjAmtLow = StorageFreeForm.addAmt;
            }
        }
        this.invalidField = spec.lowerLimit;
        if (this.invalidField == null) {
            return;
        }
        if (this.invalidField instanceof StorageFreeForm) {
            ((StorageFreeForm)this.invalidField).getAdjustedData(adjAmtLow);
        } else {
            this.invalidField.getData();
        }
        this.invalidField = spec.upperLimit;
        if (this.invalidField != null) {
            if (this.invalidField instanceof StorageFreeForm) {
                ((StorageFreeForm)this.invalidField).getAdjustedData(adjAmtHigh);
            } else {
                this.invalidField.getData();
            }
            this.invalidField = null;
        }
    }

    private void operatorChanged(TableRow spec) {
        ColumnFilter filter = spec.filter;
        NameList obj = (NameList)spec.operatorCombo.getSelectedItem();
        filter.clfCondition = (short)obj.nlID;
        if (filter.clfCondition == 13 || filter.clfCondition == 14) {
            filter.clfValueList = null;
        } else {
            try {
                this.getData(spec);
                if (filter.clfValueList != null && this.isSingleValueCondition(filter.clfCondition)) {
                    filter.clfValueList.fvNext = null;
                }
            }
            catch (GeneralException e) {
                filter.clfValueList = null;
            }
        }
        spec.lowerLimit = ReportFilterDialog.constructFreeForm(spec.filter, false);
        if (filter.clfCondition != 11 && filter.clfCondition != 12) {
            spec.upperLimit = null;
        } else {
            if (filter.clfValueList != null) {
                filter.clfValueList.fvNext = null;
            }
            ColumnFilterValue upperValue = null;
            if (spec.upperLimit != null) {
                upperValue = spec.upperLimit.getFilter().clfValueList;
            }
            ColumnFilter copy = (ColumnFilter)filter.clone();
            copy.clfValueList = upperValue;
            spec.upperLimit = ReportFilterDialog.constructFreeForm(copy, false);
        }
        this.handleEditButton(spec);
        this.table.refresh();
    }

    private boolean isSingleValueCondition(short condition) {
        return condition <= 6;
    }

    private void editButtonPressed(TableRow spec) {
        ColumnFilter filter;
        block10: {
            filter = spec.filter;
            try {
                spec.lowerLimit.getData();
            }
            catch (GeneralException ex) {
                filter.clfValueList = null;
            }
            if (spec.upperLimit != null) {
                try {
                    spec.upperLimit.getData();
                    this.undeceive(spec);
                }
                catch (GeneralException e) {
                    ColumnFilterValue firstValue = filter.clfValueList;
                    if (firstValue == null) break block10;
                    firstValue.fvNext = null;
                }
            }
        }
        ValueEditorDialog editor = new ValueEditorDialog(this.dialog, filter);
        boolean changed = editor.show();
        if (spec.upperLimit != null) {
            ColumnFilterValue value;
            if (filter.clfValueList == null) {
                value = null;
            } else {
                value = filter.clfValueList.fvNext;
                filter.clfValueList.fvNext = null;
            }
            ColumnFilter second = spec.upperLimit.getFilter();
            second.clfDataType = filter.clfDataType;
            second.clfValueList = value;
            if (changed) {
                spec.upperLimit.refresh();
            }
        }
        if (changed) {
            spec.lowerLimit.refresh();
        }
        this.table.refresh();
    }

    private void deleteButtonPressed(TableRow spec) {
        int source;
        LinkedList<MutableInteger> list = new LinkedList<MutableInteger>();
        int deleted = 0;
        int destination = 0;
        for (source = 0; source < this.nFilters; ++source) {
            TableRow other = this.filterSpecs[source];
            NameList obj = (NameList)other.columnCombo.getSelectedItem();
            if (other == spec) {
                this.columnUsed[obj.nlID] = false;
                deleted = source;
                continue;
            }
            this.filterSpecs[destination] = other;
            ++destination;
            list.add(new MutableInteger(obj.nlID));
        }
        if (destination == source) {
            throw new RuntimeException();
        }
        this.addButton.setEnabled(true);
        this.nFilters = destination;
        int[] columnNumberArray = new int[this.nFilters];
        destination = 0;
        for (MutableInteger obj : list) {
            columnNumberArray[destination] = obj.value;
            ++destination;
        }
        this.createColumnCombos(columnNumberArray);
        this.table.refresh();
        if (this.nFilters > 1) {
            if (deleted >= this.nFilters) {
                deleted = this.nFilters - 1;
            }
            this.filterSpecs[deleted].deleteButton.requestFocus();
        } else {
            this.addButton.requestFocus();
        }
    }

    private void deleteAllPressed() {
        if (this.nFilters == 0) {
            return;
        }
        this.nFilters = 0;
        this.addButton.setEnabled(true);
        Arrays.fill(this.columnUsed, false);
        this.table.refresh();
    }

    private void addPressed() {
        int i;
        int columnNumber = -1;
        int nAvailable = 0;
        for (i = 0; nAvailable < 2 && i < this.columnUsed.length; ++i) {
            if (this.columnUsed[i]) continue;
            if (columnNumber < 0) {
                columnNumber = i;
            }
            ++nAvailable;
        }
        if (columnNumber < 0) {
            throw new RuntimeException();
        }
        this.columnUsed[columnNumber] = true;
        if (nAvailable <= 1) {
            this.addButton.setEnabled(false);
        }
        for (i = 0; i < this.nFilters; ++i) {
            MutableComboBoxModel model = (MutableComboBoxModel)this.filterSpecs[i].columnCombo.getModel();
            int n = model.getSize();
            boolean going = true;
            while (going && n > 0) {
                NameList element = (NameList)model.getElementAt(--n);
                if (element.nlID != columnNumber) continue;
                going = false;
            }
            model.removeElementAt(n);
        }
        TableRow spec = new TableRow();
        Vector items = this.getColumnComboItems(columnNumber);
        this.makeColumnComboFromItems(spec, items);
        ColumnDescriptor descriptor = this.descriptorArray[columnNumber];
        this.newTableRow(descriptor, spec);
        this.makeFilterSpecDelButton(spec);
        this.filterSpecs[this.nFilters] = spec;
        ++this.nFilters;
        this.table.refresh();
    }

    private void okPressed() {
        ColumnFilter filter;
        int i;
        GeneralException exception = null;
        TableRow spec = null;
        List badBetweens = null;
        try {
            for (i = 0; i < this.nFilters; ++i) {
                spec = this.filterSpecs[i];
                this.getAdjustedData(spec);
                if (spec.upperLimit == null) continue;
                this.undeceive(spec);
                badBetweens = this.validateBetween(this.filterSpecs[i], badBetweens);
            }
        }
        catch (GeneralException e) {
            exception = e;
        }
        if (exception != null) {
            GuiUtil.displayException(exception);
            if (this.invalidField != null) {
                JComponent component = this.invalidField instanceof EnumeratedMultipleFreeForm || this.invalidField instanceof DateFreeForm ? spec.editButton : (JComponent)this.invalidField.getComponent();
                component.requestFocus();
            }
            return;
        }
        if (badBetweens != null) {
            if (!GuiUtil.getConfirmation(this.dialog, "STG3284L", "STG3285T", true)) {
                spec = (TableRow)badBetweens.get(0);
                spec.lowerLimit.getComponent().requestFocus();
                return;
            }
            for (i = badBetweens.size() - 1; i >= 0; --i) {
                ColumnFilterValue value2;
                spec = (TableRow)badBetweens.get(i);
                filter = spec.filter;
                ColumnFilterValue value1 = filter.clfValueList;
                filter.clfValueList = value2 = value1.fvNext;
                value2.fvNext = value1;
                value1.fvNext = null;
            }
        }
        if (this.nFilters == 0) {
            this.grr.columnFilters = null;
        } else {
            this.grr.columnFilters = new ColumnFilter[this.nFilters];
            for (i = 0; i < this.nFilters; ++i) {
                filter = this.filterSpecs[i].filter;
                filter.clfValue = (ColumnFilterValue[])Packer.pack(filter.clfValueList);
                filter.clfValueList = null;
                this.grr.columnFilters[i] = filter;
            }
        }
        this.grr.filtersIgnoreCase = !this.caseSensitive.isSelected();
        this.grr.orFilters = this.orFilters.isSelected();
        this.dialog.dispose();
    }

    private List validateBetween(TableRow filterSpec, List badBetweens) {
        boolean dataIsValid;
        ColumnFilter filter = filterSpec.filter;
        ColumnFilterValue valueList = filter.clfValueList;
        Comparable value1 = (Comparable)valueList.fvValue;
        Comparable value2 = (Comparable)valueList.fvNext.fvValue;
        if (filter.clfDataType != 1 || this.caseSensitive.isSelected()) {
            dataIsValid = value1.compareTo(value2) <= 0;
        } else {
            String s1 = (String)((Object)value1);
            String s2 = (String)((Object)value2);
            boolean bl = dataIsValid = s1.compareToIgnoreCase(s2) <= 0;
        }
        if (!dataIsValid) {
            if (badBetweens == null) {
                badBetweens = new ArrayList<TableRow>();
            }
            badBetweens.add(filterSpec);
        }
        return badBetweens;
    }

    public void actionPerformed(ActionEvent event) {
        char cmd = event.getActionCommand().charAt(0);
        switch (cmd) {
            case '+': {
                this.addPressed();
                break;
            }
            case 'A': {
                this.deleteAllPressed();
                break;
            }
            case 'K': {
                this.okPressed();
                break;
            }
            case 'X': {
                this.dialog.dispose();
            }
        }
    }

    private class TableRow
    implements ActionListener,
    ItemListener {
        public ColumnFilter filter;
        public JButton deleteButton;
        public JComboBox columnCombo;
        public JComboBox operatorCombo;
        public FreeForm lowerLimit;
        public FreeForm upperLimit;
        public JButton editButton;

        private TableRow() {
        }

        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() != 1) {
                return;
            }
            if (event.getSource() == this.operatorCombo) {
                ReportFilterDialog.this.operatorChanged(this);
                this.operatorCombo.requestFocus();
            } else {
                ReportFilterDialog.this.columnChanged(this);
                this.columnCombo.requestFocus();
            }
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.editButton) {
                ReportFilterDialog.this.editButtonPressed(this);
            } else {
                ReportFilterDialog.this.deleteButtonPressed(this);
            }
        }
    }
}

