/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.backend;

import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.server.agentreq.ProbeDefResp;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class ProbeLock {
    public static final String RESOURCE_TYPE = "PROBE";

    public static synchronized LinkedInteger lock(ProbeDefResp def, NasFiler local) {
        NasFiler head;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ProbeLock.class.getName(), "lock", "def, local");
        }
        if (def.pdProbeLocal) {
            head = local;
        } else {
            head = def.pdNasFiler;
            if (head == null) {
                MessageLog.logMessage("GEN0405E");
                LinkedInteger traceResult = null;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(ProbeLock.class.getName(), "lock", traceResult);
                }
                return traceResult;
            }
        }
        LinkedInteger result = null;
        boolean ok = true;
        NasFiler filer = head;
        while (ok && filer != null) {
            String lockID = Integer.toString(filer.nfComputerID);
            ok = LockManager.lock((short)0, RESOURCE_TYPE, lockID, (byte)1, false);
            if (ok) {
                LinkedInteger key = new LinkedInteger(filer.nfComputerID);
                key.next = result;
                result = key;
                filer = filer.nfNext;
                continue;
            }
            if (Constants.isDiskArray(filer.nfOSType)) {
                MessageLog.logMessage("GEN0407E", filer.nfName, filer.nfAlias);
            } else {
                MessageLog.logMessage("GEN0406E", filer.nfName);
            }
            ProbeLock.unlock(result);
            result = null;
        }
        LinkedInteger traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ProbeLock.class.getName(), "lock", traceResult);
        }
        return traceResult;
    }

    public static synchronized void unlock(LinkedInteger keys) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ProbeLock.class.getName(), "unlock", "keys");
        }
        while (keys != null) {
            String lockID = Integer.toString(keys.value);
            LockManager.unLock((short)0, RESOURCE_TYPE, lockID);
            keys = keys.next;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ProbeLock.class.getName(), "unlock");
        }
    }
}

