/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.backend;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class SaferServerSocket
extends ServerSocket {
    public SaferServerSocket(int port) throws IOException {
        super(port);
    }

    public SaferServerSocket(int port, int backlog) throws IOException {
        super(port, backlog);
    }

    public SaferServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        super(port, backlog, bindAddr);
    }

    public Socket accept() throws IOException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(SaferServerSocket.class.getName(), "accept", "");
        }
        Socket result = null;
        int exceptions = 0;
        Object[] args = null;
        while (result == null && !this.isClosed()) {
            try {
                result = super.accept();
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(SaferServerSocket.class.getName(), "accept", e);
                }
                if (args == null) {
                    args = new Object[]{e.getMessage()};
                }
                MessageLog.logMessage("GEN0004E", args);
                if (++exceptions < 10) continue;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(SaferServerSocket.class.getName(), "accept");
                }
                throw e;
            }
        }
        Socket traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(SaferServerSocket.class.getName(), "accept", traceResult);
        }
        return traceResult;
    }

    public void close() {
        try {
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(SaferServerSocket.class.getName(), "close");
        }
    }
}

