/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.backend;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.NestableException;

public class SectionedConfigParser {
    private String fileName;
    private String[] sectionNames;
    private String[][][] keywordValues;
    private BufferedReader reader;
    private StreamTokenizer tokenizer;
    private String[] keyValuePair = new String[2];
    private String currentSection;
    public static final int EOF = -1;

    public SectionedConfigParser(String fileName, String[] sectionNames, String[][][] keywordValues) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(SectionedConfigParser.class.getName(), "SectionedConfigParser", "fileName, sectionNames, keywordValues");
        }
        this.fileName = fileName;
        this.sectionNames = sectionNames;
        this.keywordValues = keywordValues;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(SectionedConfigParser.class.getName(), "SectionedConfigParser", e);
            }
            this.throwException("GEN0131E", fileName, null);
        }
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.wordChars(47, 47);
        this.tokenizer.wordChars(92, 92);
        this.tokenizer.wordChars(46, 46);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.commentChar(35);
        this.tokenizer.quoteChar(34);
        this.tokenizer.quoteChar(39);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.lowerCaseMode(false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(SectionedConfigParser.class.getName(), "SectionedConfigParser");
        }
    }

    public int nextSection() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(SectionedConfigParser.class.getName(), "nextSection", "");
        }
        try {
            while (this.nextToken(false, 91) != -1) {
                this.nextToken(true, -3);
                this.currentSection = this.tokenizer.sval;
                this.nextToken(true, 93);
                for (int i = 0; i < this.sectionNames.length; ++i) {
                    if (!this.currentSection.equalsIgnoreCase(this.sectionNames[i])) continue;
                    this.parseSection(this.keywordValues[i]);
                    int traceResult = i;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit(SectionedConfigParser.class.getName(), "nextSection", traceResult);
                    }
                    return traceResult;
                }
                this.throwException("GEN0132E", this.currentSection, null);
            }
            int traceResult = -1;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(SectionedConfigParser.class.getName(), "nextSection", traceResult);
            }
            return traceResult;
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(SectionedConfigParser.class.getName(), "nextSection", e);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(SectionedConfigParser.class.getName(), "nextSection");
            }
            throw e;
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(SectionedConfigParser.class.getName(), "nextSection", e);
            }
            Object[] args = new Object[]{this.fileName};
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(SectionedConfigParser.class.getName(), "nextSection");
            }
            throw new NestableException("GEN0133E", args, e);
        }
    }

    public void close() {
        block5: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry(SectionedConfigParser.class.getName(), "close", "");
            }
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException ignored) {
                    if (!TraceLogger.enableTrace) break block5;
                    TraceLogger.exception(SectionedConfigParser.class.getName(), "close", ignored);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(SectionedConfigParser.class.getName(), "close");
        }
    }

    private void parseSection(String[][] keywordArray) throws LocalizableException, IOException {
        while (this.getKeyValuePair()) {
            int i;
            for (i = 0; i < keywordArray.length; ++i) {
                if (!this.keyValuePair[0].equalsIgnoreCase(keywordArray[i][0])) continue;
                keywordArray[i][1] = this.keyValuePair[1];
                break;
            }
            if (i < keywordArray.length) continue;
            this.throwException("GEN0134E", this.currentSection, this.keyValuePair[0]);
        }
    }

    private int nextToken(boolean tokenRequired, int expectedTokenType) throws LocalizableException, IOException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(SectionedConfigParser.class.getName(), "nextToken", "tokenRequired, expectedTokenType");
        }
        if (this.tokenizer.ttype != -1) {
            this.tokenizer.nextToken();
        }
        if (this.tokenizer.ttype == -1) {
            if (tokenRequired) {
                this.throwException("GEN0135E", null, null);
            }
        } else {
            if (this.tokenizer.ttype == 34 || this.tokenizer.ttype == 39) {
                this.tokenizer.ttype = -3;
            }
            if (expectedTokenType != 0 && expectedTokenType != this.tokenizer.ttype) {
                this.throwException("GEN0134E", this.currentSection, this.tokenizer.toString());
            }
        }
        int traceResult = this.tokenizer.ttype;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(SectionedConfigParser.class.getName(), "nextToken", traceResult);
        }
        return traceResult;
    }

    private boolean getKeyValuePair() throws LocalizableException, IOException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(SectionedConfigParser.class.getName(), "getKeyValuePair", "");
        }
        if (this.nextToken(false, 0) == -1) {
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(SectionedConfigParser.class.getName(), "getKeyValuePair", traceResult);
            }
            return traceResult;
        }
        if (this.tokenizer.ttype == 91) {
            this.tokenizer.pushBack();
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(SectionedConfigParser.class.getName(), "getKeyValuePair", traceResult);
            }
            return traceResult;
        }
        if (this.tokenizer.ttype != -3) {
            this.throwException("GEN0136E", this.tokenizer.toString(), null);
        }
        this.keyValuePair[0] = this.tokenizer.sval.toLowerCase();
        this.nextToken(true, 61);
        this.nextToken(true, -3);
        this.keyValuePair[1] = this.tokenizer.sval;
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(SectionedConfigParser.class.getName(), "getKeyValuePair", traceResult);
        }
        return traceResult;
    }

    private void throwException(String msgID, String parm1, String parm2) throws LocalizableException {
        Object[] args = new Object[]{this.fileName, parm1, parm2};
        throw new LocalizableException(msgID, args);
    }
}

