/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class ConfigParser {
    public String configFile;
    private StreamTokenizer tokenizer;
    private Map map;
    private BufferedReader reader;

    public ConfigParser(String configFile) {
        this.configFile = configFile;
    }

    private void initializeTokenizer() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ConfigParser.class.getName(), "initializeTokenizer", "");
        }
        FileReader raw = null;
        try {
            raw = new FileReader(this.configFile);
        }
        catch (FileNotFoundException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(ConfigParser.class.getName(), "initializeTokenizer", e);
            }
            MessageLog.logException("GEN0029E", e);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(ConfigParser.class.getName(), "initializeTokenizer");
            }
            throw new GeneralException();
        }
        this.map = new HashMap();
        this.reader = new BufferedReader(raw);
        this.tokenizer = new StreamTokenizer(this.reader);
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.wordChars(47, 47);
        this.tokenizer.wordChars(92, 92);
        this.tokenizer.wordChars(46, 46);
        this.tokenizer.wordChars(45, 45);
        this.tokenizer.wordChars(95, 95);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.commentChar(35);
        this.tokenizer.quoteChar(34);
        this.tokenizer.quoteChar(39);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.lowerCaseMode(false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ConfigParser.class.getName(), "initializeTokenizer");
        }
    }

    private int nextToken(boolean tokenRequired, int expectedTokenType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ConfigParser.class.getName(), "nextToken", "tokenRequired, expectedTokenType");
        }
        if (this.tokenizer.ttype != -1) {
            try {
                this.tokenizer.nextToken();
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(ConfigParser.class.getName(), "nextToken", e);
                }
                MessageLog.logException("AGT0035W", (Exception)e, this.configFile);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(ConfigParser.class.getName(), "nextToken");
                }
                throw new GeneralException();
            }
        }
        if (this.tokenizer.ttype == -1) {
            if (tokenRequired) {
                MessageLog.logMessage("AGT0037W", this.configFile);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(ConfigParser.class.getName(), "nextToken");
                }
                throw new GeneralException();
            }
        } else {
            if (this.tokenizer.ttype == 34 || this.tokenizer.ttype == 39) {
                this.tokenizer.ttype = -3;
            }
            if (expectedTokenType != 0 && expectedTokenType != this.tokenizer.ttype) {
                MessageLog.logMessage("AGT0045E", this.configFile, new Integer(this.tokenizer.lineno()));
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(ConfigParser.class.getName(), "nextToken");
                }
                throw new GeneralException();
            }
        }
        int traceResult = this.tokenizer.ttype;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ConfigParser.class.getName(), "nextToken", traceResult);
        }
        return traceResult;
    }

    private boolean getKeyValuePair(String[] keyValuePair) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ConfigParser.class.getName(), "getKeyValuePair", "keyValuePair");
        }
        if (this.nextToken(false, 0) == -1) {
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(ConfigParser.class.getName(), "getKeyValuePair", traceResult);
            }
            return traceResult;
        }
        if (this.tokenizer.ttype != -3) {
            MessageLog.logMessage("AGT0045E", this.configFile, new Integer(this.tokenizer.lineno()));
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(ConfigParser.class.getName(), "getKeyValuePair");
            }
            throw new GeneralException();
        }
        keyValuePair[0] = this.tokenizer.sval.toLowerCase();
        this.nextToken(true, 61);
        this.nextToken(true, -3);
        keyValuePair[1] = this.tokenizer.sval;
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ConfigParser.class.getName(), "getKeyValuePair", traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readValues(String[][] variables) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ConfigParser.class.getName(), "readValues", "variables");
        }
        this.initializeTokenizer();
        for (int i = 0; i < variables.length; ++i) {
            String miniscule = variables[i][0].toLowerCase();
            this.map.put(miniscule, variables[i]);
        }
        String[] pair = new String[2];
        try {
            while (this.getKeyValuePair(pair)) {
                String[] v = (String[])this.map.get(pair[0]);
                if (v == null) continue;
                v[1] = pair[1];
            }
        }
        finally {
            block12: {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    if (!TraceLogger.enableTrace) break block12;
                    TraceLogger.exception(ConfigParser.class.getName(), "readValues", e);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ConfigParser.class.getName(), "readValues");
        }
    }
}

