/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.Timer;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class Unzip {
    private final String DEFAULT_PERM = "755";
    boolean bInterrupted = false;
    private Process process = null;

    private void ensureDirectoryExists(String directory) throws LocalizableException {
        File file;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Unzip.class.getName(), "ensureDirectoryExists", "directory");
        }
        if ((file = new File(directory)).exists()) {
            if (file.isDirectory()) {
                return;
            }
            Object[] args = new Object[]{directory};
            throw new LocalizableException("INS2078E", args);
        }
        String parentDir = file.getParent();
        if (parentDir != null) {
            this.ensureDirectoryExists(parentDir);
        }
        file.mkdir();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Unzip.class.getName(), "ensureDirectoryExists");
        }
    }

    private boolean doCopy(InputStream in, OutputStream out, String inFileName, String outFileName) {
        boolean result = false;
        byte[] buf = new byte[2000];
        boolean writing = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Unzip.class.getName(), "doCopy", "in,out,inFileName,outFileName");
        }
        try {
            int bytesRead;
            while ((bytesRead = in.read(buf)) > 0) {
                writing = true;
                out.write(buf, 0, bytesRead);
                writing = false;
            }
            writing = true;
            out.close();
            result = true;
        }
        catch (IOException e) {
            String msgID;
            Object[] parms = new Object[1];
            if (writing) {
                msgID = "GEN0152E";
                parms[0] = outFileName;
            } else {
                msgID = "GEN0209E";
                parms[0] = inFileName;
            }
            MessageLog.logException(msgID, (Exception)e, parms);
        }
        if (!result) {
            try {
                out.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Unzip.class.getName(), "doCopy");
        }
        return result;
    }

    private ZipEntry nextEntry(ZipInputStream in, MutableBoolean status) {
        ZipEntry result = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Unzip.class.getName(), "nextEntry", "in,status");
        }
        try {
            result = in.getNextEntry();
        }
        catch (IOException e) {
            MessageLog.logException("GEN0552E", e);
            status.value = false;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Unzip.class.getName(), "nextEntry");
        }
        return result;
    }

    public boolean unZIP(String strZipFileName, String strOutDir) {
        return this.unZIP(strZipFileName, strOutDir, "755", false);
    }

    public boolean unZIP(String strZipFileName, String strOutDir, String strPerm, boolean bDoNotSetPermOnExistFiles) {
        ZipEntry entry;
        ZipInputStream in = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Unzip.class.getName(), "unZIP", "strZipFileName,strOutDir,strPerm, bDoNotSetPermOnExistFiles");
        }
        try {
            in = new ZipInputStream(new FileInputStream(strZipFileName));
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
            return false;
        }
        boolean bWindowsOS = Unzip.isWindows();
        MutableBoolean status = new MutableBoolean(true);
        while (status.value && (entry = this.nextEntry(in, status)) != null) {
            String name = entry.getName();
            if (bWindowsOS && (name.length() <= 1 || name.charAt(0) != ':')) {
                name = strOutDir + "\\" + name;
            }
            if (!(bWindowsOS || name.length() > 0 && name.charAt(0) == '/')) {
                name = strOutDir + "/" + name;
            }
            if (entry.isDirectory()) {
                name = name.substring(0, name.length() - 1);
                try {
                    this.ensureDirectoryExists(name);
                }
                catch (Exception e) {
                    System.out.println(e);
                    status.value = false;
                }
                continue;
            }
            int pos = name.lastIndexOf(47);
            if (pos > 0) {
                String dirName = name.substring(0, pos);
                try {
                    this.ensureDirectoryExists(dirName);
                }
                catch (Exception e) {
                    System.out.println(e);
                    status.value = false;
                    continue;
                }
            }
            FileOutputStream out = null;
            boolean bFileExist = true;
            if (bDoNotSetPermOnExistFiles) {
                bFileExist = new File(name).exists();
            }
            try {
                out = new FileOutputStream(name);
            }
            catch (IOException e) {
                MessageLog.logException("GEN0036E", e);
            }
            if (out == null) {
                status.value = false;
                continue;
            }
            status.value = this.doCopy(in, out, strZipFileName, name);
            if (status.value) {
                try {
                    if (!bDoNotSetPermOnExistFiles || !bFileExist) {
                        this.makeExecutable(name, strPerm);
                    }
                }
                catch (Exception e) {
                    System.out.println(e);
                    status.value = false;
                }
            }
            if (!status.value) continue;
            File file = new File(name);
            file.setLastModified(entry.getTime());
        }
        try {
            in.close();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Unzip.class.getName(), "unZIP");
        }
        return status.value;
    }

    private boolean makeExecutable(String strFileName, String strPermission) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Unzip.class.getName(), "makeExecutable", "strFileName,strPermission");
        }
        if (System.getProperty("os.name").startsWith("Win")) {
            return true;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Unzip.class.getName(), "makeExecutable");
        }
        if (strPermission != null && strPermission.trim().length() > 0) {
            String[] strCommand = new String[]{"sh", "-c", "chmod " + strPermission + " \"" + this.AddEscapeChar(strFileName, '$') + "\""};
            return this.executeAction(strCommand);
        }
        return true;
    }

    private String AddEscapeChar(String strFileName, char cEscapeChar) {
        int iPrevPos = 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Unzip.class.getName(), "AddEscapeChar", "strFileName,cEscapeChar");
        }
        while ((iPrevPos = strFileName.indexOf(cEscapeChar, iPrevPos)) != -1) {
            strFileName = strFileName.substring(0, iPrevPos) + "\\" + strFileName.substring(iPrevPos);
            iPrevPos += 2;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Unzip.class.getName(), "AddEscapeChar");
        }
        return strFileName;
    }

    private boolean executeAction(String[] strCommandArr) {
        int iTimeOut = 60;
        Timer timer = null;
        this.bInterrupted = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Unzip.class.getName(), "executeAction", "strCommandArr");
        }
        if (strCommandArr == null || strCommandArr.length == 0 || strCommandArr[0].trim().length() == 0) {
            return false;
        }
        try {
            String strIn;
            DateFormat df = DateFormat.getDateTimeInstance(3, 1);
            String strInstallDateTime = df.format(new Date());
            this.process = strCommandArr.length == 1 ? Runtime.getRuntime().exec(strCommandArr[0]) : Runtime.getRuntime().exec(strCommandArr);
            BufferedReader in = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            BufferedReader err = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
            Object out = null;
            try {
                strIn = "";
                while ((strIn = in.readLine()) != null) {
                    System.out.println(strIn);
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                strIn = "";
                while ((strIn = err.readLine()) != null) {
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            strInstallDateTime = df.format(new Date());
            TimerTask timerTask = new TimerTask();
            timer = new Timer(iTimeOut * 1000, timerTask);
            timer.setRepeats(false);
            timer.start();
            strInstallDateTime = df.format(new Date());
            this.process.waitFor();
            strInstallDateTime = df.format(new Date());
            if (timer != null) {
                strInstallDateTime = df.format(new Date());
                timer.stop();
                strInstallDateTime = df.format(new Date());
            }
            try {
                in.close();
                err.close();
            }
            catch (IOException ioe) {
                System.out.println("IOException: " + ioe.getMessage());
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Unzip.class.getName(), "executeAction");
        }
        if (this.bInterrupted) {
            return true;
        }
        if (this.process == null || this.process.exitValue() != 0) {
            String strCommand = "";
            for (int i = 0; i < strCommandArr.length; ++i) {
                strCommand = strCommand + strCommandArr[i] + " ";
            }
            return false;
        }
        return true;
    }

    private void sendInterrupt() {
        if (this.process != null) {
            this.bInterrupted = true;
            this.process.destroy();
        }
        Thread.currentThread().interrupt();
    }

    public static void main(String[] args) {
        Unzip unZIP = new Unzip();
        boolean bWindowsOS = Unzip.isWindows();
        int iMinArgs = 4;
        if (bWindowsOS) {
            iMinArgs = 2;
        }
        if (args.length < iMinArgs) {
            Unzip.printUsage();
            return;
        }
        if (bWindowsOS) {
            unZIP.unZIP(args[0], args[1]);
        } else {
            boolean bDoNotSetPermOnExistFiles = false;
            if (args[3].trim().compareToIgnoreCase("true") == 0) {
                bDoNotSetPermOnExistFiles = true;
            }
            unZIP.unZIP(args[0], args[1], args[2], bDoNotSetPermOnExistFiles);
        }
    }

    static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Win");
    }

    public static void printUsage() {
        boolean bWindowsOS = Unzip.isWindows();
        if (!bWindowsOS) {
            System.out.println("Usage: unzip <zipFileName> <ExtractLocation> <Permission> <DoNotSetPermOnExistingFiles>");
        } else {
            System.out.println("Usage: unzip <zipFileName> <ExtractLocation>");
        }
        System.out.println("       zipFileName: This is the name of the zip file you want to unzip.");
        System.out.println("       ExtractLocation: Location where you want to unzip files.");
        if (!bWindowsOS) {
            System.out.println("       Permission: Unix permission format. e.g. 755");
            System.out.println("       DoNotSetPermOnExistingFiles: True if you do not want to change permission on existing files else False");
        }
    }

    private class TimerTask
    implements ActionListener {
        private TimerTask() {
        }

        public void actionPerformed(ActionEvent e) {
            Unzip.this.sendInterrupt();
        }
    }
}

