/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.api;

import java.sql.SQLException;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.DeviceAgent;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.subagent.scanner.interfaces.IScanner;

public abstract class LogFileHandler
extends org.eclipse.aperi.sanmgmt.logging.LogFileHandler {
    private static final String className = LogFileHandler.class.getName();
    private static DBConnection _dbc = null;
    private static DBConnPoolDataSource ds = null;
    private static IScanner scanner = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReadLogResponse getLog(int agentID, String name, byte direction, LogFilePos position, int linesDesired) {
        String methodName = "getLog";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        ReadLogResponse rlr = new ReadLogResponse();
        try {
            scanner = LogFileHandler.getAgentProxy(agentID);
            rlr = scanner.getLog(name, direction, position, linesDesired);
        }
        catch (Exception e) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
            }
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        return rlr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReadLogResponse getLog(int agentID, String name, byte direction, LogFilePos position, String search, int linesDesired) {
        String methodName = "getLog";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
        }
        ReadLogResponse rlr = new ReadLogResponse();
        try {
            scanner = LogFileHandler.getAgentProxy(agentID);
            rlr = scanner.getLog(name, direction, position, search, linesDesired);
        }
        catch (Exception e) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, className, methodName, e);
            }
        }
        finally {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
        }
        return rlr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static IScanner getAgentProxy(int agentID) {
        block17: {
            String methodName;
            block14: {
                methodName = "getAgentProxy";
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_ENTRY, className, methodName);
                }
                ds = DBConnPoolDataSource.getInstance();
                _dbc = (DBConnection)ds.getPooledConnection();
                DeviceAgent da = new DeviceAgent();
                da.setDeviceAgentId(agentID);
                da.retrieve(_dbc);
                int hostID = da.getHostId();
                int port = da.getPort();
                String version = da.getVersion();
                Host host = null;
                host = new Host();
                host.setComputerId(hostID);
                host.retrieve(_dbc);
                String hostName = host.getHostName();
                scanner = (IScanner)ConnectorClient.getService((String)hostName, (int)port, IScanner.class, (String)"SANAgentScanner");
                Object var9_9 = null;
                if (_dbc == null) break block14;
                try {
                    _dbc.close();
                    _dbc = null;
                }
                catch (SQLException e2) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block14;
                    traceLogger.exception(IRecordType.TYPE_EXIT, className, methodName, e2);
                }
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
            }
            break block17;
            {
                catch (Exception e) {
                    block15: {
                        msgLogger.exception(IRecordType.TYPE_ERROR_EXC, className, methodName, e);
                        Object var9_10 = null;
                        if (_dbc != null) {
                            try {
                                _dbc.close();
                                _dbc = null;
                            }
                            catch (SQLException e2) {
                                if (traceLogger == null || !traceLogger.isLogging()) break block15;
                                traceLogger.exception(IRecordType.TYPE_EXIT, className, methodName, e2);
                            }
                        }
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
                    }
                }
            }
            catch (Throwable throwable) {
                block16: {
                    Object var9_11 = null;
                    if (_dbc != null) {
                        try {
                            _dbc.close();
                            _dbc = null;
                        }
                        catch (SQLException e2) {
                            if (traceLogger == null || !traceLogger.isLogging()) break block16;
                            traceLogger.exception(IRecordType.TYPE_EXIT, className, methodName, e2);
                        }
                    }
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, className, methodName);
                }
                throw throwable;
            }
        }
        return scanner;
    }
}

