/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.api;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.aperi.common.api.Distinguishable;

public class SRMMessage
implements Cloneable,
Comparable,
Serializable,
Distinguishable {
    public static final short TYPE_UNKNOWN = 0;
    public static final short TYPE_INFO = 1;
    public static final short TYPE_WARN = 2;
    public static final short TYPE_ERR = 3;
    private static final String DEFAULT_MSG1 = "Message resource {0} is missing from {1}.";
    private static final String DEFAULT_MSG2 = "Unable to load {0} for message resource {1}.";
    private static Hashtable htBundles = new Hashtable(8);
    private static Hashtable htBundleNames = new Hashtable(4);
    private String strMsgId;
    private String[] astrInserts;
    static final long serialVersionUID = 2096267658782765626L;

    public SRMMessage(String id, String[] inserts) throws IllegalArgumentException {
        this.strMsgId = this.validate(id);
        this.astrInserts = inserts;
    }

    public SRMMessage(SRMMessage msg) {
        this.strMsgId = msg.strMsgId;
        this.astrInserts = new String[msg.astrInserts.length];
        for (int i = this.astrInserts.length - 1; i >= 0; --i) {
            this.astrInserts[i] = msg.astrInserts[i];
        }
    }

    public final String getMsgId() {
        return this.strMsgId;
    }

    public final String getMsgPrefix() {
        return this.strMsgId.substring(0, 3);
    }

    public final String getMsgCompId() {
        if (Character.isDigit(this.strMsgId.charAt(3)) && Character.isDigit(this.strMsgId.charAt(4))) {
            return "";
        }
        return this.strMsgId.substring(3, 5);
    }

    public final int getMsgNum() {
        int msgNum = -1;
        try {
            msgNum = this.getMsgCompId() == null ? Integer.parseInt(this.strMsgId.substring(3, 9)) : Integer.parseInt(this.strMsgId.substring(5, 9));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msgNum;
    }

    public final short getMsgType() {
        short type;
        switch (this.strMsgId.charAt(9)) {
            case 'I': {
                type = 1;
                break;
            }
            case 'W': {
                type = 2;
                break;
            }
            case 'E': {
                type = 3;
                break;
            }
            default: {
                type = 0;
            }
        }
        return type;
    }

    public final String[] getMsgInserts() {
        return this.astrInserts;
    }

    public String getMessage() {
        return this.getText(true);
    }

    public String getLocalizedMessage() {
        return this.getText(false);
    }

    public void setMsgId(String msgId) {
        this.strMsgId = this.validate(msgId);
    }

    public void setMsgInserts(String[] inserts) {
        this.astrInserts = inserts;
    }

    public boolean equals(Object tmObj) {
        if (tmObj instanceof SRMMessage) {
            return this.strMsgId.equals(((SRMMessage)tmObj).strMsgId);
        }
        return false;
    }

    public int compareTo(Object tmObj) {
        return this.strMsgId.compareTo(((SRMMessage)tmObj).strMsgId);
    }

    public boolean isIdentical(Object obj) {
        boolean bIdentical = false;
        if (obj instanceof SRMMessage && ((SRMMessage)obj).strMsgId.equals(this.strMsgId) && ((SRMMessage)obj).astrInserts.length == this.astrInserts.length) {
            bIdentical = true;
            for (int i = this.astrInserts.length - 1; i >= 0; --i) {
                if (((SRMMessage)obj).astrInserts[i].equals(this.astrInserts[i])) continue;
                bIdentical = false;
                break;
            }
        }
        return bIdentical;
    }

    public String toString() {
        return this.getMessage();
    }

    public Object clone() {
        SRMMessage tmNew = null;
        try {
            tmNew = (SRMMessage)super.clone();
            tmNew.astrInserts = new String[this.astrInserts.length];
            for (int i = this.astrInserts.length - 1; i >= 0; --i) {
                tmNew.astrInserts[i] = this.astrInserts[i];
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return tmNew;
    }

    protected String validate(String msgId) {
        int msgNum = -1;
        try {
            if (msgId.length() == 10) {
                msgNum = Character.isDigit(msgId.charAt(3)) && Character.isDigit(msgId.charAt(4)) ? Integer.parseInt(msgId.substring(3, 9)) : Integer.parseInt(msgId.substring(5, 9));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (msgId.length() != 10 || msgNum < 0) {
            throw new IllegalArgumentException("The message ID is invalid: " + msgId);
        }
        return msgId;
    }

    protected String getText(boolean bEnglish) {
        ResourceBundle rb = null;
        String mod = bEnglish ? "E_" : "L_";
        String bundleName = this.getBundleName();
        String strRet = null;
        rb = (ResourceBundle)htBundles.get(mod + bundleName);
        if (rb == null && bundleName != null) {
            rb = bEnglish ? ResourceBundle.getBundle(bundleName, Locale.US) : ResourceBundle.getBundle(bundleName, Locale.getDefault());
            htBundles.put(mod + bundleName, rb);
        }
        if (rb != null) {
            try {
                strRet = rb.getString(this.strMsgId);
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        strRet = strRet != null ? MessageFormat.format(strRet, this.astrInserts) : (rb != null ? MessageFormat.format(DEFAULT_MSG1, this.strMsgId, bundleName) : MessageFormat.format(DEFAULT_MSG2, bundleName, this.strMsgId));
        return strRet;
    }

    protected String getBundleName() {
        String msgPrefix = null;
        String msgCompId = null;
        String bundleName = null;
        msgPrefix = this.getMsgPrefix();
        msgCompId = this.getMsgCompId();
        bundleName = (String)htBundleNames.get(msgPrefix + msgCompId);
        return bundleName;
    }

    static {
        htBundleNames.put("HWN", "org.eclipse.aperi.disk.resources.APIMessages");
        htBundleNames.put("BTAFM", "org.eclipse.aperi.fabric.api.resources.FabricManagerMsgs");
        htBundleNames.put("HWNPM", "org.eclipse.aperi.perf.api.resources.PerfManagerMsgs");
        htBundleNames.put("HWNTM", "org.eclipse.aperi.tape.api.resources.TapeManagerMsgs");
    }
}

