/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.constants.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantFieldUtil {
    public static SortedSet<Byte> getByteValues(Class c) {
        TreeSet<Byte> tmpSet = new TreeSet<Byte>();
        Field[] constants = c.getFields();
        for (int i = 0; i < constants.length; ++i) {
            if (!ConstantFieldUtil.isConstant(constants[i]) || !constants[i].getType().equals(Byte.TYPE)) continue;
            try {
                tmpSet.add(constants[i].getByte(null));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return Collections.unmodifiableSortedSet(tmpSet);
    }

    public static SortedSet<Short> getShortValues(Class c) {
        TreeSet<Short> tmpSet = new TreeSet<Short>();
        Field[] constants = c.getFields();
        for (int i = 0; i < constants.length; ++i) {
            if (!ConstantFieldUtil.isConstant(constants[i]) || !constants[i].getType().equals(Short.TYPE)) continue;
            try {
                tmpSet.add(constants[i].getShort(null));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return Collections.unmodifiableSortedSet(tmpSet);
    }

    public static SortedSet<Integer> getIntegerValues(Class c) {
        TreeSet<Integer> tmpSet = new TreeSet<Integer>();
        Field[] constants = c.getFields();
        for (int i = 0; i < constants.length; ++i) {
            if (!ConstantFieldUtil.isConstant(constants[i]) || !constants[i].getType().equals(Integer.TYPE)) continue;
            try {
                tmpSet.add(constants[i].getInt(null));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return Collections.unmodifiableSortedSet(tmpSet);
    }

    public static SortedSet<Long> getLongValues(Class c) {
        TreeSet<Long> tmpSet = new TreeSet<Long>();
        Field[] constants = c.getFields();
        for (int i = 0; i < constants.length; ++i) {
            if (!ConstantFieldUtil.isConstant(constants[i]) || !constants[i].getType().equals(Long.TYPE)) continue;
            try {
                tmpSet.add(constants[i].getLong(null));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return Collections.unmodifiableSortedSet(tmpSet);
    }

    public static SortedSet<String> getStringValues(Class c) {
        TreeSet<String> tmpSet = new TreeSet<String>();
        Field[] constants = c.getFields();
        for (int i = 0; i < constants.length; ++i) {
            if (!ConstantFieldUtil.isConstant(constants[i]) || !constants[i].getType().equals(String.class)) continue;
            try {
                tmpSet.add(String.valueOf(constants[i].get(null)));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return Collections.unmodifiableSortedSet(tmpSet);
    }

    private static boolean isConstant(Field f) {
        int mod = f.getModifiers();
        return Modifier.isPublic(mod) && Modifier.isStatic(mod) && Modifier.isFinal(mod);
    }
}

