/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.core.constants.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.IMetadataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestTypeSource
implements IMetadataSource {
    private static final Set<String> supportedConstants;
    private static final Map<String, Map<String, Object>> constantMetadataMap;

    private static void registerInternalName(String type, String name) {
        RequestTypeSource.register(type, "org.eclipse.aperi.constants.metadata.RequestType.InternalName", name);
    }

    private static void registerExternalName(String type, String nameKey) {
        RequestTypeSource.register(type, "org.eclipse.aperi.constants.metadata.RequestType.ExternalName", nameKey);
    }

    private static void registerLogPrefix(String type, String prefix) {
        RequestTypeSource.register(type, "org.eclipse.aperi.constants.metadata.RequestType.LogPrefix", prefix);
    }

    private static void register(String requestType, String metadataKey, Object metadataValue) {
        Map<String, Object> metadata = RequestTypeSource.getMetadata(requestType);
        metadata.put(metadataKey, metadataValue);
    }

    private static Map<String, Object> getMetadata(String constantValue) {
        Map<String, Object> metadata = constantMetadataMap.get(constantValue);
        if (metadata == null) {
            metadata = new HashMap<String, Object>();
            constantMetadataMap.put(constantValue, metadata);
        }
        return metadata;
    }

    @Override
    public Object getValue(Object constantValue, String metadataKey) {
        Object metadataValue = RequestTypeSource.getMetadata((String)constantValue).get(metadataKey);
        if (metadataValue != null && metadataKey.equals("org.eclipse.aperi.constants.metadata.RequestType.ExternalName")) {
            metadataValue = Util.getString((String)metadataValue);
        }
        return metadataValue;
    }

    @Override
    public Set<?> getSupportedConstants() {
        return supportedConstants;
    }

    public void dispose() {
    }

    static {
        constantMetadataMap = new HashMap<String, Map<String, Object>>();
        RequestTypeSource.registerInternalName("org.eclipse.aperi.server.svp.ServerSvp", "Server");
        RequestTypeSource.registerInternalName("org.eclipse.aperi.agent.svp.AgentSvp", "Agent");
        RequestTypeSource.registerInternalName("org.eclipse.aperi.server.svp.SchedulerSvp", "Scheduler");
        RequestTypeSource.registerInternalName("org.eclipse.aperi.server.svp.AgentSvp", "Agent");
        RequestTypeSource.registerInternalName("org.eclipse.aperi.server.svp.GuiSvp", "GUI");
        RequestTypeSource.registerInternalName("org.eclipse.aperi.server.svp.CimomSvp", "Device");
        RequestTypeSource.registerExternalName("org.eclipse.aperi.server.svp.ServerSvp", "Server");
        RequestTypeSource.registerExternalName("org.eclipse.aperi.agent.svp.AgentSvp", "Agent");
        RequestTypeSource.registerExternalName("org.eclipse.aperi.server.svp.SchedulerSvp", "Scheduler");
        RequestTypeSource.registerExternalName("org.eclipse.aperi.server.svp.AgentSvp", "Agent");
        RequestTypeSource.registerExternalName("org.eclipse.aperi.server.svp.GuiSvp", "GUI");
        RequestTypeSource.registerExternalName("org.eclipse.aperi.server.svp.CimomSvp", "Device");
        RequestTypeSource.registerLogPrefix("org.eclipse.aperi.server.svp.ServerSvp", "server");
        RequestTypeSource.registerLogPrefix("org.eclipse.aperi.agent.svp.AgentSvp", "agent");
        RequestTypeSource.registerLogPrefix("org.eclipse.aperi.server.svp.SchedulerSvp", "scheduler");
        RequestTypeSource.registerLogPrefix("org.eclipse.aperi.server.svp.AgentSvp", "data");
        RequestTypeSource.registerLogPrefix("org.eclipse.aperi.server.svp.GuiSvp", "data");
        RequestTypeSource.registerLogPrefix("org.eclipse.aperi.server.svp.CimomSvp", "cimom");
        supportedConstants = Collections.unmodifiableSet(constantMetadataMap.keySet());
    }
}

