/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.common.api.CimomAndDeviceStatus;
import org.eclipse.aperi.common.api.DeviceStatus;
import org.eclipse.aperi.common.api.ICIMOMMgmtService;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.ParameterChecker;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerExecException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadManager;
import org.eclipse.aperi.disk.common.util.thread.ExecGroup;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyHost;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyPort;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySwitch;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyTapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyVolume;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.SlpAttributes;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.TapeFrame;
import org.eclipse.aperi.infrastructure.database.objects.Vendor;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyHostTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyTapeLibraryTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;
import org.eclipse.aperi.infrastructure.database.tables.TResElementProbeStatusTable;
import org.eclipse.aperi.infrastructure.database.tables.TResRegisteredCimomTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeLibraryTable;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetection;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.util.SRMCrypto;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;

public final class CIMOMManager
implements ICIMOMMgmtService {
    private static CIMOMManager cCimomMgr = new CIMOMManager();
    private static int cUniqueInt = 0;
    private static Map stSaxParsing = Collections.synchronizedMap(new HashMap());
    private static final Map stParsDevTypeDef = CIMOMManager.getDefinitionForSync("CIMClientWrapper.SaxParsing.SubsystemTypes");
    private static final Map stParsVendorDef = CIMOMManager.getDefinitionForSync("CIMClientWrapper.SaxParsing.Vendors");
    private static final Map stParsNSpcDef = CIMOMManager.getDefinitionForSync("CIMClientWrapper.SaxParsing.NameSpaces");
    private static Map stConcurrentAccess = Collections.synchronizedMap(new HashMap());
    private static final String DEVICE_TYPE_UNKNOWN = "type_unknown";
    private static final String VENDOR_UNKNOWN = "vendor_unknown";
    private static final Map stDevTypeDef = CIMOMManager.getDefinitionForSync("CIMClientWrapper.ReqSync.SubsystemTypes");
    private static final Map stVendorDef = CIMOMManager.getDefinitionForSync("CIMClientWrapper.ReqSync.Vendors");
    private static final Map stNSpcDef = CIMOMManager.getDefinitionForSync("CIMClientWrapper.ReqSync.NameSpaces");
    private static Map stUsedCIMOMs = Collections.synchronizedMap(new HashMap());
    private static Set stPendingCIMOMDeletions = Collections.synchronizedSet(new HashSet());
    private static final short UNIQUENUMBERLENGTHDEFAULT = 7;
    private static final String SLPDISCOVERYPROCESS_PARAMETER_DA = "DA";
    private static final String SLPDISCOVERYPROCESS_PARAMETER_DA_LOCAL = "local";
    private static final String SLPDISCOVERYPROCESS_PARAMETER_SCOPE = "SCOPE";
    private static final String SLPDISCOVERYPROCESS_PARAMETER_SCOPE_DEFAULT = "default";
    private static final String DBATTRIBUTEMAPPER = "DBAttributeMapper";
    private static final String DBATTRIBUTEMAPPER_SLP = "SLP";
    private static final String DBATTRIBUTEMAPPER_SLP_SCANID = "DummyScanID";
    private static final String TESTCONNECTIONTIMEOUT_NAME = "TESTCONNECTIONTIMEOUT";
    private static final int CIMOM_CHECK_OK = 0;
    private static final int CIMOM_CHECK_DUP = 1;
    private static final int CIMOM_CHECK_RES_ERR = 2;
    private static final int CIMOM_CHECK_URL_ERR = 3;
    private static final String PROCESSID_PREFIX = "S";
    public static final int DEVICE_UNKNOWN_UNCONFIGURED = -1;

    private CIMOMManager() {
    }

    public static CIMOMManager getCIMOMManager() {
        return cCimomMgr;
    }

    public AsyncResult discoverCIMOMs(String[] pDAs, Boolean pLocalSubnet) throws ServerException {
        return this.discoverCIMOMs(pDAs, (boolean)pLocalSubnet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult discoverCIMOMs(String[] pDAs, boolean pLocalSubnet) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "discoverCIMOMs", new Object[]{pDAs, new Boolean(pLocalSubnet)});
        AsyncResult mResult = new AsyncResult(-1);
        try {
            Object bObject;
            if (!pLocalSubnet) {
                try {
                    ParameterChecker.assertMandatoryParameter(1, "pDAs", pDAs, mLTH);
                }
                catch (MissingParameterException e) {
                    throw DiskMessageHelper.getServerException("HWN020002E", (Object)e.getMessage(), e, mLTH);
                }
            }
            if ((bObject = Activator._serviceHelper.bindLocal("DiscoverService")) == null) {
                throw DiskMessageHelper.getServerException("HWN021807E", null, mLTH);
            }
            IDiscover bProxy = (IDiscover)bObject;
            Hashtable<String, String[]> bProperties = new Hashtable<String, String[]>();
            bProperties.put(SLPDISCOVERYPROCESS_PARAMETER_SCOPE, new String[]{SLPDISCOVERYPROCESS_PARAMETER_SCOPE_DEFAULT});
            if (!pLocalSubnet) {
                bProperties.put(SLPDISCOVERYPROCESS_PARAMETER_DA, pDAs);
            } else {
                mLTH.traceInfo("local discovery was requested, add 'local' to DA array");
                String[] bTemp = null;
                int bNumOfDAs = 0;
                if (pDAs != null) {
                    bNumOfDAs = pDAs.length;
                    bTemp = new String[bNumOfDAs + 1];
                    for (int bI = 0; bI < bNumOfDAs; ++bI) {
                        bTemp[bI] = pDAs[bI];
                    }
                } else {
                    bNumOfDAs = 0;
                    bTemp = new String[bNumOfDAs + 1];
                }
                bTemp[bNumOfDAs] = SLPDISCOVERYPROCESS_PARAMETER_DA_LOCAL;
                bProperties.put(SLPDISCOVERYPROCESS_PARAMETER_DA, bTemp);
            }
            mLTH.traceSvcEntry("Discover.slpDiscover", new Object[]{bProperties});
            String bJobID = bProxy.discover("SLPDiscover", bProperties);
            mResult = bProxy.getJobStatus(bJobID);
            mLTH.traceSvcReturn("Discover.slpDiscover jobid=" + bJobID, mResult.toString());
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMOM[] getCIMOMs() throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "getCIMOMs", null);
        CIMOM[] mResult = null;
        try {
            mResult = this.getCIMOMs(null);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMOM[] getCIMOMsWithoutPW() throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "getCIMOMsWithoutPW", null);
        CIMOM[] mResult = null;
        try {
            mResult = this.getCIMOMs(null);
            for (int i = 0; i < mResult.length; ++i) {
                mResult[i].setPassword(null);
            }
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMOM[] getCIMOMs(String[] pCimomIDs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "getCIMOMs", pCimomIDs);
        Object[] mResult = new CIMOM[]{};
        try {
            DBConnection mConn = ServiceUtils.getConnection();
            if (mConn == null) {
                throw DiskMessageHelper.getServerException("HWN021800E", null, mLTH);
            }
            RegisteredCimom.RegisteredCimomCursor mCursor = null;
            Vector<String> mCimomIds = new Vector<String>();
            if (pCimomIDs != null) {
                for (int bI = 0; bI < pCimomIDs.length; ++bI) {
                    mCimomIds.add(pCimomIDs[bI]);
                }
            }
            Vector<CIMOM> mCimoms = new Vector<CIMOM>();
            try {
                mCursor = RegisteredCimom.getCursor(mConn, null, null);
                if (mCursor == null) {
                    throw DiskMessageHelper.getServerException("HWN021801E", null, mLTH);
                }
                while (mCursor.next()) {
                    RegisteredCimom bRegisteredCimom = mCursor.getObject();
                    if (bRegisteredCimom == null) {
                        throw DiskMessageHelper.getServerException("HWN021801E", null, mLTH);
                    }
                    String bCIMOMServiceUrl = bRegisteredCimom.getServiceUrl();
                    if (mCimomIds.size() != 0 && !mCimomIds.contains(bCIMOMServiceUrl) || bRegisteredCimom.getStatus() == CIMOMConnectionStatus.PENDING_DELETION.toID()) continue;
                    CIMOM bCIMOM = this.createCIMOMObject(bRegisteredCimom, mConn, mLTH);
                    mCimoms.add(bCIMOM);
                }
            }
            catch (SQLException pEx) {
                mLTH.traceError("Getting CIMOMs failed due to " + pEx.getMessage(), pEx);
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)pEx.getMessage(), pEx, mLTH);
            }
            finally {
                try {
                    if (mCursor != null) {
                        mCursor.close();
                    }
                    mConn.close();
                }
                catch (SQLException pEx) {
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)pEx.getMessage(), pEx, mLTH);
                }
            }
            mResult = new CIMOM[mCimoms.size()];
            mCimoms.copyInto(mResult);
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMOM getCIMMOMByDBKey(int pRegCimomID) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "getCIMMOMByDBKey", new Object[]{String.valueOf(pRegCimomID)});
        CIMOM mCimom = null;
        try {
            DBConnection mConn = ServiceUtils.getConnection();
            DBCursor mCursor = null;
            if (mConn == null) {
                throw DiskMessageHelper.getServerException("HWN021800E", null, mLTH);
            }
            try {
                Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
                mWhereClause.put(TResRegisteredCimomTable.getColumnInfo("REG_CIMOM_ID"), Integer.toString(pRegCimomID));
                mCursor = RegisteredCimom.getCursor(mConn, mWhereClause, null);
                if (mCursor == null) {
                    throw DiskMessageHelper.getServerException("HWN021801E", null, mLTH);
                }
                if (mCursor.next()) {
                    RegisteredCimom bRegisteredCimom = ((RegisteredCimom.RegisteredCimomCursor)mCursor).getObject();
                    if (bRegisteredCimom == null || bRegisteredCimom.getStatus() == CIMOMConnectionStatus.PENDING_DELETION.toID()) {
                        throw DiskMessageHelper.getServerException("HWN021801E", null, mLTH);
                    }
                    mCimom = this.createCIMOMObject(bRegisteredCimom, mConn, mLTH);
                }
            }
            catch (SQLException pEx) {
                mLTH.traceError("Getting CIMOMs failed due to " + pEx.getMessage(), pEx);
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)pEx.getMessage(), pEx, mLTH);
            }
            finally {
                try {
                    if (mCursor != null) {
                        mCursor.close();
                    }
                    mConn.close();
                }
                catch (SQLException pEx) {
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)pEx.getMessage(), pEx, mLTH);
                }
            }
        }
        finally {
            mLTH.exit(null);
        }
        return mCimom;
    }

    private CIMOM createCIMOMObject(RegisteredCimom bRegisteredCimom, DBConnection mConn, LogTraceHelper mLTH) throws SQLException, ServerException {
        SlpAttributes.SlpAttributesCursor mAttrCursor = null;
        String bServiceUrl = bRegisteredCimom.getServiceUrl();
        CIMOM mNewCIMOM = new CIMOM();
        mNewCIMOM.setServiceUrl(bServiceUrl);
        mNewCIMOM.setHiName(bRegisteredCimom.getHiName());
        mNewCIMOM.setDescription(bRegisteredCimom.getDescription());
        mNewCIMOM.setSoftwareLevel(bRegisteredCimom.getSoftwareLevel());
        mNewCIMOM.setProtocolVersion(bRegisteredCimom.getProtocolVersion());
        mNewCIMOM.setAuthenticationMechanism(bRegisteredCimom.getAuthenticationMechanism());
        mNewCIMOM.setUserId(bRegisteredCimom.getUserId());
        mNewCIMOM.setServiceId(String.valueOf(bRegisteredCimom.getRegCimomId()));
        String bEncrypted = bRegisteredCimom.getPassword();
        if (bEncrypted != null) {
            try {
                mNewCIMOM.setPassword(SRMCrypto.decrypt(bEncrypted));
            }
            catch (Exception pEx) {
                mLTH.traceError("Failed to decrypt password " + bEncrypted + " for CIMOM " + bServiceUrl + "due to " + pEx.getMessage(), pEx);
            }
        }
        mNewCIMOM.setTrustStoreLocation(bRegisteredCimom.getTrustStoreLocation());
        mNewCIMOM.setTrustStorePassphrase(bRegisteredCimom.getTrustStorePassphrase());
        mNewCIMOM.setInteropSchemaNamespace(bRegisteredCimom.getInteropSchemaNamespace());
        mNewCIMOM.setProtocol(bRegisteredCimom.getProtocol());
        mNewCIMOM.setDisplayName(bRegisteredCimom.getDisplayName());
        mNewCIMOM.setStatus(CIMOMConnectionStatus.getStatus(bRegisteredCimom.getStatus()));
        Timestamp bTempTimestamp = bRegisteredCimom.getStatusTimestamp();
        if (bTempTimestamp != null) {
            Calendar bTempCal = Calendar.getInstance();
            bTempCal.setTime(bTempTimestamp);
            mNewCIMOM.setStatusTimestamp(bTempCal);
        }
        try {
            mAttrCursor = SlpAttributes.getCursor(mConn, null, null);
            if (mAttrCursor == null) {
                throw DiskMessageHelper.getServerException("HWN021804E", bServiceUrl, mLTH);
            }
            String bAllAttributes = new String();
            while (mAttrCursor.next()) {
                SlpAttributes bAttributes = mAttrCursor.getObject();
                if (bAttributes == null) {
                    throw DiskMessageHelper.getServerException("HWN021804E", bServiceUrl, mLTH);
                }
                if (bAttributes.getRegCimomId() != bRegisteredCimom.getRegCimomId()) continue;
                bAllAttributes = bAllAttributes + bAttributes.getAttributeName() + ":" + bAttributes.getValue();
            }
        }
        catch (SQLException pEx) {
            mLTH.traceError("Getting CIMOMs failed due to " + pEx.getMessage(), pEx);
            throw DiskMessageHelper.getServerException("HWN021802E", (Object)pEx.getMessage(), pEx, mLTH);
        }
        finally {
            try {
                if (mAttrCursor != null) {
                    mAttrCursor.close();
                }
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)pEx.getMessage(), pEx, mLTH);
            }
        }
        return mNewCIMOM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyCIMOMs(CIMOM[] pCimoms) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "modifyCIMOMs", new Object[]{pCimoms});
        String[] mResult = null;
        try {
            mResult = this.persistCIMOMs(pCimoms, true, mLTH);
            mLTH.exit(mResult);
        }
        catch (Throwable throwable) {
            mLTH.exit(mResult);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] addCIMOMs(CIMOM[] pCimoms) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "addCIMOMs", new Object[]{pCimoms});
        String[] mResult = null;
        try {
            mResult = this.persistCIMOMs(pCimoms, false, mLTH);
            mLTH.exit(mResult);
        }
        catch (Throwable throwable) {
            mLTH.exit(mResult);
            throw throwable;
        }
        return mResult;
    }

    private String[] persistCIMOMs(CIMOM[] pCimoms, boolean pModifyOnly, LogTraceHelper mLTH) throws ServerException {
        int bI;
        try {
            ParameterChecker.assertMandatoryParameter(1, "pCimoms", pCimoms, mLTH);
        }
        catch (MissingParameterException e) {
            throw DiskMessageHelper.getServerException("HWN020002E", e.getMessage(), mLTH);
        }
        DBConnection mConn = ServiceUtils.getConnection();
        if (mConn == null) {
            throw DiskMessageHelper.getServerException("HWN021800E", null, mLTH);
        }
        int[] mCheckResult = pModifyOnly ? null : this.checkForDuplicateCIMOMs(pCimoms, mConn);
        int mI = pCimoms.length;
        String[] mResult = new String[mI];
        Hashtable[] mAttribs = new Hashtable[mI];
        for (bI = 0; bI < mI; ++bI) {
            mAttribs[bI] = this.extractAttributes(pCimoms[bI]);
        }
        bI = 0;
        try {
            for (bI = 0; bI < mI; ++bI) {
                IDBAttributeMapper mMapper;
                if (!pModifyOnly) {
                    if (mCheckResult[bI] == 1) {
                        mResult[bI] = pCimoms[bI].getServiceUrl();
                        continue;
                    }
                    if (mCheckResult[bI] == 2) {
                        mConn.rollback();
                        mResult[bI] = null;
                        throw DiskMessageHelper.getServerException("HWN021809E", pCimoms[bI].getServiceUrl(), mLTH);
                    }
                }
                if ((mMapper = MapperRouter.getMapperRouter().findMapper(DBATTRIBUTEMAPPER_SLP, null, null, null)) == null) {
                    throw DiskMessageHelper.getServerException("HWN021805E", DBATTRIBUTEMAPPER, mLTH);
                }
                MapperResult bMR = null;
                bMR = mMapper.persist(mConn, mAttribs[bI], DBATTRIBUTEMAPPER_SLP_SCANID);
                if (bMR != null) {
                    Hashtable ins;
                    mResult[bI] = pCimoms[bI].getServiceUrl();
                    mLTH.traceInfo("Database entity for " + pCimoms[bI].getServiceUrl() + " was added");
                    mConn.commit();
                    ColumnInfo idColInfo = RegisteredCimom.getColumnInfo("REG_CIMOM_ID");
                    Hashtable hashtable = ins = pModifyOnly ? (Hashtable)bMR.getUpdatedRows().get(RegisteredCimom.getTablename()) : (Hashtable)bMR.getInsertedRows().get(RegisteredCimom.getTablename());
                    if (ins == null) continue;
                    String devId = (String)ins.get(idColInfo);
                    if (pModifyOnly) {
                        ServiceUtils.getEventMonitorProxy().handleDevicePropertyChange(PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString(), RegisteredCimom.getTablename(), devId, null, null);
                        continue;
                    }
                    ServiceUtils.getEventMonitorProxy().handleNewDevice(PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString(), RegisteredCimom.getTablename(), devId);
                    continue;
                }
                mConn.rollback();
                mResult[bI] = null;
                throw DiskMessageHelper.getServerException("HWN021806E", DBATTRIBUTEMAPPER, mLTH);
            }
        }
        catch (SQLException pEx) {
            mResult[bI] = null;
            mLTH.traceError("Database entity for " + pCimoms[bI].getServiceUrl() + " was not added because of " + pEx.getMessage(), pEx);
            try {
                mConn.rollback();
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)pEx.getMessage(), pEx, mLTH);
            }
            catch (SQLException pEx2) {
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)pEx2.getMessage(), pEx2, mLTH);
            }
        }
        finally {
            try {
                mConn.close();
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)pEx.getMessage(), pEx, mLTH);
            }
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable extractAttributes(CIMOM bCimom) {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "extractAttributes", new Object[]{bCimom});
        Hashtable<String, String> mResult = new Hashtable<String, String>();
        try {
            if (bCimom.getServiceUrl() != null) {
                mResult.put("template-url-syntax", bCimom.getServiceUrl());
            }
            if (bCimom.getHiName() != null) {
                mResult.put("service-hi-name", bCimom.getHiName());
            }
            if (bCimom.getDescription() != null) {
                mResult.put("service-hi-description", bCimom.getDescription());
            }
            if (bCimom.getProtocolVersion() != null) {
                mResult.put("protocolversion", bCimom.getProtocolVersion());
            }
            if (bCimom.getInteropSchemaNamespace() != null) {
                mResult.put("interopschemanamespace", bCimom.getInteropSchemaNamespace());
            }
            if (bCimom.getSoftwareLevel() != null) {
                mResult.put("software_level", bCimom.getSoftwareLevel());
            }
            if (bCimom.getAuthenticationMechanism() != null) {
                mResult.put("authentication_mechanism", bCimom.getAuthenticationMechanism());
            }
            if (bCimom.getUserId() != null) {
                mResult.put("user_id", bCimom.getUserId());
            }
            if (bCimom.getPassword() != null) {
                try {
                    String bEncrypted = SRMCrypto.encrypt(bCimom.getPassword());
                    mResult.put("password", bEncrypted);
                }
                catch (Exception pE) {
                    mLTH.traceError("Failed to encrypt password due to " + pE.getMessage(), pE);
                }
            }
            if (bCimom.getTrustStoreLocation() != null) {
                mResult.put("trust_store_location", bCimom.getTrustStoreLocation());
            }
            if (bCimom.getTrustStorePassphrase() != null) {
                mResult.put("trust_store_passphrase", bCimom.getTrustStorePassphrase());
            }
            if (bCimom.getDisplayName() != null) {
                mResult.put("display_name", bCimom.getDisplayName());
            }
            if (bCimom.getSlpAttributes() != null) {
                mResult.put("slp_attributes", bCimom.getSlpAttributes());
            }
            if (bCimom.getProtocol() != null) {
                mResult.put("protocol", bCimom.getProtocol());
            }
            if (bCimom.getStatus() != null) {
                mResult.put("status", Short.toString(bCimom.getStatus().toID()));
            }
        }
        finally {
            mLTH.exit(mResult);
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean persistCIMOMStatus(CIMOM pCimom) throws ServerException {
        Boolean mResult;
        block26: {
            LogTraceHelper mLTH = LogTraceHelper.entry(this, "persistCIMOMStatus", new Object[]{pCimom});
            mResult = Boolean.FALSE;
            try {
                IDBAttributeMapper mMapper;
                CIMOMConnectionStatus bStatus;
                try {
                    ParameterChecker.assertMandatoryParameter(1, "pCimom", pCimom, mLTH);
                }
                catch (MissingParameterException e) {
                    throw DiskMessageHelper.getServerException("HWN020002E", (Object)e.getMessage(), e, mLTH);
                }
                DBConnection mConn = ServiceUtils.getConnection();
                if (mConn == null) {
                    throw DiskMessageHelper.getServerException("HWN021800E", null, mLTH);
                }
                Hashtable<String, String> mAttrib = new Hashtable<String, String>();
                if (pCimom.getServiceUrl() != null) {
                    mAttrib.put("template-url-syntax", pCimom.getServiceUrl());
                }
                if ((bStatus = pCimom.getStatus()) != null) {
                    mAttrib.put("status", Short.toString(bStatus.toID()));
                }
                if ((mMapper = MapperRouter.getMapperRouter().findMapper(DBATTRIBUTEMAPPER_SLP, null, null, null)) == null) {
                    throw DiskMessageHelper.getServerException("HWN021805E", DBATTRIBUTEMAPPER, mLTH);
                }
                try {
                    MapperResult bMR = mMapper.persist(mConn, mAttrib, DBATTRIBUTEMAPPER_SLP_SCANID);
                    if (bMR != null) {
                        mResult = Boolean.TRUE;
                        mLTH.traceInfo("Status for " + pCimom.getServiceUrl() + " was updated");
                        mConn.commit();
                        ColumnInfo idColInfo = RegisteredCimom.getColumnInfo("REG_CIMOM_ID");
                        Hashtable ins = (Hashtable)bMR.getUpdatedRows().get(RegisteredCimom.getTablename());
                        if (ins != null && bStatus != CIMOMConnectionStatus.TIMEOUT) {
                            int newState;
                            int oldState;
                            String devId = (String)ins.get(idColInfo);
                            if (bStatus == CIMOMConnectionStatus.SUCCESS) {
                                oldState = 0;
                                newState = 1;
                            } else {
                                oldState = 1;
                                newState = 0;
                            }
                            ServiceUtils.getEventMonitorProxy().handleDeviceStateChange(PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString(), RegisteredCimom.getTablename(), devId, oldState, newState);
                        }
                        break block26;
                    }
                    mResult = Boolean.FALSE;
                    mLTH.traceError("Status for " + pCimom.getServiceUrl() + " was not updated (no mapper result retrieved)", null);
                    mConn.rollback();
                    throw DiskMessageHelper.getServerException("HWN021806E", DBATTRIBUTEMAPPER, mLTH);
                }
                catch (SQLException pEx) {
                    mResult = Boolean.FALSE;
                    mLTH.traceError("Status for " + pCimom.getServiceUrl() + " was not updated due to " + pEx.getMessage(), pEx);
                    try {
                        mConn.rollback();
                    }
                    catch (SQLException pEx2) {
                        throw DiskMessageHelper.getServerException("HWN021802E", (Object)pEx2.getMessage(), pEx2, mLTH);
                    }
                }
                finally {
                    try {
                        mConn.close();
                    }
                    catch (SQLException pEx) {
                        throw DiskMessageHelper.getServerException("HWN021802E", (Object)pEx.getMessage(), pEx, mLTH);
                    }
                }
            }
            finally {
                mLTH.exit(mResult);
            }
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCIMOMs(String[] pCimomURLs) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "deleteCIMOMs", new Object[]{pCimomURLs});
        try {
            try {
                ParameterChecker.assertMandatoryParameter(1, "pCimomURLs", pCimomURLs, mLTH);
            }
            catch (MissingParameterException e) {
                throw DiskMessageHelper.getServerException("HWN020002E", (Object)e.getMessage(), e, mLTH);
            }
            HashSet mCIMOMsToDeleteNow = new HashSet();
            for (int i = 0; i < pCimomURLs.length; ++i) {
                try {
                    boolean bPendingDeletion = false;
                    Map map = stUsedCIMOMs;
                    synchronized (map) {
                        if (!stUsedCIMOMs.containsKey(pCimomURLs[i])) {
                            try {
                                this.processPendingCIMOMDeletion(pCimomURLs[i]);
                            }
                            catch (Throwable bEX) {
                                bPendingDeletion = true;
                                stPendingCIMOMDeletions.add(pCimomURLs[i]);
                            }
                        } else {
                            bPendingDeletion = true;
                            stPendingCIMOMDeletions.add(pCimomURLs[i]);
                        }
                    }
                    if (!bPendingDeletion) continue;
                    this.flagPendingCIMOMDeletion(pCimomURLs[i]);
                    continue;
                }
                catch (Throwable bEx) {
                    mLTH.traceError("Not able to delete CIMOM " + pCimomURLs[i] + "because of :" + bEx.getMessage(), bEx);
                }
            }
            this.cleanupPendingCIMOMDeletions();
        }
        finally {
            mLTH.exit("null");
        }
    }

    private void flagPendingCIMOMDeletion(String pCimomURL) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "flagPendingCIMOMDeletion", new Object[]{pCimomURL});
        try {
            stPendingCIMOMDeletions.add(pCimomURL);
            DBConnection mConn = ServiceUtils.getConnection();
            if (mConn == null) {
                throw DiskMessageHelper.getServerException("HWN021800E", null, mLTH);
            }
            RegisteredCimom mRegCimom = new RegisteredCimom();
            mRegCimom.setServiceUrl(pCimomURL);
            if (mRegCimom.retrieve(mConn)) {
                mRegCimom = new RegisteredCimom();
                mRegCimom.setServiceUrl(pCimomURL);
                mRegCimom.setStatus(CIMOMConnectionStatus.PENDING_DELETION.toID());
                mRegCimom.setStatusTimestamp(new Timestamp(System.currentTimeMillis()));
                mRegCimom.update(mConn);
                mConn.commit();
                mLTH.traceInfo("CIMOM " + pCimomURL + " are set to PENDING_DELETION");
            } else {
                mLTH.traceInfo("No Database entity for CIMOM " + pCimomURL + ". Nothing to do.");
            }
        }
        catch (SQLException bSQLEx) {
            throw DiskMessageHelper.getServerException("HWN021802E", (Object)bSQLEx.getMessage(), bSQLEx, mLTH);
        }
        finally {
            mLTH.exit("null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanupPendingCIMOMDeletions() {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "processPendingCIMOMDeletion", null);
        DBConnection mConn = null;
        DBCursor mCIMOMCursor = null;
        try {
            mConn = ServiceUtils.getConnection();
            if (mConn == null) {
                return;
            }
            Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
            mWhereClause.put(TResRegisteredCimomTable.getColumnInfo("STATUS"), Short.toString(CIMOMConnectionStatus.PENDING_DELETION.toID()));
            mCIMOMCursor = RegisteredCimom.getCursor(mConn, mWhereClause, null);
            while (mCIMOMCursor.next()) {
                String bCIMOMServiceURL = ((RegisteredCimom.RegisteredCimomCursor)mCIMOMCursor).getObject().getServiceUrl();
                stPendingCIMOMDeletions.add(bCIMOMServiceURL);
            }
            mCIMOMCursor.close();
            mCIMOMCursor = null;
            mConn.commit();
            HashSet bCIMOMsToDelete = new HashSet(stPendingCIMOMDeletions);
            Iterator bDelCIMOMIter = bCIMOMsToDelete.iterator();
            while (bDelCIMOMIter.hasNext()) {
                String bCIMOMServiceURL = (String)bDelCIMOMIter.next();
                Map map = stUsedCIMOMs;
                synchronized (map) {
                    if (!stUsedCIMOMs.containsKey(bCIMOMServiceURL)) {
                        this.processPendingCIMOMDeletion(bCIMOMServiceURL);
                    }
                }
            }
            return;
        }
        catch (SQLException bEx) {
            mLTH.traceError(bEx.getMessage(), bEx);
            return;
        }
        finally {
            if (mCIMOMCursor != null) {
                try {
                    mCIMOMCursor.close();
                }
                catch (Exception e) {}
            }
            if (mConn != null) {
                try {
                    mConn.close();
                }
                catch (Exception e) {}
            }
            mLTH.exit("null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingCIMOMDeletion(String pCimomURL) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "processPendingCIMOMDeletion", new Object[]{pCimomURL});
        try {
            try {
                ParameterChecker.assertMandatoryParameter(1, "pCimomURLs", pCimomURL, mLTH);
            }
            catch (MissingParameterException e) {
                throw DiskMessageHelper.getServerException("HWN020002E", (Object)e.getMessage(), e, mLTH);
            }
            try {
                DBConnection mConn = ServiceUtils.getConnection();
                if (mConn == null) {
                    throw DiskMessageHelper.getServerException("HWN021800E", null, mLTH);
                }
                try {
                    RegisteredCimom mRegCimom = new RegisteredCimom();
                    mRegCimom.setServiceUrl(pCimomURL);
                    if (mRegCimom.retrieve(mConn)) {
                        ServiceUtils.getEventMonitorProxy().handleDeviceStateChange(PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString(), RegisteredCimom.getTablename(), new Integer(mRegCimom.getRegCimomId()).toString(), 1, 0);
                        int mDeletedRows = this.deleteNamespacesOfCimom(mConn, Integer.toString(mRegCimom.getRegCimomId()));
                        mLTH.traceInfo("Related entities (namespaces and cimkeys) for CIMOM " + pCimomURL + " deleted (" + Integer.toString(mDeletedRows) + " rows).");
                        if (mRegCimom.delete(mConn) > 0) {
                            mLTH.traceInfo("Database entity for CIMOM " + pCimomURL + " deleted");
                        } else {
                            mLTH.traceWarning("Logic error. CIMOM entity was found on retrieve but not on delete.");
                        }
                        int[] mMissing = this.markDevicesAsMissing(mConn);
                        mLTH.traceInfo("Marked " + Integer.toString(mMissing[0]) + " subsystems, " + Integer.toString(mMissing[1]) + " tape libraries and " + Integer.toString(mMissing[2]) + " switches as missing.");
                    } else {
                        mLTH.traceInfo("No Database entity for CIMOM " + pCimomURL + ". Nothing to do.");
                    }
                    mConn.commit();
                    stPendingCIMOMDeletions.remove(pCimomURL);
                    stConcurrentAccess.remove(pCimomURL);
                    mLTH.traceInfo("CIMOM " + pCimomURL + " deleted.");
                }
                catch (Exception e) {
                    mLTH.traceError("Failed to delete database entity for CIMOM" + pCimomURL + ".Rolling back", e);
                    mConn.rollback();
                    throw e;
                }
                finally {
                    mConn.close();
                }
            }
            catch (Exception e) {
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)e.getMessage(), e, mLTH);
            }
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteNamespacesOfCimom(DBConnection pConn, String pCimomId) throws SQLException {
        Hashtable<ColumnInfo, String> mWhere = new Hashtable<ColumnInfo, String>(2);
        mWhere.put(TResCimom2namespaceTable.getColumnInfo("CIMOM_ID"), pCimomId);
        Cimom2namespace.Cimom2namespaceCursor mCursor = Cimom2namespace.getCursor(pConn, mWhere, null);
        int mDeleteCount = 0;
        try {
            while (mCursor.next()) {
                Cimom2namespace mElement = mCursor.getObject();
                String mNamespaceId = Integer.toString(mElement.getCimNamespaceId());
                mDeleteCount += this.deleteCimKeysOfNamespace(pConn, mNamespaceId);
                mDeleteCount += mElement.delete(pConn);
            }
        }
        finally {
            mCursor.close();
        }
        return mDeleteCount;
    }

    private int[] markDevicesAsMissing(DBConnection pConn) throws SQLException {
        Hashtable mParameters = new Hashtable(2);
        HashMap<String, LinkedList> mTouchedEntities = new HashMap<String, LinkedList>();
        int[] mRc = new int[3];
        LinkedList listOfSSIDs = this.getMissingSubsystemIDs(pConn);
        if (!listOfSSIDs.isEmpty()) {
            String mSubsystemIdsWithComma = this.convertLinkedListToCommaSeparatedString(listOfSSIDs);
            String mSqlStringSTS = "UPDATE " + TResStorageSubsystemTable.getTablename() + " SET " + "DETECTABLE" + "=0 WHERE " + "SUBSYSTEM_ID" + " IN (" + mSubsystemIdsWithComma + ")";
            mRc[0] = ComplexQuery.sqlUpdate(pConn, mSqlStringSTS, mParameters);
            mTouchedEntities.put(TResStorageSubsystemTable.getTablename(), listOfSSIDs);
        } else {
            mRc[0] = 0;
        }
        LinkedList listOfTLIDs = this.getMissingTapeLibraries(pConn);
        if (!listOfTLIDs.isEmpty()) {
            String mTapeLibraryIdsWithComma = this.convertLinkedListToCommaSeparatedString(listOfTLIDs);
            String mSqlStringTL = "UPDATE " + TResTapeLibraryTable.getTablename() + " SET " + "DETECTABLE" + "=0 WHERE " + "TAPE_LIBRARY_ID" + " IN (" + mTapeLibraryIdsWithComma + ")";
            mRc[1] = ComplexQuery.sqlUpdate(pConn, mSqlStringTL, mParameters);
            mTouchedEntities.put(TResTapeLibraryTable.getTablename(), listOfTLIDs);
        } else {
            mRc[1] = 0;
        }
        LinkedList listOfSWIDs = this.getMissingSwitches(pConn);
        if (!listOfSWIDs.isEmpty()) {
            String mSwitchIdsWithComma = this.convertLinkedListToCommaSeparatedString(listOfSWIDs);
            String mSqlStringSw = "UPDATE " + TResSwitchTable.getTablename() + " SET " + "DETECTABLE" + "=0 WHERE " + "SWITCH_ID" + " IN (" + mSwitchIdsWithComma + ")";
            mRc[2] = ComplexQuery.sqlUpdate(pConn, mSqlStringSw, mParameters);
            mTouchedEntities.put(TResSwitchTable.getTablename(), listOfSWIDs);
        } else {
            mRc[2] = 0;
        }
        if (!mTouchedEntities.isEmpty()) {
            String pProcessID = PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString();
            ChangeDetection mChangeDetection = new ChangeDetection(pConn);
            pConn.commit();
            mChangeDetection.complete(pConn, mTouchedEntities, pProcessID);
            ServiceUtils.getEventMonitorProxy().handleModelUpdate(pProcessID);
        }
        if (!pConn.getAutoCommit()) {
            pConn.commit();
        }
        return mRc;
    }

    private LinkedList getMissingTapeLibraries(DBConnection pConn) throws SQLException {
        String mSelectString = "SELECT TAPE_LIBRARY_ID FROM " + TResTapeLibraryTable.getTablename() + " WHERE (SELECT COUNT(*) FROM " + TResCimkeyTapeLibraryTable.getTablename() + " WHERE " + "TAPE_LIBRARY_ID" + "=" + TResTapeLibraryTable.getTablename() + "." + "TAPE_LIBRARY_ID" + ")=0";
        DBResultSet mDBR = ComplexQuery.sqlQuery(pConn, mSelectString, null);
        LinkedList<String> pListOfIDs = new LinkedList<String>();
        while (mDBR.next()) {
            pListOfIDs.add(mDBR.getString(1));
        }
        mDBR.close();
        return pListOfIDs;
    }

    private LinkedList getMissingSwitches(DBConnection pConn) throws SQLException {
        String mSelectString = "SELECT ELEMENT_ID FROM " + TResElementProbeStatusTable.getTablename() + " WHERE " + "PROBE_FOUND" + "!=1 AND " + "ELEMENT_ID" + " IN (SELECT " + "SWITCH_ID" + " FROM " + TResSwitchTable.getTablename() + " WHERE (SELECT COUNT(*) FROM " + TResCimkeySwitchTable.getTablename() + " WHERE " + "SWITCH_WWN" + "=" + TResSwitchTable.getTablename() + "." + "SWITCH_WWN" + ")=0 )";
        DBResultSet mDBR = ComplexQuery.sqlQuery(pConn, mSelectString, null);
        LinkedList<String> pListOfIDs = new LinkedList<String>();
        while (mDBR.next()) {
            pListOfIDs.add(mDBR.getString(1));
        }
        mDBR.close();
        return pListOfIDs;
    }

    private String convertLinkedListToCommaSeparatedString(LinkedList pList) {
        String mCSS = "";
        Iterator bIter = pList.iterator();
        while (bIter.hasNext()) {
            mCSS = mCSS + (String)bIter.next();
            mCSS = mCSS + ",";
        }
        if (mCSS.indexOf(",") >= 0) {
            mCSS = mCSS.substring(0, mCSS.length() - 1);
        }
        return mCSS;
    }

    private LinkedList getMissingSubsystemIDs(DBConnection pConn) throws SQLException {
        String mSelectString = "SELECT SUBSYSTEM_ID FROM " + TResStorageSubsystemTable.getTablename() + " WHERE (SELECT COUNT(*) FROM " + TResCimkeySubsystemTable.getTablename() + " WHERE " + "SUBSYSTEM_ID" + "=" + TResStorageSubsystemTable.getTablename() + "." + "SUBSYSTEM_ID" + ")=0";
        DBResultSet mDBR = ComplexQuery.sqlQuery(pConn, mSelectString, null);
        LinkedList<String> pListOfIDs = new LinkedList<String>();
        while (mDBR.next()) {
            pListOfIDs.add(mDBR.getString(1));
        }
        mDBR.close();
        return pListOfIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteCimKeysOfNamespace(DBConnection pConn, String pNamespaceId) throws SQLException {
        int mDeleteCount = 0;
        Hashtable<ColumnInfo, String> mWhere = new Hashtable<ColumnInfo, String>(2);
        mWhere.put(TResCimkeyHostTable.getColumnInfo("CIM_NAMESPACE_ID"), pNamespaceId);
        mDeleteCount += CimkeyHost.deletes(pConn, mWhere);
        mWhere.clear();
        mWhere.put(TResCimkeyPortTable.getColumnInfo("CIM_NAMESPACE_ID"), pNamespaceId);
        mDeleteCount += CimkeyPort.deletes(pConn, mWhere);
        mWhere.clear();
        mWhere.put(TResCimkeySwitchTable.getColumnInfo("CIM_NAMESPACE_ID"), pNamespaceId);
        mDeleteCount += CimkeySwitch.deletes(pConn, mWhere);
        mWhere.clear();
        mWhere.put(TResCimkeyTapeLibraryTable.getColumnInfo("CIM_NAMESPACE_ID"), pNamespaceId);
        mDeleteCount += CimkeyTapeLibrary.deletes(pConn, mWhere);
        mWhere.clear();
        mWhere.put(TResCimkeyVolumeTable.getColumnInfo("CIM_NAMESPACE_ID"), pNamespaceId);
        mDeleteCount += CimkeyVolume.deletes(pConn, mWhere);
        mWhere.clear();
        mWhere.put(TResCimkeySubsystemTable.getColumnInfo("CIM_NAMESPACE_ID"), pNamespaceId);
        CimkeySubsystem.CimkeySubsystemCursor mCursor = CimkeySubsystem.getCursor(pConn, mWhere, null);
        try {
            while (mCursor.next()) {
                CimkeySubsystem mCKS = mCursor.getObject();
                CapabilityData mCapability = new CapabilityData();
                mCapability.setCapabilityDataId(mCKS.getCapabilityDataId());
                if (mCapability.retrieve(pConn)) {
                    mDeleteCount += mCapability.delete(pConn);
                }
                mDeleteCount += mCKS.delete(pConn);
            }
        }
        finally {
            mCursor.close();
        }
        return mDeleteCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMOMConnectionStatus[] testCIMOMConnection(CIMOM[] pCimoms) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "testCIMOMConnection", pCimoms);
        CIMOMConnectionStatus[] mResult = null;
        try {
            mResult = this.testCIMOMConnection(pCimoms, null).getCimomStatus();
            mLTH.exit(mResult);
        }
        catch (Throwable throwable) {
            mLTH.exit(mResult);
            throw throwable;
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CimomAndDeviceStatus testCIMOMConnection(CIMOM[] pCimoms, CIMObjectPath pDevice) throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "testCIMOMConnection", pCimoms);
        CimomAndDeviceStatus mResult = null;
        try {
            try {
                ParameterChecker.assertMandatoryParameter(1, "pCimoms", pCimoms, mLTH);
            }
            catch (MissingParameterException e) {
                throw DiskMessageHelper.getServerException("HWN020002E", (Object)e.getMessage(), e, mLTH);
            }
            int bCimomCount = pCimoms.length;
            CIMOMConnectionStatus[] mCimomStatus = new CIMOMConnectionStatus[bCimomCount];
            DeviceStatus[] mDeviceStatus = new DeviceStatus[bCimomCount];
            for (int bI = 0; bI < bCimomCount; ++bI) {
                mCimomStatus[bI] = CIMOMConnectionStatus.UNCONFIGURED;
                mDeviceStatus[bI] = DeviceStatus.INVALID;
            }
            long mTimeoutValue = DiskManagerConfigSvc.getLongConfigValue("CIMOMManager.TestConnectionTimeout", 45000L);
            ExecGroup mEG = DiskThreadManager.getExecutionGroup();
            Long[] mExecutionID = new Long[bCimomCount];
            try {
                int bI;
                for (bI = 0; bI < bCimomCount; ++bI) {
                    Object[] bParamArray = null;
                    if (pDevice == null) {
                        bParamArray = new Object[]{pCimoms[bI]};
                        mExecutionID[bI] = mEG.execute(this, "testOneCIMOMConnection", bParamArray, mLTH);
                        continue;
                    }
                    bParamArray = new Object[]{pCimoms[bI], pDevice};
                    mExecutionID[bI] = mEG.execute(this, "testOneDeviceConnection", bParamArray, mLTH);
                }
                mEG.waitForCompletion(mTimeoutValue);
                for (bI = 0; bI < bCimomCount; ++bI) {
                    Throwable mExecutionError = mEG.getExecutionError(mExecutionID[bI]);
                    if (mExecutionError == null) {
                        Object bT;
                        Object mExecutionResult = mEG.getExecutionResult(mExecutionID[bI]);
                        if (mExecutionResult instanceof CIMOMConnectionStatus) {
                            bT = (CIMOMConnectionStatus)mExecutionResult;
                            mLTH.traceInfo("test CIMOM connection thread " + mExecutionID[bI] + " returned CIMOMConnectionStatus " + ((CIMOMConnectionStatus)bT).toString());
                            mCimomStatus[bI] = bT;
                            continue;
                        }
                        if (!(mExecutionResult instanceof DeviceStatus)) continue;
                        bT = (DeviceStatus)mExecutionResult;
                        mLTH.traceInfo("test CIMOM connection thread " + mExecutionID[bI] + " returned device connection status " + ((DeviceStatus)bT).toString());
                        mCimomStatus[bI] = CIMOMConnectionStatus.SUCCESS;
                        mDeviceStatus[bI] = bT;
                        continue;
                    }
                    if (mExecutionError instanceof CIMException) {
                        CIMException pCE = (CIMException)mExecutionError;
                        Throwable mNestedException = mExecutionError.getCause();
                        if (mNestedException instanceof SSLHandshakeException || mNestedException instanceof SSLProtocolException) {
                            mLTH.traceError(pCimoms[bI].getServiceUrl() + " not accessible due to SSLHandshakeException or SSLProtocolException. " + "This exception might be due to an invalid SLP registration, e.g. \"http\" instead of \"https\".", mNestedException);
                            mCimomStatus[bI] = CIMOMConnectionStatus.SSL_HANDSHAKE_ERROR;
                            continue;
                        }
                        mLTH.traceError(pCimoms[bI].getServiceUrl() + " not accessible due to a non-SSLCIM Exception", mNestedException);
                        Object[] mParams = pCE.getParams();
                        String mID = pCE.getID();
                        if (mID != null && mID.equals("CIM_ERR_ACCESS_DENIED")) {
                            mLTH.traceInfo(pCimoms[bI].getServiceUrl() + " not accessible due to an invalid username or password.");
                            mCimomStatus[bI] = CIMOMConnectionStatus.LOGIN_FAILED;
                        } else if (mID != null && mID.indexOf("CMMOM0104E") != -1) {
                            mLTH.traceInfo(pCimoms[bI].getServiceUrl() + " not accessible for one of the following reasons: " + "The SLP registration is invalid (port or IP is wrong), " + "The machine where the CIMOM is running is down, " + "The CIMOM service is not running, " + "The firewall is misconfigured.");
                            mCimomStatus[bI] = CIMOMConnectionStatus.TIMEOUT;
                        } else if (mParams != null && mParams.length != 0) {
                            for (int i = 0; i < mParams.length; ++i) {
                                Object bParam = mParams[i];
                                if (bParam.toString().indexOf("CMMOM0026E") != -1) {
                                    mLTH.traceInfo(pCimoms[bI].getServiceUrl() + " not accessible due to an invalid SLP registration. " + "In this case the SLP attribute identifying the CIM namespace seems to be wrong. " + "The namespace that was reported via SLP oder set via cmd line options is: " + pCimoms[bI].getInteropSchemaNamespace());
                                    mCimomStatus[bI] = CIMOMConnectionStatus.SSL_REGISTRATION_INVALID;
                                    continue;
                                }
                                mLTH.traceError(pCimoms[bI].getServiceUrl() + " unexpected error case parameter " + bParam.toString(), mNestedException);
                            }
                        }
                        mLTH.traceError(pCimoms[bI].getServiceUrl() + " unexpected error case ", mNestedException);
                        continue;
                    }
                    if (mExecutionError instanceof DiskManagerTimeoutException) {
                        if (pDevice == null) {
                            mLTH.traceError(pCimoms[bI].getServiceUrl() + " EnumInstances call on CIM client timed out: " + mExecutionError.toString(), mExecutionError);
                        } else {
                            mLTH.traceError(pCimoms[bI].getServiceUrl() + " EnumerateInstanceNames call on CIM client timed out: " + mExecutionError.toString(), mExecutionError);
                        }
                        mCimomStatus[bI] = CIMOMConnectionStatus.TIMEOUT;
                        continue;
                    }
                    mLTH.traceError(pCimoms[bI].getServiceUrl() + " Internal error: " + mExecutionError.toString(), mExecutionError);
                    mCimomStatus[bI] = CIMOMConnectionStatus.UNKNOWN;
                }
            }
            catch (DiskManagerTimeoutException pEx) {
                mLTH.traceError("Internal error: DiskManagerTimeoutException, whole ExecutionGroup timed out", pEx);
                for (int bI = 0; bI < bCimomCount; ++bI) {
                    mCimomStatus[bI] = CIMOMConnectionStatus.TIMEOUT;
                }
            }
            catch (DiskManagerExecException pEx) {
                mLTH.traceError("Internal error: DiskManagerExecException in ExecutionGroupFramework", pEx);
                for (int bI = 0; bI < bCimomCount; ++bI) {
                    mCimomStatus[bI] = CIMOMConnectionStatus.UNKNOWN;
                }
            }
            finally {
                mEG.clear();
            }
            mResult = new CimomAndDeviceStatus(mCimomStatus, mDeviceStatus);
            for (int bI = 0; bI < bCimomCount; ++bI) {
                CIMOM[] mCIMOMS = this.getCIMOMs(new String[]{pCimoms[bI].getServiceUrl()});
                if (mCIMOMS.length == 0) continue;
                if (mCIMOMS[0].matches(pCimoms[bI])) {
                    pCimoms[bI].setStatus(mCimomStatus[bI]);
                    if (this.persistCIMOMStatus(pCimoms[bI]).booleanValue()) continue;
                    mLTH.traceError("Failed to update cimom status in database entity", null);
                    continue;
                }
                mLTH.traceInfo("Skipped to update cimom status due to attribute mismatch for " + pCimoms[bI].getServiceUrl());
            }
            mLTH.exit(mResult);
        }
        catch (Throwable throwable) {
            mLTH.exit(mResult);
            throw throwable;
        }
        return mResult;
    }

    /*
     * Exception decompiling
     */
    public CIMOMConnectionStatus testOneCIMOMConnection(CIMOM pCimom) throws CIMException, DiskManagerTimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceStatus testOneDeviceConnection(CIMOM pCimom, CIMObjectPath pDevice) throws CIMException, DiskManagerTimeoutException {
        DeviceStatus mResult;
        LogTraceHelper mLTH;
        block10: {
            mLTH = LogTraceHelper.entry(this, "testOneDeviceConnection", new Object[]{pCimom, pDevice});
            CIMClientWrapper bClient = null;
            mResult = null;
            try {
                mResult = DeviceStatus.INVALID;
                String bServiceUrl = pCimom.getServiceUrl();
                String bNamespace = pDevice.getNameSpace();
                if (bNamespace == null || bNamespace.trim().length() == 0) {
                    bNamespace = pCimom.getInteropSchemaNamespace();
                }
                mLTH.traceInfo("Testing device status for CIMOM " + bServiceUrl + " in namespace " + bNamespace);
                mLTH.traceInfo("Getting CIM client");
                bClient = CIMClientPool.getClient(pCimom.getUserId(), pCimom.getPassword(), bServiceUrl, bNamespace);
                mLTH.traceInfo("Enumerating instances for " + pDevice);
                CIMInstance bDeviceInstance = bClient.getInstance(pDevice, false, true, false, mLTH);
                if (bDeviceInstance != null) {
                    mLTH.traceInfo("Getting OperationalStatus property for " + pDevice);
                    CIMProperty bStatusProperty = bDeviceInstance.getProperty("OperationalStatus");
                    if (bStatusProperty != null) {
                        mLTH.traceInfo("Getting value of OperationalStatus property for " + pDevice);
                        mResult = new DeviceStatus(bStatusProperty);
                    }
                }
                if (bClient == null) break block10;
            }
            catch (Throwable throwable) {
                if (bClient != null) {
                    try {
                        CIMClientPool.returnClient(bClient);
                    }
                    catch (CIMException pE) {
                        mLTH.traceError("Failed to close CIMClientWrapper in testOneCIMOMConnection due to " + pE.getMessage(), pE);
                    }
                }
                mLTH.exit(mResult);
                throw throwable;
            }
            try {
                CIMClientPool.returnClient(bClient);
            }
            catch (CIMException pE) {
                mLTH.traceError("Failed to close CIMClientWrapper in testOneCIMOMConnection due to " + pE.getMessage(), pE);
            }
        }
        mLTH.exit(mResult);
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result testDeviceStatus(String pServiceURL, String pDeviceID) {
        Result mResult;
        block38: {
            LogTraceHelper mLTH = LogTraceHelper.entry(this, "testDeviceStatus", new Object[]{pServiceURL, pDeviceID});
            mResult = new Result();
            try {
                int mRCID;
                try {
                    ParameterChecker.assertMandatoryParameter(1, "pServiceURL", pServiceURL, mLTH);
                    ParameterChecker.assertMandatoryParameter(2, "pDeviceID", pDeviceID, mLTH);
                }
                catch (MissingParameterException pE) {
                    String mParameterName;
                    mLTH.traceError("Missing parameter ", pE);
                    switch (pE.getParameterNumber()) {
                        case 1: {
                            mParameterName = "pServiceURL";
                            break;
                        }
                        case 2: {
                            mParameterName = "pDeviceID";
                            break;
                        }
                        default: {
                            mParameterName = "unknown";
                        }
                    }
                    mResult.setSRMMessage("HWN020002E", new String[]{mParameterName});
                    mResult.setRc(10030);
                    Result result = mResult;
                    mLTH.exit(mResult);
                    return result;
                }
                DBConnection mConn = ServiceUtils.getConnection();
                if (mConn == null) {
                    mResult.setSRMMessage("HWN021800E", new String[0]);
                    mResult.setRc(10030);
                    Result mParameterName = mResult;
                    return mParameterName;
                }
                int mPlusIndex = pDeviceID.indexOf("+");
                boolean mDeviceIsSubsystem = mPlusIndex > -1;
                RegisteredCimom mRC = null;
                StorageSubsystem mSS = null;
                int mSSID = 0;
                CimkeySubsystem mCKSS = null;
                CimkeySwitch mCKSw = null;
                Vector mNSs = null;
                try {
                    mRC = new RegisteredCimom();
                    mRC.setServiceUrl(pServiceURL);
                    mRC.retrieve(mConn);
                    mRCID = mRC.getRegCimomId();
                }
                catch (SQLException pE) {
                    mLTH.traceError("Unable to retrieve RegisteredCimom for " + pServiceURL, pE);
                    mResult.setSRMMessage("HWN021801E", new String[0]);
                    mResult.setRc(10030);
                    throw pE;
                }
                if (mDeviceIsSubsystem) {
                    String bName = pDeviceID.substring(0, mPlusIndex);
                    short bNameFormat = Short.valueOf(pDeviceID.substring(pDeviceID.indexOf("+") + 1, pDeviceID.length()));
                    try {
                        mSS = new StorageSubsystem();
                        mSS.setName(bName);
                        mSS.setNameFormat(bNameFormat);
                        mSS.retrieve(mConn);
                        mSSID = mSS.getSubsystemId();
                    }
                    catch (SQLException pE) {
                        mLTH.traceError("Unable to retrieve StorageSubsystem for " + pDeviceID, pE);
                        mResult.setSRMMessage("HWN021504E", new String[]{pDeviceID});
                        mResult.setRc(10030);
                        throw pE;
                    }
                }
                mNSs = this.getNamespacesForServiceUrl(mLTH, pServiceURL);
                for (int bI = 0; bI < mNSs.size(); ++bI) {
                    int mNSID;
                    String bNS = (String)mNSs.get(bI);
                    try {
                        Cimom2namespace mC2N = new Cimom2namespace();
                        mC2N.setCimomId(mRCID);
                        mC2N.setNamespace(bNS);
                        mC2N.retrieve(mConn);
                        mNSID = mC2N.getCimNamespaceId();
                    }
                    catch (SQLException pE) {
                        if (bI == mNSs.size() - 1) {
                            mLTH.traceError("Unable to retrieve Cimom2namespace for CIMOM ID" + mRCID + " and namespace " + bNS, pE);
                            mResult.setSRMMessage("HWN021802E", new String[0]);
                            mResult.setRc(10030);
                            throw pE;
                        }
                        mLTH.traceError("Unable to retrieve Cimom2namespace for CIMOM ID" + mRCID + " and namespace " + bNS, pE);
                        continue;
                    }
                    try {
                        if (mDeviceIsSubsystem) {
                            mCKSS = new CimkeySubsystem();
                            mCKSS.setSubsystemId(mSSID);
                            mCKSS.setCimNamespaceId(mNSID);
                            mCKSS.retrieve(mConn);
                        } else {
                            mCKSw = new CimkeySwitch();
                            mCKSw.setSwitchWwn(pDeviceID);
                            mCKSw.setCimNamespaceId(mNSID);
                            mCKSw.retrieve(mConn);
                        }
                    }
                    catch (SQLException pE) {
                        if (bI == mNSs.size() - 1) {
                            mLTH.traceError("Unable to retrieve Cimkey data for device " + pDeviceID + " and CimNamespace ID " + mNSID, pE);
                            mResult.setSRMMessage("HWN021802E", new String[0]);
                            mResult.setRc(10030);
                            throw pE;
                        }
                        mLTH.traceError("Unable to retrieve Cimkey data for device " + pDeviceID + " and CimNamespace ID " + mNSID, pE);
                        continue;
                    }
                    mLTH.traceInfo("Testing device status for device with ID" + pDeviceID + " thru CIMOM " + pServiceURL + " in namespace " + bNS);
                    CIMOM[] mCimoms = this.getCIMOMs(new String[]{pServiceURL});
                    CIMObjectPath mDeviceCOP = mDeviceIsSubsystem ? ExternalKeyManager.getCIMObjectPath(mCKSS, bNS) : ExternalKeyManager.getCIMObjectPath(mCKSw, bNS);
                    CimomAndDeviceStatus mCDS = this.testCIMOMConnection(mCimoms, mDeviceCOP);
                    CIMOMConnectionStatus mCimomStatus = mCDS.getCimomStatus(0);
                    DeviceStatus mDevStatus = mCDS.getDeviceStatus(0);
                    if (mCimomStatus.isSuccess()) {
                        mResult.setSRMMessage("HWN021811I", new String[]{pDeviceID, pServiceURL, mDevStatus.getStatusString()});
                        mResult.setRc(0);
                        break;
                    }
                    mResult.setSRMMessage("HWN021812E", new String[]{pDeviceID, pServiceURL, mCimomStatus.toString()});
                    mResult.setRc(10030);
                }
                try {
                    mConn.close();
                }
                catch (SQLException ignore) {}
                break block38;
                catch (SQLException pE) {
                    Result result;
                    try {
                        result = mResult;
                    }
                    catch (Throwable throwable) {
                        try {
                            mConn.close();
                        }
                        catch (SQLException ignore) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        mConn.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                    mLTH.exit(mResult);
                    return result;
                }
            }
            finally {
                mLTH.exit(mResult);
            }
        }
        return mResult;
    }

    private Vector getNamespacesForServiceUrl(LogTraceHelper mLTH, String bServiceUrl) {
        Vector<String> bNamespaces = new Vector<String>();
        DBConnection mConn = ServiceUtils.getConnection();
        if (mConn == null) {
            throw DiskMessageHelper.getServerException("HWN021800E", null, mLTH);
        }
        String mSQL = "select C2N.NAMESPACE from T_RES_CIMOM2NAMESPACE as C2N where C2N.CIMOM_ID IN (select RC.REG_CIMOM_ID from T_RES_REGISTERED_CIMOM as RC where RC.SERVICE_URL = '" + bServiceUrl + "'" + ")";
        DBResultSet mDBRS = null;
        try {
            mDBRS = ComplexQuery.sqlQuery(mConn, mSQL, new Hashtable());
            while (mDBRS.next()) {
                bNamespaces.add(mDBRS.getString(1));
            }
            mConn.commit();
        }
        catch (Exception pE) {
            mLTH.traceError("Unable to retrieve namespaces for CIMOM" + bServiceUrl + " due to " + pE.getMessage(), pE);
            throw DiskMessageHelper.getServerException("HWN021802E", (Object)pE.getMessage(), pE, mLTH);
        }
        finally {
            try {
                mConn.close();
            }
            catch (SQLException pE) {
                mLTH.traceError("Unable to close database connection due to " + pE.getMessage(), pE);
            }
        }
        return bNamespaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCIMOMIDs() throws ServerException {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "getCIMOMIDs", null);
        Object[] mResult = null;
        try {
            DBConnection mConn = ServiceUtils.getConnection();
            if (mConn == null) {
                throw DiskMessageHelper.getServerException("HWN021800E", null, mLTH);
            }
            Vector<String> mIDs = new Vector<String>();
            RegisteredCimom.RegisteredCimomCursor mCursor = null;
            try {
                mCursor = RegisteredCimom.getCursor(mConn, null, null);
                if (mCursor == null) {
                    throw DiskMessageHelper.getServerException("HWN021801E", null, mLTH);
                }
                while (mCursor.next()) {
                    RegisteredCimom bRegisteredCimom = mCursor.getObject();
                    if (bRegisteredCimom == null) {
                        throw DiskMessageHelper.getServerException("HWN021801E", null, mLTH);
                    }
                    if (bRegisteredCimom.getStatus() != CIMOMConnectionStatus.PENDING_DELETION.toID()) {
                        mIDs.add(bRegisteredCimom.getServiceUrl());
                        mLTH.traceInfo("CIMOM ID " + bRegisteredCimom.getServiceUrl() + " was retrieved");
                        continue;
                    }
                    mLTH.traceInfo("CIMOM ID " + bRegisteredCimom.getServiceUrl() + " was skipped because of deletion pending");
                }
            }
            catch (SQLException pEx) {
                throw DiskMessageHelper.getServerException("HWN021802E", (Object)pEx.getMessage(), pEx, mLTH);
            }
            finally {
                try {
                    if (mCursor != null) {
                        mCursor.close();
                    }
                    mConn.close();
                }
                catch (SQLException pEx) {
                    throw DiskMessageHelper.getServerException("HWN021802E", (Object)pEx.getMessage(), pEx, mLTH);
                }
            }
            mResult = new String[mIDs.size()];
            mIDs.copyInto(mResult);
            mLTH.exit(mResult);
        }
        catch (Throwable throwable) {
            mLTH.exit(mResult);
            throw throwable;
        }
        return mResult;
    }

    public CIMOM[] findCIMOMsByNetAddress(InetAddress pNetAddress) {
        try {
            CIMOM[] result = this.searchCimomInDb(pNetAddress.getHostAddress());
            if (result.length == 0) {
                result = this.searchCimomInDb(pNetAddress.getCanonicalHostName());
            }
            return result;
        }
        catch (SQLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CIMOM[] searchCimomInDb(String pUrlFragment) throws SQLException {
        CIMOM[] cIMOMArray;
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "searchCimomInDb", new Object[]{pUrlFragment});
        DBResultSet mDbResult = null;
        CIMOM[] bResult = null;
        DBConnection mConnection = null;
        try {
            mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
            mParameters.put(TResRegisteredCimomTable.getColumnInfo("SERVICE_URL"), "%//" + pUrlFragment + ":%");
            String mQueryString = "SELECT REG_CIMOM_ID,SERVICE_URL FROM " + TResRegisteredCimomTable.getTablename() + " WHERE " + "SERVICE_URL" + " LIKE (?)";
            mDbResult = ComplexQuery.sqlQuery(mConnection, mQueryString, mParameters);
            ArrayList<String> mIds = new ArrayList<String>();
            if (mDbResult.next()) {
                mIds.add(mDbResult.getString("SERVICE_URL"));
            }
            cIMOMArray = bResult = this.getCIMOMs(mIds.toArray(new String[mIds.size()]));
        }
        catch (Throwable throwable) {
            try {
                if (mDbResult != null) {
                    mDbResult.closeAll();
                }
            }
            catch (SQLException pE) {
                mLTH.traceError("Unable to close database result set due to " + pE.getMessage(), pE);
            }
            try {
                if (mConnection != null) {
                    mConnection.close();
                }
            }
            catch (SQLException pE) {
                mLTH.traceError("Unable to close database connection due to " + pE.getMessage(), pE);
            }
            mLTH.exit(bResult);
            throw throwable;
        }
        try {
            if (mDbResult != null) {
                mDbResult.closeAll();
            }
        }
        catch (SQLException pE) {
            mLTH.traceError("Unable to close database result set due to " + pE.getMessage(), pE);
        }
        try {
            if (mConnection != null) {
                mConnection.close();
            }
        }
        catch (SQLException pE) {
            mLTH.traceError("Unable to close database connection due to " + pE.getMessage(), pE);
        }
        mLTH.exit(bResult);
        return cIMOMArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCIMOMIDforURL(String pUrl) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "getCIMOMIDforURL", new Object[]{pUrl});
        DBConnection mConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
        DBResultSet mDbResult = null;
        int mReturn = 0;
        try {
            Hashtable<ColumnInfo, String> mParameters = new Hashtable<ColumnInfo, String>();
            mParameters.put(TResRegisteredCimomTable.getColumnInfo("SERVICE_URL"), pUrl);
            String mQueryString = "SELECT REG_CIMOM_ID,SERVICE_URL FROM " + TResRegisteredCimomTable.getTablename() + " WHERE " + "SERVICE_URL" + " = ?";
            mDbResult = ComplexQuery.sqlQuery(mConnection, mQueryString, mParameters);
            if (mDbResult.next()) {
                mReturn = mDbResult.getInt(1);
            }
        }
        finally {
            try {
                if (mDbResult != null) {
                    mDbResult.closeAll();
                }
            }
            catch (SQLException pE) {
                mLTH.traceError("Unable to close database result set due to " + pE.getMessage(), pE);
            }
            try {
                mConnection.close();
            }
            catch (SQLException pE) {
                mLTH.traceError("Unable to close database connection due to " + pE.getMessage(), pE);
            }
            mLTH.exit(Integer.toString(mReturn));
        }
        return mReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult discoverDevicesFromCIMOM(String[] pCimomIDs) throws ServerException, InvalidParameterException, MissingParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "discoverDevicesFromCIMOM", new Object[]{pCimomIDs});
        Object mResult = null;
        try {
            Object bObject = Activator._serviceHelper.bindLocal("DiscoverService");
            if (bObject == null) {
                throw DiskMessageHelper.getServerException("HWN021807E", null, mLTH);
            }
            IDiscover bProxy = (IDiscover)bObject;
            ParameterChecker.assertMandatoryParameter(1, "CimomIDs", pCimomIDs, mLTH);
            Hashtable<String, Object> mParams = new Hashtable<String, Object>();
            AsyncResult mReturn = new AsyncResult(0, -1);
            mParams.put("CIMOMID_PARAM", pCimomIDs);
            mParams.put("Type", "ToplevelALL");
            mLTH.traceSvcEntry("DiscoverServise.discover", new Object[]{mParams});
            String mJob = bProxy.discover("dispatchDiscoveryProcess", mParams);
            mLTH.traceSvcReturn("DiscoverServise.discover", mJob);
            AsyncResult asyncResult = mReturn = bProxy.getJobStatus(mJob);
            return asyncResult;
        }
        finally {
            mLTH.exit(mResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] checkForDuplicateCIMOMs(CIMOM[] pCimoms, DBConnection pConn) {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "checkForDuplicateCIMOMs", new Object[]{pCimoms, pConn});
        int[] mReturn = new int[pCimoms.length];
        try {
            CIMOM[] bDBCimoms = this.getCIMOMs();
            String bCimomURL = null;
            String bCheckURL = null;
            for (int bIndex = 0; bIndex < pCimoms.length; ++bIndex) {
                try {
                    bCimomURL = pCimoms[bIndex].getServiceUrl();
                    bCheckURL = this.parseHost(bCimomURL) + ":" + this.parsePort(bCimomURL);
                    if (bCheckURL.indexOf("null") > -1) {
                        mReturn[bIndex] = 2;
                        continue;
                    }
                    for (int bDBIndex = 0; bDBIndex < bDBCimoms.length; ++bDBIndex) {
                        if (bDBCimoms[bDBIndex].getServiceUrl().indexOf(bCheckURL) <= -1) continue;
                        mReturn[bIndex] = 1;
                        break;
                    }
                    pCimoms[bIndex].setServiceUrl(this.replaceHost(bCimomURL, bCheckURL));
                    continue;
                }
                catch (UnknownHostException pEx) {
                    mLTH.traceError(pEx.getMessage(), pEx);
                    mReturn[bIndex] = 2;
                }
            }
            int[] nArray = mReturn;
            return nArray;
        }
        finally {
            mLTH.exit(mReturn);
        }
    }

    private String parsePort(String pURL) {
        int mStartIndex = pURL.indexOf("://");
        int mColonIndex = pURL.indexOf(58, mStartIndex + 1);
        if (mColonIndex == -1 || mColonIndex == pURL.length() - 1) {
            return null;
        }
        return pURL.substring(mColonIndex + 1);
    }

    private String parseHost(String pURL) throws UnknownHostException {
        int mStartIndex = pURL.indexOf("://");
        int mEndIndex = pURL.indexOf(58, mStartIndex + 1);
        if (mStartIndex == -1 || mEndIndex == -1 || mEndIndex == pURL.length() - 1) {
            return null;
        }
        String mHost = pURL.substring(mStartIndex + 3, mEndIndex);
        return InetAddress.getByName(mHost).getHostAddress();
    }

    private String replaceHost(String pURL, String pHost) {
        int mStartIndex = pURL.indexOf("://");
        int mEndIndex = pURL.indexOf(58, mStartIndex + 1);
        if (mStartIndex == -1 || mEndIndex == -1 || mEndIndex == pURL.length() - 1) {
            return null;
        }
        return pURL.substring(0, mStartIndex) + "://" + pHost;
    }

    public static String getUniqueNumberString() {
        int mI;
        String mResult;
        int mLength = 7;
        if ((mResult = Integer.toString(mI = cUniqueInt++)).length() > mLength) {
            return mResult.substring(mResult.length() - mLength);
        }
        if (mResult.length() < mLength) {
            return "000000000000000000000000000".substring(0, mLength - mResult.length()) + mResult;
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean needsSaxParsing(String pServiceURL) {
        LogTraceHelper mLTH = LogTraceHelper.entry(CIMOMManager.class.getName(), "needsSaxParsing", new Object[]{pServiceURL});
        Boolean mReturn = null;
        try {
            mReturn = (Boolean)stSaxParsing.get(pServiceURL);
            if (mReturn == null) {
                String bReason = "subsystem type";
                mReturn = CIMOMManager.checkForSubsystemCIMOMParsing(pServiceURL);
                if (mReturn == null) {
                    bReason = "switch vendor";
                    mReturn = CIMOMManager.checkForVendorParsing(pServiceURL, CIMOMManager.getSwitchVendorForCIMOM(pServiceURL));
                    if (mReturn == null) {
                        bReason = "tape library vendor";
                        mReturn = CIMOMManager.checkForVendorParsing(pServiceURL, CIMOMManager.getLibraryVendorForCIMOM(pServiceURL));
                        if (mReturn == null) {
                            bReason = "namespace";
                            mReturn = CIMOMManager.checkForNamespaceofCIMOMParsing(pServiceURL);
                            if (mReturn == null) {
                                mReturn = Boolean.FALSE;
                                boolean bl = false;
                                return bl;
                            }
                        }
                    }
                }
                mLTH.traceWarning("Caching 'SAX parsing needed = " + mReturn.toString() + "' for CIMOM " + pServiceURL + " (Reason: " + bReason + ")");
                stSaxParsing.put(pServiceURL, mReturn);
            }
            boolean bl = mReturn;
            return bl;
        }
        finally {
            mLTH.exit(mReturn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Boolean checkForNamespaceofCIMOMParsing(String pServiceURL) {
        LogTraceHelper mLTH = LogTraceHelper.entry(CIMOMManager.class.getName(), "checkForNamespaceofCIMOMParsing", new Object[]{pServiceURL});
        Boolean mReturn = null;
        try {
            List mNSList = CIMOMManager.getNamespacesForCIMOM(pServiceURL);
            Iterator mNSIt = mNSList.iterator();
            String mNS = null;
            String mVer = null;
            while (mNSIt.hasNext()) {
                mNS = (String)mNSIt.next();
                mVer = (String)stParsNSpcDef.get(mNS);
                if (mVer == null) continue;
                mReturn = Boolean.TRUE;
            }
            Boolean bl = mReturn;
            return bl;
        }
        finally {
            mLTH.exit(mReturn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Boolean checkForVendorParsing(String pServiceURL, String pVendor) {
        Boolean mReturn;
        LogTraceHelper mLTH;
        block3: {
            mLTH = LogTraceHelper.entry(CIMOMManager.class.getName(), "checkForVendorParsing", new Object[]{pServiceURL, pVendor});
            mReturn = null;
            try {
                if (!VENDOR_UNKNOWN.equals(pVendor)) break block3;
                Boolean bl = null;
                mLTH.exit(mReturn);
                return bl;
            }
            catch (Throwable throwable) {
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        String bVer = (String)stParsVendorDef.get(pVendor);
        mReturn = bVer == null ? Boolean.FALSE : Boolean.TRUE;
        Boolean bl = mReturn;
        mLTH.exit(mReturn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Boolean checkForSubsystemCIMOMParsing(String pServiceURL) {
        String mDevType;
        Boolean mReturn;
        LogTraceHelper mLTH;
        block3: {
            mLTH = LogTraceHelper.entry(CIMOMManager.class.getName(), "checkForSubsystemCIMOMParsing", new Object[]{pServiceURL});
            mReturn = null;
            try {
                mDevType = CIMOMManager.getSubsystemTypeForCIMOM(pServiceURL);
                if (!DEVICE_TYPE_UNKNOWN.equals(mDevType) && !"Unknown".equals(mDevType)) break block3;
                Boolean bl = null;
                mLTH.exit(mReturn);
                return bl;
            }
            catch (Throwable throwable) {
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        String bVer = (String)stParsDevTypeDef.get(mDevType);
        mReturn = bVer == null ? Boolean.FALSE : Boolean.TRUE;
        Boolean bl = mReturn;
        mLTH.exit(mReturn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean allowsConcurrentAccess(String pServiceURL) {
        LogTraceHelper mLTH = LogTraceHelper.entry(CIMOMManager.class.getName(), "allowsConcurrentAccess", new Object[]{pServiceURL});
        Boolean mReturn = null;
        try {
            mReturn = (Boolean)stConcurrentAccess.get(pServiceURL);
            if (mReturn == null) {
                String bReason = "subsystem type";
                mReturn = CIMOMManager.checkForSubsystemCIMOM(pServiceURL);
                if (mReturn == null) {
                    bReason = "switch vendor";
                    mReturn = CIMOMManager.checkForVendor(pServiceURL, CIMOMManager.getSwitchVendorForCIMOM(pServiceURL));
                    if (mReturn == null) {
                        bReason = "tape library vendor";
                        mReturn = CIMOMManager.checkForVendor(pServiceURL, CIMOMManager.getLibraryVendorForCIMOM(pServiceURL));
                        if (mReturn == null) {
                            bReason = "namespace";
                            mReturn = CIMOMManager.checkForNamespaceofCIMOM(pServiceURL);
                            if (mReturn == null) {
                                mReturn = Boolean.TRUE;
                                boolean bl = true;
                                return bl;
                            }
                        }
                    }
                }
                mLTH.traceWarning("Caching 'concurrent access = " + mReturn.toString() + "' for CIMOM " + pServiceURL + " (Reason: " + bReason + ")");
                stConcurrentAccess.put(pServiceURL, mReturn);
            }
            boolean bl = mReturn;
            return bl;
        }
        finally {
            mLTH.exit(mReturn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Boolean checkForSubsystemCIMOM(String pServiceURL) {
        String mDevType;
        Boolean mReturn;
        LogTraceHelper mLTH;
        block3: {
            mLTH = LogTraceHelper.entry(CIMOMManager.class.getName(), "checkForSubsystemCIMOM", new Object[]{pServiceURL});
            mReturn = null;
            try {
                mDevType = CIMOMManager.getSubsystemTypeForCIMOM(pServiceURL);
                if (!DEVICE_TYPE_UNKNOWN.equals(mDevType) && !"Unknown".equals(mDevType)) break block3;
                Boolean bl = null;
                mLTH.exit(mReturn);
                return bl;
            }
            catch (Throwable throwable) {
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        String bVer = (String)stDevTypeDef.get(mDevType);
        mReturn = bVer == null ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl = mReturn;
        mLTH.exit(mReturn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Boolean checkForNamespaceofCIMOM(String pServiceURL) {
        LogTraceHelper mLTH = LogTraceHelper.entry(CIMOMManager.class.getName(), "checkForNamespaceofCIMOM", new Object[]{pServiceURL});
        Boolean mReturn = null;
        try {
            List mNSList = CIMOMManager.getNamespacesForCIMOM(pServiceURL);
            Iterator mNSIt = mNSList.iterator();
            String mNS = null;
            String mVer = null;
            while (mNSIt.hasNext()) {
                mNS = (String)mNSIt.next();
                mVer = (String)stNSpcDef.get(mNS);
                if (mVer == null) continue;
                mReturn = Boolean.FALSE;
            }
            Boolean bl = mReturn;
            return bl;
        }
        finally {
            mLTH.exit(mReturn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Boolean checkForVendor(String pServiceURL, String pVendor) {
        Boolean mReturn;
        LogTraceHelper mLTH;
        block3: {
            mLTH = LogTraceHelper.entry(CIMOMManager.class.getName(), "checkForVendor", new Object[]{pServiceURL, pVendor});
            mReturn = null;
            try {
                if (!VENDOR_UNKNOWN.equals(pVendor)) break block3;
                Boolean bl = null;
                mLTH.exit(mReturn);
                return bl;
            }
            catch (Throwable throwable) {
                mLTH.exit(mReturn);
                throw throwable;
            }
        }
        String bVer = (String)stVendorDef.get(pVendor);
        mReturn = bVer == null ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl = mReturn;
        mLTH.exit(mReturn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getSubsystemTypeForCIMOM(String pServiceURL) {
        StringBuffer mSQL = new StringBuffer();
        mSQL.append("select ss.").append("TYPE").append(" from ");
        mSQL.append(StorageSubsystem.getTablename()).append(" as ss where ss.");
        mSQL.append("SUBSYSTEM_ID").append(" in (select ck.");
        mSQL.append("SUBSYSTEM_ID").append(" from ").append(CimkeySubsystem.getTablename());
        mSQL.append(" as ck where ck.").append("CIM_NAMESPACE_ID").append(" in (select c2n.");
        mSQL.append("CIM_NAMESPACE_ID").append(" from ").append(Cimom2namespace.getTablename());
        mSQL.append(" as c2n where c2n.").append("CIMOM_ID").append(" in (select rc.");
        mSQL.append("REG_CIMOM_ID").append(" from ").append(RegisteredCimom.getTablename());
        mSQL.append(" as rc where rc.").append("SERVICE_URL").append("=?)))");
        DBConnection mConn = null;
        DBPreparedStatement mStmt = null;
        DBResultSet mRS = null;
        try {
            mConn = ServiceUtils.getConnection();
            mStmt = mConn.prepareStatement(mSQL.toString());
            mStmt.clearParameters();
            mStmt.setString(1, pServiceURL);
            mRS = mStmt.executeQuery();
            if (mRS.next()) {
                String string = mRS.getString(1);
                return string;
            }
            String string = DEVICE_TYPE_UNKNOWN;
            return string;
        }
        catch (Exception pEx) {
            String string = DEVICE_TYPE_UNKNOWN;
            return string;
        }
        finally {
            try {
                if (mRS != null) {
                    mRS.close();
                }
                if (mStmt != null) {
                    mStmt.close();
                }
                if (mConn != null) {
                    mConn.commit();
                    mConn.close();
                }
            }
            catch (SQLException pEx) {
                pEx.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getSwitchVendorForCIMOM(String pServiceURL) {
        StringBuffer mSQL = new StringBuffer();
        mSQL.append("select v.").append("VENDOR_NAME").append(" from ");
        mSQL.append(Vendor.getTablename()).append(" as v where v.").append("VENDOR_ID").append(" in (");
        mSQL.append("select sw.").append("VENDOR_ID").append(" from ");
        mSQL.append(Switch.getTablename()).append(" as sw where sw.");
        mSQL.append("SWITCH_WWN").append(" in (select ck.");
        mSQL.append("SWITCH_WWN").append(" from ").append(CimkeySwitch.getTablename());
        mSQL.append(" as ck where ck.").append("CIM_NAMESPACE_ID").append(" in (select c2n.");
        mSQL.append("CIM_NAMESPACE_ID").append(" from ").append(Cimom2namespace.getTablename());
        mSQL.append(" as c2n where c2n.").append("CIMOM_ID").append(" in (select rc.");
        mSQL.append("REG_CIMOM_ID").append(" from ").append(RegisteredCimom.getTablename());
        mSQL.append(" as rc where rc.").append("SERVICE_URL").append("=?))))");
        DBConnection mConn = null;
        DBPreparedStatement mStmt = null;
        DBResultSet mRS = null;
        try {
            mConn = ServiceUtils.getConnection();
            mStmt = mConn.prepareStatement(mSQL.toString());
            mStmt.clearParameters();
            mStmt.setString(1, pServiceURL);
            mRS = mStmt.executeQuery();
            if (mRS.next()) {
                String string = mRS.getString(1);
                return string;
            }
            String string = VENDOR_UNKNOWN;
            return string;
        }
        catch (Exception pEx) {
            String string = VENDOR_UNKNOWN;
            return string;
        }
        finally {
            try {
                if (mRS != null) {
                    mRS.close();
                }
                if (mStmt != null) {
                    mStmt.close();
                }
                if (mConn != null) {
                    mConn.commit();
                    mConn.close();
                }
            }
            catch (SQLException pEx) {
                pEx.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getLibraryVendorForCIMOM(String pServiceURL) {
        StringBuffer mSQL = new StringBuffer();
        mSQL.append("select v.").append("VENDOR_NAME").append(" from ");
        mSQL.append(Vendor.getTablename()).append(" as v where v.").append("VENDOR_ID").append(" in (");
        mSQL.append("select tf.").append("VENDOR_ID").append(" from ");
        mSQL.append(TapeFrame.getTablename()).append(" as tf where tf.");
        mSQL.append("TAPE_LIBRARY_ID").append(" in (select ck.");
        mSQL.append("TAPE_LIBRARY_ID").append(" from ").append(CimkeyTapeLibrary.getTablename());
        mSQL.append(" as ck where ck.").append("CIM_NAMESPACE_ID").append(" in (select c2n.");
        mSQL.append("CIM_NAMESPACE_ID").append(" from ").append(Cimom2namespace.getTablename());
        mSQL.append(" as c2n where c2n.").append("CIMOM_ID").append(" in (select rc.");
        mSQL.append("REG_CIMOM_ID").append(" from ").append(RegisteredCimom.getTablename());
        mSQL.append(" as rc where rc.").append("SERVICE_URL").append("=?))))");
        DBConnection mConn = null;
        DBPreparedStatement mStmt = null;
        DBResultSet mRS = null;
        try {
            mConn = ServiceUtils.getConnection();
            mStmt = mConn.prepareStatement(mSQL.toString());
            mStmt.clearParameters();
            mStmt.setString(1, pServiceURL);
            mRS = mStmt.executeQuery();
            if (mRS.next()) {
                String string = mRS.getString(1);
                return string;
            }
            String string = VENDOR_UNKNOWN;
            return string;
        }
        catch (Exception pEx) {
            String string = VENDOR_UNKNOWN;
            return string;
        }
        finally {
            try {
                if (mRS != null) {
                    mRS.close();
                }
                if (mStmt != null) {
                    mStmt.close();
                }
                if (mConn != null) {
                    mConn.commit();
                    mConn.close();
                }
            }
            catch (SQLException pEx) {
                pEx.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List getNamespacesForCIMOM(String pServiceURL) {
        StringBuffer mSQL = new StringBuffer();
        mSQL.append("select c2n.").append("NAMESPACE").append(" from ").append(Cimom2namespace.getTablename());
        mSQL.append(" as c2n where c2n.").append("CIMOM_ID").append(" in (select rc.");
        mSQL.append("REG_CIMOM_ID").append(" from ").append(RegisteredCimom.getTablename());
        mSQL.append(" as rc where rc.").append("SERVICE_URL").append("=?)");
        DBConnection mConn = null;
        DBPreparedStatement mStmt = null;
        DBResultSet mRS = null;
        ArrayList<String> mReturn = new ArrayList<String>();
        try {
            mConn = ServiceUtils.getConnection();
            mStmt = mConn.prepareStatement(mSQL.toString());
            mStmt.clearParameters();
            mStmt.setString(1, pServiceURL);
            mRS = mStmt.executeQuery();
            while (mRS.next()) {
                mReturn.add(mRS.getString(1));
            }
            ArrayList<String> arrayList = mReturn;
            return arrayList;
        }
        catch (Exception pEx) {
            ArrayList arrayList = new ArrayList();
            return arrayList;
        }
        finally {
            try {
                if (mRS != null) {
                    mRS.close();
                }
                if (mStmt != null) {
                    mStmt.close();
                }
                if (mConn != null) {
                    mConn.commit();
                    mConn.close();
                }
            }
            catch (SQLException pEx) {
                pEx.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map getDefinitionForSync(String pConfKey) {
        LogTraceHelper mLTH = LogTraceHelper.entry(CIMOMManager.class.getName(), "getDefinitionForSync", new Object[]{pConfKey});
        HashMap<String, String> mReturn = new HashMap<String, String>();
        try {
            String mCheckInfo = DiskManagerConfigSvc.getConfigValue(pConfKey, null);
            if (mCheckInfo != null && mCheckInfo.trim().length() > 0) {
                StringTokenizer mT = new StringTokenizer(mCheckInfo, "]");
                String mDef = null;
                String[] mElements = null;
                while (mT.hasMoreTokens()) {
                    mDef = mT.nextToken().substring(1);
                    mElements = mDef.split(";");
                    mLTH.traceWarning("Using synchronized access for device type " + mDef);
                    if (mElements.length > 1) {
                        mReturn.put(mElements[0], mElements[1]);
                        continue;
                    }
                    mReturn.put(mElements[0], "*");
                }
            }
            HashMap<String, String> hashMap = mReturn;
            return hashMap;
        }
        finally {
            mLTH.exit(mReturn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCIMOMUsage(String pServiceURL) {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "registerCIMOMUsage", new Object[]{pServiceURL});
        try {
            if (pServiceURL == null || pServiceURL.length() == 0) {
                return;
            }
            Map map = stUsedCIMOMs;
            synchronized (map) {
                Integer bUsedCount = (Integer)stUsedCIMOMs.get(pServiceURL);
                if (bUsedCount == null) {
                    stUsedCIMOMs.put(pServiceURL, new Integer(1));
                } else {
                    bUsedCount = new Integer(bUsedCount + 1);
                    stUsedCIMOMs.put(pServiceURL, bUsedCount);
                }
            }
        }
        catch (Throwable bEX) {
            mLTH.traceError("Exception with CIMOM " + pServiceURL + ": " + bEX.getMessage(), bEX);
        }
        finally {
            mLTH.exit("null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deRegisterCIMOMUsage(String pServiceURL) {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "registerCIMOMUsage", new Object[]{pServiceURL});
        try {
            int mNewUsedCount;
            if (pServiceURL == null || pServiceURL.length() == 0) {
                return;
            }
            Map map = stUsedCIMOMs;
            synchronized (map) {
                Integer bUsedCount = (Integer)stUsedCIMOMs.get(pServiceURL);
                if (bUsedCount != null) {
                    mNewUsedCount = bUsedCount - 1;
                    if (mNewUsedCount == 0) {
                        stUsedCIMOMs.remove(pServiceURL);
                    } else {
                        stUsedCIMOMs.put(pServiceURL, new Integer(mNewUsedCount));
                    }
                } else {
                    throw new Exception("Usage Count for CIMOM " + pServiceURL + " not found!");
                }
            }
            if (mNewUsedCount == 0 && stPendingCIMOMDeletions.contains(pServiceURL)) {
                this.processPendingCIMOMDeletion(pServiceURL);
            }
        }
        catch (Throwable bEX) {
            mLTH.traceError("Exception with CIMOM " + pServiceURL + ": " + bEX.getMessage(), bEX);
        }
        finally {
            mLTH.exit("null");
        }
    }
}

