/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common;

import java.sql.SQLException;
import java.util.Arrays;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.CIMOMSelectorDbHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.ParameterHelper;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySwitch;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyTapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.TapeFrame;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.sblim.wbem.cim.CIMObjectPath;

public class CIMOMSelector {
    private static CIMOMSelector stSelector = new CIMOMSelector();

    public static CIMOMSelector getSelector() {
        return stSelector;
    }

    private CIMOMSelector() {
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SubsystemConnectionData getCimomForSubsystem(int pSubsystemId) throws NoCimomAvailableException {
        block11: {
            block10: {
                mLTH = LogTraceHelper.entry(this, "getCimomForSubsystem", new Object[]{new Integer(pSubsystemId)});
                mResult = null;
                try {
                    mCimomInfos = CIMOMSelectorDbHelper.Subsystem.getCimomInformation(pSubsystemId);
                    if (mCimomInfos.length == 0) {
                        CIMOMSelectorDbHelper.Subsystem.setMissing(pSubsystemId);
                        throw new NoCimomAvailableException(new SRMMessage("HWN021801E", null));
                    }
                    Arrays.sort(mCimomInfos);
                    pCIMOMUrls = new String[mCimomInfos.length];
                    i = 0;
lbl11:
                    // 2 sources

                    while (i < mCimomInfos.length) {
                        bCimomInfo = mCimomInfos[i];
                        try {
                            bCimom = CIMOMSelectorDbHelper.getCimom(bCimomInfo.getId());
                            pCIMOMUrls[i] = bCimom.getServiceUrl();
                            bSubsystemMapping = CIMOMSelectorDbHelper.Subsystem.getCimNamespaceMapping(pSubsystemId, bCimomInfo.getNamespaceId());
                            bPath = ExternalKeyManager.getCIMObjectPath(bSubsystemMapping, bCimomInfo.getNamespace());
                            bStatus = CIMOMManager.getCIMOMManager().testCIMOMConnection(new CIMOM[]{bCimom}, bPath);
                            if (bStatus.getCimomStatus(0).isSuccess() && !bStatus.getDeviceStatus(0).isDisconnected()) {
                                CIMOMSelectorDbHelper.Subsystem.setVisible(pSubsystemId);
                                var12_14 = mResult = new SubsystemConnectionData(bCimom, pSubsystemId, bCimomInfo.getNamespace(), bCimomInfo.getNamespaceId(), bPath);
                                mLTH.exit(mResult);
                                return var12_14;
                            }
                            CIMOMSelectorDbHelper.Subsystem.degradeCimomPriority(bCimomInfo.getNamespaceId(), pSubsystemId);
                        }
                        catch (Exception e) {
                            mLTH.traceError("HWN021503E", e);
                        }
                        break block10;
                    }
                    break block11;
                }
                catch (SQLException e) {
                    throw new NoCimomAvailableException(new SRMMessage("HWN021503E", null), (Throwable)e);
                }
                catch (Throwable var13_15) {
                    mLTH.exit(mResult);
                    throw var13_15;
                }
            }
            ++i;
            ** GOTO lbl11
        }
        CIMOMSelectorDbHelper.Subsystem.setMissing(pSubsystemId);
        throw new NoCimomAvailableException(new SRMMessage("HWN021808E", new String[]{ParameterHelper.stringArrayToString(pCIMOMUrls)}));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SwitchConnectionData getCimomForSwitch(String pSwitchWwn) throws NoCimomAvailableException {
        block11: {
            block10: {
                mLTH = LogTraceHelper.entry(this, "getCimomForSwitch", new Object[]{pSwitchWwn});
                mResult = null;
                try {
                    mCimomInfos = CIMOMSelectorDbHelper.Switch.getCimomInformation(pSwitchWwn);
                    if (mCimomInfos.length == 0) {
                        CIMOMSelectorDbHelper.Switch.setMissing(pSwitchWwn);
                        throw new NoCimomAvailableException(new SRMMessage("HWN021801E", null));
                    }
                    Arrays.sort(mCimomInfos);
                    pCIMOMUrls = new String[mCimomInfos.length];
                    i = 0;
lbl11:
                    // 2 sources

                    while (i < mCimomInfos.length) {
                        bCimomInfo = mCimomInfos[i];
                        try {
                            bCimom = CIMOMSelectorDbHelper.getCimom(bCimomInfo.getId());
                            pCIMOMUrls[i] = bCimom.getServiceUrl();
                            bSwitchMapping = CIMOMSelectorDbHelper.Switch.getCimNamespaceMapping(pSwitchWwn, bCimomInfo.getNamespaceId());
                            bPath = ExternalKeyManager.getCIMObjectPath(bSwitchMapping, bCimomInfo.getNamespace());
                            bStatus = CIMOMManager.getCIMOMManager().testCIMOMConnection(new CIMOM[]{bCimom}, bPath);
                            if (bStatus.getCimomStatus(0).isSuccess() && !bStatus.getDeviceStatus(0).isDisconnected()) {
                                CIMOMSelectorDbHelper.Switch.setVisible(pSwitchWwn);
                                var12_14 = mResult = new SwitchConnectionData(bCimom, pSwitchWwn, bCimomInfo.getNamespace(), bCimomInfo.getNamespaceId(), bPath);
                                mLTH.exit(mResult);
                                return var12_14;
                            }
                            CIMOMSelectorDbHelper.Switch.degradeCimomPriority(bCimomInfo.getNamespaceId(), pSwitchWwn);
                        }
                        catch (Exception e) {
                            mLTH.traceError("HWN021503E", e);
                        }
                        break block10;
                    }
                    break block11;
                }
                catch (SQLException e) {
                    throw new NoCimomAvailableException(new SRMMessage("HWN021503E", null), (Throwable)e);
                }
                catch (Throwable var13_15) {
                    mLTH.exit(mResult);
                    throw var13_15;
                }
            }
            ++i;
            ** GOTO lbl11
        }
        CIMOMSelectorDbHelper.Switch.setMissing(pSwitchWwn);
        throw new NoCimomAvailableException(new SRMMessage("HWN021808E", new String[]{ParameterHelper.stringArrayToString(pCIMOMUrls)}));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TapeLibraryConnectionData getCimomForTapeLibrary(int pTapeLibraryId) throws NoCimomAvailableException {
        block11: {
            block10: {
                mLTH = LogTraceHelper.entry(this, "getCimomForTapeLibrary", new Object[]{new Integer(pTapeLibraryId)});
                mResult = null;
                try {
                    mCimomInfos = CIMOMSelectorDbHelper.Tape.getCimomInformation(pTapeLibraryId);
                    if (mCimomInfos.length == 0) {
                        CIMOMSelectorDbHelper.Tape.setMissing(pTapeLibraryId);
                        throw new NoCimomAvailableException(new SRMMessage("HWN021801E", null));
                    }
                    Arrays.sort(mCimomInfos);
                    pCIMOMUrls = new String[mCimomInfos.length];
                    i = 0;
lbl11:
                    // 2 sources

                    while (i < mCimomInfos.length) {
                        bCimomInfo = mCimomInfos[i];
                        try {
                            bCimom = CIMOMSelectorDbHelper.getCimom(bCimomInfo.getId());
                            pCIMOMUrls[i] = bCimom.getServiceUrl();
                            bLibraryMapping = CIMOMSelectorDbHelper.Tape.getCimNamespaceMapping(pTapeLibraryId, bCimomInfo.getNamespaceId());
                            bPath = ExternalKeyManager.getCIMObjectPath(bLibraryMapping, bCimomInfo.getNamespace());
                            bStatus = CIMOMManager.getCIMOMManager().testCIMOMConnection(new CIMOM[]{bCimom}, bPath);
                            if (bStatus.getCimomStatus(0).isSuccess() && !bStatus.getDeviceStatus(0).isDisconnected()) {
                                CIMOMSelectorDbHelper.Tape.setVisible(pTapeLibraryId);
                                var12_14 = mResult = new TapeLibraryConnectionData(bCimom, pTapeLibraryId, bCimomInfo.getNamespace(), bCimomInfo.getNamespaceId(), bPath);
                                mLTH.exit(mResult);
                                return var12_14;
                            }
                            CIMOMSelectorDbHelper.Tape.degradeCimomPriority(bCimomInfo.getNamespaceId(), pTapeLibraryId);
                        }
                        catch (Exception e) {
                            mLTH.traceError("HWN021503E", e);
                        }
                        break block10;
                    }
                    break block11;
                }
                catch (SQLException e) {
                    throw new NoCimomAvailableException(new SRMMessage("HWN021503E", null), (Throwable)e);
                }
                catch (Throwable var13_15) {
                    mLTH.exit(mResult);
                    throw var13_15;
                }
            }
            ++i;
            ** GOTO lbl11
        }
        CIMOMSelectorDbHelper.Tape.setMissing(pTapeLibraryId);
        throw new NoCimomAvailableException(new SRMMessage("HWN021808E", new String[]{ParameterHelper.stringArrayToString(pCIMOMUrls)}));
    }

    public void activateCimomForSubsystem(int pNamespaceId, int pSubsytemId) {
        try {
            CimkeySubsystem mCKS = CIMOMSelectorDbHelper.Subsystem.getCimNamespaceMapping(pSubsytemId, pNamespaceId);
            if (mCKS.getActive() == 0 && !CIMOMSelectorDbHelper.Subsystem.degradeCimomPriority(pNamespaceId, pSubsytemId)) {
                throw new RuntimeException("Database update failed.");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void activateCimomForSwitch(int pNamespaceId, String pSwitchWwn) {
        try {
            CimkeySwitch mCKS = CIMOMSelectorDbHelper.Switch.getCimNamespaceMapping(pSwitchWwn, pNamespaceId);
            if (mCKS.getActive() == 0 && !CIMOMSelectorDbHelper.Switch.degradeCimomPriority(pNamespaceId, pSwitchWwn)) {
                throw new RuntimeException("Database update failed.");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void activateCimomForTapeLibrary(int pNamespaceId, int pLibraryId) {
        try {
            CimkeyTapeLibrary mCKTL = CIMOMSelectorDbHelper.Tape.getCimNamespaceMapping(pLibraryId, pNamespaceId);
            if (mCKTL.getActive() == 0 && !CIMOMSelectorDbHelper.Tape.degradeCimomPriority(pNamespaceId, pLibraryId)) {
                throw new RuntimeException("Database update failed.");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static class SwitchConnectionData {
        private CIMOM cCimom;
        private String cSwitchWwn;
        private Switch cSwitch;
        private String cCimNamespace;
        private int cCimNamespaceId;
        private CIMObjectPath cSwitchCop;

        public SwitchConnectionData(CIMOM pCimom, String pSwitchWwn, String pNamespace, int pNamespaceId, CIMObjectPath pSwitchCop) {
            this.cCimom = pCimom;
            this.cSwitchWwn = pSwitchWwn;
            this.cCimNamespace = pNamespace;
            this.cCimNamespaceId = pNamespaceId;
            this.cSwitchCop = pSwitchCop;
            this.cSwitch = null;
        }

        public Switch getSwitch() {
            if (this.cSwitch == null) {
                try {
                    this.cSwitch = CIMOMSelectorDbHelper.Switch.getSwitch(this.cSwitchWwn);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.cSwitch;
        }

        public CIMClientWrapper getClientWrapper() {
            return CIMClientPool.getClient(this.cCimom.getUserId(), this.cCimom.getPassword(), this.cCimom.getServiceUrl(), this.cCimNamespace);
        }

        public String getCimNamespace() {
            return this.cCimNamespace;
        }

        public int getCimNamespaceId() {
            return this.cCimNamespaceId;
        }

        public CIMOM getCimom() {
            return this.cCimom;
        }

        public CIMObjectPath getSwitchCop() {
            return this.cSwitchCop;
        }

        public int getSwitchId() {
            return this.getSwitch().getSwitchId();
        }

        public String getSwitchWwn() {
            return this.cSwitchWwn;
        }
    }

    public static class TapeLibraryConnectionData {
        private CIMOM cCimom;
        private int cTapeLibraryId;
        private TapeLibrary cTapeLibrary;
        private CapabilityData cCapability;
        private TapeFrame cTapeFrame;
        private String cCimNamespace;
        private int cCimNamespaceId;
        private CIMObjectPath cTapeLibraryCop;

        public TapeLibraryConnectionData(CIMOM pCimom, int pTapeLibraryId, String pNamespace, int pNamespaceId, CIMObjectPath pTapeLibraryCop) {
            this.cCimom = pCimom;
            this.cTapeLibraryId = pTapeLibraryId;
            this.cCimNamespace = pNamespace;
            this.cCimNamespaceId = pNamespaceId;
            this.cTapeLibraryCop = pTapeLibraryCop;
            this.cTapeLibrary = null;
        }

        public String getCimNamespace() {
            return this.cCimNamespace;
        }

        public CIMOM getCimom() {
            return this.cCimom;
        }

        public TapeLibrary getTapeLibrary() {
            if (this.cTapeLibrary == null) {
                try {
                    this.cTapeLibrary = CIMOMSelectorDbHelper.Tape.getTapeLibrary(this.cTapeLibraryId);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.cTapeLibrary;
        }

        public TapeFrame getTapeFrame() {
            if (this.cTapeFrame == null) {
                try {
                    this.cTapeFrame = CIMOMSelectorDbHelper.Tape.getTapeFrame(this.cTapeLibraryId);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.cTapeFrame;
        }

        public CIMObjectPath getTapeLibraryCop() {
            return this.cTapeLibraryCop;
        }

        public int getTapeLibraryId() {
            return this.cTapeLibraryId;
        }

        public CapabilityData getCapability() {
            if (this.cCapability == null) {
                try {
                    this.cCapability = CIMOMSelectorDbHelper.getCapabilityData(CIMOMSelectorDbHelper.Tape.getCorrespondingCapabilityDataId(this.cCimNamespaceId, this.cTapeLibraryId));
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.cCapability;
        }

        public int getCimNamespaceID() {
            return this.cCimNamespaceId;
        }

        public CIMClientWrapper getClientWrapper() {
            return CIMClientPool.getClient(this.cCimom.getUserId(), this.cCimom.getPassword(), this.cCimom.getServiceUrl(), this.cCimNamespace);
        }
    }

    public static class SubsystemConnectionData {
        private CIMOM cCimom;
        private int cSubsystemId;
        private StorageSubsystem cSubsystem;
        private CapabilityData cCapability;
        private String cCimNamespace;
        private int cCimNamespaceId;
        private CIMObjectPath cSubsystemCop;

        public SubsystemConnectionData(CIMOM pCimom, int pSubsystemId, String pNamespace, int pNamespaceId, CIMObjectPath pSubsystemCop) {
            this.cCimom = pCimom;
            this.cSubsystemId = pSubsystemId;
            this.cCimNamespace = pNamespace;
            this.cCimNamespaceId = pNamespaceId;
            this.cSubsystemCop = pSubsystemCop;
            this.cSubsystem = null;
            this.cCapability = null;
        }

        public CapabilityData getCapability() {
            if (this.cCapability == null) {
                try {
                    this.cCapability = CIMOMSelectorDbHelper.getCapabilityData(CIMOMSelectorDbHelper.Subsystem.getCorrespondingCapabilityDataId(this.cCimNamespaceId, this.cSubsystemId));
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.cCapability;
        }

        public String getCimNamespace() {
            return this.cCimNamespace;
        }

        public CIMOM getCimom() {
            return this.cCimom;
        }

        public StorageSubsystem getSubsystem() {
            if (this.cSubsystem == null) {
                try {
                    this.cSubsystem = CIMOMSelectorDbHelper.Subsystem.getSubsystem(this.cSubsystemId);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.cSubsystem;
        }

        public CIMObjectPath getSubsystemCop() {
            return this.cSubsystemCop;
        }

        public int getSubsystemId() {
            return this.cSubsystemId;
        }

        public int getCimNamespaceID() {
            return this.cCimNamespaceId;
        }

        public CIMClientWrapper getClientWrapper() {
            return CIMClientPool.getClient(this.cCimom.getUserId(), this.cCimom.getPassword(), this.cCimom.getServiceUrl(), this.cCimNamespace);
        }
    }

    public static class NoCimomAvailableException
    extends ServerException {
        public NoCimomAvailableException(SRMMessage pMessage) {
            super(pMessage);
        }

        public NoCimomAvailableException(SRMMessage pMessage, Throwable pCause) {
            super(pMessage, pCause);
        }
    }
}

