/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.log;

import com.ibm.log.Level;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.InstancePool;
import org.eclipse.aperi.disk.resources.APIMessages;
import org.eclipse.aperi.disk.resources.DMTraceMessages;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public final class LogTraceHelperFactory
extends InstancePool {
    private static LogTraceHelperFactory stSingletonInstance = null;
    private ILogger cMsgLogger = null;
    private ILogger cTrcLogger = null;
    private ResourceBundle cTraceMsgBundle = null;
    private ResourceBundle cAPIMsgBundle = null;
    private ThreadLocal cReqID = null;
    private long cReqCounter = Long.MIN_VALUE;
    private long cExecCounter = Long.MIN_VALUE;

    private LogTraceHelperFactory() {
        super(DiskManagerConfigSvc.getIntConfigValue("LogTraceHelper.PoolSize", 250));
        this.cTraceMsgBundle = ResourceBundle.getBundle(DMTraceMessages.class.getName(), Locale.getDefault());
        this.cAPIMsgBundle = ResourceBundle.getBundle(APIMessages.class.getName(), Locale.US);
        this.setupLogging();
        this.cReqID = new ThreadLocal();
    }

    private static LogTraceHelperFactory get() {
        return stSingletonInstance;
    }

    private void setupLogging() {
        this.cMsgLogger = LogManagerFactory.getMessageLogger("aperi.logger.message.DiskManager");
        this.cMsgLogger.setMessageFile(APIMessages.class.getName());
        this.cTrcLogger = LogManagerFactory.getMessageLogger("aperi.logger.trace.DiskManager");
    }

    public static LogTraceHelper getLTHelper(String pJobID, Object pClass, String pMethod, Request pDiscoverRequest, Token pCtrlToken) {
        LogTraceHelper mLTHelper = (LogTraceHelper)LogTraceHelperFactory.get().getClearInstance();
        long[] mReqID = (long[])LogTraceHelperFactory.get().cReqID.get();
        if (mReqID == null) {
            mReqID = new long[]{LogTraceHelperFactory.getInternalRequestID(), 0L, 0L};
        } else {
            mReqID[2] = mReqID[2] + 1L;
        }
        LogTraceHelperFactory.registerReqCtxt(mReqID);
        if (mLTHelper != null) {
            if (mLTHelper.isInPool()) {
                mLTHelper.traceWarning("Using pooled instance of LogTraceHelper");
            }
            mLTHelper.initializeInstance(pJobID, pClass, pMethod, pDiscoverRequest, pCtrlToken, mReqID);
            return mLTHelper;
        }
        return new LogTraceHelper(pJobID, pClass, pMethod, pDiscoverRequest, pCtrlToken, mReqID);
    }

    public static void returnInstance(LogTraceHelper pHelper) {
        LogTraceHelperFactory.deregisterReqCtxt();
        LogTraceHelperFactory.get().returnInst(pHelper);
    }

    protected static ILogger getDMMsgLogger() {
        return LogTraceHelperFactory.get().cMsgLogger;
    }

    protected static ILogger getDMTrcLogger() {
        return LogTraceHelperFactory.get().cTrcLogger;
    }

    public static String resolveMessage(String pMsgID, Object[] pParams) {
        String mMsgTemplate = LogTraceHelperFactory.get().cTraceMsgBundle.getString(pMsgID);
        if (mMsgTemplate == null) {
            return pMsgID + "(not resolvable): " + DiskMessageHelper.toMsgString(pParams);
        }
        return MessageFormat.format(mMsgTemplate, pParams);
    }

    public static String resolveAPIMessage(String pMsgID, Object[] pParams) {
        String mMsgTemplate = LogTraceHelperFactory.get().cAPIMsgBundle.getString(pMsgID);
        if (mMsgTemplate == null) {
            return pMsgID + "(not resolvable): " + DiskMessageHelper.toMsgString(pParams);
        }
        return "Msg: " + MessageFormat.format(mMsgTemplate, pParams);
    }

    protected static long getInternalRequestID() {
        return ++LogTraceHelperFactory.get().cReqCounter;
    }

    protected static long getInternalExecID() {
        return ++LogTraceHelperFactory.get().cExecCounter;
    }

    private static void registerReqCtxt(long[] pCtxt) {
        LogTraceHelperFactory.get().cReqID.set(pCtxt);
    }

    private static void deregisterReqCtxt() {
        try {
            long[] mReqID = (long[])LogTraceHelperFactory.get().cReqID.get();
            if (mReqID != null) {
                if (mReqID[2] > 0L) {
                    mReqID[2] = mReqID[2] - 1L;
                    LogTraceHelperFactory.get().cReqID.set(mReqID);
                } else {
                    LogTraceHelperFactory.get().cReqID.set(null);
                }
            } else {
                ILogger bTrcLogger = LogTraceHelperFactory.getDMTrcLogger();
                if (bTrcLogger != null && bTrcLogger.isLogging()) {
                    bTrcLogger.text(Level.WARN, "LogTraceHelperFactory", "deregisterReqCtxt", LogTraceHelperFactory.resolveMessage("HWN099992W", new Object[]{"Request context was already deregistered", "0;[0,0,0];0;" + Thread.currentThread().getName()}));
                }
            }
        }
        catch (Exception pEx) {
            System.err.println("Error during LogTraceHelperFactory.deregisterReqCtxt()");
            pEx.printStackTrace();
        }
    }

    static {
        stSingletonInstance = new LogTraceHelperFactory();
    }
}

