/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util.thread;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.Reusable;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadManager;
import org.eclipse.aperi.disk.common.util.thread.ThreadObserver;

public class DiskMgrThread
extends Thread
implements Reusable {
    private static final long PAUSE = 10000L;
    private static long stThreadCount = 0L;
    private DiskThreadManager cThreadMgr = null;
    private boolean cIsInPool = false;
    private boolean cContinue = true;
    private Object cExecInstance = null;
    private Method cMethod = null;
    private Object[] cParams = null;
    private Object cResult = null;
    private Throwable cThrowable = null;
    private boolean cIsSetUp = false;
    private boolean cIsExecutionComplete = false;
    private ThreadObserver cObserver = null;

    public DiskMgrThread(DiskThreadManager pMgr) {
        super("DiskManagerThread-" + ++stThreadCount);
        this.cThreadMgr = pMgr;
    }

    public void clearInstance() {
        this.cExecInstance = null;
        this.cMethod = null;
        this.cParams = null;
        this.cResult = null;
        this.cThrowable = null;
        this.cIsSetUp = false;
        this.cIsExecutionComplete = false;
        this.cObserver = null;
    }

    public boolean isInPool() {
        return this.cIsInPool;
    }

    public void setIsInPool(boolean pInPool) {
        this.cIsInPool = pInPool;
    }

    public boolean cIsExecutionComplete() {
        return this.cIsExecutionComplete;
    }

    public Object getResult() {
        return this.cResult;
    }

    public Throwable getThrowable() {
        return this.cThrowable;
    }

    public void releaseThread() {
        this.cContinue = false;
    }

    public void releaseInstance() {
        this.releaseThread();
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(ThreadObserver pInvoker, Object pInstance, String pMethod, Class[] pParamTypes, Object[] pParams) throws NoSuchMethodException {
        this.cObserver = pInvoker;
        this.cExecInstance = pInstance;
        this.cMethod = this.cExecInstance.getClass().getMethod(pMethod, pParamTypes);
        this.cParams = pParams;
        DiskMgrThread diskMgrThread = this;
        synchronized (diskMgrThread) {
            this.cIsSetUp = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "run", null);
        try {
            while (this.cContinue) {
                DiskMgrThread diskMgrThread = this;
                synchronized (diskMgrThread) {
                    while (!this.cIsSetUp) {
                        try {
                            this.wait(10000L);
                        }
                        catch (InterruptedException pEx) {
                            // empty catch block
                        }
                        if (this.cContinue) continue;
                        mLTH.traceHigh("Thread has been released. Exiting.");
                        return;
                    }
                }
                String bName = this.getName();
                try {
                    StringBuffer bMName = new StringBuffer();
                    bMName.append(bName);
                    bMName.append(" - ");
                    bMName.append(this.cMethod.getName());
                    bMName.append("(");
                    bMName.append(DiskMessageHelper.toMsgString(this.cParams));
                    bMName.append(")");
                    this.setName(bMName.toString());
                    this.cResult = this.cMethod.invoke(this.cExecInstance, this.cParams);
                }
                catch (Throwable pEx) {
                    String bExMsg = null;
                    if (pEx instanceof InvocationTargetException) {
                        Throwable bCause = ((InvocationTargetException)pEx).getCause();
                        bExMsg = bCause != null ? bCause.toString() : pEx.toString();
                        this.cThrowable = bCause != null ? bCause : pEx;
                    } else {
                        bExMsg = pEx.toString();
                        this.cThrowable = pEx;
                    }
                    mLTH.traceWarning("Method invokation on thread " + this.getName() + " returned an error: " + bExMsg);
                }
                finally {
                    this.setName(bName);
                    this.cIsExecutionComplete = true;
                    this.cIsSetUp = false;
                    try {
                        this.cObserver.notifyExecutionComplete();
                    }
                    catch (Exception pEx) {
                        mLTH.traceInfo("Exception :" + pEx.toString());
                    }
                }
            }
            return;
        }
        finally {
            mLTH.exit("void");
        }
    }
}

