/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control.util;

import java.util.ArrayList;
import org.eclipse.aperi.disk.control.util.ConfigurationParameter;
import org.eclipse.aperi.disk.control.util.OutputHelper;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.sblim.wbem.cim.CIMObjectPath;

public class ModifyStoragePoolParameter
extends ConfigurationParameter {
    private StoragePool storagePool;
    private CIMObjectPath storagePoolCIMOP;
    private ArrayList storageExtentsToAdd = new ArrayList();
    private ArrayList storageExtentsToAddCIMOP = new ArrayList();
    private ArrayList storageExtentsToRemove = new ArrayList();
    private ArrayList storageExtentsToRemoveCIMOP = new ArrayList();

    public ModifyStoragePoolParameter(StorageSubsystem pStorageSubsystem, CIMObjectPath pStorageSystemCIMOP) {
        super(pStorageSubsystem, pStorageSystemCIMOP);
    }

    public void addModifyStoragePoolParameter(StoragePool pStoragePool, CIMObjectPath pStoragePoolCIMOP, StorageExtent[] pStorageExtentsToAdd, CIMObjectPath[] pStorageExtentsToAddCIMOP, StorageExtent[] pStorageExtentsToRemove, CIMObjectPath[] pStorageExtentsToRemoveCIMOP) {
        int idx;
        this.storagePool = pStoragePool;
        this.storagePoolCIMOP = pStoragePoolCIMOP;
        if (pStorageExtentsToAdd != null) {
            for (idx = 0; idx < pStorageExtentsToAdd.length; ++idx) {
                this.storageExtentsToAdd.add(pStorageExtentsToAdd[idx]);
                this.storageExtentsToAddCIMOP.add(pStorageExtentsToAddCIMOP[idx]);
            }
        }
        if (pStorageExtentsToRemove != null) {
            for (idx = 0; idx < pStorageExtentsToRemove.length; ++idx) {
                this.storageExtentsToRemove.add(pStorageExtentsToRemove[idx]);
                this.storageExtentsToRemoveCIMOP.add(pStorageExtentsToRemoveCIMOP[idx]);
            }
        }
    }

    public StorageExtent[] getStorageExtentsToAdd() {
        return this.storageExtentsToAdd.toArray(new StorageExtent[this.storageExtentsToAdd.size()]);
    }

    public CIMObjectPath[] getStorageExtentsToAddCIMOP() {
        return this.storageExtentsToAddCIMOP.toArray(new CIMObjectPath[this.storageExtentsToAddCIMOP.size()]);
    }

    public StorageExtent[] getStorageExtentsToRemove() {
        return this.storageExtentsToRemove.toArray(new StorageExtent[this.storageExtentsToRemove.size()]);
    }

    public CIMObjectPath[] getStorageExtentsToRemoveCIMOP() {
        return this.storageExtentsToRemoveCIMOP.toArray(new CIMObjectPath[this.storageExtentsToRemoveCIMOP.size()]);
    }

    public StoragePool getStoragePool() {
        return this.storagePool;
    }

    public CIMObjectPath getStoragePoolCIMOP() {
        return this.storagePoolCIMOP;
    }

    String prepareToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.prepareToStringNoVolumes());
        sb.append("; Storage Pool COP: ");
        if (this.storagePoolCIMOP != null) {
            sb.append(this.storagePoolCIMOP.toString());
        } else {
            sb.append("null");
        }
        sb.append("; StorageExtents to add: {");
        sb.append(OutputHelper.listToCS(this.storageExtentsToAdd));
        sb.append("}");
        sb.append("; StorageExtents to remove: {");
        sb.append(OutputHelper.listToCS(this.storageExtentsToRemove));
        sb.append("}");
        return sb.toString();
    }
}

