/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.disk.SubprofileConstants;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt64;

public class CIMInstanceHelper {
    public static final String SEPARATOR = ",";

    public static final Hashtable changeCIMInstanceToHashtable(CIMInstance pInstance) {
        Vector mCIMProp = pInstance.getProperties();
        CIMProperty mProp = null;
        Hashtable<String, String> mReturn = new Hashtable<String, String>();
        for (int mLoop = 0; mLoop < mCIMProp.size(); ++mLoop) {
            mProp = (CIMProperty)mCIMProp.elementAt(mLoop);
            CIMValue mValue = mProp.getValue();
            String mName = mProp.getName();
            if (mName == null || mValue == null) continue;
            String mVal = mValue.toString();
            if ((mVal = mVal.replaceAll("\"", "")).length() <= 0) continue;
            mReturn.put(mName.toLowerCase(), mVal.startsWith("\t") ? mVal.substring(1) : mVal);
        }
        return mReturn;
    }

    public static final HashMap changeCIMInstanceToHashMap(CIMInstance pInstance) {
        Vector mCIMProp = pInstance.getProperties();
        CIMProperty mProp = null;
        HashMap<String, String> mReturn = new HashMap<String, String>();
        for (int mLoop = 0; mLoop < mCIMProp.size(); ++mLoop) {
            mProp = (CIMProperty)mCIMProp.elementAt(mLoop);
            CIMValue mValue = mProp.getValue();
            String mName = mProp.getName();
            mReturn.put(mName, mValue.toString());
        }
        return mReturn;
    }

    public static final Object getCIMProperyValue(CIMInstance pInstance, String pName) {
        CIMProperty mProp = pInstance.getProperty(pName);
        if (mProp == null) {
            return null;
        }
        CIMValue mPropVal = mProp.getValue();
        if (mPropVal == null) {
            return null;
        }
        return mPropVal.getValue();
    }

    public static final Object getCIMKeyValue(CIMObjectPath pCIMObjectPath, String pName) {
        CIMProperty mProp = pCIMObjectPath.getKey(pName);
        if (mProp == null) {
            return null;
        }
        CIMValue mPropVal = mProp.getValue();
        if (mPropVal == null) {
            return null;
        }
        return mPropVal.getValue();
    }

    public static final Object getCIMPropertyValue(CIMArgument[] pArguments, String pName) {
        for (int i = 0; i < pArguments.length; ++i) {
            CIMArgument bArgument = pArguments[i];
            if (!bArgument.getName().equalsIgnoreCase(pName)) continue;
            if (bArgument.getValue() == null) {
                return null;
            }
            if (bArgument.getValue().getValue() == null) {
                return null;
            }
            return bArgument.getValue().getValue();
        }
        return null;
    }

    public static final Object getCIMPropertyValue(Vector pArguments, String pName) {
        for (int i = 0; i < pArguments.size(); ++i) {
            CIMArgument bArgument = (CIMArgument)pArguments.get(i);
            if (!bArgument.getName().equalsIgnoreCase(pName)) continue;
            if (bArgument.getValue() == null) {
                return null;
            }
            if (bArgument.getValue().getValue() == null) {
                return null;
            }
            return bArgument.getValue().getValue();
        }
        return null;
    }

    public static final String convertSubProfile(String pSubProfile, LogTraceHelper pLTH) {
        StringBuffer mBuffer = new StringBuffer();
        String mKey = null;
        StringTokenizer mToken = new StringTokenizer(pSubProfile, SEPARATOR);
        List<String> mShortList = Arrays.asList(SubprofileConstants.SHORT_SUBPROFILEKEYS);
        List<String> mKeyList = Arrays.asList(SubprofileConstants.SUBPROFILEKEYS);
        while (mToken.hasMoreElements()) {
            mKey = mToken.nextToken();
            if (mKeyList.contains(mKey = mKey.trim())) {
                mBuffer.append(mShortList.get(mKeyList.indexOf(mKey)) + SEPARATOR);
                continue;
            }
            pLTH.traceWarning("No Mapping found for :" + mKey);
        }
        return mBuffer.toString();
    }

    public static final boolean isSupportedSubprofile(String pSupportedSubprofiles, String pAllSubprofiles) {
        boolean mReturn = false;
        if (pAllSubprofiles.indexOf(pSupportedSubprofiles) >= 0) {
            mReturn = true;
        }
        return mReturn;
    }

    public static long getPropertyLongValue(CIMArgument arg) {
        Object bVal;
        long value = -1L;
        CIMValue mCimVal = arg.getValue();
        if (mCimVal != null && (bVal = mCimVal.getValue()) != null) {
            value = ((UnsignedInt64)bVal).longValue();
        }
        return value;
    }

    public static Hashtable getAllPropertiesIntoHashTable(CIMInstance pInstance) {
        Vector mCIMProp = pInstance.getAllProperties();
        CIMProperty mProp = null;
        Hashtable<String, String> mReturn = new Hashtable<String, String>();
        for (int mLoop = 0; mLoop < mCIMProp.size(); ++mLoop) {
            mProp = (CIMProperty)mCIMProp.elementAt(mLoop);
            CIMValue mValue = mProp.getValue();
            String mName = mProp.getName();
            if (mName == null || mValue == null) continue;
            String mVal = mValue.toString();
            if ((mVal = mVal.replaceAll("\"", "")).length() <= 0) continue;
            mReturn.put(mName.toLowerCase(), mVal.startsWith("\t") ? mVal.substring(1) : mVal);
        }
        return mReturn;
    }
}

