/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.xmsg.MessageLog;

public class AlertEmailEditor
implements ActionListener,
ListSelectionListener {
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private JDialog dialog = new JDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI0155T"), true);
    private Container contentpane = this.dialog.getContentPane();
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private JMenuItem saveItem = new JMenuItem();
    private JMenuItem defaultsItem = new JMenuItem();
    private JMenuItem closeItem = new JMenuItem();
    private JMenu helpMenu = new JMenu();
    private JMenuItem helpCS = new JMenuItem();
    private JPanel topPanel = new JPanel(new BorderLayout());
    private JPanel spacePanel = new JPanel();
    private JLabel spaceLabel = new JLabel(" ");
    private JPanel subjectPanel = new JPanel();
    private JLabel subjectLabel = new JLabel(MessageLog.getMessageNoID("GUI0156L") + "   ");
    private TTextField subjectField;
    private JPanel textPanel = new JPanel(new BorderLayout());
    private JLabel textLabel = new JLabel(MessageLog.getMessageNoID("GUI0157L"));
    private JScrollPane textScroll = new JScrollPane();
    private JTextArea textArea = new JTextArea();
    private JPanel parmPanel = new JPanel();
    private JLabel parmLabel = new JLabel(MessageLog.getMessageNoID("GUI0163L"));
    private JPanel listPanel = new JPanel();
    private JList parmList = new JList();
    protected String subject;
    protected String text;
    private String defaultText;
    private String defaultSubject;
    private String initialText;
    private String initialSubject;
    private Map<Integer, Object> parmIdToMsgMap;
    private Map<Object, Integer> parmMsgToIdMap;

    public void edit(String subject, String text, AlertDefinition alertDef) {
        this.subject = subject;
        this.text = text;
        this.defaultSubject = MessageLog.getMessageNoID(alertDef.getEmailSubjectID());
        this.defaultText = MessageLog.getMessageNoID(alertDef.getEmailMsgID());
        this.parmIdToMsgMap = new HashMap<Integer, Object>();
        this.parmMsgToIdMap = new HashMap<Object, Integer>();
        Map<Integer, String> parmMsgKeyMap = alertDef.getEmailParmMsgIdMap();
        if (parmMsgKeyMap != null) {
            for (Integer parmId : parmMsgKeyMap.keySet()) {
                String message = MessageLog.getMessageNoID(parmMsgKeyMap.get(parmId));
                this.parmIdToMsgMap.put(parmId, message);
                this.parmMsgToIdMap.put(message, parmId);
            }
        }
        if (AlertEmailEditor.isNullString(subject)) {
            subject = this.defaultSubject;
        }
        if (AlertEmailEditor.isNullString(text)) {
            text = this.defaultText;
        }
        this.initialSubject = subject;
        StringBuffer test = new StringBuffer(2048);
        Util.formatLine(text, test, this.parmIdToMsgMap);
        this.initialText = test.toString();
        this.fileMenu.setText(MessageLog.getMessageNoID("GUI5005L"));
        this.saveItem.setText(MessageLog.getMessageNoID("GUI5006L"));
        this.defaultsItem.setText(MessageLog.getMessageNoID("GUI0162L"));
        this.closeItem.setText(MessageLog.getMessageNoID("GUI5008L"));
        this.saveItem.addActionListener(this);
        this.defaultsItem.addActionListener(this);
        this.closeItem.addActionListener(this);
        this.fileMenu.add(this.saveItem);
        this.fileMenu.add(this.defaultsItem);
        this.fileMenu.add(this.closeItem);
        this.menuBar.add(this.fileMenu);
        this.helpMenu.setText(MessageLog.getMessageNoID("GUI0072L"));
        this.helpCS.setText(MessageLog.getMessageNoID("GUI0075L"));
        Help.setHelpID(this.helpCS, "asco40");
        this.helpCS.addActionListener(Help.getDisplayHelpFromSource());
        this.helpMenu.add(this.helpCS);
        this.menuBar.add(this.helpMenu);
        this.dialog.setJMenuBar(this.menuBar);
        GuiUtil.setAccessibleDescription(this.dialog, MessageLog.getMessageNoID("GUI0155T"));
        GuiUtil.setAccessibleLabel(this.textLabel, this.textArea, "", this.textLabel.getText(), this.textLabel.getText());
        GuiUtil.setAccessibleLabel(this.subjectLabel, this.subjectField, "", this.subjectLabel.getText(), this.subjectLabel.getText());
        GuiUtil.setAccessibleLabel(this.parmLabel, this.parmList, "", this.parmLabel.getText(), this.parmLabel.getText());
        this.helpMenu.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_HELP"));
        this.subjectField = TTextField.newTTextField(this.initialSubject, 120, false);
        this.subjectPanel.setLayout(new BoxLayout(this.subjectPanel, 0));
        this.subjectPanel.add(this.subjectLabel);
        this.subjectPanel.add(this.subjectField);
        this.subjectPanel.add(new JLabel("    "));
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(GuiUtil.wrapAtWords());
        this.textArea.setText(this.initialText);
        this.textPanel.add((Component)new JLabel("    "), "West");
        this.textPanel.add((Component)new JLabel("    "), "East");
        this.textPanel.add((Component)new JLabel("    "), "South");
        this.textPanel.add((Component)this.textLabel, "North");
        this.textPanel.add((Component)this.textScroll, "Center");
        this.textScroll.setViewportView(this.textArea);
        this.spacePanel.add(this.spaceLabel);
        this.topPanel.add((Component)this.spacePanel, "North");
        this.topPanel.add((Component)this.subjectPanel, "South");
        this.parmPanel.setLayout(new BoxLayout(this.parmPanel, 1));
        this.parmPanel.add(this.parmLabel);
        this.listPanel.add(this.parmList);
        this.parmPanel.add(this.listPanel);
        this.parmList.setListData(this.parmMsgToIdMap.keySet().toArray());
        this.parmList.setSelectionMode(0);
        this.parmList.addListSelectionListener(this);
        this.contentpane.add((Component)this.topPanel, "North");
        this.contentpane.add((Component)this.textPanel, "Center");
        this.contentpane.add((Component)this.parmPanel, "South");
        JRootPane root = this.dialog.getRootPane();
        Help.setHelpID(root, "asco40");
        root.registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        root.registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
        Dimension screenSize = this.dialog.getToolkit().getScreenSize();
        int x = (screenSize.width - 500) / 2;
        int y = (screenSize.height - 500) / 2;
        this.dialog.setBounds(x, y, 700, 500);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowClosing());
        this.dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.saveItem) {
            this.saveText();
        } else if (source == this.defaultsItem) {
            this.subjectField.setText(this.defaultSubject);
            StringBuffer buffer = new StringBuffer();
            Util.formatLine(this.defaultText, buffer, this.parmIdToMsgMap);
            this.textArea.setText(buffer.toString());
        } else if (source == this.closeItem) {
            this.close();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int sel = this.parmList.getSelectedIndex();
        if (!e.getValueIsAdjusting() && sel > -1) {
            int cursor = this.textArea.getCaretPosition();
            this.textArea.insert(this.parmList.getSelectedValue().toString(), cursor);
            this.parmList.removeSelectionInterval(0, this.parmIdToMsgMap.size() - 1);
            this.textArea.requestFocus();
        }
    }

    private void close() {
        String mySubject = this.subjectField.getText();
        String myText = this.textArea.getText();
        if ((AlertEmailEditor.isNullString(this.subject) && AlertEmailEditor.isNullString(mySubject) || mySubject.equals(this.initialSubject)) && (AlertEmailEditor.isNullString(this.text) && AlertEmailEditor.isNullString(myText) || myText.equals(this.initialText))) {
            this.dialog.dispose();
        } else {
            new JOptionPane();
            int answer = JOptionPane.showConfirmDialog(this.dialog, MessageLog.getMessageNoID("GUI0159T"), MessageLog.getMessageNoID("GUI0158T"), 1);
            switch (answer) {
                case 0: {
                    if (!this.saveText()) break;
                }
                case 1: {
                    this.dialog.dispose();
                }
            }
        }
    }

    private boolean saveText() {
        String myText = this.encode();
        if (myText == null) {
            return false;
        }
        this.text = AlertEmailEditor.isNullString(myText) || myText.equals(this.defaultText) ? null : myText;
        String mySubject = this.subjectField.getText();
        this.subject = AlertEmailEditor.isNullString(mySubject) || mySubject.equals(this.defaultSubject) ? null : mySubject;
        this.initialText = this.textArea.getText();
        this.initialSubject = mySubject;
        return true;
    }

    private String encode() {
        StringBuffer plain = new StringBuffer(this.textArea.getText());
        StringBuffer encoded = new StringBuffer(plain.length());
        StringBuffer keyword = new StringBuffer(30);
        int keyWordCount = 0;
        block0: for (int i = 0; i < plain.length(); ++i) {
            char ch = plain.charAt(i);
            encoded.append(ch);
            if (ch != '[') continue;
            int keyoffset = i++;
            keyword.setLength(0);
            keyword.append(ch);
            while (i < plain.length()) {
                ch = plain.charAt(i);
                keyword.append(ch);
                if (ch == ']') {
                    ++keyWordCount;
                    String key = keyword.toString();
                    Integer id = this.parmMsgToIdMap.get(key);
                    if (id != null) {
                        encoded.append(id);
                        encoded.append(ch);
                        continue block0;
                    }
                    this.textArea.setCaretPosition(keyoffset);
                    Object[] args = new Object[]{key, new Integer(keyoffset)};
                    JOptionPane.showMessageDialog(this.dialog, MessageLog.getMessageNoID("GUI0161T", args), MessageLog.getMessageNoID("GUI0160T"), 2);
                    return null;
                }
                ++i;
            }
        }
        return encoded.toString();
    }

    public static boolean isNullString(String s) {
        return s == null || s.length() == 0 || s.length() == 1 && s.charAt(0) == ' ';
    }

    private class WindowClosing
    extends WindowAdapter {
        private WindowClosing() {
        }

        public void windowClosing(WindowEvent event) {
            AlertEmailEditor.this.close();
        }
    }
}

