/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.AlertProduct;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.constants.metadata.AlertProductManager;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.Alertable;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.AlertLog;
import org.eclipse.aperi.server.guireq.AlertNameList;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.server.guireq.UserPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertManager
implements GuiRequestor {
    private static Map<Integer, Integer> firstSubProducts = new HashMap<Integer, Integer>();
    private static Map idMap;
    private static Map<Integer, Map<Integer, Anchor>> historyNodes;
    private static Map<Integer, Anchor> productNodes;
    private static Map<Integer, Anchor> myAlertsNodes;
    private static IGuiMain guiMain;

    private static void classifyAlert(NameList element) {
        element.nlState = AlertConditionManager.getFlags(element.nlInfo);
        element.nlInfo = AlertConditionManager.getResourceType(element.nlInfo);
    }

    private static void incrementCounts(Anchor anchor, NameList element) {
        if ((element.nlState & 1) != 0) {
            ++anchor.nNotBad;
        } else {
            ++anchor.nBad;
        }
    }

    private static void addToIDMap(NameList element, MutableInteger key) {
        key.value = element.nlID;
        Anchor anchor = (Anchor)idMap.get(key);
        if (anchor == null) {
            key = new MutableInteger(key.value);
            anchor = new Anchor();
            anchor.ID = key.value;
            idMap.put(key, anchor);
        }
        AlertManager.incrementCounts(anchor, element);
    }

    private static Anchor anchorInArray(Map<Integer, Anchor> array, int index) {
        Anchor result = array.get(index);
        if (result == null) {
            result = new Anchor();
            array.put(index, result);
        }
        return result;
    }

    private static int subProductIndex(short productID, byte subProductID) {
        int result = firstSubProducts.get(productID);
        if (result >= 0) {
            result = AlertProductManager.isValidSubproduct(subProductID) ? (result += subProductID) : -1;
        }
        return result;
    }

    private static int subProductIndex(AlertNameList element) {
        return AlertManager.subProductIndex(element.nlProductID, element.nlSubProductID);
    }

    private static void addToHistoryNodes(AlertNameList element) {
        Anchor anchor = AlertManager.anchorInArray(AlertManager.getNestedAnchorMap(historyNodes, element.nlProductID), element.nlInfo);
        AlertManager.incrementCounts(anchor, element);
        int index = AlertManager.subProductIndex(element);
        if (index >= 0) {
            anchor = AlertManager.anchorInArray(AlertManager.getNestedAnchorMap(historyNodes, index), element.nlInfo);
            AlertManager.incrementCounts(anchor, element);
        }
    }

    private static Map<Integer, Anchor> getNestedAnchorMap(Map<Integer, Map<Integer, Anchor>> outerMap, int index) {
        Map<Integer, Anchor> innerMap = outerMap.get(index);
        if (innerMap == null) {
            innerMap = new HashMap<Integer, Anchor>();
            outerMap.put(index, innerMap);
        }
        return innerMap;
    }

    private static void addToProductArray(Map<Integer, Anchor> array, AlertNameList element) {
        Anchor anchor = AlertManager.anchorInArray(array, element.nlProductID);
        AlertManager.incrementCounts(anchor, element);
        int index = AlertManager.subProductIndex(element);
        if (index >= 0) {
            anchor = AlertManager.anchorInArray(array, index);
            AlertManager.incrementCounts(anchor, element);
        }
    }

    private static void refreshAnchorArrayMap(Map<Integer, Map<Integer, Anchor>> array, Map<Integer, Map<Integer, Anchor>> oldArray, Map alertableMap) {
        for (Integer index : oldArray.keySet()) {
            AlertManager.refreshAnchorArray(AlertManager.getNestedAnchorMap(array, index), oldArray.get(index), alertableMap);
        }
    }

    private static void refreshAnchorArray(Map<Integer, Anchor> array, Map<Integer, Anchor> oldArray, Map alertableMap) {
        for (Integer index : oldArray.keySet()) {
            Anchor anchor = oldArray.get(index);
            if (anchor == null || anchor.nodeList.isEmpty()) continue;
            Iterator nodeIterator = anchor.nodeList.iterator();
            anchor = array.get(index);
            if (anchor == null) {
                anchor = new Anchor();
                array.put(index, anchor);
            }
            AlertManager.setStates(anchor, nodeIterator, alertableMap);
        }
    }

    private static void setStates(Anchor anchor, Iterator nodeIterator, Map alertableMap) {
        while (nodeIterator.hasNext()) {
            Alertable node = (Alertable)nodeIterator.next();
            if (alertableMap.get(node) != null) {
                node.reset();
                alertableMap.put(node, node);
            }
            AlertManager.setState(anchor, node);
        }
    }

    private static void setState(Anchor anchor, Alertable node) {
        node.change(anchor.nBad, anchor.nNotBad);
        anchor.nodeList.add(node);
    }

    public static void refresh(NameList alerts) {
        MutableInteger key = new MutableInteger();
        Map<Integer, Map<Integer, Anchor>> oldHistoryNodes = historyNodes;
        Map<Integer, Anchor> oldProductNodes = productNodes;
        Map<Integer, Anchor> oldMyAlertsNodes = myAlertsNodes;
        Map oldIDMap = idMap;
        historyNodes = new HashMap<Integer, Map<Integer, Anchor>>();
        myAlertsNodes = new HashMap<Integer, Anchor>();
        productNodes = new HashMap<Integer, Anchor>();
        idMap = new HashMap();
        NameList compAlso = new NameList();
        compAlso.nlInfo = 1;
        while (alerts != null) {
            AlertManager.classifyAlert(alerts);
            if ((alerts.nlState & 4) != 0) {
                AlertManager.addToIDMap(alerts, key);
            }
            if ((alerts.nlState & 2) != 0) {
                compAlso.nlID = alerts.nlID2;
                compAlso.nlState = alerts.nlState;
                AlertManager.addToIDMap(compAlso, key);
            }
            if (alerts.nlInfo >= 0) {
                alerts.nlInfo = (short)(alerts.nlInfo + 1);
                AlertManager.addToHistoryNodes((AlertNameList)alerts);
                alerts.nlInfo = 0;
                AlertManager.addToProductArray(productNodes, (AlertNameList)alerts);
            }
            if (alerts.nlName != null) {
                AlertNameList alert = (AlertNameList)alerts;
                Anchor anchor = AlertManager.anchorInArray(myAlertsNodes, alert.nlProductID);
                AlertManager.incrementCounts(anchor, alert);
            }
            alerts = alerts.nlNext;
        }
        if (oldIDMap == null) {
            return;
        }
        HashMap alertableMap = new HashMap();
        for (Anchor anchor : oldIDMap.values()) {
            if (anchor.nodeList.isEmpty()) continue;
            Iterator nodeIterator = anchor.nodeList.iterator();
            key.value = anchor.ID;
            anchor = (Anchor)idMap.get(key);
            if (anchor == null) {
                anchor = new Anchor();
                anchor.ID = key.value;
                idMap.put(key, anchor);
                key = new MutableInteger();
            }
            AlertManager.setStates(anchor, nodeIterator, alertableMap);
        }
        AlertManager.refreshAnchorArrayMap(historyNodes, oldHistoryNodes, alertableMap);
        AlertManager.refreshAnchorArray(productNodes, oldProductNodes, alertableMap);
        AlertManager.refreshAnchorArray(myAlertsNodes, oldMyAlertsNodes, alertableMap);
    }

    public static void register(int ID2, Alertable node) {
        MutableInteger key = new MutableInteger(ID2);
        Anchor anchor = (Anchor)idMap.get(key);
        if (anchor == null) {
            anchor = new Anchor();
            anchor.ID = key.value;
            idMap.put(key, anchor);
        }
        AlertManager.setState(anchor, node);
    }

    public static void register(short productID, short objectType, byte subProduct, Alertable node) {
        Map<Integer, Anchor> array;
        int index = AlertManager.subProductIndex(productID, subProduct);
        if (index >= 0) {
            productID = (short)index;
        }
        if (objectType < 0) {
            array = productNodes;
            index = productID;
        } else {
            array = AlertManager.getNestedAnchorMap(historyNodes, productID);
            index = objectType + 1;
        }
        Anchor anchor = AlertManager.anchorInArray(array, index);
        AlertManager.setState(anchor, node);
    }

    public static void register(short productID, Alertable node) {
        Anchor anchor = AlertManager.anchorInArray(myAlertsNodes, productID);
        AlertManager.setState(anchor, node);
    }

    private static void clearAlert(Anchor anchor, NameList element) {
        int deltaNotBad;
        int deltaBad;
        if ((element.nlState & 1) != 0) {
            deltaBad = 0;
            deltaNotBad = -1;
            if (anchor.nNotBad > 0) {
                --anchor.nNotBad;
            }
        } else {
            deltaBad = -1;
            deltaNotBad = 0;
            if (anchor.nBad > 0) {
                --anchor.nBad;
            }
        }
        if (!anchor.nodeList.isEmpty()) {
            for (Alertable node : anchor.nodeList) {
                node.change(deltaBad, deltaNotBad);
            }
        }
    }

    private static void clearMapAlert(MutableInteger key, NameList element) {
        Anchor anchor = (Anchor)idMap.get(key);
        if (anchor != null) {
            AlertManager.clearAlert(anchor, element);
        }
    }

    private static void clearArrayAlert(Map<Integer, Anchor> array, int index, NameList element) {
        Anchor anchor = array.get(index);
        if (anchor != null) {
            AlertManager.clearAlert(anchor, element);
        }
    }

    private static void clearArrayAlertMap(Map<Integer, Map<Integer, Anchor>> array, AlertNameList element) {
        int objectType = element.nlInfo + 1;
        int index = AlertManager.subProductIndex(element.nlProductID, element.nlSubProductID);
        if (index >= 0) {
            AlertManager.clearArrayAlert(AlertManager.getNestedAnchorMap(array, index), 0, element);
            if (objectType > 0) {
                AlertManager.clearArrayAlert(AlertManager.getNestedAnchorMap(array, index), objectType, element);
            }
        }
        AlertManager.clearArrayAlert(AlertManager.getNestedAnchorMap(array, element.nlProductID), 0, element);
        if (objectType > 0) {
            AlertManager.clearArrayAlert(AlertManager.getNestedAnchorMap(array, element.nlProductID), objectType, element);
        }
    }

    public static void alertCleared(AlertLog record) {
        AlertNameList element = new AlertNameList();
        element.nlID = record.alResourceID;
        element.nlID2 = record.alComputerID;
        element.nlInfo = record.alAlertCondition;
        element.nlProductID = (short)record.alProductID;
        element.nlSubProductID = record.alDbmsType;
        AlertManager.classifyAlert(element);
        if (element.nlInfo < 0) {
            return;
        }
        MutableInteger key = new MutableInteger();
        if ((element.nlState & 4) != 0) {
            key.value = element.nlID;
            AlertManager.clearMapAlert(key, element);
        }
        if ((element.nlState & 2) != 0) {
            key.value = element.nlID2;
            AlertManager.clearMapAlert(key, element);
        }
        AlertManager.clearArrayAlertMap(historyNodes, element);
        AlertManager.clearArrayAlert(productNodes, record.alProductID, element);
        if (record instanceof ExtAlertLog && ((ExtAlertLog)record).alDbInstance != null) {
            int subindex = AlertManager.subProductIndex(element.nlProductID, element.nlSubProductID);
            AlertManager.clearArrayAlert(productNodes, subindex, element);
        }
        if (record.alNotifyUser != null) {
            AlertManager.clearArrayAlert(myAlertsNodes, record.alProductID, element);
        }
    }

    private static boolean anyToDisplay(Map<Integer, Anchor> array) {
        Iterator<Anchor> anchorIt = array.values().iterator();
        while (anchorIt.hasNext()) {
            if (Anchor.getState(anchorIt.next()) == 0) continue;
            return true;
        }
        return false;
    }

    public static boolean anyToDisplayAtLogin() {
        UserPreferences prefs = guiMain.getUserPrefs();
        short what = prefs.showLoginAlerts;
        if (what == 0) {
            return false;
        }
        return what == 2 ? AlertManager.anyToDisplay(productNodes) : AlertManager.anyToDisplay(myAlertsNodes);
    }

    private AlertManager() {
    }

    public static void refreshAlerts() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.server.RefreshAlertsHndlr";
        request.flags = (byte)4;
        AlertManager obj = new AlertManager();
        GuiClient.doRequest(obj, request);
    }

    @Override
    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        NameList list = (NameList)response.responseData;
        AlertManager.refresh(list);
    }

    static {
        SortedSet<Short> productIds = AlertProduct.getValues();
        int nextSubProductId = Collections.max(productIds).intValue() + 1;
        Iterator productIdIt = productIds.iterator();
        while (productIdIt.hasNext()) {
            short productId = (Short)productIdIt.next();
            firstSubProducts.put(Integer.valueOf(productId), nextSubProductId);
            nextSubProductId += AlertProductManager.getSubproductCount(productId);
        }
        idMap = null;
        historyNodes = null;
        productNodes = null;
        myAlertsNodes = null;
        guiMain = GuiManager.getGuiManager().getGuiMain();
    }

    private static class Anchor {
        public int ID;
        public short productCode;
        public int nNotBad;
        public int nBad;
        public List nodeList = new LinkedList();

        private short getObjState() {
            if (this.nBad > 0) {
                return -1;
            }
            if (this.nNotBad > 0) {
                return 1;
            }
            return 0;
        }

        public static short getState(Anchor anchor) {
            if (anchor == null) {
                return 0;
            }
            return anchor.getObjState();
        }
    }
}

