/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.xmsg.MessageLog;

public class BaseTreeNode
extends DefaultMutableTreeNode
implements PopupMenuListener {
    public boolean expandBranchMenu = false;
    public boolean collapseBranchMenu = false;
    public int expandBranch = 0;
    public boolean selectable = true;
    public int batchSortNumber = 777;
    public Color nodeColor = Color.black;
    public DataDisplayInfo ddi;
    private static JPopupMenu popup = null;
    private static JMenuItem collapseAll = new JMenuItem(MessageLog.getMessageNoID("GUI0040L"));
    private static JMenuItem expandAll = new JMenuItem(MessageLog.getMessageNoID("GUI0064L"));
    private static JMenuItem printSubtree = new JMenuItem(MessageLog.getMessageNoID("GUI5101L"));
    private static BaseTreeNode popupNode;
    private static TreePath popupPath;
    protected static IGuiMain guiMain;
    protected Capabilities capabilities = guiMain.getCapabilities();

    public BaseTreeNode() {
    }

    public BaseTreeNode(Object userObject) {
        super(userObject);
    }

    public BaseTreeNode(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    public void render(DefaultTreeCellRenderer renderer, BaseTree tree, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        renderer.setFont(BaseTree.boldFont);
    }

    public void expand(TreeExpansionEvent event) {
    }

    public void collapse(TreeExpansionEvent event) {
    }

    void expandBranch(int level) {
        this.expand(null);
        BaseTree.pBaseTree.expandPath(new TreePath(this.getPath()));
        Enumeration<TreeNode> nodes = this.children();
        while (nodes.hasMoreElements()) {
            BaseTreeNode treenode = (BaseTreeNode)nodes.nextElement();
            if (level > treenode.expandBranch) continue;
            treenode.expandBranch(level + 1);
        }
    }

    public void showPopupMenu(MouseEvent event) {
        this.showPopupMenu(this.getPopupMenu(), event);
    }

    public void showPopupMenu(JPopupMenu popup, MouseEvent event) {
        boolean needSeparator = false;
        if (popup.getComponentCount() > 0) {
            needSeparator = true;
        }
        if (this.collapseBranchMenu) {
            if (needSeparator) {
                popup.addSeparator();
                needSeparator = false;
            }
            popup.add(collapseAll);
        }
        if (this.expandBranchMenu) {
            if (needSeparator) {
                popup.addSeparator();
                needSeparator = false;
            }
            popup.add(expandAll);
        }
        if (needSeparator) {
            popup.addSeparator();
        }
        popup.add(printSubtree);
        if (event != null && popup.getComponentCount() > 0) {
            popup.show(event.getComponent(), event.getX(), event.getY());
            if (!event.isPopupTrigger()) {
                popup.requestFocus();
            }
        }
    }

    public JPopupMenu getPopupMenu() {
        popup = new JPopupMenu();
        popup.addPopupMenuListener(this);
        return popup;
    }

    public void select(TreeSelectionEvent event) {
        this.selectable = true;
    }

    public void addSorted(BaseTreeNode child) {
        BaseTreeNode node;
        int index;
        String childKey = child.getUserObject().toString();
        int childCount = this.getChildCount();
        for (index = 0; index < childCount && childKey.compareTo((node = (BaseTreeNode)this.getChildAt(index)).getUserObject().toString()) >= 0; ++index) {
        }
        BaseTree.MyTree.insertNodeInto(child, this, index);
    }

    public JPopupMenu getPopupMenuForButtons() {
        return new JPopupMenu();
    }

    public void popupMenuCanceled(PopupMenuEvent pme) {
        BaseTree.pBaseTree.setSelectionPath(BaseTree.selectedPath);
        BaseTree.pBaseTree.requestFocus();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
        BaseTree.pBaseTree.setSelectionPath(BaseTree.selectedPath);
        BaseTree.pBaseTree.requestFocus();
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
    }

    static {
        guiMain = GuiManager.getGuiManager().getGuiMain();
        collapseAll.setToolTipText(MessageLog.getMessageNoID("GUI0041T"));
        expandAll.setToolTipText(MessageLog.getMessageNoID("GUI0065T"));
        printSubtree.setToolTipText(MessageLog.getMessageNoID("GUI5102T"));
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (event.getSource() == collapseAll) {
                    guiMain.getBaseTree();
                    BaseTree.pBaseTree.collapseBranch(BaseTree.popupNode);
                } else if (event.getSource() == expandAll) {
                    guiMain.getBaseTree();
                    BaseTree.popupNode.expandBranch(1);
                } else if (event.getSource() == printSubtree) {
                    guiMain.getBaseTree();
                    guiMain.printTree(BaseTree.popupNode);
                }
            }
        };
        collapseAll.addActionListener(al);
        expandAll.addActionListener(al);
        printSubtree.addActionListener(al);
    }
}

