/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.xmsg.MessageLog;

public class DDIremover
extends JDialog
implements ActionListener {
    public boolean wasDDIremoved = true;
    private JTextPane textPane = new JTextPane();
    private JPanel listPanel = new JPanel();
    private JScrollPane jScrollPane = new JScrollPane(this.listPanel);
    private JPanel buttonPanel = new JPanel();
    private JButton allButton = new JButton(MessageLog.getMessageNoID("GUI0137L"));
    private JButton noneButton = new JButton(MessageLog.getMessageNoID("GUI0138L"));
    private JButton okButton = new JButton(MessageLog.getMessageNoID("GUI0113L"));
    IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public DDIremover() {
        DataDisplayInfo ddi;
        Dimension screenSize = this.getToolkit().getScreenSize();
        int x = (screenSize.width - 500) / 2;
        int y = (screenSize.height - 500) / 2;
        this.setBounds(x, y, 500, 500);
        this.setModal(true);
        this.setTitle(MessageLog.getMessageNoID("GUI0135T"));
        this.getContentPane().add((Component)this.textPane, "North");
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.textPane.setText(MessageLog.getMessageNoID("GUI0136T"));
        this.textPane.setEditable(false);
        this.buttonPanel.add(this.allButton);
        this.buttonPanel.add(this.noneButton);
        this.buttonPanel.add(this.okButton);
        this.allButton.addActionListener(this);
        this.noneButton.addActionListener(this);
        this.okButton.addActionListener(this);
        GuiUtil.setAccessible(this.allButton, this.allButton.getText(), this.allButton.getText());
        GuiUtil.setAccessible(this.noneButton, this.noneButton.getText(), this.noneButton.getText());
        GuiUtil.setAccessible(this.okButton, this.okButton.getText(), this.okButton.getText());
        this.listPanel.setLayout(new GridLayout(0, 1));
        int numUnchangedDDIs = 0;
        for (ddi = DataDisplayInfo.getRoot(); ddi != null; ddi = ddi.getNext()) {
            if (ddi.changesPending()) continue;
            DDICheckBox cb = new DDICheckBox(ddi);
            this.listPanel.add(cb);
            ++numUnchangedDDIs;
        }
        if (numUnchangedDDIs > 0) {
            this.show();
        } else {
            ddi = DataDisplayInfo.getCurrent();
            this.wasDDIremoved = false;
            if (ddi != null && ddi.changesPending()) {
                if (ddi.fileClose()) {
                    this.wasDDIremoved = true;
                } else {
                    this.wasDDIremoved = false;
                    this.guiMain.setView(ddi);
                }
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.allButton) {
            for (int i = this.listPanel.getComponentCount(); i > 0; --i) {
                ((DDICheckBox)this.listPanel.getComponent(i - 1)).setSelected(true);
            }
        } else if (e.getSource() == this.noneButton) {
            for (int i = this.listPanel.getComponentCount(); i > 0; --i) {
                ((DDICheckBox)this.listPanel.getComponent(i - 1)).setSelected(false);
            }
        } else {
            DataDisplayInfo.removeWithoutShow = true;
            for (int i = this.listPanel.getComponentCount(); i > 0; --i) {
                DDICheckBox cb = (DDICheckBox)this.listPanel.getComponent(i - 1);
                if (!cb.isSelected()) continue;
                cb.ddi.remove();
            }
            DataDisplayInfo.removeWithoutShow = false;
            this.dispose();
        }
    }

    private class DDICheckBox
    extends JCheckBox {
        DataDisplayInfo ddi;

        DDICheckBox(DataDisplayInfo ddi) {
            super(ddi.getDescription(), true);
            this.ddi = ddi;
        }
    }
}

