/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.DateSelector;
import org.eclipse.aperi.gui.TimeSelector;

public class DateTimeSelector
extends JPanel
implements ActionListener {
    private int maxYear;
    private boolean bValidate = true;
    private int minYear = 2000;
    private Calendar calendar = Calendar.getInstance();
    private DateSelector dateBox = new DateSelector();
    private TimeSelector timeBox = new TimeSelector();

    public DateTimeSelector() {
        this.initFromCalendar(this.calendar);
        this.buildPanel();
    }

    public DateTimeSelector(short initYear) {
        if (initYear > 2000) {
            this.minYear = initYear;
        }
        this.initFromCalendar(this.calendar);
        this.buildPanel();
    }

    public DateTimeSelector(long milliseconds) {
        this.calendar.setTime(new Date(milliseconds));
        this.initFromCalendar(this.calendar);
        this.buildPanel();
    }

    public DateTimeSelector(short year, short month, short day, short hour, short minute) {
        if (year == 0) {
            this.initFromCalendar(this.calendar);
        } else {
            this.initFromShorts(year, month, day, hour, minute);
        }
        this.buildPanel();
    }

    private void initFromCalendar(Calendar cal) {
        if (cal.get(1) < 2000) {
            cal.set(1, 2000);
        }
        this.timeBox.setTime(cal.getTime().getTime());
        this.dateBox.setDate(cal.getTime().getTime());
    }

    private void initFromShorts(short year, short month, short day, short hour, short minute) {
        if (year < (short)this.minYear) {
            year = (short)this.minYear;
        }
        this.calendar.set(year, month - 1, day, hour, minute);
        this.timeBox.setTime(this.calendar.getTime().getTime());
        this.dateBox.setDate(this.calendar.getTime().getTime());
    }

    public void setDateTime(short year, short month, short day, short hour, short minute) {
        this.initFromShorts(year, month, day, hour, minute);
        this.setDateTime();
    }

    public void setDateTime(long milliseconds) {
        this.calendar.setTime(new Date(milliseconds));
        this.initFromCalendar(this.calendar);
        this.setDateTime();
    }

    public short[] getDateTime() {
        this.getSelection();
        short[] dateTime = new short[]{(short)this.calendar.get(1), (short)this.calendar.get(2), (short)this.calendar.get(5), (short)this.calendar.get(11), (short)this.calendar.get(12)};
        return dateTime;
    }

    public long getMilliseconds() {
        this.getSelection();
        Calendar dateTime = this.calendar;
        dateTime.set(13, 0);
        dateTime.set(14, 0);
        return dateTime.getTime().getTime();
    }

    public void setEnabled(boolean state) {
        this.dateBox.setEnabled(state);
        this.timeBox.setEnabled(state);
    }

    private void buildPanel() {
        this.setDateTime();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        this.add((Component)this.dateBox, gbc);
        this.add(Box.createHorizontalStrut(18), gbc);
        this.add((Component)this.timeBox, gbc);
    }

    private void setDateTime() {
        this.bValidate = false;
        this.timeBox.setTime(this.calendar.getTime().getTime());
        this.dateBox.setDate(this.calendar.getTime().getTime());
        this.bValidate = true;
    }

    private void getSelection() {
        Calendar calDate = Calendar.getInstance();
        calDate.setTime(new Date(this.dateBox.getLongDate()));
        Calendar calTime = Calendar.getInstance();
        calTime.setTime(new Date(this.timeBox.getLongTime()));
        this.calendar.set(calDate.get(1), calDate.get(2), calDate.get(5), calTime.get(11), calTime.get(12));
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.bValidate) {
            return;
        }
        Object source = e.getSource();
    }
}

