/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class DoubleLineBorder
implements Border {
    private int width = 1;
    private int height = 1;
    private static Color MEDIUM_BLUE = new Color(140, 177, 209);
    private static Color WHITE = Color.white;
    public static final int TOP = 0;
    public static final int LEFT = 1;
    public static final int BOTTOM = 2;
    public static final int RIGHT = 3;
    public static final int TOPandBOTTOM = 4;
    public static final int LEFTandRIGHT = 5;
    public static final int TBLR = 6;
    public static final int TOPandRIGHT = 7;
    public static final int TOPandLEFT = 8;
    public static final int TOPBOTTOMRIGHT = 9;
    public static final int TOPLEFTRIGHT = 10;
    public static final int TOPBOTTOMLEFT = 11;
    public static final int BOTTOMLEFTRIGHT = 12;
    public static final int BOTTOMandLEFT = 13;
    public static final int BOTTOMandRIGHT = 14;
    private int alignment = 2;
    protected Color color1;
    protected Color color2;

    public DoubleLineBorder() {
        this(MEDIUM_BLUE, WHITE, 2);
    }

    public DoubleLineBorder(Color col1, Color col2) {
        this(col1, col2, 2);
    }

    public DoubleLineBorder(Color col1, Color col2, int align) {
        this.color1 = col1;
        this.color2 = col2;
        this.alignment = align;
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.height, this.width, this.height, this.width);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        --w;
        --h;
        switch (this.alignment) {
            case 0: {
                this.drawTop(c, g, x, y, w, h);
                break;
            }
            case 1: {
                this.drawLeft(c, g, x, y, w, h);
                break;
            }
            case 2: {
                this.drawBottom(c, g, x, y, w, h);
                break;
            }
            case 3: {
                this.drawRight(c, g, x, y, w, h);
                break;
            }
            case 4: {
                this.drawTop(c, g, x, y, w, h);
                this.drawBottom(c, g, x, y, w, h);
                break;
            }
            case 5: {
                this.drawLeft(c, g, x, y, w, h);
                this.drawRight(c, g, x, y, w, h);
                break;
            }
            case 6: {
                this.drawTop(c, g, x, y, w, h);
                this.drawBottom(c, g, x, y, w, h);
                this.drawLeft(c, g, x, y, w, h);
                this.drawRight(c, g, x, y, w, h);
                break;
            }
            case 7: {
                this.drawTop(c, g, x, y, w, h);
                this.drawRight(c, g, x, y, w, h);
                break;
            }
            case 8: {
                this.drawTop(c, g, x, y, w, h);
                this.drawLeft(c, g, x, y, w, h);
                break;
            }
            case 9: {
                this.drawTop(c, g, x, y, w, h);
                this.drawBottom(c, g, x, y, w, h);
                this.drawRight(c, g, x, y, w, h);
                break;
            }
            case 10: {
                this.drawTop(c, g, x, y, w, h);
                this.drawLeft(c, g, x, y, w, h);
                this.drawRight(c, g, x, y, w, h);
                break;
            }
            case 11: {
                this.drawTop(c, g, x, y, w, h);
                this.drawBottom(c, g, x, y, w, h);
                this.drawLeft(c, g, x, y, w, h);
                break;
            }
            case 12: {
                this.drawBottom(c, g, x, y, w, h);
                this.drawLeft(c, g, x, y, w, h);
                this.drawRight(c, g, x, y, w, h);
                break;
            }
            case 13: {
                this.drawBottom(c, g, x, y, w, h);
                this.drawLeft(c, g, x, y, w, h);
                break;
            }
            case 14: {
                this.drawBottom(c, g, x, y, w, h);
                this.drawRight(c, g, x, y, w, h);
            }
        }
    }

    private void drawTop(Component c, Graphics g, int x, int y, int w, int h) {
        if (this.color1 != null) {
            g.setColor(this.color1);
            g.drawLine(x + this.width, y, x + w, y);
        }
        if (this.color2 != null) {
            g.setColor(this.color2);
            g.drawLine(x + this.width, y - 1, x + w, y - 1);
        }
    }

    private void drawLeft(Component c, Graphics g, int x, int y, int w, int h) {
        if (this.color1 != null) {
            g.setColor(this.color1);
            g.drawLine(x, y + h + 1, x, y);
        }
        if (this.color2 != null) {
            g.setColor(this.color2);
            g.drawLine(x, y + h, x, y);
        }
    }

    private void drawBottom(Component c, Graphics g, int x, int y, int w, int h) {
        if (this.color1 != null) {
            g.setColor(this.color1);
            g.drawLine(x + this.width, y + h - 1, x + w, y + h - 1);
        }
        if (this.color2 != null) {
            g.setColor(this.color2);
            g.drawLine(x + this.width, y + h, x + w, y + h);
        }
    }

    private void drawRight(Component c, Graphics g, int x, int y, int w, int h) {
        if (this.color1 != null) {
            g.setColor(this.color1);
            g.drawLine(x + w, y + this.height, x + w, y + h);
        }
        if (this.color2 != null) {
            g.setColor(this.color2);
            g.drawLine(x + w, y + this.height + 1, x + w, y + h);
        }
    }
}

