/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.aperi.gui.DefaultListEditor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.ListElementEditor;
import org.eclipse.aperi.xmsg.MessageLog;

public class EditableList
extends JPanel
implements ActionListener,
ListSelectionListener {
    public JButton addButton;
    protected JButton remButton;
    public JList editList;
    protected DefaultListModel listModel;
    protected ListElementEditor editor;
    protected JLabel lTitle;
    private JScrollPane scrollPane;

    public EditableList(String title, Object prototypeCell, int visibleRowCount) {
        this(title, null, null, prototypeCell, visibleRowCount, 50);
    }

    public EditableList(JLabel titleLabel, Object prototypeCell, int visibleRowCount) {
        this(null, titleLabel, null, prototypeCell, visibleRowCount, 50);
    }

    public EditableList(String title, Object prototypeCell, int visibleRowCount, int defaultEditorMaxSize) {
        this(title, null, null, prototypeCell, visibleRowCount, defaultEditorMaxSize);
    }

    public EditableList(String title, ListElementEditor editor, Object prototypeCell, int visibleRowCount) {
        this(title, null, editor, prototypeCell, visibleRowCount, -1);
    }

    private EditableList(String title, JLabel titleLabel, ListElementEditor editor, Object prototypeCell, int visibleRowCount, int defaultEditorMaxSize) {
        this.lTitle = titleLabel != null ? titleLabel : new JLabel(title);
        if (editor != null) {
            this.editor = editor;
        } else {
            this.editor = new DefaultListEditor(defaultEditorMaxSize, this);
            GuiUtil.setAccessibleDescription((DefaultListEditor)this.editor, this.lTitle.getText());
        }
        this.listModel = new DefaultListModel();
        this.editList = new JList(this.listModel);
        this.editList.setSelectionMode(0);
        this.editList.addMouseListener(new EditListMouseListener());
        this.editList.addListSelectionListener(this);
        this.scrollPane = new JScrollPane(this.editList);
        if (prototypeCell != null) {
            this.editList.setPrototypeCellValue(prototypeCell);
        }
        if (visibleRowCount > 0) {
            this.editList.setVisibleRowCount(visibleRowCount);
        }
        this.addButton = new JButton(MessageLog.getMessageNoID("GUI0043L"));
        this.remButton = new JButton(MessageLog.getMessageNoID("GUI0044L"));
        GuiUtil.setAccessible(this.addButton, this.addButton.getText(), this.addButton.getText());
        GuiUtil.setAccessible(this.remButton, this.remButton.getText(), this.remButton.getText());
        this.addButton.setEnabled(false);
        this.remButton.setEnabled(false);
        this.addButton.addActionListener(this);
        this.remButton.addActionListener(this);
        this.buildPanel();
    }

    public void addObject(Object o) {
        if (o != null) {
            int index = this.editList.getSelectedIndex();
            index = index == -1 ? this.listModel.size() : ++index;
            this.listModel.add(index, o);
        }
    }

    public void removeAllObjects() {
        for (int i = this.listModel.getSize() - 1; i >= 0; --i) {
            Object item = this.listModel.remove(i);
            this.editor.objectRemoved(item);
        }
        this.remButton.setEnabled(false);
    }

    public Object[] getElements() {
        return this.listModel.toArray();
    }

    public void setAddEnabled(boolean state) {
        this.addButton.setEnabled(state);
    }

    public void setEnabled(boolean state, boolean clearList) {
        super.setEnabled(state);
        this.editor.setEnabled(state);
        this.editList.setEnabled(state);
        this.lTitle.setEnabled(state);
        if (state) {
            if (this.editList.getSelectedIndex() >= 0) {
                this.remButton.setEnabled(true);
            }
        } else {
            if (clearList) {
                this.listModel.clear();
                this.editor.getObject();
            }
            this.remButton.setEnabled(false);
        }
    }

    public void setEnabled(boolean state) {
        this.setEnabled(state, true);
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.ipadx = 8;
        this.add((Component)this.lTitle, constraints);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        constraints.anchor = 17;
        constraints.ipadx = 0;
        buttonPanel.add((Component)this.addButton, constraints);
        ++constraints.gridx;
        constraints.gridwidth = 0;
        buttonPanel.add((Component)this.remButton, constraints);
        constraints.gridwidth = 0;
        constraints.anchor = 13;
        this.add((Component)buttonPanel, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.anchor = 17;
        constraints.fill = 2;
        this.add(this.editor.getComponent(), constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.add((Component)this.scrollPane, constraints);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.addButton) {
            this.actionAdd();
        } else if (source == this.remButton) {
            int selectionIndex = this.editList.getSelectedIndex();
            if (selectionIndex != -1) {
                Object item = this.listModel.remove(selectionIndex);
                int nItems = this.listModel.getSize();
                if (selectionIndex >= nItems) {
                    --selectionIndex;
                }
                this.editor.objectRemoved(item);
            }
            if (selectionIndex >= 0) {
                this.editList.setSelectedIndex(selectionIndex);
            } else {
                this.remButton.setEnabled(false);
            }
        }
    }

    protected void actionAdd() {
        this.addObject(this.editor.getObject());
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.editList.getSelectedValue() == null) {
            this.remButton.setEnabled(false);
        } else {
            this.remButton.setEnabled(true);
        }
    }

    private class EditListMouseListener
    extends MouseAdapter {
        private EditListMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            Object o;
            if (e.getClickCount() == 2 && (o = EditableList.this.editList.getSelectedValue()) != null) {
                EditableList.this.editor.setObject(o);
            }
        }
    }
}

