/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class GlassPaneMouseListener
extends MouseAdapter
implements MouseMotionListener {
    private JButton stopButton;
    private Component glassPane;
    private Container contentPane;
    private Window window;
    private Rectangle stopBounds;

    public GlassPaneMouseListener(JButton stopButton, Component glassPane, Container contentPane, JFrame frame) {
        this(stopButton, glassPane, contentPane, (Window)frame);
    }

    public GlassPaneMouseListener(JButton stopButton, Component glassPane, Container contentPane, Window window) {
        this.stopButton = stopButton;
        this.glassPane = glassPane;
        this.contentPane = contentPane;
        this.window = window;
    }

    public void mouseClicked(MouseEvent e) {
        Point glassPanePoint = e.getPoint();
        Component component = null;
        Point contentPanePoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, this.contentPane);
        component = SwingUtilities.getDeepestComponentAt(this.contentPane, contentPanePoint.x, contentPanePoint.y);
        if (component == this.stopButton) {
            this.stopButton.doClick();
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.stopBounds.contains(e.getX(), e.getY())) {
            this.glassPane.setCursor(Cursor.getPredefinedCursor(0));
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
            this.window.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.stopBounds.contains(e.getX(), e.getY())) {
            this.glassPane.setCursor(Cursor.getPredefinedCursor(0));
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
            this.window.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void setStopBounds() {
        Point stopTopLeft = SwingUtilities.convertPoint(this.stopButton, 0, 0, this.glassPane);
        this.stopBounds = new Rectangle(stopTopLeft, this.stopButton.getSize());
    }
}

