/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Window;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.eclipse.aperi.TStorm.gui.ReportPrefsManager;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.AlertLogDDI;
import org.eclipse.aperi.gui.AlertManager;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.GuiMain;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiSendRequest;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.server.guireq.SignonResp;
import org.eclipse.aperi.server.guireq.UserPreferences;
import org.eclipse.aperi.server.guireq.UserPreferencesSM;
import org.eclipse.aperi.server.req.DeviceServerStatusResp;
import org.eclipse.aperi.server.req.FabricIpsExistResp;
import org.eclipse.aperi.server.req.GuiInfoReq;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.server.req.ServerStatusResp;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiClient {
    public static String server;
    public static int port;
    public static ServerStatusResp serverStatusResp;
    public static DeviceServerStatusResp deviceServerStatusResp;
    public static Response response;
    private static Request request;
    private static final String SERVER;
    private static final String STATUS;
    private static final String PRESS_PF1;
    private static RequestNode pendingRequests;

    public static void getChartCustomizations(String userID) {
        GuiChartSettingsReq gcsr = new GuiChartSettingsReq();
        gcsr.creator = userID;
        gcsr.reqType = 5;
        Request r = new Request();
        r.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        r.serviceName = RequestTypeManager.getInternalName(r.typeCode);
        r.subType = "org.eclipse.aperi.server.handler.gui.ChartSettingsHndlr";
        r.userName = GuiUtil.getUserName();
        r.flags = (byte)4;
        r.requestData = gcsr;
        if (GuiClient.doRequest(r) <= 4) {
            AperiChartCustomizationManager.initManager(GuiUtil.getUserName(), (ArrayList)GuiClient.response.responseData);
        }
    }

    public static short serverStatus() {
        ServerRequest.serverStatus(request);
        short status = GuiClient.doRequest(request);
        if (status > 4) {
            status = 12;
            serverStatusResp = null;
        } else {
            status = GuiClient.response.status;
            serverStatusResp = (ServerStatusResp)GuiClient.response.responseData;
        }
        return status;
    }

    public static short deviceServerStatus() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(GuiClient.class.getName(), "deviceServerStatus", "");
        }
        DeviceRequest deviceRequest = new DeviceRequest("org.eclipse.aperi.server.svp.GuiSvp", "org.eclipse.aperi.server.handler.gui.DeviceServerStatusHndlr");
        deviceRequest.requestData = null;
        short status = GuiClient.doRequest(deviceRequest);
        if (status > 4) {
            status = 12;
            deviceServerStatusResp = null;
        } else {
            status = GuiClient.response.status;
            deviceServerStatusResp = (DeviceServerStatusResp)GuiClient.response.responseData;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(GuiClient.class.getName(), "deviceServerStatus", status);
        }
        return status;
    }

    public static boolean doesIpTableDefinitelyHaveIps() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(GuiClient.class.getName(), "deviceServerStatus", "");
        }
        DeviceRequest deviceRequest = new DeviceRequest("org.eclipse.aperi.server.svp.GuiSvp", "org.eclipse.aperi.server.handler.gui.fabric.FabricIpsExistHndlr");
        short status = GuiClient.doRequest(deviceRequest);
        boolean ret = false;
        if (status != 12) {
            FabricIpsExistResp resp = (FabricIpsExistResp)GuiClient.response.responseData;
            ret = resp.hasIps();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(GuiClient.class.getName(), "deviceServerStatus", status);
        }
        return ret;
    }

    public static boolean doesCimomTableHaveCimoms() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(GuiClient.class.getName(), "doesCimomTableHaveCimoms", "");
        }
        Request request = GuiUtil.newGUIDeviceRequest("org.eclipse.aperi.server.handler.gui.cimom.CIMOMMgmtGetCIMOMsHandler");
        short status = GuiClient.doRequest(request);
        boolean ret = false;
        if (status != 12) {
            CIMOM[] cimomList = (CIMOM[])GuiClient.response.responseData;
            ret = cimomList != null && cimomList.length != 0;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(GuiClient.class.getName(), "doesCimomTableHaveCimoms", status);
        }
        return ret;
    }

    protected static short signon(String id, String pwd) {
        ServerRequest.signon(request, id, pwd);
        int status = GuiClient.doRequest(request);
        if (status <= 4 && GuiClient.response.responseData != null) {
            SignonResp responseData = (SignonResp)GuiClient.response.responseData;
            GuiMain.capabilities = new Capabilities(responseData.userRoles, responseData.productAvailabilities, responseData.deviceServerInstalled);
            if (responseData.userRoles == RoleChecker.NO_ROLE) {
                JOptionPane.showMessageDialog(null, Util.getString("GUI8214E", id), Util.getString("LOGIN_FAILED"), 0);
                status = 12;
                GuiClient.clearFields();
            }
            AlertManager.refresh(NameList.unpackList(responseData.activeAlerts));
            GuiMain.prefs = responseData.prefs;
            GuiMain.adminGroup = responseData.adminGroup;
            GuiUtil.sortOrderNotASCII = responseData.sortOrderNotASCII;
            GuiMain.dashTotalsRow = responseData.dashTotalsRow;
            Variables.spaceUnits = GuiMain.prefs.spaceUnits;
            ReportPrefsManager.cacheAll(GuiMain.prefs.sm.reportPrefs);
            AlertLogDDI.showLoginAlerts();
            GuiMain.prefs.sm.reportPrefs = null;
            GuiMain.prefs.administrator = GuiMain.capabilities.isAperiAdmin();
        } else {
            GuiClient.clearFields();
        }
        return (short)status;
    }

    private static void clearFields() {
        GuiMain.prefs = new UserPreferences();
        GuiMain.prefs.showLoginAlerts = 1;
        GuiMain.prefs.tabToDisplay = 0;
        GuiMain.prefs.sm = new UserPreferencesSM();
        GuiMain.dashTotalsRow = null;
        GuiMain.adminGroup = null;
        GuiUtil.sortOrderNotASCII = false;
        Variables.spaceUnits = 0;
    }

    protected static short checkServerVersion(String productVersion) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        GuiInfoReq gif = new GuiInfoReq();
        gif.dataRequested = GuiInfoReq.SERVER_PRODUCT_VERSION;
        gif.productVersion = productVersion;
        request.requestData = gif;
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiHndlr";
        short status = GuiClient.doRequest(request);
        return status;
    }

    public static short saveUserPrefs() {
        IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
        if (guiMain instanceof GuiMain && GuiMain.DEMO_MODE) {
            return 0;
        }
        UserPreferences prefs = guiMain.getUserPrefs();
        prefs.sm.reportPrefs = ReportPrefsManager.getAll();
        ServerRequest.userPrefUpd(request, GuiUtil.getUserName(), prefs);
        short status = GuiClient.doRequest(request);
        return status;
    }

    public static GComputer getComputer(int computerID) {
        ServerRequest.guiInfo(request, GuiInfoReq.COMPUTER, computerID);
        short status = GuiClient.doRequest(request);
        if (status > 4) {
            return null;
        }
        return GComputer.unpackList((GComputer[])GuiClient.response.responseData);
    }

    public static String getAgentHome(int computerID) {
        String home = null;
        ServerRequest.agentGetAgentHome(request, computerID);
        short status = GuiClient.doRequest(request);
        if (status > 4) {
            return null;
        }
        home = (String)((Object)GuiClient.response.responseData);
        return home;
    }

    public static void serverError(short status, String errorMessage) {
        int severity;
        String headerID;
        String titleID;
        IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
        if (status == 4) {
            titleID = "GUI0057M";
            headerID = "GUI0058M";
            severity = 2;
        } else {
            titleID = "GUI0020M";
            headerID = "GUI0021M";
            severity = 0;
        }
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(MessageLog.getMessageNoID(headerID));
        buffer.append('\n');
        buffer.append(SERVER);
        buffer.append(" ");
        buffer.append(server);
        buffer.append("           ");
        buffer.append(STATUS);
        buffer.append(" ");
        buffer.append(status);
        buffer.append('\n');
        buffer.append(" ");
        buffer.append('\n');
        buffer.append(errorMessage);
        String helpID = null;
        if (errorMessage != null && (helpID = GuiClient.getHelpID(errorMessage)) != null) {
            buffer.append("\n\n");
            buffer.append(PRESS_PF1);
        }
        JOptionPane optPane = new JOptionPane();
        if (errorMessage != null) {
            JTextArea text = new JTextArea(buffer.toString(), 10, 75);
            text.setLineWrap(true);
            text.setWrapStyleWord(true);
            text.setEditable(false);
            Color bcolor = optPane.getBackground();
            text.setBackground(bcolor);
            JScrollPane scrollPane = new JScrollPane(text);
            optPane.setMessage(scrollPane);
        }
        String title = MessageLog.getMessageNoID(titleID);
        optPane.setMessageType(severity);
        Window[] windows = guiMain.getFrame().getOwnedWindows();
        Dialog parent = null;
        if (windows != null) {
            for (int i = 0; i < windows.length; ++i) {
                Window w = windows[i];
                if (!(w instanceof Dialog) || w.getFocusOwner() == null) continue;
                parent = (Dialog)w;
                break;
            }
        }
        JDialog optDialog = parent != null ? optPane.createDialog(parent, title) : optPane.createDialog(guiMain.getFrame(), title);
        if (helpID != null) {
            JRootPane rootPane = optDialog.getRootPane();
            Help.setHelpID(rootPane, helpID);
            rootPane.registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
            rootPane.registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
        }
        GuiUtil.centerDialog(optDialog);
        optDialog.pack();
        optDialog.show();
    }

    private static String getHelpID(String errorMessage) {
        int index = 0;
        String helpID = null;
        while (index >= 0) {
            int i;
            char c;
            if ((index = errorMessage.indexOf(": ", index + 1)) < 8 || (c = errorMessage.charAt(index - 1)) != 'E' && c != 'I' && c != 'W' && c != 'M') continue;
            boolean isMsgID = true;
            int charPos = index - 8;
            for (i = 0; i < 3; ++i) {
                if ((c = errorMessage.charAt(charPos++)) >= 'A' && c <= 'Z') continue;
                isMsgID = false;
                break;
            }
            if (!isMsgID) continue;
            for (i = 0; i < 4; ++i) {
                if (Character.isDigit(errorMessage.charAt(charPos++))) continue;
                isMsgID = false;
                break;
            }
            if (!isMsgID) continue;
            String msgID = errorMessage.substring(index - 8, index);
            if (!Help.isValidID(msgID)) break;
            helpID = msgID;
            break;
        }
        return helpID;
    }

    private static short doRequest(Request request) {
        String errorMessage;
        int status;
        response = null;
        request.userName = GuiUtil.getUserName();
        try {
            Socket socket = new Socket(server, port);
            SocketTransceiver t = new SocketTransceiver(socket, server, 300);
            response = t.transmitRequest(request, null);
            t.close();
            if (response == null) {
                status = 12;
                errorMessage = MessageLog.getMessage("GUI0022M", null);
            } else {
                status = GuiClient.response.status;
                errorMessage = GuiClient.response.errorMessage;
            }
        }
        catch (Exception e) {
            status = 12;
            errorMessage = MessageLog.getMessage("GUI0023M", null);
        }
        if (status != 0) {
            GuiClient.serverError((short)status, errorMessage);
        }
        return (short)status;
    }

    private static RequestNode addToPending(GuiRequestor requestor) {
        RequestNode result = new RequestNode();
        result.requestor = requestor;
        result.next = pendingRequests;
        pendingRequests = result;
        return result;
    }

    static boolean removeNode(RequestNode node) {
        RequestNode prev = null;
        RequestNode current = pendingRequests;
        while (current != null && current != node) {
            prev = current;
            current = current.next;
        }
        if (current == null) {
            return false;
        }
        if (prev != null) {
            prev.next = current.next;
        } else {
            pendingRequests = current.next;
        }
        return true;
    }

    public static void cancelAll() {
        pendingRequests = null;
    }

    static boolean nonePending() {
        return pendingRequests == null;
    }

    public static void doRequest(GuiRequestor requestor, Request request) {
        IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
        guiMain.guiEnabled(false);
        RequestNode node = GuiClient.addToPending(requestor);
        request.userName = GuiUtil.getUserName();
        GuiSendRequest gsr = new GuiSendRequest(request, node);
        Thread reqThread = new Thread((Runnable)gsr, "Server Request");
        reqThread.setPriority(reqThread.getPriority() + 1);
        reqThread.start();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean doRhetoricalRequest(Request request) {
        Socket socket;
        request.userName = GuiUtil.getUserName();
        try {
            socket = new Socket(server, port);
        }
        catch (IOException e) {
            MessageLog.logException("GUI0023M", null);
            return false;
        }
        SocketTransceiver t = new SocketTransceiver(socket, server);
        boolean result = t.writeObject((Object)request, -1);
        t.close();
        return result;
    }

    static {
        request = new Request();
        SERVER = MessageLog.getMessageNoID("GUI0001L", null);
        STATUS = MessageLog.getMessageNoID("GUI0002L", null);
        PRESS_PF1 = MessageLog.getMessageNoID("GUI0084M", null);
    }

    static class RequestNode {
        public RequestNode next;
        public GuiRequestor requestor;

        RequestNode() {
        }
    }
}

