/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.gui.DiskMgrTreeLabel;
import org.eclipse.aperi.TStorm.gui.FabricMgrTreeLabel;
import org.eclipse.aperi.TStorm.gui.StormTreeLabel;
import org.eclipse.aperi.TStorm.gui.TapeMgrTreeLabel;
import org.eclipse.aperi.TStorm.gui.TreeLabel;
import org.eclipse.aperi.TStorm.gui.UserPrefEditorSM;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.PrintOptions;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.About;
import org.eclipse.aperi.gui.AlertManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GlassPaneMouseListener;
import org.eclipse.aperi.gui.GuiApplet;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiConnect;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.PrintManager;
import org.eclipse.aperi.gui.PrintOutputChooser;
import org.eclipse.aperi.gui.PrintPreviewPanel;
import org.eclipse.aperi.gui.PrintTableData;
import org.eclipse.aperi.gui.SplashPanel;
import org.eclipse.aperi.gui.UserPrefEditor;
import org.eclipse.aperi.gui.WindowMenu;
import org.eclipse.aperi.gui.admin.AdminTreeLabel;
import org.eclipse.aperi.gui.charting.AperiChartFactory;
import org.eclipse.aperi.gui.dashboard.DashMain;
import org.eclipse.aperi.server.guireq.DashTotalsRow;
import org.eclipse.aperi.server.guireq.UserPreferences;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiMain
extends JFrame
implements IGuiMain,
ActionListener,
MouseListener,
MenuListener,
KeyListener {
    public static final String LAF = GuiMain.setSystemLAF();
    public static Frame frame;
    static boolean DEMO_MODE;
    public static final String VERSION = "5.0.0";
    static final String BUILD = "5.0.0_20070109-212026";
    private static final short ERROR = 12;
    private static Icon blankIcon;
    private String[] servers;
    public static String server;
    private static Hashtable computerTable;
    public static GuiMain pGuiMain;
    public static BaseTree pBaseTree;
    protected static String userName;
    public static UserPreferences prefs;
    public static DataDisplayInfo nullDDI;
    private static DashMain dashMain;
    public static DashTotalsRow dashTotalsRow;
    private static SplashPanel splashPanel;
    private static String[] lafClassNames;
    private static final String TITLE;
    private static final String NOT_CONNECTED;
    private static final String CONNECTION;
    private static final String NEW_CONNECTION;
    private static final String ERR_GET_COMP;
    private static final String PREFERENCES;
    private static final String LOOK_AND_FEEL;
    private static final String PREF_EDIT;
    private static final String FILE;
    private static final String FILE_SAVE;
    private static final String FILE_SAVE_AS;
    private static final String FILE_EXPORT;
    private static final String FILE_PRINT;
    private static final String FILE_PRINT_TREE;
    private static final String FILE_REFRESH_ALERTS;
    private static final String FILE_CLOSE;
    private static final String FILE_EXIT;
    private static final String VIEW;
    private static final String TREE;
    private static final String DISCONNECT_TITLE;
    private static final String DISCONNECT_WARNING;
    private static final String SYNCH = "SYN";
    public static JSplitPane splitPane;
    public static JScrollPane treePane;
    public static JScrollPane dataPane;
    private static JPanel holderPane;
    private static Component glassPane;
    public static Container contentPane;
    private static GlassPaneMouseListener glassML;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu connection_menu = new JMenu();
    private JMenuItem connectChange = new JMenuItem();
    private JMenu fileMenu = new JMenu();
    public myJMenuItem fileSave = new myJMenuItem();
    public myJMenuItem fileSaveAs = new myJMenuItem();
    public myJMenuItem fileExport = new myJMenuItem();
    public myJMenuItem filePrint = new myJMenuItem();
    public myJMenuItem filePrintTree = new myJMenuItem();
    public static JMenuItem fileClose;
    public static int curProperAdmin;
    private JMenuItem fileRefreshAlerts;
    private JMenuItem fileExit;
    private JMenu viewMenu = new JMenu();
    private JMenuItem viewSynch;
    private JCheckBoxMenuItem showTree = new JCheckBoxMenuItem();
    private JMenu preferencesMenu = new JMenu();
    private JMenu lookAndFeelMenu = new JMenu();
    private JMenuItem prefEdit = new JMenuItem();
    private JMenuItem prefEditSM = new JMenuItem();
    private JMenu windowMenu = new WindowMenu();
    private JMenu helpMenu = new JMenu();
    private JToolBar toolBar = new JToolBar();
    private JButton nextButton = new JButton();
    private JButton backButton = new JButton();
    public JButton printButton = new JButton();
    public static JButton stopButton;
    public static JButton cancelButton;
    public static BaseTreeNode selectedNode;
    private JLabel treeTitle;
    public static JPanel leftPanel;
    public static String adminGroup;
    private static boolean[] showNoSaveMsg;
    public SaveJButton saveButton = new SaveJButton();
    private static Color background;
    protected static GuiApplet applet;
    public static final Color blueGreen;
    public static final Color dustyRose;
    public static final Color purple;
    public static final Color brightRed;
    public static final Color coral;
    public static final Color dkCoral;
    public static final Color ltPink;
    public static final Color leafGreen;
    public static final Color blueSky;
    public static final Color greySky;
    public static final Color swimPool;
    public static final Color ltYellow;
    public static final Color hotPink;
    public static final Color teal;
    public static final Color sage;
    public static final Color bronze;
    public static final Color ocre;
    public static final Color peaGreen;
    public static final Color moss;
    public static final Color seaweed;
    public static final Color violet;
    public static final Color darkBlue;
    public static final Color[] chartColors;
    private static Component savedComponentWithFocus;
    public static Capabilities capabilities;
    public JPanel mainPanel = null;
    public static String platform;
    public static String RCP_PLATFORM;
    public static String SWING_PLATFORM;
    int indentLevel = 0;
    boolean expanded;
    static final String[] indentDots;
    static final String[] indentBlanks;
    private String INDENT_CHARS = "     ";
    String[] indenters;
    public static DataDisplayInfo ddiCurr;
    public static boolean disconnectInProcess;

    public boolean isProperAdmin() {
        boolean isAdminForMgr = false;
        DataDisplayInfo ddi = DataDisplayInfo.getCurrent();
        if (ddi != null) {
            BaseTreeNode treeNode = ddi.treeNode;
            isAdminForMgr = GuiMain.isProperAdmin(treeNode);
        }
        return isAdminForMgr;
    }

    private static boolean isProperAdmin(BaseTreeNode treeNode) {
        boolean isAdminForMgr = false;
        if (treeNode != null) {
            TreeNode[] path = treeNode.getPath();
            int len = path.length;
            if (len < 2) {
                return false;
            }
            TreeNode mgrNode = path[1];
            if (mgrNode instanceof AdminTreeLabel) {
                isAdminForMgr = capabilities.isAperiAdmin();
                curProperAdmin = 5;
            } else if (mgrNode instanceof TreeLabel) {
                isAdminForMgr = capabilities.isAnyAdmin();
                curProperAdmin = 4;
            } else if (mgrNode instanceof StormTreeLabel) {
                isAdminForMgr = capabilities.isDataAdmin();
                curProperAdmin = 1;
            } else if (mgrNode instanceof DiskMgrTreeLabel) {
                isAdminForMgr = capabilities.isDiskAdmin();
                curProperAdmin = 2;
            } else if (mgrNode instanceof FabricMgrTreeLabel) {
                isAdminForMgr = capabilities.isFabricAdmin();
                curProperAdmin = 3;
            } else if (mgrNode instanceof TapeMgrTreeLabel) {
                isAdminForMgr = capabilities.isTapeAdmin();
                curProperAdmin = 6;
            }
        }
        return isAdminForMgr;
    }

    public static void main(String[] args) {
        new GuiMain(args, null);
    }

    public GuiMain(String[] args, GuiApplet applet) {
        GuiManager.getGuiManager().setGuiMain(this);
        platform = SWING_PLATFORM;
        SwingUtilities.updateComponentTreeUI(this);
        GuiMain.prefs.lookAndFeel = LAF;
        GuiMain.applet = applet;
        this.setVisible(false);
        pGuiMain = this;
        for (int i = 0; i < 7; ++i) {
            GuiMain.showNoSaveMsg[i] = true;
        }
        splitPane = new JSplitPane();
        treePane = new JScrollPane();
        dataPane = new JScrollPane();
        GuiUtil.setAccessible(pGuiMain, TITLE, TITLE);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(GuiMain.class.getResource("images/icon.gif")));
        glassPane = this.getGlassPane();
        contentPane = this.getContentPane();
        background = contentPane.getBackground();
        GuiMain.setServer(NOT_CONNECTED);
        this.setDefaultCloseOperation(0);
        this.setLocation(0, 0);
        contentPane.setLayout(new BorderLayout(0, 0));
        Dimension screenSize = this.getToolkit().getScreenSize();
        this.setSize(screenSize.width, screenSize.height - 26);
        this.setupMenuBar();
        this.setupToolBar();
        this.setupGlassPane();
        GuiMain.nullDDI.displayInScrollPane = false;
        nullDDI.setDescription(MessageLog.getMessageNoID("STG5238L"));
        splashPanel = new SplashPanel();
        dashMain = new DashMain();
        this.showNull(false);
        String[] a = new String[]{"localhost:9549"};
        try {
            Properties props = new Properties();
            FileInputStream fis = new FileInputStream("gui.properties");
            props.load(fis);
            a[0] = props.getProperty("server");
        }
        catch (IOException e) {
            // empty catch block
        }
        GuiConnect.createServerList(a);
        if (!DEMO_MODE) {
            splitPane.setDividerLocation((int)((double)screenSize.width * 0.27));
            this.setVisible(true);
        }
        new GuiConnect();
        if (DEMO_MODE) {
            splitPane.setDividerLocation((int)((double)screenSize.width * 0.27));
            this.setVisible(true);
        }
        this.helpMenu.setNextFocusableComponent(pBaseTree);
        this.addKeyListener(this);
        BaseTree.pBaseTree.setSelectionRow(0);
        BaseTree.pBaseTree.requestFocus();
    }

    private void setupMenuBar() {
        int i;
        this.setJMenuBar(this.menuBar);
        this.fileMenu.setText(FILE);
        this.fileMenu.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_FILEMENU"));
        GuiUtil.setAccessible(this.fileMenu, FILE, FILE);
        this.menuBar.add(this.fileMenu);
        this.fileSave.setText(FILE_SAVE);
        this.fileSave.setActionCommand("Save");
        this.fileSave.setEnabled(false);
        this.fileSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        GuiUtil.setAccessible(this.fileSave, FILE_SAVE, FILE_SAVE);
        this.fileMenu.add(this.fileSave);
        this.viewMenu.setText(VIEW);
        this.viewMenu.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_VIEWMENU"));
        GuiUtil.setAccessible(this.viewMenu, VIEW, VIEW);
        this.menuBar.add(this.viewMenu);
        this.showTree.setActionCommand("tree");
        this.showTree.setText(TREE);
        this.showTree.setSelected(true);
        GuiUtil.setAccessible(this.showTree, TREE, TREE);
        this.viewMenu.add(this.showTree);
        String s = MessageLog.getMessageNoID("GUI0066L");
        this.viewSynch = new JMenuItem(s);
        this.viewSynch.setActionCommand(SYNCH);
        this.viewSynch.addActionListener(this);
        GuiUtil.setAccessible(this.viewSynch, SYNCH, SYNCH);
        this.viewMenu.add(this.viewSynch);
        this.viewMenu.addMenuListener(this);
        this.fileSaveAs.setText(FILE_SAVE_AS);
        this.fileSaveAs.setActionCommand("SaveAs");
        this.fileSaveAs.setEnabled(false);
        this.fileSaveAs.setAccelerator(KeyStroke.getKeyStroke(83, 10));
        GuiUtil.setAccessible(this.fileSaveAs, FILE_SAVE_AS, FILE_SAVE_AS);
        this.fileMenu.add(this.fileSaveAs);
        this.fileExport.setText(FILE_EXPORT);
        this.fileExport.setActionCommand("Export");
        this.fileExport.setEnabled(false);
        GuiUtil.setAccessible(this.fileExport, FILE_EXPORT, FILE_EXPORT);
        this.fileMenu.add(this.fileExport);
        this.filePrint.setText(FILE_PRINT);
        this.filePrint.setActionCommand("Print");
        this.filePrint.setEnabled(false);
        this.filePrint.addActionListener(this);
        GuiUtil.setAccessible(this.filePrint, FILE_PRINT, FILE_PRINT);
        this.fileMenu.add(this.filePrint);
        this.filePrintTree.setText(FILE_PRINT_TREE);
        this.filePrintTree.setActionCommand("PrintTree");
        this.filePrintTree.addActionListener(this);
        GuiUtil.setAccessible(this.filePrintTree, FILE_PRINT_TREE, FILE_PRINT_TREE);
        this.fileMenu.add(this.filePrintTree);
        this.fileRefreshAlerts = new JMenuItem(FILE_REFRESH_ALERTS);
        this.fileMenu.add(this.fileRefreshAlerts);
        this.fileRefreshAlerts.addActionListener(this);
        GuiUtil.setAccessible(this.fileRefreshAlerts, FILE_REFRESH_ALERTS, FILE_REFRESH_ALERTS);
        fileClose.setText(FILE_CLOSE);
        fileClose.setActionCommand("Close");
        fileClose.setEnabled(true);
        fileClose.addActionListener(this);
        GuiUtil.setAccessible(fileClose, FILE_CLOSE, FILE_CLOSE);
        this.fileMenu.add(fileClose);
        this.fileExit = new JMenuItem(FILE_EXIT);
        this.fileMenu.add(this.fileExit);
        this.fileExit.addActionListener(this);
        GuiUtil.setAccessible(this.fileExit, FILE_EXIT, FILE_EXIT);
        this.connection_menu.setText(CONNECTION);
        this.connection_menu.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_CONNECTION"));
        GuiUtil.setAccessible(this.connection_menu, CONNECTION, CONNECTION);
        this.menuBar.add(this.connection_menu);
        this.connectChange.setText(NEW_CONNECTION);
        GuiUtil.setAccessible(this.connectChange, NEW_CONNECTION, NEW_CONNECTION);
        this.connection_menu.add(this.connectChange);
        this.preferencesMenu.setText(PREFERENCES);
        this.preferencesMenu.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_PREFERENCES"));
        GuiUtil.setAccessible(this.preferencesMenu, PREFERENCES, PREFERENCES);
        this.menuBar.add(this.preferencesMenu);
        this.lookAndFeelMenu.setText(LOOK_AND_FEEL);
        GuiUtil.setAccessible(this.lookAndFeelMenu, LOOK_AND_FEEL, LOOK_AND_FEEL);
        this.preferencesMenu.add(this.lookAndFeelMenu);
        this.prefEdit.setText(PREF_EDIT);
        this.prefEdit.setActionCommand(PREF_EDIT);
        GuiUtil.setAccessible(this.prefEdit, PREF_EDIT, PREF_EDIT);
        this.preferencesMenu.add(this.prefEdit);
        this.preferencesMenu.add(AperiChartFactory.getChartEngineMenu());
        this.menuBar.add(this.windowMenu);
        this.menuBar.add(this.helpMenu);
        String helpText = Util.getString("LABEL_HELP_MENU");
        this.helpMenu.setText(helpText);
        this.helpMenu.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_HELP"));
        GuiUtil.setAccessible(this.helpMenu, helpText, helpText);
        new Help().createMenu(this.helpMenu);
        LookAndFeel laf = UIManager.getLookAndFeel();
        String currentLafClassName = laf.getClass().getName();
        boolean winHost = false;
        String osName = System.getProperty("os.name", " ");
        if (osName.regionMatches(true, 0, "win", 0, 3)) {
            winHost = true;
        }
        String javaVersion = System.getProperty("java.version", " ");
        javaVersion = null;
        ButtonGroup lookAndFeelGroup = new ButtonGroup();
        NameList head = null;
        int nValidLAFs = 0;
        UIManager.LookAndFeelInfo[] installedLafs = UIManager.getInstalledLookAndFeels();
        for (i = 0; i < installedLafs.length; ++i) {
            String lafName = installedLafs[i].getName();
            if (lafName == null || !winHost && lafName.equalsIgnoreCase("windows")) continue;
            NameList element = new NameList();
            element.nlID = i;
            element.nlName = lafName;
            element.nlNext = head;
            head = element;
            ++nValidLAFs;
        }
        lafClassNames = new String[nValidLAFs];
        i = 0;
        while (head != null) {
            GuiMain.lafClassNames[i] = installedLafs[head.nlID].getClassName();
            boolean buttonState = false;
            if (currentLafClassName.equals(lafClassNames[i])) {
                buttonState = true;
            }
            JRadioButtonMenuItem rb = new JRadioButtonMenuItem(head.nlName, buttonState);
            rb.setActionCommand(lafClassNames[i]);
            lookAndFeelGroup.add(rb);
            this.lookAndFeelMenu.add(rb);
            rb.addActionListener(this);
            ++i;
            head = head.nlNext;
        }
    }

    private void setupToolBar() {
        contentPane.add("North", this.toolBar);
        this.backButton.setToolTipText("   " + MessageLog.getMessageNoID("GUI0007L", null) + "   ");
        this.backButton.setIcon(IconFactory.getBackIcon());
        this.backButton.setRolloverIcon(IconFactory.getRolloverBackIcon());
        this.backButton.setVerticalTextPosition(3);
        this.backButton.setHorizontalTextPosition(0);
        this.backButton.setMargin(new Insets(2, 2, 2, 2));
        this.backButton.addMouseListener(this);
        this.backButton.setEnabled(false);
        this.toolBar.add(this.backButton);
        this.nextButton.setToolTipText(MessageLog.getMessageNoID("GUI0008L", null));
        this.nextButton.setIcon(IconFactory.getNextIcon());
        this.nextButton.setRolloverIcon(IconFactory.getRolloverNextIcon());
        this.nextButton.setVerticalTextPosition(3);
        this.nextButton.setHorizontalTextPosition(0);
        this.nextButton.setMargin(new Insets(2, 2, 2, 2));
        this.nextButton.addMouseListener(this);
        this.nextButton.setEnabled(false);
        this.toolBar.add(this.nextButton);
        this.toolBar.addSeparator();
        this.saveButton.setIcon(IconFactory.getSaveIcon());
        this.saveButton.setRolloverIcon(IconFactory.getRolloverSaveIcon());
        this.saveButton.setVerticalTextPosition(3);
        this.saveButton.setHorizontalTextPosition(0);
        this.saveButton.setMargin(new Insets(2, 2, 2, 2));
        this.saveButton.setEnabled(false);
        this.saveButton.setActionCommand("Save");
        this.toolBar.add(this.saveButton);
        this.toolBar.addSeparator();
        this.printButton.setToolTipText("   " + MessageLog.getMessageNoID("GUI0009L", null) + "   ");
        this.printButton.setIcon(IconFactory.getPrintIcon());
        this.printButton.setRolloverIcon(IconFactory.getRolloverPrintIcon());
        this.printButton.setVerticalTextPosition(3);
        this.printButton.setHorizontalTextPosition(0);
        this.printButton.setMargin(new Insets(2, 2, 2, 2));
        this.printButton.setEnabled(false);
        this.toolBar.add(this.printButton);
        this.toolBar.addSeparator();
        cancelButton.setToolTipText(MessageLog.getMessageNoID("GUI5010T"));
        cancelButton.setIcon(IconFactory.getRaggedBlackXIcon());
        cancelButton.setRolloverIcon(IconFactory.getRaggedRedXIcon());
        cancelButton.setVerticalTextPosition(3);
        cancelButton.setHorizontalTextPosition(0);
        cancelButton.setMargin(new Insets(2, 2, 2, 2));
        cancelButton.setActionCommand("Cancel");
        this.toolBar.add(cancelButton);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        stopButton.setIcon(IconFactory.getStopIcon());
        stopButton.setToolTipText("   " + MessageLog.getMessageNoID("GUI0042T", null) + "   ");
        stopButton.setMargin(new Insets(2, 2, 2, 2));
        this.toolBar.add(stopButton);
        stopButton.setEnabled(false);
        this.enableRollover();
        contentPane.add("Center", splitPane);
        splitPane.setBounds(0, 0, 0, 0);
        treePane.setOpaque(true);
        leftPanel = new JPanel(new BorderLayout(2, 2));
        this.treeTitle = new JLabel(Util.getString("LABEL_TREE_TITLE"));
        this.treeTitle.setOpaque(false);
        this.treeTitle.setDisplayedMnemonic(GuiUtil.getMnemonic("MNEMONIC_TREE_TITLE"));
        this.treeTitle.setLabelFor(pBaseTree);
        leftPanel.add((Component)this.treeTitle, "North");
        leftPanel.add((Component)treePane, "Center");
        splitPane.add((Component)leftPanel, "left");
        treePane.setBounds(1, 1, 182, 798);
        pBaseTree = new BaseTree();
        pBaseTree.setBackground(Color.white);
        pBaseTree.putClientProperty("JTree.lineStyle", "Angled");
        treePane.getViewport().add(pBaseTree);
        pBaseTree.setBounds(0, 0, 179, 795);
        splitPane.add((Component)dataPane, "right");
        dataPane.setBounds(193, 1, 406, 798);
        TSWindow aTSWindow = new TSWindow();
        this.addWindowListener(aTSWindow);
        this.showTree.addActionListener(this);
        this.connectChange.addActionListener(this);
        this.prefEdit.addActionListener(this);
        this.prefEditSM.addActionListener(this);
        this.backButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.printButton.addActionListener(this);
        stopButton.addActionListener(this);
        cancelButton.addActionListener(this);
    }

    private void setupGlassPane() {
        glassML = new GlassPaneMouseListener(stopButton, glassPane, contentPane, this);
        glassPane.addMouseListener(glassML);
        glassPane.addMouseMotionListener(glassML);
    }

    public void keyPressed(KeyEvent e) {
        if (e.isAltDown() && e.getKeyCode() == this.treeTitle.getDisplayedMnemonic()) {
            if (savedComponentWithFocus != null) {
                savedComponentWithFocus.requestFocus();
            } else {
                pBaseTree.setSelectionRow(0);
                pBaseTree.requestFocus();
            }
        }
        if (e.isControlDown() && e.getKeyCode() == 77) {
            if (BaseTree.selectedNode != null) {
                Rectangle r = pBaseTree.getPathBounds(BaseTree.selectedPath);
                BaseTree.selectedNode.showPopupMenu(new MouseEvent(pBaseTree, 0, 0L, 0, (int)r.getX(), (int)r.getY(), 1, false));
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void windowClosing() {
        if (this.disconnectFromServer()) {
            pGuiMain = null;
            if (applet == null) {
                System.exit(0);
            } else {
                GuiApplet guiApplet = applet;
                synchronized (guiApplet) {
                    applet.notify();
                }
                this.dispose();
            }
        }
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        this.checkPopup(event);
    }

    public void mouseReleased(MouseEvent event) {
        this.checkPopup(event);
    }

    private void checkPopup(MouseEvent event) {
        JButton jb = (JButton)event.getSource();
        if (event.isPopupTrigger() && jb.isEnabled()) {
            boolean forward = jb == this.nextButton;
            JPopupMenu pm = new JPopupMenu();
            DataDisplayInfo ddi = DataDisplayInfo.getCurrent();
            int i = 0;
            while ((ddi = forward ? ddi.getNext() : ddi.getPrev()) != null) {
                JMenuItem mi = new JMenuItem(ddi.toString());
                mi.addActionListener(this);
                mi.setActionCommand(Integer.toString(forward ? ++i : --i));
                if (ddi.changesPending()) {
                    mi.setIcon(IconFactory.getRedLightIcon());
                } else if (ddi.isEditable()) {
                    mi.setIcon(IconFactory.getGreenLightIcon());
                } else {
                    mi.setIcon(blankIcon);
                }
                pm.add(mi);
            }
            pm.show(jb, jb.getWidth(), 0);
        }
    }

    private void setSelectedNode() {
        selectedNode = null;
        DataDisplayInfo currentDDI = DataDisplayInfo.getCurrent();
        if (currentDDI == null) {
            return;
        }
        BaseTreeNode ddiTreeNode = currentDDI.treeNode;
        if (ddiTreeNode == null) {
            return;
        }
        TreeNode[] arrayPath = BaseTree.MyTree.getPathToRoot(ddiTreeNode);
        if (arrayPath == null || arrayPath.length == 0) {
            return;
        }
        if (arrayPath[0] == (TreeNode)BaseTree.MyTree.getRoot()) {
            selectedNode = ddiTreeNode;
        }
    }

    public void menuCanceled(MenuEvent event) {
    }

    public void menuDeselected(MenuEvent event) {
    }

    public void menuSelected(MenuEvent event) {
        this.setSelectedNode();
        this.viewSynch.setEnabled(selectedNode != null);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.connectChange) {
            if (this.disconnectFromServer()) {
                new GuiConnect();
            }
        } else if (source == this.fileExit) {
            this.windowClosing();
        } else if (source == this.fileRefreshAlerts) {
            AlertManager.refreshAlerts();
        } else if (source == this.showTree) {
            if (this.showTree.isSelected()) {
                splitPane.add((Component)leftPanel, "left");
            } else {
                splitPane.remove(leftPanel);
            }
        } else if (source == this.prefEdit) {
            new UserPrefEditor();
        } else if (source == this.prefEditSM) {
            new UserPrefEditorSM();
        } else if (source == this.backButton) {
            DataDisplayInfo prev = DataDisplayInfo.getCurrent();
            if (ddiCurr != nullDDI) {
                prev = prev.getPrev();
            }
            if (prev != null) {
                prev.reDisplay();
            }
        } else if (source == this.nextButton) {
            DataDisplayInfo next = DataDisplayInfo.getCurrent().getNext();
            if (next != null) {
                next.reDisplay();
            }
        } else if (source == this.printButton || source == this.filePrint) {
            DataDisplayInfo printer = DataDisplayInfo.getCurrent();
            if (printer == null || dashMain.getDisplayedDashboard().isShowing()) {
                GuiMain.nullDDI.panel = dashMain.getDisplayedDashboard();
                nullDDI.setDescription(dashMain.getTitle());
                printer = nullDDI;
            }
            printer.printData(null);
        } else if (source == this.filePrintTree) {
            this.printTree(BaseTree.root);
        } else if (source == stopButton) {
            this.endRequestWait();
        } else if (source == cancelButton || source == fileClose) {
            if (GuiMain.nullDDI.panel != null) {
                DataDisplayInfo prev = DataDisplayInfo.getCurrent();
                if (ddiCurr != nullDDI) {
                    prev = prev.getPrev();
                }
                if (prev != null) {
                    prev.reDisplay();
                }
            } else {
                DataDisplayInfo curr = DataDisplayInfo.getCurrent();
                if (curr != null) {
                    curr.fileClose();
                }
            }
        } else if (JRadioButtonMenuItem.class.isInstance(source)) {
            this.setLookAndFeel(event.getActionCommand());
        } else if (source == this.viewSynch) {
            BaseTree.pBaseTree.reselect(selectedNode, false);
        } else if (JMenuItem.class.isInstance(source)) {
            int ddiNum = Integer.decode(event.getActionCommand());
            boolean forward = ddiNum > 0;
            ddiNum = forward ? ddiNum : -ddiNum;
            DataDisplayInfo ddi = DataDisplayInfo.getCurrent();
            int i = 0;
            while (i++ < ddiNum) {
                ddi = forward ? ddi.getNext() : ddi.getPrev();
            }
            ddi.reDisplay();
        }
    }

    public void printTree(BaseTreeNode treeNode) {
        PrintOutputChooser chooser = new PrintOutputChooser();
        chooser.allowCSV(false);
        chooser.allowFormatted(false);
        PrintOptions options = chooser.getOptions(true, true);
        if (options != null) {
            options.creator = GuiUtil.getUserName();
            options.title = MessageLog.getMessageNoID("GEN0194L");
            options.fileMask = TREE;
            if (options.outputType == 2 || options.outputType == 3 || options.outputType == 4 || options.outputType == 5) {
                options.fileName = PrintTableData.getFileName(options);
                if (options.fileName == null) {
                    return;
                }
            }
            if (options.outputType == 1) {
                BaseTree.setPrintableSubTree(treeNode);
                new PrintPreviewPanel(pBaseTree, false);
                return;
            }
            PrintManager.getPrinter(options);
            if (options.outFile != null) {
                options.printTitle(options.outFile);
                if (options.outputType == 3) {
                    this.INDENT_CHARS = ".....";
                    OutputStreamWriter osw = null;
                    PrintWriter writer = null;
                    try {
                        if (options.outFile != null) {
                            osw = new OutputStreamWriter((OutputStream)options.outFile, "UTF-8");
                        }
                    }
                    catch (Exception e1) {
                        GuiUtil.displayErrorMessage(e1.getMessage());
                    }
                    if (options.outFile != null) {
                        writer = new PrintWriter((Writer)osw, true);
                    }
                    if (writer != null) {
                        writer.println("<html>");
                        writer.println("<head>");
                        writer.print("<title>");
                        if (options.title != null) {
                            writer.print(options.title);
                        }
                        writer.println("</title>");
                        writer.println(" ");
                        writer.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
                        writer.println("<style type=\"text/css\">");
                        writer.println("   .title   { color: #000066  }");
                        writer.println("</style>");
                        writer.println(" ");
                        writer.println("</head>");
                        writer.println("<body>");
                        writer.println(" ");
                        writer.print("<h2 class=\"title\">");
                        if (options.title != null) {
                            writer.print(options.title);
                        }
                        writer.println("</h2>");
                        writer.println(" ");
                        writer.print("<h4 class=\"title\">");
                        writer.print(MessageLog.getMessageNoID("GEN0192L"));
                        writer.print(" ");
                        writer.print(GuiUtil.getUserName());
                        writer.print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                        writer.print(MessageLog.getMessageNoID("GEN0193L"));
                        writer.print(" ");
                        writer.print(Util.formatDateTime(Calendar.getInstance().getTime()));
                        writer.println("</h4>");
                        writer.println(" ");
                        writer.println("<p>");
                        this.printHTMLSubtree(treeNode, writer);
                        writer.println("</p>");
                        writer.println(" ");
                        writer.println("</body>");
                        writer.println("</html>");
                        writer.close();
                    }
                    return;
                }
                this.indenters = indentBlanks;
                this.printSubtree(treeNode);
                PrintManager.printDocument(options);
            }
        }
    }

    private void printSubtree(BaseTreeNode subtree) {
        if (subtree.getAllowsChildren()) {
            this.expanded = pBaseTree.isExpanded(new TreePath(subtree.getPath()));
        }
        if (subtree.getAllowsChildren() && this.expanded) {
            ++this.indentLevel;
            int count = subtree.getChildCount();
            Enumeration<TreeNode> e = subtree.children();
            while (e.hasMoreElements()) {
                this.printSubtree((BaseTreeNode)e.nextElement());
            }
            --this.indentLevel;
        }
    }

    private String createTreeIndent(BaseTreeNode subtree) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("");
        for (int depthFromRoot = subtree.getLevel(); depthFromRoot > 0; --depthFromRoot) {
            buffer.append(this.INDENT_CHARS);
        }
        return buffer.toString();
    }

    private void printHTMLSubtree(BaseTreeNode subtree, PrintWriter writer) {
        boolean usingFontColor = false;
        if (subtree.nodeColor != Color.black) {
            usingFontColor = true;
            writer.print("<font color=\"#");
            writer.print(Integer.toHexString(subtree.nodeColor.getRed()));
            writer.print(Integer.toHexString(subtree.nodeColor.getGreen()));
            writer.print(Integer.toHexString(subtree.nodeColor.getBlue()));
            writer.print("\"/>");
        }
        writer.print(this.createTreeIndent(subtree));
        if (subtree.getAllowsChildren()) {
            if (pBaseTree.isExpanded(new TreePath(subtree.getPath()))) {
                writer.print("- ");
                this.expanded = true;
            } else {
                writer.print("+ ");
                this.expanded = false;
            }
        } else {
            writer.print("  ");
        }
        writer.print(subtree.toString());
        if (usingFontColor) {
            writer.print("</font>");
        }
        writer.println("<br>");
        if (subtree.getAllowsChildren() && this.expanded) {
            int count = subtree.getChildCount();
            Enumeration<TreeNode> e = subtree.children();
            while (e.hasMoreElements()) {
                this.printHTMLSubtree((BaseTreeNode)e.nextElement(), writer);
            }
        }
    }

    public void endRequestWait() {
        GuiClient.cancelAll();
        pGuiMain.guiEnabled(true);
    }

    protected void setLookAndFeel(String lafClassName) {
        String newLAF = null;
        for (int i = 0; i < lafClassNames.length; ++i) {
            if (!lafClassName.equals(lafClassNames[i])) continue;
            newLAF = lafClassNames[i];
        }
        if (newLAF == null) {
            return;
        }
        try {
            int dividerLocation = splitPane.getDividerLocation() + splitPane.getDividerSize() / 2;
            UIManager.setLookAndFeel(newLAF);
            GuiMain.prefs.lookAndFeel = newLAF;
            SwingUtilities.updateComponentTreeUI(this);
            splitPane.setDividerLocation(dividerLocation - splitPane.getDividerSize() / 2);
            for (DataDisplayInfo ddiNode = DataDisplayInfo.getRoot(); ddiNode != null; ddiNode = ddiNode.getNext()) {
                if (ddiNode.panel == null) continue;
                SwingUtilities.updateComponentTreeUI(ddiNode.panel);
            }
            this.enableRollover();
        }
        catch (Exception e) {
            Object[] args = new String[]{lafClassName};
            JOptionPane.showMessageDialog(this, MessageLog.getMessageNoID("GUI0109M", args), MessageLog.getMessageNoID("GUI0110T", null), 2);
        }
    }

    protected void setLAFbutton() {
        JPopupMenu pop = this.lookAndFeelMenu.getPopupMenu();
        String lafClassName = UIManager.getLookAndFeel().getClass().getName();
        for (int i = 0; i < lafClassNames.length; ++i) {
            JRadioButtonMenuItem rb = (JRadioButtonMenuItem)pop.getComponent(i);
            if (!rb.getActionCommand().equals(lafClassName)) continue;
            rb.setSelected(true);
        }
    }

    private void enableRollover() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GuiMain.this.backButton.setRolloverEnabled(true);
                GuiMain.this.nextButton.setRolloverEnabled(true);
                GuiMain.this.printButton.setRolloverEnabled(true);
                GuiMain.this.saveButton.setRolloverEnabled(true);
                cancelButton.setRolloverEnabled(true);
            }
        });
    }

    public void guiEnabled(boolean enabled) {
        glassPane.setVisible(!enabled);
        if (savedComponentWithFocus != null) {
            savedComponentWithFocus.requestFocus();
        } else {
            pBaseTree.requestFocus();
        }
        stopButton.setEnabled(!enabled);
        if (enabled) {
            glassPane.setCursor(Cursor.getPredefinedCursor(0));
            pGuiMain.setCursor(Cursor.getPredefinedCursor(0));
        } else if (savedComponentWithFocus != stopButton) {
            savedComponentWithFocus = pGuiMain.getFocusOwner();
            stopButton.requestFocus();
            glassML.setStopBounds();
            glassPane.setCursor(Cursor.getPredefinedCursor(3));
            pGuiMain.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public static void setServer(String server) {
        pGuiMain.setTitle(TITLE + server);
        GuiMain.server = server;
    }

    public void showNull() {
        this.showNull(false);
    }

    public void showNull(boolean rotate) {
        if (DataDisplayInfo.getCurrent() != null) {
            DataDisplayInfo.getCurrent().loseFocus();
        }
        GuiMain.nullDDI.panel = server == NOT_CONNECTED || dashTotalsRow == null ? About.getAboutPanel() : dashMain.getDashboard(dashTotalsRow, rotate);
        this.setView(nullDDI);
    }

    public static void setTheTitle(String s) {
        StringBuffer buf = new StringBuffer(100);
        buf.append(TITLE);
        buf.append(server);
        buf.append(" -- ");
        buf.append(s);
        pGuiMain.setTitle(buf.toString());
    }

    public void setView(DataDisplayInfo ddi) {
        if (ddi != nullDDI) {
            GuiMain.nullDDI.panel = null;
        }
        ddiCurr = ddi;
        int dividerLocation = splitPane.getDividerLocation();
        if (ddi.displayInScrollPane) {
            splitPane.add((Component)dataPane, "right");
            dataPane.setViewportView(ddi.panel);
            contentPane.setBackground(background);
        } else {
            holderPane = new JPanel();
            holderPane.setLayout(new BorderLayout());
            holderPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            holderPane.setBounds(193, 1, 406, 798);
            holderPane.add((Component)ddi.panel, "Center");
            splitPane.add((Component)holderPane, "right");
            contentPane.setBackground(Color.white);
        }
        splitPane.setDividerLocation(dividerLocation);
        pBaseTree.reselect(ddi.treeNode);
        this.setPrevNext();
        StringBuffer buf = new StringBuffer(100);
        buf.append(TITLE);
        buf.append(server);
        if (ddi != nullDDI) {
            buf.append(" -- ");
            buf.append(ddi.getDescription());
        }
        pGuiMain.setTitle(buf.toString());
    }

    public void setPrevNext() {
        DataDisplayInfo currDDI = DataDisplayInfo.getCurrent();
        DataDisplayInfo backDDI = null;
        DataDisplayInfo nextDDI = null;
        if (currDDI != null) {
            if (currDDI.panel == null) {
                GuiMain.pGuiMain.printButton.setEnabled(false);
            }
            nextDDI = currDDI.getNext();
            backDDI = ddiCurr == nullDDI ? currDDI : currDDI.getPrev();
        }
        GuiMain.pGuiMain.backButton.setEnabled(backDDI != null);
        GuiMain.pGuiMain.nextButton.setEnabled(nextDDI != null);
        GuiMain.pGuiMain.backButton.getModel().setRollover(false);
        GuiMain.pGuiMain.nextButton.getModel().setRollover(false);
        GuiMain.pGuiMain.printButton.getModel().setRollover(false);
    }

    public boolean disconnectFromServer() {
        disconnectInProcess = true;
        DataDisplayInfo.removeAllWithoutChanges();
        DataDisplayInfo currDDI = DataDisplayInfo.getCurrent();
        if (currDDI != null) {
            Object[] options = new String[]{MessageLog.getMessageNoID("GUI0113L"), MessageLog.getMessageNoID("GUI0114L")};
            int answer = 0;
            BaseTreeNode treeNode = currDDI.treeNode;
            if (GuiMain.isProperAdmin(treeNode)) {
                answer = JOptionPane.showOptionDialog(pGuiMain, DISCONNECT_WARNING, DISCONNECT_TITLE, 0, 2, null, options, options[1]);
            }
            if (answer == 0) {
                GuiMain.removeAllDDI();
            }
        }
        if (DataDisplayInfo.getCurrent() == null) {
            if (server != NOT_CONNECTED) {
                GuiClient.saveUserPrefs();
            }
            computerTable = null;
            GuiMain.setServer(NOT_CONNECTED);
            BaseTree.pBaseTree.setVisible(false);
            GuiClient.serverStatusResp = null;
            this.showNull(false);
            disconnectInProcess = false;
            for (int i = 0; i < 7; ++i) {
                GuiMain.showNoSaveMsg[i] = true;
            }
            return true;
        }
        DataDisplayInfo.getCurrent().reDisplay();
        return false;
    }

    private static void removeAllDDI() {
        DataDisplayInfo currDDI;
        while ((currDDI = DataDisplayInfo.getCurrent()) != null) {
            currDDI.remove();
        }
    }

    private static String setSystemLAF() {
        String laf = null;
        try {
            laf = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(laf);
            return laf;
        }
        catch (Exception e) {
            Object[] args = new String[]{laf};
            JOptionPane.showMessageDialog(null, MessageLog.getMessageNoID("GUI0109M", args), MessageLog.getMessageNoID("GUI0110T", null), 2);
            return null;
        }
    }

    public void setExportActionEnabled(boolean state, boolean force) {
        if (state && force) {
            this.fileExport.setEnabledForced();
        } else {
            this.fileExport.setEnabled(state);
        }
    }

    public void setPrintActionEnabled(boolean state, boolean force) {
        if (state && force) {
            this.filePrint.setEnabledForced();
            this.printButton.setEnabled(state);
        } else {
            this.filePrint.setEnabled(state);
            this.printButton.setEnabled(state);
        }
    }

    public void setPrintTreeActionEnabled(boolean state) {
        this.filePrintTree.setEnabled(state);
    }

    public void setSaveAsActionEnabled(boolean state, boolean force) {
        if (state && force) {
            this.fileSaveAs.setEnabledForced();
        } else {
            this.fileSaveAs.setEnabled(state);
        }
    }

    public void setSaveActionEnabled(boolean state, boolean force) {
        if (state && force) {
            this.fileSave.setEnabledForced();
            this.saveButton.setEnabledForced();
        } else {
            this.fileSave.setEnabled(state);
            this.saveButton.setEnabled(state);
        }
    }

    public Frame getFrame() {
        return pGuiMain;
    }

    public ActionListener[] getSaveActionListeners() {
        return this.fileSave.getActionListeners();
    }

    public ActionListener[] getSaveAsActionListeners() {
        return this.fileSaveAs.getActionListeners();
    }

    public void addSaveActionListener(ActionListener l) {
        this.fileSave.addActionListener(l);
        this.saveButton.addActionListener(l);
    }

    public void addSaveAsActionListener(ActionListener l) {
        this.fileSaveAs.addActionListener(l);
    }

    public BaseTree getBaseTree() {
        return pBaseTree;
    }

    public void removeSaveActionListener(ActionListener l) {
        this.fileSave.removeActionListener(l);
        this.saveButton.removeActionListener(l);
    }

    public void removeSaveAsActionListener(ActionListener l) {
        this.fileSaveAs.removeActionListener(l);
    }

    public void setSaveActionToolTip(String text) {
        this.fileSave.setToolTipText(text);
        this.saveButton.setToolTipText(text);
    }

    public void setSaveAsActionToolTip(String text) {
        this.fileSaveAs.setToolTipText(text);
    }

    public void removeExportActionListener(ActionListener l) {
        this.fileExport.removeActionListener(l);
    }

    public void removePrintActionListener(ActionListener l) {
        this.filePrint.removeActionListener(l);
        this.printButton.removeActionListener(l);
    }

    public void addExportActionListener(ActionListener l) {
        this.fileExport.addActionListener(l);
    }

    public void setExportActionToolTip(String text) {
        this.fileExport.setToolTipText(text);
    }

    public void addPrintActionListener(ActionListener l) {
        this.filePrint.addActionListener(l);
        this.printButton.addActionListener(l);
    }

    public void setPrintActionToolTip(String text) {
        this.filePrint.setToolTipText(text);
        this.printButton.setToolTipText(text);
    }

    public ActionListener[] getExportActionListeners() {
        return this.fileExport.getActionListeners();
    }

    public void setDashTotalsRow(DashTotalsRow dashTotals) {
        dashTotalsRow = dashTotals;
    }

    public Capabilities getCapabilities() {
        return capabilities;
    }

    public UserPreferences getUserPrefs() {
        return prefs;
    }

    public DataDisplayInfo getNullDDI() {
        return nullDDI;
    }

    public void addCancelActionListener(ActionListener l) {
        cancelButton.addActionListener(l);
    }

    public void addStopActionListener(ActionListener l) {
        stopButton.addActionListener(l);
    }

    public ActionListener[] getCancelActionListeners() {
        return cancelButton.getActionListeners();
    }

    public ActionListener[] getStopActionListeners() {
        return stopButton.getActionListeners();
    }

    public void removeCancelActionListener(ActionListener l) {
        cancelButton.removeActionListener(l);
    }

    public void removeStopActionListener(ActionListener l) {
        stopButton.removeActionListener(l);
    }

    public void setCancelActionToolTip(String text) {
        cancelButton.setToolTipText(text);
    }

    public void setCancelActionEnabled(boolean state, boolean force) {
        cancelButton.setEnabled(state);
    }

    public void setStopActionToolTip(String text) {
        stopButton.setToolTipText(text);
    }

    public void setStopActionEnabled(boolean state, boolean force) {
        stopButton.setEnabled(state);
    }

    static {
        DEMO_MODE = false;
        blankIcon = IconFactory.getBlankIcon(IconFactory.getRedLightIcon().getIconWidth());
        computerTable = null;
        prefs = new UserPreferences();
        nullDDI = new DataDisplayInfo();
        TITLE = MessageLog.getMessageNoID("GUI0000T") + ":  ";
        NOT_CONNECTED = MessageLog.getMessageNoID("GUI0010T");
        CONNECTION = Util.getString("LABEL_CONNECTION_MENU");
        NEW_CONNECTION = MessageLog.getMessageNoID("GUI0012L");
        ERR_GET_COMP = MessageLog.getMessageNoID("GUI0016M");
        PREFERENCES = Util.getString("LABEL_PREFERENCES_MENU");
        LOOK_AND_FEEL = MessageLog.getMessageNoID("GUI0112T");
        PREF_EDIT = MessageLog.getMessageNoID("GUI5079L");
        FILE = Util.getString("LABEL_FILE_MENU");
        FILE_SAVE = MessageLog.getMessageNoID("GUI5006L");
        FILE_SAVE_AS = MessageLog.getMessageNoID("GUI5007L");
        FILE_EXPORT = MessageLog.getMessageNoID("GUI5069L");
        FILE_PRINT = MessageLog.getMessageNoID("GUI5098L");
        FILE_PRINT_TREE = MessageLog.getMessageNoID("GUI5099L");
        FILE_REFRESH_ALERTS = MessageLog.getMessageNoID("GUI2047L");
        FILE_CLOSE = MessageLog.getMessageNoID("GUI5008L");
        FILE_EXIT = MessageLog.getMessageNoID("GUI2046L");
        VIEW = Util.getString("LABEL_VIEW_MENU");
        TREE = MessageLog.getMessageNoID("GUI0152L");
        DISCONNECT_TITLE = MessageLog.getMessageNoID("GUI0132T");
        DISCONNECT_WARNING = MessageLog.getMessageNoID("GUI0133T");
        fileClose = new JMenuItem();
        curProperAdmin = 5;
        stopButton = new JButton();
        cancelButton = new JButton();
        showNoSaveMsg = new boolean[7];
        applet = null;
        blueGreen = new Color(64, 204, 204);
        dustyRose = new Color(204, 102, 102);
        purple = new Color(150, 0, 150);
        brightRed = new Color(255, 0, 0);
        coral = new Color(255, 120, 60);
        dkCoral = new Color(220, 35, 35);
        ltPink = new Color(255, 210, 210);
        leafGreen = new Color(188, 255, 50);
        blueSky = new Color(150, 150, 255);
        greySky = new Color(200, 200, 255);
        swimPool = new Color(200, 255, 255);
        ltYellow = new Color(255, 255, 150);
        hotPink = new Color(255, 140, 255);
        teal = new Color(0, 100, 200);
        sage = new Color(180, 220, 180);
        bronze = new Color(200, 100, 0);
        ocre = new Color(200, 150, 0);
        peaGreen = new Color(200, 220, 0);
        moss = new Color(150, 150, 50);
        seaweed = new Color(100, 100, 0);
        violet = new Color(150, 110, 150);
        darkBlue = new Color(0, 0, 200);
        chartColors = new Color[]{Color.blue, darkBlue, brightRed, dkCoral, coral, Color.orange, Color.yellow, peaGreen, leafGreen, Color.green, blueGreen, Color.cyan, teal, purple, Color.magenta, violet, dustyRose, bronze, ocre, moss, seaweed, Color.gray, ltYellow, ltPink, Color.pink, hotPink, blueSky, greySky, swimPool, sage, Color.white};
        savedComponentWithFocus = null;
        RCP_PLATFORM = "RCP";
        SWING_PLATFORM = "SWING";
        indentDots = new String[]{"", ".....", "..........", "...............", "....................", ".........................", "..............................", "...................................", "........................................", ".............................................", "..................................................", "......................................................."};
        indentBlanks = new String[]{"", "     ", "          ", "               ", "                    ", "                         ", "                              ", "                                   ", "                                        ", "                                             ", "                                                  ", "                                                       "};
        disconnectInProcess = false;
    }

    private class TSWindow
    extends WindowAdapter {
        private TSWindow() {
        }

        public void windowClosing(WindowEvent event) {
            GuiMain.this.windowClosing();
        }
    }

    public class SaveJButton
    extends JButton {
        public SaveJButton() {
            this.setToolTipText(MessageLog.getMessageNoID("GUI5009T"));
        }

        public void setToolTipText(String text) {
            if (text == null || text.equals("")) {
                super.setToolTipText(MessageLog.getMessageNoID("GUI5009T"));
            } else {
                super.setToolTipText(text);
            }
        }

        public void setEnabled(boolean state) {
            boolean properAdmin = GuiMain.this.isProperAdmin();
            super.setEnabled(state && properAdmin);
            if (state && !properAdmin && showNoSaveMsg[curProperAdmin]) {
                String s;
                showNoSaveMsg[GuiMain.curProperAdmin] = false;
                if (curProperAdmin == 4) {
                    s = Util.getString("GUI0166T");
                } else {
                    Object[] args = new Object[]{Capabilities.roleNames[curProperAdmin]};
                    s = MessageLog.getMessageNoID("GUI0154T", args);
                }
                JOptionPane.showMessageDialog(pGuiMain, s, MessageLog.getMessageNoID("GUI0153T"), 2);
            }
        }

        public void setEnabledForced() {
            super.setEnabled(true);
        }
    }

    public class myJMenuItem
    extends JMenuItem {
        public void setEnabled(boolean state) {
            super.setEnabled(state && GuiMain.this.isProperAdmin());
        }

        public void setEnabledForced() {
            super.setEnabled(true);
        }
    }
}

