/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.io.Serializable;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.accessibility.AccessibleContext;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.FilterResultsViewer;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.HelpBrokerTS;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public final class GuiUtil {
    public static final int TYPICAL_FIELD_HEIGHT = 20;
    public static final int TYPICAL_CONDITION_COMBO_WIDTH = 425;
    public static final int TYPICAL_VALUE_UNITS_FIELD_WIDTH = 190;
    private static final DecimalFormat dFmt = new DecimalFormat();
    private static final DecimalFormat ddFmt = new DecimalFormat("00");
    private static final DecimalFormat dddFmt = new DecimalFormat("000");
    private static final DecimalFormat d0Fmt = new DecimalFormat("###0");
    private static final DecimalFormat d2Fmt = new DecimalFormat("###0.00");
    private static GridBagConstraints gbcNorthWest = new GridBagConstraints();
    private static GridBagConstraints gbcSouthWest = new GridBagConstraints();
    private static GridBagConstraints gbcWest = new GridBagConstraints();
    private static GridBagConstraints gbcLast = new GridBagConstraints();
    private static final int TOP_MARGIN = 4;
    private static final int BOTTOM_MARGIN = 6;
    private static final int LEFT_MARGIN = 10;
    private static final int RIGHT_MARGIN = 10;
    private static final Border aperiBorder = BorderFactory.createLineBorder(Color.darkGray);
    private static final String ERR_GET_COMP = MessageLog.getMessageNoID("GUI0016M");
    public static boolean sortOrderNotASCII = false;
    private static String userName;

    private GuiUtil() {
    }

    public static String formatElapsed(long milliseconds, boolean wantMillis) {
        if (milliseconds < 0L) {
            return Util.getString("NA");
        }
        long millis = milliseconds % 1000L;
        long left = milliseconds / 1000L;
        long secs = left % 60L;
        long mins = (left /= 60L) % 60L;
        long hours = left / 60L;
        return new String(hours + ":" + ddFmt.format(mins) + ":" + ddFmt.format(secs) + (wantMillis ? "." + dddFmt.format(millis) : " "));
    }

    public static String formatElapsed(int minutes) {
        if (minutes < 0) {
            return Util.getString("NA");
        }
        long mins = minutes % 60;
        long left = minutes / 60;
        long hours = left % 24L;
        long days = left / 24L;
        StringBuffer sb = new StringBuffer(50);
        if (days > 0L) {
            sb = sb.append(days);
            sb = sb.append(" ");
            sb = sb.append(MessageLog.getMessageNoID("GUI0116L"));
            sb = sb.append("   ");
        }
        if (hours > 0L) {
            sb = sb.append(hours);
            sb = sb.append(" ");
            sb = sb.append(MessageLog.getMessageNoID("GUI0117L"));
            sb = sb.append("   ");
        }
        sb = sb.append(mins);
        sb = sb.append(" ");
        sb = sb.append(MessageLog.getMessageNoID("GUI0118L"));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char getMnemonic(String key) {
        String mnemonicChar = null;
        try {
            mnemonicChar = Util.getString(key);
            if (mnemonicChar.equals("")) {
                mnemonicChar = "0";
                return (char)mnemonicChar;
            }
        }
        catch (Exception e) {
            System.out.println("GuiUtil::getMnemonic() -- " + key + " not found in resource bundle.");
            mnemonicChar = "0";
            return (char)mnemonicChar;
        }
        finally {
            return mnemonicChar.trim().toUpperCase().charAt(0);
        }
    }

    public static String cleanString(String bigString) {
        StringBuffer newString = new StringBuffer();
        StringTokenizer st = new StringTokenizer(bigString, "\f\r\t");
        if (st.hasMoreTokens()) {
            while (st.hasMoreTokens()) {
                newString.append(st.nextToken());
            }
            return newString.toString();
        }
        return bigString;
    }

    public static void setAccessible(Component component, String name, String description) {
        AccessibleContext ac = null;
        try {
            ac = component.getAccessibleContext();
            ac.setAccessibleName(GuiUtil.resolveString(name));
            ac.setAccessibleDescription(GuiUtil.resolveString(description));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void setAccessibleDescription(Component component, String description) {
        AccessibleContext ac = null;
        try {
            ac = component.getAccessibleContext();
            ac.setAccessibleDescription(GuiUtil.resolveString(description));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setAccessibleLabel(JLabel label, Component component, String mnemonic, String name, String description) {
        label.setLabelFor(component);
        GuiUtil.setAccessible(component, name, description);
    }

    private static String resolveString(String string) {
        return Util.getString(string);
    }

    public static boolean wrapAtWords() {
        boolean wrap = true;
        Locale locale = Locale.getDefault();
        if (locale.getLanguage().equals(new Locale("ja", "", "").getLanguage()) || locale.getLanguage().equals(new Locale("ko", "", "").getLanguage()) || locale.getLanguage().equals(new Locale("zh", "", "").getLanguage())) {
            wrap = false;
        }
        return wrap;
    }

    public static ImageIcon createImageIcon(String imageString) {
        ImageIcon ii = null;
        URL url = GuiUtil.class.getResource(imageString);
        if (url == null) {
            url = GuiUtil.class.getResource("images/" + imageString);
        }
        try {
            if (url != null) {
                ii = new ImageIcon(url);
            }
        }
        catch (Exception e) {
            ii = new ImageIcon(GuiUtil.class.getResource("images/exclam.gif"));
            System.out.println("GuiUtil.createImageIcon() couldn't locate image " + imageString + ".");
        }
        return ii;
    }

    public static ImageIcon createImageIcon(String imageString, String description) {
        ImageIcon ii = null;
        URL url = GuiUtil.class.getResource(imageString);
        if (url == null) {
            url = GuiUtil.class.getResource("images/" + imageString);
        }
        try {
            if (url != null) {
                ii = new ImageIcon(url, description);
            }
        }
        catch (Exception e) {
            ii = new ImageIcon(GuiUtil.class.getResource("images/exclam.gif"));
            System.out.println("GuiUtil.createImageIcon() couldn't locate image " + imageString + ".");
        }
        return ii;
    }

    public static String formatDateTime(Date date) {
        return Util.formatDateTime(date);
    }

    public static String formatNumber(long number) {
        return NumberFormat.getInstance().format(number);
    }

    public static String formatNumber(double number) {
        return NumberFormat.getInstance().format(number);
    }

    public static boolean getConfirmation(Component parent, String title, String text, boolean getMessageText) {
        int response;
        if (getMessageText) {
            title = MessageLog.getMessageNoID(title);
            text = MessageLog.getMessageNoID(text);
        }
        return (response = JOptionPane.showConfirmDialog(parent, text, title, 0)) == 0;
    }

    public static String displayOkCancelPane(String title, String prompt, int length, boolean numeric, String initialText, Frame frame) {
        int textLength = prompt.length() - 3;
        if (textLength > 20) {
            textLength = 21;
        }
        if (length < textLength) {
            textLength = length;
        }
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(prompt);
        TTextField result = TTextField.newTTextField("x", textLength, length, numeric, true);
        panel.add((Component)label, "North");
        panel.add((Component)result, "South");
        JOptionPane pane = new JOptionPane(panel, 3, 2);
        JDialog dialog = pane.createDialog(frame, title);
        result.setText(initialText);
        dialog.show();
        Integer response = (Integer)pane.getValue();
        String whatWasEntered = response != null && response == 0 ? result.getText() : null;
        return whatWasEntered;
    }

    public static String formatFilesystem(String computerName, String mountPoint) {
        StringBuffer buf = new StringBuffer(80);
        buf.append(computerName);
        buf.append(" : ");
        buf.append(mountPoint);
        return buf.toString();
    }

    public static void centerDialog(Component dialog) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - dialog.getWidth()) / 2;
        int y = (screenSize.height - dialog.getHeight()) / 2;
        dialog.setLocation(x, y);
    }

    public static Border getBorder(String title) {
        TitledBorder border = BorderFactory.createTitledBorder(aperiBorder, title);
        Font boldFont = border.getTitleFont().deriveFont(1);
        border.setTitleFont(boldFont);
        return border;
    }

    public static Border getBorder() {
        return aperiBorder;
    }

    public static JPanel getPanel() {
        JPanel panel = new JPanel();
        GuiUtil.initPanel(panel);
        return panel;
    }

    public static void initPanel(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        panel.add(Box.createVerticalStrut(4), gbcNorthWest);
        panel.add(Box.createHorizontalStrut(10), gbcWest);
    }

    public static JPanel getBorderedPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(GuiUtil.getBorder());
        GuiUtil.initPanel(panel);
        return panel;
    }

    public static JPanel getTitledBorderedPanel(String title) {
        JPanel panel = new JPanel();
        panel.setBorder(GuiUtil.getBorder(title));
        GuiUtil.initPanel(panel);
        return panel;
    }

    public static void completePanel(JPanel panel) {
        panel.add(Box.createVerticalStrut(6), gbcSouthWest);
        panel.add(Box.createHorizontalStrut(10), gbcLast);
    }

    public static NameList sortNameList(NameList head) {
        if (!sortOrderNotASCII) {
            return head;
        }
        TreeMap<String, NameList> sorter = new TreeMap<String, NameList>();
        while (head != null) {
            sorter.put(head.toString(), head);
            head = head.nlNext;
        }
        NameList prev = null;
        for (NameList element : sorter.values()) {
            element.nlNext = null;
            if (prev != null) {
                prev.nlNext = element;
            } else {
                head = element;
            }
            prev = element;
        }
        return head;
    }

    public static boolean isAnyDiskArrayInstalled() {
        return true;
    }

    public static void setAllEnabled(Component component, boolean enabled) {
        if (!(component instanceof JLabel)) {
            component.setEnabled(enabled);
            if (component instanceof Container) {
                Container container = (Container)component;
                int i = container.getComponentCount();
                while (i > 0) {
                    GuiUtil.setAllEnabled(container.getComponent(--i), enabled);
                }
            }
        }
    }

    public static HelpBrokerTS getHelpBroker() {
        String helpSetName = "org/eclipse/aperi/gui/help/OS/storagealert.hs";
        ClassLoader cl = FilterResultsViewer.class.getClassLoader();
        URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)helpSetName);
        HelpSet hs = null;
        try {
            hs = new HelpSet(cl, url);
        }
        catch (Exception ee) {
            System.out.println("Help Set " + helpSetName + " not found");
            ee.printStackTrace();
        }
        return new HelpBrokerTS(hs);
    }

    public static Request newGUIRequest(String subType) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.subType = subType;
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.userName = GuiUtil.getUserName();
        request.flags = (byte)4;
        return request;
    }

    public static Request newGUIDeviceRequest(String subType) {
        DeviceRequest request = new DeviceRequest("org.eclipse.aperi.server.svp.GuiSvp", subType, DeviceRequest.DR_DISK);
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.userName = GuiUtil.getUserName();
        request.flags = (byte)4;
        return request;
    }

    public static Request newGUIDeviceRequest(String subType, short mgrType, Serializable requestData) {
        DeviceRequest request = new DeviceRequest("org.eclipse.aperi.server.svp.GuiSvp", subType, mgrType, requestData);
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.userName = GuiUtil.getUserName();
        request.flags = (byte)4;
        return request;
    }

    public static boolean isIPFormatValid(String ip) {
        return true;
    }

    public static String getString(String key) {
        return Util.getString(key);
    }

    public static String getUserName() {
        if (userName == null) {
            userName = System.getProperty("user.name", " ");
        }
        return userName;
    }

    public static boolean confirmDelete(Component parent, String object) {
        String title;
        if (object == null) {
            title = MessageLog.getMessageNoID("GUI0045L");
        } else {
            Object[] args = new Object[]{object};
            title = MessageLog.getMessageNoID("GUI0048L", args);
        }
        String question = null;
        question = object == null ? MessageLog.getMessageNoID("GUI0100M", null) : Util.getString("CONFIRM_DELETE", object);
        JOptionPane pane = new JOptionPane();
        JDialog dialog = pane.createDialog(parent, title);
        int response = JOptionPane.showConfirmDialog(dialog, question, title, 0);
        return response == 0;
    }

    public static boolean confirmDelete(Component parent) {
        return GuiUtil.confirmDelete(parent, null);
    }

    public static GComputer getComputer(int computerID) {
        GComputer computer;
        Integer iComputerID = new Integer(computerID);
        Hashtable<Integer, GComputer> computerTable = null;
        if (computerTable == null) {
            computerTable = new Hashtable<Integer, GComputer>();
            computer = GuiClient.getComputer(-2);
            while (computer != null) {
                computerTable.put(new Integer(computer.gcComputerID), computer);
                computer = computer.gcNext;
            }
        }
        if ((computer = (GComputer)computerTable.get(iComputerID)) == null) {
            computer = GuiClient.getComputer(computerID);
            if (computer != null) {
                if (computer.gcManufacturer.toLowerCase().equals("unknown")) {
                    computer.gcManufacturer = MessageLog.getMessageNoID("GUI0129T");
                }
                computerTable.put(iComputerID, computer);
            } else {
                computer = new GComputer();
                computer.gcComputerID = computerID;
                computer.gcTSName = ERR_GET_COMP;
                computerTable.put(iComputerID, computer);
            }
        }
        return computer;
    }

    public static void displayException(GeneralException e) {
        GuiUtil.displayErrorMessage(e.getMessage());
    }

    public static void displayErrorMessage(String msg) {
        Object ta;
        String msgID = msg.substring(0, 8);
        String text = msg.substring(10);
        if (text.length() > 100) {
            ta = new TextArea(text, 1, 100);
            ((TextArea)ta).setEditable(false);
        } else {
            ta = text;
        }
        JOptionPane.showMessageDialog(null, ta, msgID, 0);
    }

    static {
        GuiUtil.gbcNorthWest.gridwidth = 0;
        GuiUtil.gbcWest.gridx = 0;
        GuiUtil.gbcWest.gridy = 1;
        GuiUtil.gbcWest.gridheight = -1;
        GuiUtil.gbcSouthWest.gridx = 0;
        GuiUtil.gbcSouthWest.gridwidth = 8;
        GuiUtil.gbcSouthWest.gridheight = 0;
        GuiUtil.gbcSouthWest.weighty = 1.0;
        GuiUtil.gbcLast.gridwidth = 0;
        GuiUtil.gbcLast.weightx = 1.0;
    }
}

