/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.ListElementEditor;

public class IPScanElementEditor
extends JPanel
implements ListElementEditor {
    private JTextField one;
    private JTextField two;
    private JTextField three;
    private JTextField four;
    private JLabel dot1 = new JLabel(".");
    private JLabel dot2 = new JLabel(".");
    private JLabel dot3 = new JLabel(".");

    public IPScanElementEditor() {
        this.one = new JTextField(4);
        this.two = new JTextField(4);
        this.three = new JTextField(4);
        this.four = new JTextField(4);
        this.four.setText("0");
        this.four.setEditable(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 0, 4);
        GridBagConstraints dotConstraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        constraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.one, constraints);
        this.add((Component)this.dot1, constraints);
        this.add((Component)this.two, constraints);
        this.add((Component)this.dot2, constraints);
        this.add((Component)this.three, constraints);
        this.add((Component)this.dot3, constraints);
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.four, constraints);
    }

    public Object getObject() {
        String ip = null;
        String dotStr = this.dot1.getText();
        String oneStr = this.one.getText();
        String twoStr = this.two.getText();
        String threeStr = this.three.getText();
        String fourStr = this.four.getText();
        ip = oneStr + dotStr + twoStr + dotStr + threeStr + dotStr + fourStr;
        return new String(ip);
    }

    public void setObject(Object listElement) {
        String ipStr = (String)listElement;
        String oneStr = "";
        String twoStr = "";
        String threeStr = "";
        if (!Util.isEmpty(ipStr)) {
            int firstSeparator = ipStr.indexOf(46);
            if (firstSeparator != -1) {
                oneStr = ipStr.substring(0, firstSeparator);
                int secondSeparator = ipStr.indexOf(46, firstSeparator + 1);
                if (secondSeparator != -1) {
                    twoStr = ipStr.substring(firstSeparator + 1, secondSeparator);
                    int thirdSeparator = ipStr.indexOf(46, secondSeparator + 1);
                    if (thirdSeparator != -1) {
                        threeStr = ipStr.substring(secondSeparator + 1, thirdSeparator);
                    }
                }
            }
            this.one.setText(oneStr);
            this.two.setText(twoStr);
            this.three.setText(threeStr);
            this.four.setText("0");
        }
    }

    public void objectRemoved(Object listElement) {
        String oneStr = this.one.getText();
    }

    public Component getComponent() {
        return this;
    }

    public void setEnabled(boolean state) {
        this.one.setEnabled(true);
        this.two.setEnabled(true);
        this.three.setEnabled(true);
        this.four.setEnabled(true);
    }

    public Document getIpDocumentOne() {
        return this.one.getDocument();
    }

    public Document getIpDocumentTwo() {
        return this.two.getDocument();
    }

    public Document getIpDocumentThree() {
        return this.three.getDocument();
    }

    public boolean allIpFieldsFull() {
        return !Util.isEmpty(this.one.getText()) && !Util.isEmpty(this.two.getText()) && !Util.isEmpty(this.three.getText());
    }

    public boolean allIpFieldsEmpty() {
        return Util.isEmpty(this.one.getText()) && Util.isEmpty(this.two.getText()) && Util.isEmpty(this.three.getText());
    }

    public void emptyAllIpFields() {
        this.one.setText("");
        this.two.setText("");
        this.three.setText("");
    }
}

