/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.aperi.TStorm.common.PrintHtmlTable;
import org.eclipse.aperi.TStorm.common.PrintTable;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.WriteReports;
import org.eclipse.aperi.TStorm.gui.SavedReportDDI;
import org.eclipse.aperi.common.PrintOptions;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.PrintFileChooser;
import org.eclipse.aperi.gui.PrintManager;
import org.eclipse.aperi.gui.PrintOutputChooser;
import org.eclipse.aperi.gui.PrintPreviewPanel;
import org.eclipse.aperi.gui.tables.MegaTable;

public class PrintTableData {
    public static void print(DataDisplayInfo ddi, Container thing, String creator, String title, String fileMask) {
        Component[] stuff = thing.getComponents();
        if (stuff != null) {
            for (int i = 0; i < stuff.length; ++i) {
                if (!(stuff[i] instanceof MegaTable)) continue;
                MegaTable table = (MegaTable)stuff[i];
                PrintTableData.printTable(ddi, table, creator, title, fileMask);
                break;
            }
        }
    }

    public static void printTable(DataDisplayInfo ddi, MegaTable table, String creator, String title, String fileMask) {
        PrintOptions options;
        PrintOutputChooser chooser = new PrintOutputChooser();
        boolean pdfAllowed = true;
        if (ddi instanceof SavedReportDDI) {
            pdfAllowed = ((SavedReportDDI)ddi).getPdfAllowed();
        }
        if ((options = chooser.getOptions(true, pdfAllowed)) != null) {
            options.creator = creator;
            options.title = title;
            options.fileMask = fileMask;
            if (options.outputType == 2 || options.outputType == 3 || options.outputType == 4 || options.outputType == 7 || options.outputType == 8 || options.outputType == 5) {
                options.fileName = PrintTableData.getFileName(options);
                if (options.fileName == null) {
                    return;
                }
            }
            if (options.outputType == 3 || options.outputType == 7 || options.outputType == 8) {
                options.outFile = null;
                OutputStreamWriter osw = null;
                PrintWriter writer = null;
                try {
                    options.outFile = new FileOutputStream(options.fileName);
                }
                catch (IOException e) {
                    GuiUtil.displayErrorMessage(e.getMessage());
                    options.outFile = null;
                }
                try {
                    if (options.outFile != null) {
                        osw = options.outputType == 3 || System.getProperty("os.name", " ").regionMatches(true, 0, "win", 0, 3) ? new OutputStreamWriter((OutputStream)options.outFile, "UTF-8") : new OutputStreamWriter(options.outFile);
                    }
                }
                catch (Exception e1) {
                    GuiUtil.displayErrorMessage(e1.getMessage());
                }
                if (options.outFile != null) {
                    writer = new PrintWriter((Writer)osw, true);
                }
                if (writer != null) {
                    BaseTableModel model = (BaseTableModel)table.getDataSource();
                    ReportDataAdjuster adjuster = model.getAdjuster();
                    int[] columnArray = null;
                    columnArray = adjuster.fixColumnArray(columnArray);
                    int[] rowMap = table.getViewToModelIndices();
                    if (options.outputType == 3) {
                        new PrintHtmlTable().printHtml(adjuster, writer, columnArray, GuiUtil.getUserName(), title, rowMap);
                    } else if (options.outputType == 7) {
                        new WriteReports().writeCSV(adjuster, writer, columnArray, options.includeHeaders, options.includeTotals, rowMap);
                    } else if (options.outputType == 8) {
                        new WriteReports().writeFormatted(adjuster, writer, columnArray, rowMap);
                    }
                    writer.close();
                }
            } else if (options.outputType == 1) {
                new PrintPreviewPanel(ddi, title, false);
            } else {
                PrintManager.getPrinter(options);
                if (options.printer != null) {
                    BaseTableModel model = (BaseTableModel)table.getDataSource();
                    ReportDataAdjuster adjuster = model.getAdjuster();
                    int[] columnArray = null;
                    columnArray = adjuster.fixColumnArray(columnArray);
                    int[] rowMap = table.getViewToModelIndices();
                    new PrintTable().print(adjuster, options, columnArray, rowMap);
                    PrintManager.printDocument(options);
                }
            }
        }
    }

    public static String getFileName(PrintOptions options) {
        String name = options.fileMask;
        String suffix = options.outputType == 2 ? ".pdf" : (options.outputType == 3 ? ".html" : (options.outputType == 4 ? ".ps" : (options.outputType == 7 ? ".csv" : (options.outputType == 8 ? ".txt" : ".pcl"))));
        if (name == null) {
            name = "report" + suffix;
        } else {
            name = name + suffix;
            name = WriteReports.adjustFileName(name);
        }
        String path = System.getProperty("user.dir", " ") + File.separatorChar;
        String fileName = new PrintFileChooser().getName(path, name);
        return fileName;
    }
}

