/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.UilTimeFieldBean;

public class TimeSelector
extends JPanel {
    private Calendar calendar = Calendar.getInstance();
    private UilTimeFieldBean timeField = new UilTimeFieldBean();

    public TimeSelector() {
        this.initFromCalendar(this.calendar);
        this.buildPanel();
    }

    public TimeSelector(short hour, short minute) {
        this.initFromShorts(hour, minute);
        this.buildPanel();
    }

    private void initFromCalendar(Calendar cal) {
        this.timeField.setTime(cal.getTime());
    }

    private void initFromShorts(short hour, short minute) {
        this.calendar.set(11, hour);
        this.calendar.set(12, minute);
    }

    public void setTime(short hour, short minute) {
        this.initFromShorts(hour, minute);
        this.setTime();
    }

    public void setTime(long milliseconds) {
        this.calendar.setTime(new Date(milliseconds));
        this.initFromCalendar(this.calendar);
        this.setTime();
    }

    public short[] getTime() {
        this.getSelection();
        short[] time = new short[]{(short)this.calendar.get(11), (short)this.calendar.get(12)};
        return time;
    }

    public long getLongTime() {
        this.getSelection();
        return this.calendar.getTime().getTime();
    }

    public void setEnabled(boolean state) {
        this.timeField.setEnabled(state);
    }

    private void buildPanel() {
        this.timeField.setDateFormat(DateFormat.getTimeInstance(3));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        this.add((Component)this.timeField, gbc);
    }

    private void setTime() {
        this.timeField.setTime(this.calendar.getTime());
    }

    private void getSelection() {
        this.calendar.setTime(this.timeField.getTime());
    }
}

