/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UilDateFieldBean
extends JPanel
implements ActionListener {
    private int yearsComponent_;
    private int monthsComponent_;
    private int dayComponent_;
    private JComboBox monthComboBox_;
    private JComboBox dayComboBox_ = new JComboBox();
    private JComboBox yearComboBox_ = new JComboBox();
    private JLabel commaLabel_;
    private DateFormat format_;
    private Calendar calendar;
    private int minYear_ = 1990;
    private int maxYear_ = 2050;
    private static String[] Months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    public UilDateFieldBean() {
        this(Calendar.getInstance());
    }

    public UilDateFieldBean(Calendar date) {
        this.monthComboBox_ = new JComboBox();
        this.calendar = date;
        this.commaLabel_ = new JLabel(",");
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.monthComboBox_);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.dayComboBox_);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.commaLabel_);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.yearComboBox_);
        DefaultComboBoxModel<String> mmodel = new DefaultComboBoxModel<String>();
        for (int i = 0; i < 12; ++i) {
            mmodel.addElement(Months[i]);
        }
        this.monthComboBox_.setModel(mmodel);
        this.monthComboBox_.setSelectedIndex(0);
        this.monthComboBox_.addActionListener(this);
        DefaultComboBoxModel<String> ymodel = new DefaultComboBoxModel<String>();
        for (int i = this.minYear_; i <= this.maxYear_; ++i) {
            ymodel.addElement(String.valueOf(i));
        }
        this.yearComboBox_.setModel(ymodel);
        this.yearComboBox_.setSelectedIndex(0);
        DefaultComboBoxModel<String> dmodel = new DefaultComboBoxModel<String>();
        for (int i = 1; i <= 31; ++i) {
            dmodel.addElement(String.valueOf(i));
        }
        this.dayComboBox_.setModel(dmodel);
        this.dayComboBox_.setSelectedIndex(0);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.monthComboBox_ || source == this.yearComboBox_) {
            DefaultComboBoxModel<String> dmodel = new DefaultComboBoxModel<String>();
            for (int i = 1; i <= 28; ++i) {
                dmodel.addElement(String.valueOf(i));
            }
            switch (this.monthComboBox_.getSelectedIndex()) {
                case 1: {
                    int yr = Integer.parseInt((String)this.yearComboBox_.getSelectedItem());
                    if (yr / 4 * 4 != yr) break;
                    dmodel.addElement(String.valueOf(29));
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: {
                    dmodel.addElement(String.valueOf(29));
                    dmodel.addElement(String.valueOf(30));
                    break;
                }
                case 0: 
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 11: {
                    dmodel.addElement(String.valueOf(29));
                    dmodel.addElement(String.valueOf(30));
                    dmodel.addElement(String.valueOf(31));
                }
            }
            this.dayComboBox_.setModel(dmodel);
            this.dayComboBox_.setSelectedIndex(0);
        }
    }

    public void setDateFormat(DateFormat format) {
        this.format_ = format;
    }

    public void setTime(Date theTime) {
        this.calendar.setTime(theTime);
        this.yearsComponent_ = this.calendar.get(1);
        this.monthsComponent_ = this.calendar.get(2);
        this.dayComponent_ = this.calendar.get(5);
        this.yearComboBox_.setSelectedItem(String.valueOf(this.yearsComponent_));
        this.monthComboBox_.setSelectedItem(Months[this.monthsComponent_]);
        this.dayComboBox_.setSelectedItem(String.valueOf(this.dayComponent_));
    }

    public void setEnabled(boolean enable) {
        this.yearComboBox_.setEnabled(enable);
        this.monthComboBox_.setEnabled(enable);
        this.dayComboBox_.setEnabled(enable);
    }

    public void setYearRange(int minYear, int maxYear) {
        this.minYear_ = minYear;
        this.maxYear_ = maxYear;
        DefaultComboBoxModel<String> ymodel = new DefaultComboBoxModel<String>();
        for (int i = this.minYear_; i <= this.maxYear_; ++i) {
            ymodel.addElement(String.valueOf(i));
        }
        this.yearComboBox_.setModel(ymodel);
    }

    public Date getTime() {
        return this.calendar.getTime();
    }
}

