/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Dimension;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class UilTimeFieldBean
extends JPanel {
    private int hoursComponent_;
    private int minutesComponent_;
    private int secondsComponent_;
    private long millisecondsComponent_;
    private JComboBox amPmComboBox_;
    private JTextField hourField_;
    private JTextField minField_;
    private JTextField secField_;
    private JLabel colonLabel_;
    private DateFormat format_;
    private Calendar calendar;
    private String[] ampm = new String[]{"AM", "PM"};

    public UilTimeFieldBean() {
        this(Calendar.getInstance());
    }

    public UilTimeFieldBean(Calendar date) {
        PlainDocument pd1 = new PlainDocument(){

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str != null && str.length() + this.getLength() <= 2) {
                    try {
                        Integer.parseInt(str);
                    }
                    catch (NumberFormatException nn) {
                        return;
                    }
                    super.insertString(offs, str, a);
                }
            }
        };
        PlainDocument pd2 = new PlainDocument(){

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str != null && str.length() + this.getLength() <= 2) {
                    try {
                        Integer.parseInt(str);
                    }
                    catch (NumberFormatException nn) {
                        return;
                    }
                    super.insertString(offs, str, a);
                }
            }
        };
        this.hourField_ = new JTextField(pd1, "", 2);
        int width = 5 * this.hourField_.getFontMetrics(this.getFont()).charWidth(0) + 10;
        int height = this.hourField_.getFontMetrics(this.getFont()).getHeight() + 8;
        this.hourField_.setMinimumSize(new Dimension(width, height));
        this.hourField_.setPreferredSize(new Dimension(width, height));
        this.hourField_.setMaximumSize(new Dimension(width, height));
        this.minField_ = new JTextField(pd2, "", 2);
        this.minField_.setMinimumSize(new Dimension(width, height));
        this.minField_.setPreferredSize(new Dimension(width, height));
        this.minField_.setMaximumSize(new Dimension(width, height));
        this.amPmComboBox_ = new JComboBox<String>(this.ampm);
        this.colonLabel_ = new JLabel(":");
        this.calendar = date;
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.hourField_);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.minField_);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.colonLabel_);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.amPmComboBox_);
        this.hourField_.setText(String.valueOf(this.calendar.get(11)));
        this.minField_.setText(String.valueOf(this.calendar.get(12)));
        if (this.calendar.get(9) == 0) {
            this.amPmComboBox_.setSelectedIndex(0);
        } else {
            this.amPmComboBox_.setSelectedIndex(1);
        }
    }

    public void setDateFormat(DateFormat format) {
        this.format_ = format;
    }

    public void setTime(Date theTime) {
        this.calendar.setTime(theTime);
        this.hoursComponent_ = this.calendar.get(10);
        this.minutesComponent_ = this.calendar.get(12);
        this.hourField_.setText(String.valueOf(this.hoursComponent_));
        this.minField_.setText(String.valueOf(this.minutesComponent_));
        if (this.hoursComponent_ > 12) {
            this.amPmComboBox_.setSelectedIndex(0);
        } else {
            this.amPmComboBox_.setSelectedIndex(1);
        }
    }

    public void setEnabled(boolean enable) {
        this.hourField_.setEnabled(enable);
        this.minField_.setEnabled(enable);
        this.amPmComboBox_.setEnabled(enable);
    }

    public Date getTime() {
        return this.calendar.getTime();
    }
}

