/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.aperi.gui.BaseWizard;
import org.eclipse.aperi.gui.WizardEvent;
import org.eclipse.aperi.gui.WizardListener;
import org.eclipse.aperi.gui.WizardPage;

public class Wizard
extends BaseWizard {
    protected transient ContainerListener containerListener = new CardsListener();
    protected WizardPage currentPage;
    private Hashtable pages = new Hashtable();
    private Stack previous = new Stack();

    public Wizard() {
        this.addContainerListener(this.containerListener);
    }

    public WizardPage add(WizardPage page) {
        this.add((Component)page.getContentPane(), page.getName());
        return page;
    }

    public void show(String name) {
        this.cardLayout.show(this, name);
    }

    public void first() {
        this.cardLayout.first(this);
    }

    public void last() {
        this.cardLayout.last(this);
    }

    public void finish() {
        this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        WizardEvent wevt = new WizardEvent(null, this.currentPage, null, true, true);
        Vector l = new Vector();
        Wizard wizard = this;
        synchronized (wizard) {
            l = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < l.size(); ++i) {
            WizardListener wl = (WizardListener)l.elementAt(i);
            wl.canceled(wevt);
        }
    }

    protected Component getCurrentPage() {
        return this.currentPage;
    }

    private boolean next(WizardEvent wevt) {
        WizardPage newPage = (WizardPage)wevt.getNewPage();
        this.cardLayout.show(this, newPage.getName());
        return true;
    }

    private boolean previous(WizardEvent wevt) {
        WizardPage newPage = (WizardPage)wevt.getNewPage();
        this.cardLayout.show(this, newPage.getName());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNextWizardEvent(ActionEvent evt) {
        WizardPage newPage;
        boolean bLast = false;
        if (this.currentPage.next() == null) {
            newPage = null;
            bLast = true;
        } else {
            bLast = false;
            newPage = (WizardPage)this.pages.get(this.currentPage.next());
        }
        WizardEvent wevt = new WizardEvent(evt.getSource(), this.currentPage, newPage, bLast, true);
        Vector l = new Vector();
        Wizard wizard = this;
        synchronized (wizard) {
            l = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < l.size(); ++i) {
            WizardListener wl = (WizardListener)l.elementAt(i);
            wl.nextBegin(wevt);
            if (!wevt.getAllowChange()) continue;
            WizardEvent wevt2 = new WizardEvent(evt.getSource(), this.currentPage, wevt.getNewPage(), bLast, true);
            this.previous.push(this.currentPage);
            this.currentPage = (WizardPage)wevt2.getNewPage();
            this.next(wevt2);
            wl.nextComplete(wevt2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePreviousWizardEvent(ActionEvent evt) {
        WizardPage newPage = (WizardPage)this.previous.pop();
        WizardEvent wevt = new WizardEvent(evt.getSource(), this.currentPage, newPage, false, true);
        Vector l = new Vector();
        Wizard wizard = this;
        synchronized (wizard) {
            l = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < l.size(); ++i) {
            WizardListener wl = (WizardListener)l.elementAt(i);
            wl.previousBegin(wevt);
            WizardEvent wevt2 = new WizardEvent(evt.getSource(), this.currentPage, wevt.getNewPage(), false, true);
            this.previous(wevt2);
            wl.previousComplete(wevt2);
            this.currentPage = newPage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFinishWizardEvent(ActionEvent evt, WizardPage currentPage) {
        WizardEvent wevt = new WizardEvent(evt.getSource(), currentPage, null, true, true);
        Vector l = new Vector();
        Wizard wizard = this;
        synchronized (wizard) {
            l = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < l.size(); ++i) {
            WizardListener wl = (WizardListener)l.elementAt(i);
            wl.finished(wevt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHelpWizardEvent(ActionEvent evt, WizardPage currentPage) {
        WizardEvent wevt = new WizardEvent(evt.getSource(), currentPage, null, false, true);
        Vector l = new Vector();
        Wizard wizard = this;
        synchronized (wizard) {
            l = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < l.size(); ++i) {
            WizardListener wl = (WizardListener)l.elementAt(i);
            wl.help(wevt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCancelWizardEvent(ActionEvent evt, WizardPage currentPage) {
        WizardEvent wevt = new WizardEvent(evt.getSource(), currentPage, null, true, true);
        Vector l = new Vector();
        Wizard wizard = this;
        synchronized (wizard) {
            l = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < l.size(); ++i) {
            WizardListener wl = (WizardListener)l.elementAt(i);
            wl.canceled(wevt);
        }
    }

    class CardsListener
    implements ContainerListener {
        CardsListener() {
        }

        public void componentAdded(ContainerEvent e) {
            WizardPage page = (WizardPage)e.getChild();
            if (Wizard.this.pages.isEmpty()) {
                Wizard.this.currentPage = page;
            }
            Wizard.this.pages.put(page.getName(), page);
            page.getPreviousButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Wizard.this.firePreviousWizardEvent(evt);
                }
            });
            page.getNextButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Wizard.this.fireNextWizardEvent(evt);
                }
            });
            page.getFinishButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Wizard.this.fireFinishWizardEvent(evt, Wizard.this.currentPage);
                }
            });
            page.getHelpButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Wizard.this.fireHelpWizardEvent(evt, Wizard.this.currentPage);
                }
            });
            page.getCancelButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Wizard.this.fireCancelWizardEvent(evt, Wizard.this.currentPage);
                }
            });
        }

        public void componentRemoved(ContainerEvent e) {
        }
    }
}

