/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;

public abstract class WizardPage
extends JPanel {
    public static final int ALL = 31;
    public static final int CANCEL = 8;
    public static final int FINISH = 4;
    public static final int HELP = 16;
    public static final int NEXT = 2;
    public static final int NO_BUTTONS = 0;
    public static final int PREVIOUS = 1;
    protected static final int SPACING = 5;
    protected JButton backButton;
    protected JButton nextButton;
    protected JButton finishButton;
    protected JButton helpButton;
    protected JButton cancelButton;
    protected JPanel buttonPanel = new JPanel();

    public WizardPage() {
        this(31);
    }

    public WizardPage(int flags) {
        this.createButtonBox(flags);
        this.setLayout(new BorderLayout());
        this.add((Component)this.buttonPanel, "South");
    }

    public Container getContentPane() {
        return this;
    }

    public abstract Object next();

    protected void createButtonBox(int button_flags) {
        this.buttonPanel = new JPanel();
        JSeparator separator = new JSeparator();
        Box buttonBox = new Box(0);
        this.backButton = new JButton(Util.getString("LABEL_PREVIOUS"));
        this.backButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_PREVIOUS"));
        GuiUtil.setAccessibleDescription(this.backButton, "DESC_PREVIOUS");
        this.nextButton = new JButton(Util.getString("LABEL_NEXT"));
        this.nextButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_NEXT"));
        GuiUtil.setAccessibleDescription(this.nextButton, "DESC_NEXT");
        this.finishButton = new JButton(Util.getString("LABEL_FINISH"));
        this.finishButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_FINISH"));
        GuiUtil.setAccessibleDescription(this.finishButton, "DESCRIPTION_FINISH");
        this.helpButton = new JButton(Util.getString("LABEL_HELP_MENU"));
        this.helpButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_HELP"));
        this.cancelButton = new JButton(Util.getString("LABEL_CANCEL"));
        this.cancelButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_CANCEL"));
        GuiUtil.setAccessibleDescription(this.cancelButton, "DESCRIPTION_CANCEL");
        buttonBox.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        if ((button_flags & 1) == 1) {
            buttonBox.add(this.backButton);
            buttonBox.add(Box.createHorizontalStrut(5));
        }
        if ((button_flags & 2) == 2) {
            buttonBox.add(this.nextButton);
            buttonBox.add(Box.createHorizontalStrut(5));
        }
        if ((button_flags & 4) == 4) {
            buttonBox.add(this.finishButton);
            buttonBox.add(Box.createHorizontalStrut(5));
        }
        if ((button_flags & 8) == 8) {
            buttonBox.add(this.cancelButton);
            buttonBox.add(Box.createHorizontalStrut(5));
        }
        if ((button_flags & 0x10) == 16) {
            buttonBox.add(this.helpButton);
            buttonBox.add(Box.createHorizontalStrut(5));
        }
        this.buttonPanel.setLayout(new BorderLayout());
        this.buttonPanel.add((Component)separator, "North");
        this.buttonPanel.add((Component)buttonBox, "East");
    }

    protected JButton getPreviousButton() {
        return this.backButton;
    }

    protected JButton getNextButton() {
        return this.nextButton;
    }

    protected JButton getFinishButton() {
        return this.finishButton;
    }

    protected JButton getHelpButton() {
        return this.helpButton;
    }

    protected JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setUpHelp(String helpIdString) {
        Help.setHelpID(this, helpIdString);
        this.registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
        this.getHelpButton().addActionListener(Help.getDisplayHelpFromSource());
        Help.setHelpID(this.getHelpButton(), helpIdString);
    }

    public boolean nextBegin() {
        return true;
    }

    public boolean nextComplete() {
        return true;
    }

    public boolean previousBegin() {
        return true;
    }

    public boolean previousComplete() {
        return true;
    }

    public boolean finished() {
        return true;
    }

    public boolean canceled() {
        return true;
    }

    public boolean help() {
        return true;
    }
}

