/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.TreeNode;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.admin.AgentDDI;
import org.eclipse.aperi.gui.admin.AgentTreeNode;
import org.eclipse.aperi.gui.admin.InbandFabricAgentTreeNode;
import org.eclipse.aperi.gui.admin.OutOfBandAgentDialog;
import org.eclipse.aperi.gui.admin.OutOfBandFabricAgentTreeNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class AgentTreeLabel
extends BaseTreeNode
implements GuiRequestor,
ActionListener {
    private int currAgent = -1;
    private int agentType = -1;
    JMenuItem addSNMPAgentMenu;

    public AgentTreeLabel(int iAgentType) {
        this.agentType = iAgentType;
        switch (this.agentType) {
            case 2: {
                this.setUserObject(Util.getString("DATA"));
                break;
            }
            case 6: {
                this.setUserObject(Util.getString("CIMOMS"));
                break;
            }
            case 7: {
                this.setUserObject(Util.getString("OUT_OF_BAND_FABRIC"));
                break;
            }
            case 8: {
                this.setUserObject(Util.getString("INBAND_FABRIC"));
                break;
            }
            default: {
                this.setUserObject("<unknown>");
            }
        }
    }

    public void expand(TreeExpansionEvent event) {
        if (this.getChildCount() == 0) {
            this.getAgents();
        }
    }

    public void showPopupMenu(MouseEvent event) {
        JPopupMenu popup = this.getPopupMenu();
        JMenuItem refresh = new JMenuItem(MessageLog.getMessageNoID("ADG0003L"));
        refresh.setToolTipText(MessageLog.getMessageNoID("ADG0004T"));
        refresh.addActionListener(this);
        popup.add(refresh);
        if (this.agentType == 6) {
            JMenuItem addCimomMenu = new JMenuItem(Util.getString("CIMOM_CFG_ADD"));
            addCimomMenu.setToolTipText(Util.getString("CIMOM_CFG_ADD_TIP"));
            addCimomMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JOptionPane.showMessageDialog(guiMain.getFrame(), Util.getString("CIMOM_CFG_ADD_TITLE"), Util.getString("CIMOM_CFG_ADD_TITLE"), 1);
                }
            });
            popup.add(addCimomMenu);
        }
        if (this.agentType == 7) {
            this.addSNMPAgentMenu = new JMenuItem(Util.getString("FabricAgent_add"));
            this.addSNMPAgentMenu.addActionListener(this);
            this.addSNMPAgentMenu.setEnabled(this.capabilities.isAperiAdmin());
            popup.add(this.addSNMPAgentMenu);
        }
        this.showPopupMenu(popup, event);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.addSNMPAgentMenu) {
            OutOfBandAgentDialog oobad = new OutOfBandAgentDialog(guiMain.getFrame(), true);
            oobad.setParentNode(this);
            oobad.show();
        } else {
            this.getAgents();
        }
    }

    public void refreshAgents() {
        if (this.getChildCount() > 0) {
            this.getAgents();
        }
    }

    private void getAgents() {
        Request request = new Request();
        ServerRequest.guiInfo(request, this.agentType, -2);
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        this.currAgent = -1;
        DataDisplayInfo currDDI = DataDisplayInfo.getCurrent();
        if (currDDI != null && currDDI instanceof AgentDDI) {
            this.currAgent = ((AgentTreeNode)currDDI.treeNode).computerID;
        }
        DataDisplayInfo ddi = DataDisplayInfo.getRoot();
        while (ddi != null) {
            DataDisplayInfo ddiNext = ddi.getNext();
            if (ddi instanceof AgentDDI) {
                ddi.remove();
            }
            ddi = ddiNext;
        }
        this.removeAllChildren();
        NameList agent = null;
        if (status <= 4) {
            agent = (NameList)response.responseData;
        }
        while (agent != null) {
            AgentTreeNode node = null;
            switch (this.agentType) {
                case 2: {
                    GComputer agentComputer = GuiUtil.getComputer(agent.nlID);
                    node = new AgentTreeNode(agentComputer.gcTSName, agent.nlID, agent.nlState);
                    break;
                }
                case 7: {
                    node = new OutOfBandFabricAgentTreeNode((Object)agent.nlName, agent.nlName2, agent.nlState);
                    break;
                }
                case 8: {
                    node = new InbandFabricAgentTreeNode(agent.nlName, agent.nlID, agent.nlState);
                }
            }
            this.addSorted(node);
            agent = agent.nlNext;
        }
        BaseTree.MyTree.nodeStructureChanged(this);
        if (this.currAgent > -1) {
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                AgentTreeNode child = (AgentTreeNode)e.nextElement();
                if (child.computerID != this.currAgent) continue;
                child.select(null);
                break;
            }
        }
    }
}

