/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.gui.admin.AgentDDI;
import org.eclipse.aperi.gui.admin.LogConfigDialog;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.UserPreferences;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class AgentTreeNode
extends BaseTreeNode
implements GuiRequestor,
ActionListener {
    protected int computerID;
    protected byte state;
    private String actionCommand;
    private LogConfigDialog lConfigDialog = null;
    public JPopupMenu popup;
    private static final String lLog = "ADG0017L";
    private static final String lTracing = "ADG0304L";
    private static final String lConfig = "ADG0255L";
    private static final String lShutdown = "ADG0006L";
    private static final String lNormal = "ADG0007L";
    private static final String lImmediate = "ADG0009L";
    private static final String lAbort = "ADG0011L";
    private static final String lUninstall = "ADG0262L";
    private static final String lCheck = "ADG0288L";
    private static final String lEnable = "ADG0289L";
    private static final String lDisable = "ADG0290L";

    public AgentTreeNode(Object name, int id, byte agentstate) {
        this.setUserObject(name);
        this.computerID = id;
        this.state = agentstate;
        this.setAllowsChildren(false);
    }

    public void render(DefaultTreeCellRenderer renderer, BaseTree tree, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        switch (this.state) {
            case 2: {
                renderer.setIcon(IconFactory.getStateDefectedIcon());
                break;
            }
            case 1: {
                renderer.setIcon(IconFactory.getStateUpIcon());
                break;
            }
            case 0: {
                renderer.setIcon(IconFactory.getStateDownIcon());
                break;
            }
            case 3: {
                renderer.setIcon(IconFactory.getStateUpgradingIcon());
                break;
            }
            case 4: {
                renderer.setIcon(IconFactory.getStateUreachableIcon());
                break;
            }
            case 5: {
                renderer.setIcon(IconFactory.getStateUpgradeNeededIcon());
            }
        }
    }

    public void select(TreeSelectionEvent event) {
        if (this.ddi == null) {
            AgentDDI addi = new AgentDDI();
            this.ddi = addi;
            this.ddi.treeNode = this;
            this.ddi.setDescription(MessageLog.getMessageNoID("ADG0201L") + ":  " + this.getUserObject());
            addi.runNumber = -1;
            addi.agentTab = 0;
        }
        this.ddi.reDisplay();
    }

    public JPopupMenu getPopupMenuForButtons() {
        this.showPopupMenu(null);
        return this.popup;
    }

    public void showPopupMenu(MouseEvent event) {
        UserPreferences prefs = guiMain.getUserPrefs();
        boolean showPopup = true;
        if (event == null) {
            showPopup = false;
        }
        this.popup = this.getPopupMenu();
        JMenuItem log = new JMenuItem(MessageLog.getMessageNoID(lLog));
        JMenuItem tracing = new JMenuItem(MessageLog.getMessageNoID(lTracing));
        JMenuItem config = new JMenuItem(MessageLog.getMessageNoID(lConfig));
        JMenu shutdown = new JMenu(MessageLog.getMessageNoID(lShutdown));
        JMenuItem normal = new JMenuItem(MessageLog.getMessageNoID(lNormal));
        JMenuItem immediate = new JMenuItem(MessageLog.getMessageNoID(lImmediate));
        JMenuItem abort = new JMenuItem(MessageLog.getMessageNoID(lAbort));
        JMenuItem uninstall = new JMenuItem(MessageLog.getMessageNoID(lUninstall));
        JMenuItem check = new JMenuItem(MessageLog.getMessageNoID(lCheck));
        JMenuItem enable = new JMenuItem(MessageLog.getMessageNoID(lEnable));
        JMenuItem disable = new JMenuItem(MessageLog.getMessageNoID(lDisable));
        log.setName(MessageLog.getMessageNoID(lLog));
        tracing.setName(MessageLog.getMessageNoID(lTracing));
        config.setName(MessageLog.getMessageNoID(lConfig));
        shutdown.setName(MessageLog.getMessageNoID(lShutdown));
        normal.setName(MessageLog.getMessageNoID(lNormal));
        immediate.setName(MessageLog.getMessageNoID(lImmediate));
        abort.setName(MessageLog.getMessageNoID(lAbort));
        uninstall.setName(MessageLog.getMessageNoID(lUninstall));
        check.setName(MessageLog.getMessageNoID(lCheck));
        enable.setName(MessageLog.getMessageNoID(lEnable));
        disable.setName(MessageLog.getMessageNoID(lDisable));
        config.setToolTipText(MessageLog.getMessageNoID("ADG0256T"));
        tracing.setToolTipText(MessageLog.getMessageNoID("ADG0305T"));
        log.setToolTipText(MessageLog.getMessageNoID("ADG0260T"));
        shutdown.setToolTipText(MessageLog.getMessageNoID("ADG0016T"));
        normal.setToolTipText(MessageLog.getMessageNoID("ADG0008T"));
        immediate.setToolTipText(MessageLog.getMessageNoID("ADG0010T"));
        abort.setToolTipText(MessageLog.getMessageNoID("ADG0012T"));
        uninstall.setToolTipText(MessageLog.getMessageNoID("ADG0263T"));
        check.setToolTipText(MessageLog.getMessageNoID("ADG0291T"));
        enable.setToolTipText(MessageLog.getMessageNoID("ADG0293T"));
        disable.setToolTipText(MessageLog.getMessageNoID("ADG0292T"));
        log.setActionCommand(lLog);
        tracing.setActionCommand(lTracing);
        config.setActionCommand(lConfig);
        normal.setActionCommand(lNormal);
        immediate.setActionCommand(lImmediate);
        abort.setActionCommand(lAbort);
        uninstall.setActionCommand(lUninstall);
        check.setActionCommand(lCheck);
        enable.setActionCommand(lEnable);
        disable.setActionCommand(lDisable);
        log.addActionListener(this);
        tracing.addActionListener(this);
        config.addActionListener(this);
        normal.addActionListener(this);
        immediate.addActionListener(this);
        abort.addActionListener(this);
        uninstall.addActionListener(this);
        check.addActionListener(this);
        enable.addActionListener(this);
        disable.addActionListener(this);
        config.setEnabled(prefs.administrator);
        tracing.setEnabled(prefs.administrator);
        shutdown.setEnabled(prefs.administrator);
        uninstall.setEnabled(prefs.administrator);
        enable.setEnabled(prefs.administrator);
        disable.setEnabled(prefs.administrator);
        if (this.state == 1 || this.state == 5) {
            this.popup.add(log);
            if (this.state == 1) {
                this.popup.add(tracing);
            }
            this.popup.add(config);
        }
        this.popup.add(check);
        if (this.state == 1 || this.state == 5) {
            this.popup.add(shutdown);
            shutdown.add(normal);
            shutdown.add(immediate);
            shutdown.add(abort);
            this.popup.add(disable);
        } else if (this.state == 4) {
            this.popup.add(disable);
        } else if (this.state == 0) {
            this.popup.add(enable);
        }
        this.popup.add(uninstall);
        if (showPopup) {
            this.showPopupMenu(this.popup, event);
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.actionCommand = event.getActionCommand();
        if (this.actionCommand == lNormal) {
            this.stopAgent((byte)1);
        } else if (this.actionCommand == lImmediate) {
            this.stopAgent((byte)2);
        } else if (this.actionCommand == lAbort) {
            this.stopAgent((byte)3);
        } else if (this.actionCommand == lConfig) {
            this.config();
        } else if (this.actionCommand == lLog) {
            this.log();
        } else if (this.actionCommand == lUninstall) {
            this.uninstallAgent();
        } else if (this.actionCommand == lCheck) {
            this.checkAgent();
        } else if (this.actionCommand == lEnable) {
            this.enableAgent();
        } else if (this.actionCommand == lDisable) {
            this.disableAgent();
        } else if (this.actionCommand == lTracing) {
            this.tracingConfig();
        }
    }

    private void stopAgent(byte newState) {
        String STOP_TITLE = MessageLog.getMessageNoID("ADG0251T", this.getUserObject());
        String STOP_WARNING = MessageLog.getMessageNoID("ADG0252T", this.getUserObject());
        String STOP_NO = MessageLog.getMessageNoID("ADG0253L");
        String STOP_YES = MessageLog.getMessageNoID("ADG0254L");
        Object[] options = new String[]{STOP_NO, STOP_YES};
        int answer = JOptionPane.showOptionDialog(guiMain.getFrame(), STOP_WARNING, STOP_TITLE, 0, 2, null, options, options[0]);
        if (answer == 1) {
            Request request = new Request();
            ServerRequest.agentStop(request, this.computerID, newState);
            GuiClient.doRhetoricalRequest(request);
            this.state = 0;
            BaseTree.MyTree.nodeChanged(this);
        }
    }

    private void log() {
        LogViewer lv = new LogViewer(this.computerID, this);
    }

    private void tracingConfig() {
        Request request = new Request();
        ServerRequest.agentGetTracingConfig(request, this.computerID, "org.eclipse.aperi.agent.svp.AgentSvp");
        GuiClient.doRequest(this, request);
    }

    private void config() {
        Request request = new Request();
        ServerRequest.agentReadConfig(request, this.computerID);
        GuiClient.doRequest(this, request);
    }

    private void uninstallAgent() {
        String UNINSTALL_TITLE = MessageLog.getMessageNoID("ADG0264T", this.getUserObject());
        String UNINSTALL_WARNING = MessageLog.getMessageNoID("ADG0265T", this.getUserObject());
        String UNINSTALL_NO = MessageLog.getMessageNoID("ADG0266L");
        String UNINSTALL_YES = MessageLog.getMessageNoID("ADG0267L");
        Object[] options = new String[]{UNINSTALL_NO, UNINSTALL_YES};
        int answer = JOptionPane.showOptionDialog(guiMain.getFrame(), UNINSTALL_WARNING, UNINSTALL_TITLE, 0, 2, null, options, options[0]);
        if (answer == 1) {
            Request request = new Request();
            byte productCode = 0;
            ServerRequest.uninstallAgent(request, this.computerID, productCode);
            GuiClient.doRequest(this, request);
            BaseTree.MyTree.removeNodeFromParent(this);
        }
    }

    private void checkAgent() {
        Request request = new Request();
        ServerRequest.agentStatus(request, this.computerID);
        GuiClient.doRequest(this, request);
    }

    private void enableAgent() {
        Request request = new Request();
        ServerRequest.agentState(request, new ComputerID(this.computerID), (byte)1);
        GuiClient.doRequest(this, request);
    }

    private void disableAgent() {
        Request request = new Request();
        ServerRequest.agentState(request, new ComputerID(this.computerID), (byte)0);
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (this.actionCommand == lCheck) {
            this.setState(response);
            if (status < 4) {
                String msg = MessageLog.getMessageNoID("ADG0294M", this.getUserObject());
                JOptionPane.showMessageDialog(guiMain.getFrame(), msg, MessageLog.getMessageNoID("ADG0295T"), 1);
            }
        } else if (this.actionCommand == lEnable || this.actionCommand == lDisable) {
            this.setState(response);
        } else if (this.actionCommand == lTracing) {
            if (status != 0) {
                String msg = MessageLog.getMessage("ADG0308E", this.getUserObject());
                JOptionPane.showMessageDialog(guiMain.getFrame(), msg, MessageLog.getMessageNoID("ADG0307L"), 0);
            } else {
                HashMap config = (HashMap)response.responseData;
                if (this.lConfigDialog == null) {
                    String msg = MessageLog.getMessageNoID("ADG0310L", this.getUserObject());
                    this.lConfigDialog = new LogConfigDialog(msg, this.computerID, this.getUserObject(), "org.eclipse.aperi.agent.svp.AgentSvp");
                }
                this.lConfigDialog.setLocationRelativeTo(null);
                this.lConfigDialog.show(config, "org.eclipse.aperi.agent.svp.AgentSvp");
            }
        } else if ((this.actionCommand == lImmediate || this.actionCommand == lAbort) && status <= 4) {
            this.actionCommand = null;
            Request request = new Request();
            ServerRequest.agentState(request, new ComputerID(this.computerID), (byte)0);
            GuiClient.doRequest(this, request);
        }
    }

    private void setState(Response response) {
        if (response != null && response.responseData != null && response.responseData instanceof Byte) {
            this.state = (Byte)response.responseData;
            BaseTree.MyTree.nodeChanged(this);
            DataDisplayInfo currDDI = DataDisplayInfo.getCurrent();
            if (currDDI != null && currDDI instanceof AgentDDI && (AgentTreeNode)currDDI.treeNode == this) {
                currDDI.remove();
                this.select(null);
            }
        }
    }
}

