/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.Encrypt;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.DeviceServerStatusResp;

public class ChangeDeviceServerPasswordDialog
extends JDialog
implements GuiRequestor,
ActionListener,
DocumentListener {
    private Container cp = this.getContentPane();
    private JButton okButton;
    private JButton cancelButton;
    private GridBagPanel tablePanel;
    private GridBagPanel panel;
    private JPanel buttonPanel;
    private JScrollPane tablePane;
    private JPasswordField pwd1;
    private JPasswordField pwd2;
    private static GridBagConstraints gbcLabel = new GridBagConstraints();
    private static GridBagConstraints gbcLast = new GridBagConstraints();

    public ChangeDeviceServerPasswordDialog(Frame myFrame, String title, boolean modal) {
        super(myFrame, title, modal);
        this.getMainPanel();
        this.getButtonPanel();
        this.cp.add((Component)this.panel, "Center");
        this.cp.add((Component)this.buttonPanel, "South");
        this.pack();
        Dimension d = this.getSize();
        this.setSize(new Dimension(d.width + 20, d.height + 20));
    }

    public void handleResponse(short status, Response response) {
        if (status <= 4) {
            new JOptionPane();
            JOptionPane.showMessageDialog(this, ((DeviceServerStatusResp)response.responseData).getResultMsg(), Util.getString("PASSWD_UPDATE"), 1);
        }
        this.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            boolean success = true;
            String pw1 = new String(this.pwd1.getPassword());
            String pw2 = new String(this.pwd2.getPassword());
            int i = pw1.compareTo(pw2);
            if (pw1.compareTo(pw2) == 0) {
                char[] pArray = this.pwd1.getPassword();
                String password = String.valueOf(pArray);
                success = this.sendPassword(password);
                if (success) {
                    this.dispose();
                }
            } else {
                new JOptionPane();
                JOptionPane.showMessageDialog(null, Util.getString("PASSWDS_NOT_MATCH"), "", 0);
                this.pwd1.requestFocus();
            }
        } else {
            this.dispose();
        }
    }

    private void getMainPanel() {
        this.panel = new GridBagPanel();
        this.pwd1 = new JPasswordField(8);
        this.pwd2 = new JPasswordField(8);
        GuiUtil.setAccessibleDescription(this.pwd1, Util.getString(Util.getString("ENTER_NEW_AUTH_PSSWD")));
        GuiUtil.setAccessibleDescription(this.pwd2, Util.getString(Util.getString("ENTER_NEW_AUTH_PSSWD")));
        String toolTip = Util.getString("ENTER_NEW_AUTH_PSSWD");
        this.pwd1.setToolTipText(toolTip);
        this.pwd2.setToolTipText(toolTip);
        JLabel pw1label = new JLabel(Util.getString("NEW_PASSWD"));
        JLabel pw2label = new JLabel(Util.getString("CONFIRM_PASSWD"));
        GuiUtil.setAccessibleLabel(pw1label, this.pwd1, "", "ENTER_NEW_AUTH_PSSWD", "ENTER_NEW_AUTH_PSSWD");
        GuiUtil.setAccessibleLabel(pw2label, this.pwd2, "", "ENTER_NEW_AUTH_PSSWD", "ENTER_NEW_AUTH_PSSWD");
        ChangeDeviceServerPasswordDialog.gbcLabel.anchor = 17;
        ChangeDeviceServerPasswordDialog.gbcLast.anchor = 17;
        ChangeDeviceServerPasswordDialog.gbcLast.gridwidth = 0;
        ChangeDeviceServerPasswordDialog.gbcLast.fill = 2;
        ChangeDeviceServerPasswordDialog.gbcLabel.ipadx = 5;
        this.panel.add((Component)pw1label, gbcLabel);
        this.panel.add((Component)this.pwd1, gbcLast);
        this.panel.add((Component)pw2label, gbcLabel);
        this.panel.add((Component)this.pwd2, gbcLast);
        this.pwd1.getDocument().addDocumentListener(this);
        this.pwd2.getDocument().addDocumentListener(this);
    }

    private void getButtonPanel() {
        this.buttonPanel = new JPanel();
        this.okButton = new JButton(Util.getString("LABEL_OK"));
        this.okButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_OK"));
        GuiUtil.setAccessible(this.okButton, this.okButton.getText(), this.okButton.getText());
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton(Util.getString("LABEL_CANCEL"));
        this.cancelButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_CANCEL"));
        GuiUtil.setAccessible(this.cancelButton, this.cancelButton.getText(), this.cancelButton.getText());
        this.buttonPanel.add(this.okButton);
        this.okButton.setEnabled(false);
        this.buttonPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
    }

    public void displayDialog() {
        this.setVisible(true);
    }

    private boolean sendPassword(String pwd) {
        String encrPwd = null;
        try {
            encrPwd = Encrypt.encrypt(pwd);
        }
        catch (Exception e) {
            new JOptionPane();
            JOptionPane.showMessageDialog(null, "ENCRYPT_FAIL_PWD", "", 0);
            return false;
        }
        DeviceRequest deviceReq = new DeviceRequest("org.eclipse.aperi.server.svp.GuiSvp", "org.eclipse.aperi.server.handler.gui.DeviceChangePasswordHndlr");
        deviceReq.requestData = new DeviceServerStatusResp();
        ((DeviceServerStatusResp)deviceReq.requestData).setPwd(encrPwd);
        GuiClient.doRequest(this, deviceReq);
        return true;
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.okButton.setEnabled(this.ifAnyText());
    }

    public void removeUpdate(DocumentEvent e) {
        this.okButton.setEnabled(this.ifAnyText());
    }

    private boolean ifAnyText() {
        return this.pwd1.getText().length() > 0 && this.pwd2.getText().length() > 0;
    }
}

