/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.SpinBox;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class LogConfigDialog
extends JDialog
implements ActionListener,
GuiRequestor {
    private int computerID;
    private HashMap config;
    private TComboBox lComboBox;
    private SpinBox mfSpinBox;
    private SpinBox mfsSpinBox;
    private JButton okButton;
    private JButton cancelButton;
    private Object name;
    private boolean isAgent;
    private boolean isAudit;
    private JLabel label;
    private JCheckBox enableTrace;
    private String serviceCode;
    private static String[] levelArray = new String[]{"DEBUG_MIN", "DEBUG_MID", "DEBUG_MAX"};
    static IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public LogConfigDialog(String title, String reqCode) {
        this(title, 0, null, false, reqCode, false);
    }

    public LogConfigDialog(String title, String reqCode, boolean boolAudit) {
        this(title, 0, null, false, reqCode, boolAudit);
    }

    public LogConfigDialog(String title, int agentComputerID, Object agentName, String reqCode) {
        this(title, agentComputerID, agentName, true, reqCode, false);
    }

    private LogConfigDialog(String title, int agentComputerID, Object agentName, boolean isAgentDialog, String requestCode, boolean boolAudit) {
        super(guiMain.getFrame(), title, true);
        this.computerID = agentComputerID;
        this.name = agentName;
        this.isAgent = isAgentDialog;
        this.isAudit = boolAudit;
        JComponent cp = (JComponent)this.getContentPane();
        JPanel configPanel = new JPanel(new GridBagLayout());
        JPanel buttonPanel = new JPanel();
        this.lComboBox = new TComboBox(levelArray);
        this.mfSpinBox = new SpinBox(2, 2, 100, 1);
        this.mfsSpinBox = new SpinBox(128, 128, 102400, 128);
        this.okButton = new JButton(Util.getString("LABEL_OK"));
        this.cancelButton = new JButton(Util.getString("LABEL_CANCEL"));
        this.okButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_OK"));
        this.cancelButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_CANCEL"));
        GridBagConstraints gbcLabel = new GridBagConstraints();
        GridBagConstraints gbcField = new GridBagConstraints();
        Insets insets = new Insets(4, 8, 4, 8);
        gbcLabel.anchor = 17;
        gbcLabel.insets = insets;
        gbcField.anchor = 17;
        gbcField.gridwidth = 0;
        gbcField.insets = insets;
        this.enableTrace = new JCheckBox(Util.getString("ADG0325L"));
        this.enableTrace.addActionListener(this);
        configPanel.add((Component)this.enableTrace, gbcLabel);
        if (this.isAudit) {
            this.label = new JLabel(Util.getString("ADG0312L"));
        } else {
            this.label = new JLabel(Util.getString("ADG0311L"));
            configPanel.add((Component)this.label, gbcLabel);
            configPanel.add((Component)this.lComboBox, gbcField);
        }
        if (requestCode.equals("org.eclipse.aperi.server.svp.ServerSvp") || requestCode.equals("org.eclipse.aperi.agent.svp.AgentSvp") || requestCode.equals("org.eclipse.aperi.common.svp.AuditSvp")) {
            configPanel.add((Component)new JLabel(Util.getString("ADG0312L")), gbcLabel);
            configPanel.add((Component)this.mfSpinBox, gbcField);
            configPanel.add((Component)new JLabel(Util.getString("ADG0313L")), gbcLabel);
            configPanel.add((Component)this.mfsSpinBox, gbcField);
        }
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        cp.setLayout(new BorderLayout());
        cp.add((Component)configPanel, "Center");
        cp.add((Component)buttonPanel, "South");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        String helpStringID = null;
        if (requestCode.equals("org.eclipse.aperi.server.svp.ServerSvp")) {
            helpStringID = "assrv6";
        } else if (requestCode.equals("org.eclipse.aperi.agent.svp.AgentSvp")) {
            helpStringID = "asag3";
        } else if (requestCode.equals("org.eclipse.aperi.server.svp.SchedulerSvp")) {
            helpStringID = "assrv25";
        } else if (requestCode.equals("org.eclipse.aperi.server.svp.CimomSvp")) {
            helpStringID = "assrv45";
        } else if (requestCode.equals("org.eclipse.aperi.server.svp.GuiSvp")) {
            helpStringID = "assrv35";
        } else if (requestCode.equals("org.eclipse.aperi.server.svp.AgentSvp")) {
            helpStringID = "assrv30";
        } else if (requestCode.equals("org.eclipse.aperi.common.svp.AuditSvp")) {
            helpStringID = "assrv6";
        }
        if (helpStringID != null) {
            Help.setHelpID(this.getRootPane(), helpStringID);
        }
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
        this.pack();
    }

    public void show(HashMap tracingConfig, String reqCode) {
        this.serviceCode = reqCode;
        this.setTracingConfig(tracingConfig);
        this.show();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.okButton) {
            this.config.put("enableFlag", new Boolean(this.enableTrace.isSelected()));
            this.config.put("level", this.lComboBox.getSelectedItem());
            this.config.put("maxFiles", "" + this.mfSpinBox.getValue());
            this.config.put("maxFileSize", "" + this.mfsSpinBox.getValue() * 1000);
            Request request = new Request();
            if (this.isAgent) {
                ServerRequest.agentSetTracingConfig(request, this.computerID, this.config, this.serviceCode);
            } else if (this.isAudit) {
                ServerRequest.serverSetAuditConfig(request, this.config, this.serviceCode);
            } else {
                ServerRequest.serverSetTracingConfig(request, this.config, this.serviceCode);
            }
            GuiClient.doRequest(this, request);
        } else if (event.getSource() == this.enableTrace) {
            if (this.enableTrace.isSelected()) {
                this.label.setEnabled(true);
                this.lComboBox.setEnabled(true);
            } else {
                this.label.setEnabled(false);
                this.lComboBox.setEnabled(false);
            }
        } else if (event.getSource() == this.cancelButton) {
            this.hide();
        }
    }

    private void setTracingConfig(HashMap tracingConfig) {
        this.config = tracingConfig;
        Boolean enable = (Boolean)this.config.get("enableFlag");
        String level = (String)this.config.get("level");
        String maxFiles = (String)this.config.get("maxFiles");
        String maxFileSize = (String)this.config.get("maxFileSize");
        this.enableTrace.setSelected(enable);
        if (enable.booleanValue()) {
            this.label.setEnabled(true);
            this.lComboBox.setEnabled(true);
            this.lComboBox.setSelectedItem(level);
        } else {
            this.label.setEnabled(false);
            this.lComboBox.setEnabled(false);
        }
        this.mfSpinBox.setValue(Integer.parseInt(maxFiles));
        this.mfsSpinBox.setValue(Integer.parseInt(maxFileSize) / 1000);
    }

    public void handleResponse(short status, Response response) {
        if (status != 0) {
            String msg = null;
            msg = this.isAgent ? MessageLog.getMessage("ADG0309E", this.name) : MessageLog.getMessage("ADG0316E");
            JOptionPane.showMessageDialog(guiMain.getFrame(), msg, MessageLog.getMessageNoID("ADG0307L"), 0);
        }
        this.hide();
    }
}

