/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.common.DirtyListenerInterface;

public class CIMOMMgmtDetailsPanel
extends JPanel
implements ActionListener,
DocumentListener {
    HashMap model;
    protected static final String SERVICE_URL = Util.getString("CIMOM_MGMT_SERVICE_URL_LABEL");
    protected static final String HI_NAME = Util.getString("CIMOM_MGMT_HI_NAME_LABEL");
    protected static final String DESCRIPTION = Util.getString("CIMOM_MGMT_DESCRIPTION_LABEL");
    protected static final String SOFTWARE_LEVEL = Util.getString("CIMOM_MGMT_SOFTWARE_LEVEL_LABEL");
    protected static final String PROTOCOL_VERSION = Util.getString("CIMOM_MGMT_PROTOCOL_VERSION_LABEL");
    protected static final String AUTHENTICATION_VERSION = Util.getString("CIMOM_MGMT_AUTHENTICATION_VERSION_LABEL");
    protected static final String USER_ID = Util.getString("CIMOM_MGMT_USER_ID_LABEL");
    protected static final String PASSWORD = Util.getString("CIMOM_MGMT_PASSWORD_LABEL");
    protected static final String PASSWORD_CONFIRM = Util.getString("CIMOM_MGMT_PASSWORD_CONFIRM_LABEL");
    protected static final String TRUSTSTORE_LOCATION = Util.getString("CIMOM_MGMT_TRUSTSTORE_LOCATION_LABEL");
    protected static final String TRUSTSTORE_PASSPHRASE = Util.getString("CIMOM_MGMT_TRUSTSTORE_PASSPHRASE_LABEL");
    protected static final String ALIAS = Util.getString("CIMOM_MGMT_ALIAS_LABEL");
    protected static final String SERVICE_ID = Util.getString("CIMOM_MGMT_SERVICE_ID_LABEL");
    protected static final String INTEROP_SCHEMA_NAMESPACE = Util.getString("CIMOM_MGMT_INTEROP_SCHEMA_NAMESPACE_LABEL");
    protected static final String PROTOCOL = Util.getString("CIMOM_MGMT_PROTOCOL_LABEL");
    protected static final String DISPLAY_NAME = Util.getString("CIMOM_MGMT_DISPLAY_NAME_LABEL");
    protected static final String SLP_ATTRIBUTES = Util.getString("CIMOM_MGMT_SLP_ATTRIBUTES_LABEL");
    protected static final String STATUS = Util.getString("CIMOM_MGMT_STATUS_LABEL");
    protected static final String TIMESTAMP = Util.getString("CIMOM_MGMT_TIMESTAMP_LABEL");
    protected static final String CHECKBOX_LABEL = Util.getString("CIMOM_MGT_TESTBEFORE_UPDATE_LABEL");
    private static final String CIMOM_MGT_CONNECTION_STATUS_SUCCESS = Util.getString("CIMOM_MGT_CONNECTION_STATUS_SUCCESS");
    private static final String CIMOM_MGT_CONNECTION_STATUS_UNCONFIGURED = Util.getString("CIMOM_MGT_CONNECTION_STATUS_UNCONFIGURED");
    private static final String CIMOM_MGT_CONNECTION_STATUS_UNKNOWN = Util.getString("CIMOM_MGT_CONNECTION_STATUS_UNKNOWN");
    private static final String CIMOM_MGT_CONNECTION_STATUS_INVALID_NAMESPACE = Util.getString("CIMOM_MGT_CONNECTION_STATUS_INVALID_NAMESPACE");
    private static final String CIMOM_MGT_CONNECTION_STATUS_TIMEOUT = Util.getString("CIMOM_MGT_CONNECTION_STATUS_TIMEOUT");
    private static final String CIMOM_MGT_CONNECTION_STATUS_REFUSED = Util.getString("DISK_COMMON_STATE_UNREACHABLE");
    private static final String CIMOM_MGT_CONNECTION_STATUS_LOGIN_FAILED = Util.getString("CIMOM_MGT_CONNECTION_STATUS_LOGIN_FAILED");
    private static final String CIMOM_MGT_CONNECTION_STATUS_SSL_HANDSHAKE_ERROR = Util.getString("CIMOM_MGT_CONNECTION_STATUS_SSL_HANDSHAKE_ERROR");
    private static final String CIMOM_MGT_CONNECTION_STATUS_SSL_REGISTRATION_INVALID = Util.getString("CIMOM_MGT_CONNECTION_STATUS_SSL_REGISTRATION_INVALID");
    private static final String CIMOM_MGT_CONNECTION_STATUS_CIMCLIENT_ERROR = Util.getString("CIMOM_MGT_CONNECTION_STATUS_CIMCLIENT_ERROR");
    private static final String FIELD = "CIMOM_FIELD";
    private static final int MIN_FIELD_WIDTH = 30;
    private DirtyListenerInterface dirtyListener = null;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private static HashMap CIMOMConnectionStatus2LocalizedString = new HashMap();

    public CIMOMMgmtDetailsPanel(CIMOM cimom, boolean testBeforeAdd, String passwordConfirm) {
        this.model = new HashMap();
        this.buildPanel(cimom, testBeforeAdd, passwordConfirm);
        this.validateAndEnable(null);
    }

    public CIMOMMgmtDetailsPanel(CIMOM cimom) {
        this(cimom, true, null);
    }

    public void actionPerformed(ActionEvent ae) {
        this.talkDirty(ae.getActionCommand());
    }

    public void changedUpdate(DocumentEvent e) {
        this.talkDirty((String)e.getDocument().getProperty(FIELD));
    }

    public void insertUpdate(DocumentEvent e) {
        this.talkDirty((String)e.getDocument().getProperty(FIELD));
    }

    public void removeUpdate(DocumentEvent e) {
        this.talkDirty((String)e.getDocument().getProperty(FIELD));
    }

    protected void validateAndEnable(String who) {
        String confirmText;
        JTextField password = this.getTextFieldFromRow(PASSWORD);
        JTextField confirm = this.getTextFieldFromRow(PASSWORD_CONFIRM);
        String passwordText = password.getText();
        if (passwordText == null) {
            passwordText = "";
        }
        if ((confirmText = confirm.getText()) == null) {
            confirmText = "";
        }
        if (!passwordText.equals(confirmText)) {
            password.setBorder(BorderFactory.createBevelBorder(1, Color.RED, Color.BLACK));
            confirm.setBorder(BorderFactory.createBevelBorder(1, Color.RED, Color.BLACK));
        } else {
            password.setBorder(BorderFactory.createBevelBorder(1));
            confirm.setBorder(BorderFactory.createBevelBorder(1));
        }
    }

    protected void makeNonEditable(JTextField textField) {
        if (textField == null) {
            return;
        }
        textField.setEditable(false);
        textField.setBorder(BorderFactory.createEmptyBorder());
        textField.setFont(this.getFont().deriveFont(0));
        textField.setForeground(Color.black);
    }

    protected void makeEditable(JTextField textField) {
        if (textField == null) {
            return;
        }
        textField.setEditable(true);
        textField.setBorder(BorderFactory.createBevelBorder(1));
        textField.setFont(this.getFont().deriveFont(0));
        textField.setForeground(Color.black);
    }

    protected JTextField getTextFieldFromRow(String label) {
        return (JTextField)this.model.get(label);
    }

    private void buildRow(GridBagPanel gridbag, String label, String value) {
        JTextField textField = new JTextField(value);
        this.setWidth(value, textField);
        this.buildRowWithTextField(gridbag, label, textField);
    }

    private void buildPasswordRow(GridBagPanel gridbag, String label, String value) {
        JPasswordField passwordField = new JPasswordField(value);
        this.setWidth(value, passwordField);
        this.buildRowWithTextField(gridbag, label, passwordField);
    }

    private void setWidth(String value, JTextField textField) {
        textField.setColumns(Math.max(value == null ? 0 : value.length(), 30));
    }

    private void buildRowWithTextField(GridBagPanel gridbag, String label, JTextField textField) {
        BoldLabel jlabel = new BoldLabel(label);
        gridbag.add(jlabel);
        this.makeNonEditable(textField);
        GuiUtil.setAccessibleLabel(jlabel, textField, "", label, label);
        this.addEditListeners(label, textField);
        gridbag.add(textField);
        this.model.put(label, textField);
        gridbag.newRow();
    }

    private void addEditListeners(String label, JTextField textField) {
        textField.setActionCommand(label);
        textField.addActionListener(this);
        textField.getDocument().addDocumentListener(this);
        textField.getDocument().putProperty(FIELD, label);
    }

    private void buildPanel(CIMOM cimom, boolean testBeforeAdd, String passwordConfirm) {
        this.setLayout(new FlowLayout(0));
        this.add((Component)this.buildGridBag(cimom, testBeforeAdd, passwordConfirm), "Before");
    }

    private GridBagPanel buildGridBag(CIMOM cimom, boolean testBeforeAdd, String passwordConfirm) {
        GridBagPanel gridbag = new GridBagPanel();
        this.buildRow(gridbag, SERVICE_URL, cimom.getServiceUrl());
        this.buildRow(gridbag, DISPLAY_NAME, cimom.getDisplayName());
        this.buildRow(gridbag, DESCRIPTION, cimom.getDescription());
        this.buildRow(gridbag, USER_ID, cimom.getUserId());
        this.buildPasswordRow(gridbag, PASSWORD, cimom.getPassword());
        this.buildPasswordRow(gridbag, PASSWORD_CONFIRM, passwordConfirm != null ? passwordConfirm : cimom.getPassword());
        this.buildRow(gridbag, INTEROP_SCHEMA_NAMESPACE, cimom.getInteropSchemaNamespace());
        this.buildRow(gridbag, TRUSTSTORE_LOCATION, cimom.getTrustStoreLocation());
        this.buildRow(gridbag, HI_NAME, cimom.getHiName());
        this.buildRow(gridbag, SOFTWARE_LEVEL, cimom.getSoftwareLevel());
        this.buildRow(gridbag, PROTOCOL_VERSION, cimom.getProtocolVersion());
        this.buildRow(gridbag, AUTHENTICATION_VERSION, cimom.getAuthenticationMechanism());
        this.buildRow(gridbag, ALIAS, cimom.getAlias());
        this.buildRow(gridbag, SERVICE_ID, cimom.getServiceId());
        this.buildRow(gridbag, PROTOCOL, cimom.getProtocol());
        this.buildRow(gridbag, SLP_ATTRIBUTES, cimom.getSlpAttributes());
        this.buildRow(gridbag, STATUS, this.getStatus(cimom));
        this.buildRow(gridbag, TIMESTAMP, this.getStatusTimestamp(cimom));
        this.buildCheckboxRow(gridbag, CHECKBOX_LABEL, testBeforeAdd);
        gridbag.createStretchBox();
        return gridbag;
    }

    private void buildCheckboxRow(GridBagPanel gridbag, String label, boolean checkedByDefault) {
        gridbag.add(new BoldLabel(label));
        JCheckBox checkBox = new JCheckBox();
        checkBox.setSelected(checkedByDefault);
        checkBox.setActionCommand(label);
        checkBox.addActionListener(this);
        gridbag.add(checkBox);
        this.model.put(label, checkBox);
        gridbag.newRow();
    }

    private boolean getStateFromCheckBox(String key) {
        return ((JCheckBox)this.model.get(key)).isSelected();
    }

    public boolean testBeforeAdd() {
        return this.getStateFromCheckBox(CHECKBOX_LABEL);
    }

    public String passwordConfirm() {
        return this.getFieldText(PASSWORD_CONFIRM);
    }

    private String getStatusTimestamp(CIMOM cimom) {
        if (cimom.getStatusTimestamp() == null) {
            return DateFormat.getDateTimeInstance(1, 1).format(new Date());
        }
        return DateFormat.getDateTimeInstance(1, 1).format(cimom.getStatusTimestamp().getTime());
    }

    private String getStatus(CIMOM cimom) {
        String returnStatus;
        if (cimom.getStatus() != null) {
            returnStatus = (String)CIMOMConnectionStatus2LocalizedString.get(cimom.getStatus());
            if (returnStatus == null) {
                System.err.println(this.getClass().getName() + ": Unknown CIMOM Connection Status Value " + cimom.getStatus().toString());
                returnStatus = (String)CIMOMConnectionStatus2LocalizedString.get(CIMOMConnectionStatus.UNKNOWN);
            }
        } else {
            returnStatus = (String)CIMOMConnectionStatus2LocalizedString.get(CIMOMConnectionStatus.UNKNOWN);
        }
        return returnStatus;
    }

    private String getFieldText(String key) {
        String rez = this.getTextFieldFromRow(key).getText();
        return rez != null ? rez.trim() : null;
    }

    public CIMOM getModel() {
        CIMOM cimom = new CIMOM();
        cimom.setServiceUrl(this.getFieldText(SERVICE_URL));
        cimom.setHiName(this.getFieldText(HI_NAME));
        cimom.setDescription(this.getFieldText(DESCRIPTION));
        cimom.setSoftwareLevel(this.getFieldText(SOFTWARE_LEVEL));
        cimom.setProtocolVersion(this.getFieldText(PROTOCOL_VERSION));
        cimom.setAuthenticationMechanism(this.getFieldText(AUTHENTICATION_VERSION));
        cimom.setUserId(this.getFieldText(USER_ID));
        cimom.setPassword(this.getFieldText(PASSWORD));
        cimom.setTrustStoreLocation(this.getFieldText(TRUSTSTORE_LOCATION));
        cimom.setAlias(this.getFieldText(ALIAS));
        cimom.setServiceId(this.getFieldText(SERVICE_ID));
        cimom.setInteropSchemaNamespace(this.getFieldText(INTEROP_SCHEMA_NAMESPACE));
        cimom.setProtocol(this.getFieldText(PROTOCOL));
        cimom.setDisplayName(this.getFieldText(DISPLAY_NAME));
        cimom.setSlpAttributes(this.getFieldText(SLP_ATTRIBUTES));
        return cimom;
    }

    public boolean validatePanel() {
        String confirmText;
        boolean result = true;
        JTextField password = this.getTextFieldFromRow(PASSWORD);
        JTextField confirm = this.getTextFieldFromRow(PASSWORD_CONFIRM);
        String passwordText = password.getText();
        if (passwordText == null) {
            passwordText = "";
        }
        if ((confirmText = confirm.getText()) == null) {
            confirmText = "";
        }
        if (!passwordText.equals(confirmText)) {
            result = false;
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), Util.getString("GUI8103E"), Util.getString("CIMOM_MGMT_EDT_TITLE"), 0);
        }
        return result;
    }

    protected void talkDirty(String label) {
        this.validateAndEnable(label);
        if (this.dirtyListener != null) {
            this.dirtyListener.dirtyTalk(this, label);
        }
    }

    public void addDirtyListener(DirtyListenerInterface dirtyListener) {
        this.dirtyListener = dirtyListener;
    }

    public void removeDirtyListener(DirtyListenerInterface dirtyListener) {
        if (this.dirtyListener == this.dirtyListener) {
            this.dirtyListener = null;
        }
    }

    protected void equalizeEditableTextFieldsSize() {
        int maxColumns = 0;
        for (int phase = 0; phase < 2; ++phase) {
            for (String key : this.model.keySet()) {
                JTextField textField;
                Object obj = this.model.get(key);
                if (!(obj instanceof JTextField) || !(textField = (JTextField)obj).isEditable()) continue;
                if (phase == 0) {
                    int columns = textField.getColumns();
                    if (columns <= maxColumns) continue;
                    maxColumns = columns;
                    continue;
                }
                textField.setColumns(maxColumns);
            }
        }
    }

    static {
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.SUCCESS, CIMOM_MGT_CONNECTION_STATUS_SUCCESS);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.UNCONFIGURED, CIMOM_MGT_CONNECTION_STATUS_UNCONFIGURED);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.UNKNOWN, CIMOM_MGT_CONNECTION_STATUS_UNKNOWN);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.INVALID_NAMESPACE, CIMOM_MGT_CONNECTION_STATUS_INVALID_NAMESPACE);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.TIMEOUT, CIMOM_MGT_CONNECTION_STATUS_TIMEOUT);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.REFUSED, CIMOM_MGT_CONNECTION_STATUS_REFUSED);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.LOGIN_FAILED, CIMOM_MGT_CONNECTION_STATUS_LOGIN_FAILED);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.SSL_HANDSHAKE_ERROR, CIMOM_MGT_CONNECTION_STATUS_SSL_HANDSHAKE_ERROR);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.SSL_REGISTRATION_INVALID, CIMOM_MGT_CONNECTION_STATUS_SSL_REGISTRATION_INVALID);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.CIMCLIENT_ERROR, CIMOM_MGT_CONNECTION_STATUS_CIMCLIENT_ERROR);
    }
}

