/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.common.DirtyListenerInterface;

public class HashMapDetailsPanel
extends JPanel
implements ActionListener,
DocumentListener {
    HashMap model = new HashMap();
    private static final String FIELD = "MAP_FIELD";
    private DirtyListenerInterface dirtyListener = null;

    public HashMapDetailsPanel(HashMap map) {
        this.buildPanel(map);
    }

    public void actionPerformed(ActionEvent ae) {
        this.talkDirty(ae.getActionCommand());
    }

    public void changedUpdate(DocumentEvent e) {
        this.talkDirty((String)e.getDocument().getProperty(FIELD));
    }

    public void insertUpdate(DocumentEvent e) {
        this.talkDirty((String)e.getDocument().getProperty(FIELD));
    }

    public void removeUpdate(DocumentEvent e) {
        this.talkDirty((String)e.getDocument().getProperty(FIELD));
    }

    private void makeNonEditable(JTextField textField) {
        textField.setEditable(false);
        textField.setBorder(BorderFactory.createEmptyBorder());
        textField.setFont(this.getFont().deriveFont(1));
        textField.setForeground(Color.black);
    }

    private void makeEditable(JTextField textField) {
        textField.setEditable(true);
        textField.setBorder(BorderFactory.createBevelBorder(1));
        textField.setFont(this.getFont().deriveFont(0));
        textField.setForeground(Color.black);
    }

    private JTextField getTextFieldFromRow(String label) {
        return (JTextField)this.model.get(label);
    }

    protected void makeAllEditable() {
        for (Object key : this.model.keySet()) {
            this.makeEditable(this.getTextFieldFromRow((String)key));
        }
    }

    public void makeEditable(String key) {
        this.makeEditable(this.getTextFieldFromRow(key));
    }

    public void makeNonEditable(String key) {
        this.makeNonEditable(this.getTextFieldFromRow(key));
    }

    private void buildRow(GridBagPanel gridbag, String label, String value) {
        JTextField textField = new JTextField(value);
        textField.setColumns(30);
        if (value == null || value.length() == 0) {
            textField.setColumns(20);
        }
        this.buildRowWithTextField(gridbag, label, textField);
    }

    private void buildPasswordRow(GridBagPanel gridbag, String label, String value) {
        JPasswordField passwordField = new JPasswordField(value);
        passwordField.setColumns(30);
        if (value == null || value.length() == 0) {
            passwordField.setColumns(20);
        }
        this.buildRowWithTextField(gridbag, label, passwordField);
    }

    private void buildRowWithTextField(GridBagPanel gridbag, String label, JTextField textField) {
        gridbag.add(new BoldLabel(label));
        this.makeNonEditable(textField);
        this.addEditListeners(label, textField);
        gridbag.add(textField);
        this.model.put(label, textField);
        gridbag.newRow();
    }

    private void addEditListeners(String label, JTextField textField) {
        textField.setActionCommand(label);
        textField.addActionListener(this);
        textField.getDocument().addDocumentListener(this);
        textField.getDocument().putProperty(FIELD, label);
    }

    private void buildPanel(HashMap map) {
        this.setLayout(new FlowLayout(0));
        this.add((Component)this.buildGridBag(map), "Before");
    }

    private GridBagPanel buildGridBag(HashMap map) {
        GridBagPanel gridbag = new GridBagPanel();
        for (Object key : map.keySet()) {
            this.buildRow(gridbag, (String)key, (String)map.get(key));
        }
        gridbag.createStretchBox();
        return gridbag;
    }

    private String getFieldText(String key) {
        return this.getTextFieldFromRow(key).getText();
    }

    public HashMap getModel() {
        HashMap result = new HashMap();
        for (Object key : this.model.keySet()) {
            result.put(key, this.getTextFieldFromRow((String)key).getText());
        }
        return result;
    }

    protected void talkDirty(String label) {
        if (this.dirtyListener != null) {
            this.dirtyListener.dirtyTalk(this, label);
        }
    }

    public void addDirtyListener(DirtyListenerInterface dirtyListener) {
        this.dirtyListener = dirtyListener;
    }

    public void removeDirtyListener(DirtyListenerInterface dirtyListener) {
        if (this.dirtyListener == this.dirtyListener) {
            this.dirtyListener = null;
        }
    }
}

