/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.common.model.GUIEntity;
import org.eclipse.aperi.gui.disk.common.DiskConstants;

public class GUIEntityUtil {
    public static final int STORAGE_CAPACITY_UNIT_BYTE = 0;
    public static final int STORAGE_CAPACITY_UNIT_KB = 1;
    public static final int STORAGE_CAPACITY_UNIT_MB = 2;
    public static final int STORAGE_CAPACITY_UNIT_GB = 3;
    public static final int STORAGE_CAPACITY_UNIT_TB = 4;
    public static final int STORAGE_CAPACITY_UNIT_PB = 5;
    private static final int[] STORAGE_CAPACITY_CONVERSION_TABLE = new int[]{0, 10, 20, 30, 40, 50};
    private static BigInteger STORAGE_CAPACITY_CONVERSION_BASE = BigInteger.valueOf(2L);

    public static double convertStorageCapacity(double capacity, int fromUnit, int toUnit, int numFractionDigits) {
        BigDecimal from = new BigDecimal(STORAGE_CAPACITY_CONVERSION_BASE.pow(STORAGE_CAPACITY_CONVERSION_TABLE[fromUnit]));
        BigDecimal to = new BigDecimal(STORAGE_CAPACITY_CONVERSION_BASE.pow(STORAGE_CAPACITY_CONVERSION_TABLE[toUnit]));
        BigDecimal cap = new BigDecimal(capacity);
        return cap.multiply(from).divide(to, numFractionDigits, 4).doubleValue();
    }

    public static long convertStorageCapacity(long capacity, int fromUnit, int toUnit) {
        return BigInteger.valueOf(capacity).multiply(STORAGE_CAPACITY_CONVERSION_BASE.pow(STORAGE_CAPACITY_CONVERSION_TABLE[fromUnit])).divide(STORAGE_CAPACITY_CONVERSION_BASE.pow(STORAGE_CAPACITY_CONVERSION_TABLE[toUnit])).longValue();
    }

    public static float convertStorageCapacityDecimal(double capacity, int fromUnit, int toUnit, int numFractionDigits) {
        BigDecimal from = new BigDecimal(STORAGE_CAPACITY_CONVERSION_BASE.pow(STORAGE_CAPACITY_CONVERSION_TABLE[fromUnit]));
        BigDecimal to = new BigDecimal(STORAGE_CAPACITY_CONVERSION_BASE.pow(STORAGE_CAPACITY_CONVERSION_TABLE[toUnit]));
        BigDecimal cap = new BigDecimal(capacity);
        return cap.multiply(from).divide(to, numFractionDigits, 4).floatValue();
    }

    public static String convertStorageCapacityString(Object capacity, DecimalFormat d0Fmt) {
        String data;
        d0Fmt.setMaximumFractionDigits(2);
        d0Fmt.setMinimumFractionDigits(2);
        int indexOfE = capacity.toString().indexOf("E");
        if (indexOfE != -1) {
            int exp = Integer.parseInt(capacity.toString().substring(indexOfE + 1));
            BigDecimal size = new BigDecimal(capacity.toString().substring(0, indexOfE));
            data = exp < 0 ? size.movePointRight(exp).toString() : size.movePointLeft(exp).toString();
        } else {
            data = d0Fmt.format((Number)capacity);
        }
        return data;
    }

    public static String getNumberString(Number number, Locale locale) {
        try {
            NumberFormat nf = NumberFormat.getInstance(locale);
            return nf.format(number);
        }
        catch (IllegalArgumentException ex) {
            return "";
        }
    }

    public static String getNumberString(Number number, int numFractionDigits, Locale locale) {
        try {
            NumberFormat nf = NumberFormat.getInstance(locale);
            nf.setMaximumFractionDigits(numFractionDigits);
            return nf.format(number);
        }
        catch (IllegalArgumentException ex) {
            return "";
        }
    }

    public static String getTimeLongString(Date date, Locale locale) {
        if (date.getTime() <= 0L) {
            return "";
        }
        try {
            DateFormat dfDefined = DateFormat.getDateTimeInstance(1, 1, locale);
            return dfDefined.format(date);
        }
        catch (IllegalArgumentException ex) {
            return "";
        }
    }

    public static String getTimeString(Date date, Locale locale) {
        if (date.getTime() <= 0L) {
            return "";
        }
        try {
            DateFormat dfDefined = DateFormat.getDateTimeInstance(2, 2, locale);
            return dfDefined.format(date);
        }
        catch (IllegalArgumentException ex) {
            return "";
        }
    }

    public static Number getNumber(String numstring, Locale locale) throws ParseException {
        NumberFormat nf = NumberFormat.getInstance(locale);
        return nf.parse(numstring);
    }

    public static JLabel getEntityStateLabel(GUIEntity entity) {
        String labelText = "";
        ImageIcon labelIcon = null;
        if (!entity.isDetectable()) {
            labelText = Util.getString("DISK_COMMON_STATE_UNREACHABLE");
            labelIcon = IconFactory.getStateUreachableIcon();
        } else {
            switch (entity.getState()) {
                case 0: {
                    labelText = Util.getString("DISK_COMMON_STATE_NORMAL");
                    labelIcon = IconFactory.getStateUpIcon();
                    break;
                }
                case 1: {
                    labelText = Util.getString("DISK_COMMON_STATE_WARNING");
                    labelIcon = IconFactory.getStateWarningIcon();
                    break;
                }
                case 2: {
                    labelText = Util.getString("DISK_COMMON_STATE_CRITICAL");
                    labelIcon = IconFactory.getStateFailedIcon();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown state: " + entity.getState());
                }
            }
        }
        if (labelIcon != null) {
            labelIcon.setDescription(labelText);
        }
        return new JLabel(labelText, labelIcon, 10);
    }

    public static Vector sort(Vector orig) {
        int i;
        Vector sorted = new Vector();
        Vector<String> nameVector = new Vector<String>();
        int index = -1;
        for (i = 0; i < orig.size(); ++i) {
            nameVector.add(((GUIEntity)orig.get(i)).getName());
        }
        Collections.sort(nameVector);
        for (i = 0; i < nameVector.size(); ++i) {
            index = GUIEntityUtil.findName(orig, nameVector.get(i).toString());
            if (index == -1) continue;
            sorted.insertElementAt(orig.get(index), i);
        }
        return sorted;
    }

    public static int findName(Vector searchVector, String name) {
        int index = -1;
        for (int i = 0; i < searchVector.size(); ++i) {
            if (!name.equals(((GUIEntity)searchVector.get(i)).getName())) continue;
            return i;
        }
        return index;
    }

    public static int getRaidLevel(int dataRedundancy, int packageRedundancy) {
        int raidLevel = -1;
        if (packageRedundancy == 0 && dataRedundancy == 1) {
            raidLevel = 0;
        } else if (packageRedundancy == 1 && dataRedundancy == 2) {
            raidLevel = 10;
        } else if (packageRedundancy == 1 && dataRedundancy == 1) {
            raidLevel = 5;
        } else if (packageRedundancy == 2 && dataRedundancy == 1) {
            raidLevel = 6;
        } else if (packageRedundancy == 2 && dataRedundancy == 2) {
            raidLevel = 15;
        }
        return raidLevel;
    }

    public static String getDisplayText(Object obj) {
        if (obj != null && !obj.equals("")) {
            return String.valueOf(obj);
        }
        return DiskConstants.DISK_VALUE_IS_NULL;
    }

    public static void main(String[] args) {
        System.out.println("Result (double)= " + GUIEntityUtil.convertStorageCapacity(7.5E12, 0, 3, 2) + " GB");
        System.out.println("Result (long) = " + GUIEntityUtil.convertStorageCapacity(7500000000000L, 0, 3) + " GB");
    }
}

