/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.dashboard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.dashboard.DashMain;
import org.eclipse.aperi.gui.dashboard.PanelClasses;
import org.eclipse.aperi.server.guireq.DashTotalsRow;
import org.eclipse.aperi.xmsg.MessageLog;

public class CompTypeSummary
extends PanelClasses {
    private int[] compArray;
    private long[] fsSpaceArray;
    private long[] diskSpaceArray;
    private JPanel panel;
    private JPanel titlePanel;
    private JPanel compPanel;
    private GridBagConstraints gbcIndent;
    private GridBagConstraints gbcPlop1;
    private GridBagConstraints gbcPlop2;
    private GridBagConstraints gbcPlop3;
    private GridBagConstraints gbcLast;
    private Insets insetA;
    private Insets insetB;
    private Insets insetC;
    private Insets insetD;
    private static final String NA = MessageLog.getMessageNoID("STG0019T");
    private static final DecimalFormat decimalFormatter = new DecimalFormat();

    public CompTypeSummary(DashTotalsRow pTotalsRow) {
        super(pTotalsRow);
        int max = Constants.OSTYPES.length;
        this.compArray = new int[max];
        this.fsSpaceArray = new long[max];
        this.diskSpaceArray = new long[max];
        DashTotalsRow node = pTotalsRow;
        while (node != null) {
            short type;
            if (node.dtrStatisticType == 5 && (type = node.dtrComputerType) < max) {
                this.compArray[type] = node.dtrTotalComputers;
                this.fsSpaceArray[type] = node.dtrFilesystemCapacity;
                this.diskSpaceArray[type] = node.dtrDiskCapacity;
            }
            node = node.dtrNext;
        }
    }

    public Component getComponent(Object whatever, boolean addListeners) {
        this.gbcIndent = new GridBagConstraints();
        this.gbcPlop1 = new GridBagConstraints();
        this.gbcPlop2 = new GridBagConstraints();
        this.gbcPlop3 = new GridBagConstraints();
        this.gbcLast = new GridBagConstraints();
        if (DashMain.screenWidth <= 800) {
            this.insetA = new Insets(1, 0, 1, 1);
            this.insetB = new Insets(1, 0, 1, 7);
            this.insetC = new Insets(1, 0, 1, 2);
            this.insetD = new Insets(1, 0, 1, 0);
        } else {
            this.insetA = new Insets(1, 0, 3, 9);
            this.insetB = new Insets(1, 0, 3, 9);
            this.insetC = new Insets(1, 0, 3, 5);
            this.insetD = new Insets(1, 0, 3, 0);
        }
        this.gbcIndent.anchor = 17;
        this.gbcIndent.insets = this.insetA;
        this.gbcPlop1.anchor = 17;
        this.gbcPlop1.insets = this.insetB;
        this.gbcPlop2.anchor = 17;
        this.gbcPlop2.insets = this.insetC;
        this.gbcPlop3.anchor = 17;
        this.gbcPlop3.insets = this.insetD;
        this.gbcLast.gridwidth = 0;
        this.gbcLast.insets = this.insetD;
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.titlePanel = new JPanel();
        this.compPanel = GuiUtil.getPanel();
        this.titlePanel.add(this.getLabel("STG5250L"));
        if (this.compArray == null) {
            this.compPanel.add(this.getLabel("STG5251L"));
        } else {
            BoldLabel osType = this.getLabel("STG1108L");
            BoldLabel number = this.getLabel("STG5253L");
            BoldLabel fsCapacity = this.getLabel("STG5003L");
            BoldLabel diskCapacity = this.getLabel("STG1240L");
            BoldLabel capacity1 = this.getLabel("STG1162L");
            BoldLabel capacity2 = this.getLabel("STG1162L");
            this.addLine(osType, number, fsCapacity, diskCapacity);
            this.addLine(new JLabel(" "), new JLabel(" "), capacity1, capacity2);
            this.addComputer(4, MessageLog.getMessageNoID("STG1024L"));
            this.addComputer(5, MessageLog.getMessageNoID("STG1025L"));
            this.addComputer(20, MessageLog.getMessageNoID("STG1027L"));
            this.addComputer(6, MessageLog.getMessageNoID("STG1026L"));
            this.addComputer(1, MessageLog.getMessageNoID("STG1021L"));
            this.addComputer(3, MessageLog.getMessageNoID("STG1023L"));
            this.addComputer(2, MessageLog.getMessageNoID("STG1022L"));
            this.addComputer(10, MessageLog.getMessageNoID("STG3254L"));
            this.addComputer(9, MessageLog.getMessageNoID("STG5227L"));
            this.addComputer(0, MessageLog.getMessageNoID("STG1020L"));
        }
        GuiUtil.completePanel(this.compPanel);
        this.panel.add((Component)this.titlePanel, "North");
        this.panel.add((Component)this.compPanel, "Center");
        return this.panel;
    }

    private BoldLabel getLabel(String msg) {
        return new BoldLabel(MessageLog.getMessageNoID(msg));
    }

    private void addComputer(int compType, String name) {
        BoldLabel computer = name == null ? new BoldLabel(MessageLog.getMessageNoID(Constants.OSTYPES[compType])) : new BoldLabel(name);
        JLabel number = this.getNumber(this.compArray[compType]);
        JLabel fsCapacity = this.getSpace(this.fsSpaceArray[compType]);
        JLabel diskCapacity = this.getSpace(this.diskSpaceArray[compType]);
        this.addLine(computer, number, fsCapacity, diskCapacity);
    }

    private void addLine(JLabel label, JLabel datum1, JLabel datum2, JLabel datum3) {
        this.compPanel.add((Component)label, this.gbcIndent);
        this.compPanel.add((Component)datum1, this.gbcPlop1);
        this.compPanel.add((Component)datum2, this.gbcPlop2);
        this.compPanel.add((Component)datum3, this.gbcPlop3);
        this.compPanel.add((Component)new JLabel(" "), this.gbcLast);
    }

    private JLabel getNumber(int num) {
        if (num < 0) {
            return new JLabel("0");
        }
        return new JLabel(decimalFormatter.format(num));
    }

    private JLabel getSpace(long space) {
        if (space <= 0L) {
            return new JLabel(NA);
        }
        return new JLabel(Util.formatBytes(space * 512L));
    }
}

