/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.dashboard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.dashboard.PanelClasses;
import org.eclipse.aperi.server.guireq.DashTotalsRow;
import org.eclipse.aperi.xmsg.MessageLog;

public class FsPercentSummary
extends PanelClasses {
    private DashTotalsRow[] fsArray;
    private JPanel panel;
    private JPanel titlePanel;
    private JPanel fsPanel;
    private GridBagConstraints gbcIndent;
    private GridBagConstraints gbcPlop;
    private GridBagConstraints gbcLast;
    private Insets insetA;
    private Insets insetB;
    private Insets insetC;

    public FsPercentSummary(DashTotalsRow pTotalsRow) {
        super(pTotalsRow);
        int count = 0;
        DashTotalsRow node = pTotalsRow;
        while (node != null) {
            if (node.dtrStatisticType == 4) {
                ++count;
            }
            node = node.dtrNext;
        }
        if (count > 0) {
            this.fsArray = new DashTotalsRow[count];
            count = 0;
            node = pTotalsRow;
            while (node != null) {
                if (node.dtrStatisticType == 4) {
                    this.fsArray[count] = node;
                    ++count;
                }
                node = node.dtrNext;
            }
            Arrays.sort(this.fsArray, new FsComparator());
        }
    }

    public Component getComponent(Object whatever, boolean addListeners) {
        this.gbcIndent = new GridBagConstraints();
        this.gbcPlop = new GridBagConstraints();
        this.gbcLast = new GridBagConstraints();
        this.insetA = new Insets(1, 0, 2, 5);
        this.insetB = new Insets(1, 0, 2, 2);
        this.insetC = new Insets(1, 0, 2, 0);
        this.gbcIndent.anchor = 17;
        this.gbcIndent.insets = this.insetA;
        this.gbcPlop.anchor = 17;
        this.gbcPlop.insets = this.insetB;
        this.gbcLast.gridwidth = 0;
        this.gbcLast.insets = this.insetC;
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.titlePanel = new JPanel();
        this.fsPanel = GuiUtil.getPanel();
        this.titlePanel.add(this.getLabel("STG5246L"));
        if (this.fsArray == null) {
            this.fsPanel.add(this.getLabel("STG5247L"));
        } else {
            BoldLabel fs = this.getLabel("STG5248L");
            JLabel percent = this.getLabel("STG5249L");
            JLabel capacity = this.getLabel("STG1162L");
            this.addLine(fs, percent, capacity);
            for (int i = 0; i < this.fsArray.length; ++i) {
                fs = this.getFs(this.fsArray[i].dtrFilesystemName);
                percent = this.getPercent(this.fsArray[i].dtrFreeSpace);
                capacity = this.getSize(this.fsArray[i].dtrFilesystemCapacity);
                this.addLine(fs, percent, capacity);
            }
        }
        GuiUtil.completePanel(this.fsPanel);
        this.panel.add((Component)this.titlePanel, "North");
        this.panel.add((Component)this.fsPanel, "Center");
        return this.panel;
    }

    private BoldLabel getLabel(String msg) {
        return new BoldLabel(MessageLog.getMessageNoID(msg));
    }

    private BoldLabel getFs(String fs) {
        return new BoldLabel(fs);
    }

    private JLabel getPercent(long number) {
        return new JLabel(Long.toString(number) + "% ");
    }

    private JLabel getSize(long size) {
        return new JLabel(Util.formatBytes(size * 512L));
    }

    private void addLine(JLabel label, JLabel datum1, JLabel datum2) {
        this.fsPanel.add((Component)datum1, this.gbcIndent);
        this.fsPanel.add((Component)datum2, this.gbcPlop);
        this.fsPanel.add((Component)label, this.gbcPlop);
        this.fsPanel.add((Component)new JLabel(" "), this.gbcLast);
    }

    private class FsComparator
    implements Comparator {
        private FsComparator() {
        }

        public int compare(Object o1, Object o2) {
            DashTotalsRow r1 = (DashTotalsRow)o1;
            DashTotalsRow r2 = (DashTotalsRow)o2;
            if (r2.dtrFreeSpace < r1.dtrFreeSpace) {
                return 1;
            }
            if (r2.dtrFreeSpace > r1.dtrFreeSpace) {
                return -1;
            }
            return 0;
        }
    }
}

