/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.system;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.disk.common.DiskConstants;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.system.SubsystemDetailsPanel;
import org.eclipse.aperi.gui.disk.system.SubsystemListPanel;
import org.eclipse.aperi.gui.disk.system.SubsystemPanel;
import org.eclipse.aperi.request.Response;

public class SubsystemDDI
extends DataDisplayInfo
implements ActionListener {
    private SubsystemPanel mainPanel;
    private Vector subsystems = new Vector();
    private Vector changedDetailsPanels = new Vector();
    private GUIStorageSubsystem subsystem = null;
    private int subsystemInternalId = -1;

    public SubsystemDDI() {
        this.setDescription(Util.getString("DISK_STORAGESUBSYS_LABEL"));
        this.displayInScrollPane = true;
    }

    public SubsystemDDI(int subsystemInternalId) {
        this.subsystemInternalId = subsystemInternalId;
        this.setDescription(Util.getString("DISK_STORAGESUBSYS_SINGLE_LABEL"));
        this.displayInScrollPane = true;
    }

    public String getHelpID() {
        Component panel = this.mainPanel.tabs.getSelectedComponent();
        if (panel instanceof SubsystemListPanel) {
            return DiskConstants.DISK_SUBSYSTEM;
        }
        if (panel instanceof SubsystemDetailsPanel) {
            return DiskConstants.DISK_SUBSYSTEM_DETAILS;
        }
        return "welcome_gettingstarted";
    }

    public Vector getSubsystems() {
        return this.subsystems;
    }

    public GUIStorageSubsystem getSubsystem() {
        return this.subsystem;
    }

    public int getSubsystemInternalId() {
        return this.subsystemInternalId;
    }

    public void reDisplay() {
        if (this.panel == null || this.subsystems.isEmpty()) {
            this.getData();
        } else {
            this.show();
            guiMain.setSaveActionEnabled(true, false);
        }
        guiMain.addSaveActionListener(this);
    }

    public void getData() {
        this.subsystems.removeAllElements();
        this.subsystem = null;
        DiskDataAccessor.getInstance().getAllStorageSubsystems(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4) {
                    HashMap hmapAllss = (HashMap)response.responseData;
                    SubsystemDDI.this.subsystems = new Vector(hmapAllss.values());
                    if (SubsystemDDI.this.subsystemInternalId != -1) {
                        for (GUIStorageSubsystem sys : SubsystemDDI.this.subsystems) {
                            if (sys.getInternalId() != SubsystemDDI.this.subsystemInternalId) continue;
                            SubsystemDDI.this.subsystem = sys;
                            break;
                        }
                    }
                    if (SubsystemDDI.this.mainPanel == null) {
                        SubsystemDDI.this.mainPanel = new SubsystemPanel(SubsystemDDI.this);
                    } else {
                        SubsystemDDI.this.mainPanel.refreshPanel();
                    }
                    SubsystemDDI.this.panel = SubsystemDDI.this.mainPanel.getComponent();
                    SubsystemDDI.this.show();
                    guiMain.setSaveActionEnabled(true, false);
                }
            }
        });
    }

    public void panelToBeNulled() {
        this.changesPending();
        this.mainPanel = null;
    }

    void showDetails(int dataRow) {
        GUIStorageSubsystem sys = (GUIStorageSubsystem)this.subsystems.elementAt(dataRow);
        this.mainPanel.showDetails(sys, true);
    }

    public void losingFocus() {
        guiMain.setSaveActionEnabled(false, false);
        guiMain.setSaveActionToolTip(null);
        guiMain.removeSaveActionListener(this);
    }

    public boolean isEditable() {
        return false;
    }

    public boolean changesPending() {
        this.changedDetailsPanels.removeAllElements();
        if (this.mainPanel != null) {
            for (SubsystemDetailsPanel detPanel : this.mainPanel.getAllTabs()) {
                if (!detPanel.hasChanged()) continue;
                this.changedDetailsPanels.addElement(detPanel);
            }
        }
        return !this.changedDetailsPanels.isEmpty();
    }

    public void saveAndClose() {
        for (SubsystemDetailsPanel detPanel : this.changedDetailsPanels) {
            detPanel.saveAll(false);
        }
        this.remove();
    }
}

