/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.system;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.common.ElementManagerHelperInterface;
import org.eclipse.aperi.gui.common.ElementManagerManager;
import org.eclipse.aperi.gui.disk.common.DiskGuiTable;
import org.eclipse.aperi.gui.disk.common.TableCapacityRenderer;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUICapabilityData;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.system.SubsystemDDI;
import org.eclipse.aperi.gui.disk.system.SubsystemTableModel;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskWizard;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeWizard;
import org.eclipse.aperi.gui.disk.volume.VDiskDDI;
import org.eclipse.aperi.gui.disk.volume.VolumeDDI;
import org.eclipse.aperi.request.Response;

public class SubsystemListPanel
extends JPanel
implements TJCTableMouseInterface,
ActionListener {
    private static final String ACTION_VIEW_DETAILS = Util.getString("DISK_VIEW_DETAILS_SUBSYS_LABEL");
    private SubsystemDDI theSSDDI;
    private GUIStorageSubsystem sys;
    private DiskGuiTable table = new DiskGuiTable();
    private SubsystemTableModel tableModel;
    private JButton launchButton = null;
    private JButton createButton = null;
    private JButton createVolButton = null;
    private JButton vdiskButton = null;
    private JButton createVdiskButton = null;
    private JButton removeSubsysButton = null;
    private JButton volButton = null;
    private boolean dblClick = false;
    private static TableCellRenderer drillDownRenderer = new DrillDownRenderer();
    private static TableCellRenderer capacityRenderer = new TableCapacityRenderer();
    private JDialog wizardDialog = null;
    private CreateVolumeWizard crvol = null;
    private JPanel tablePanel = GuiUtil.getPanel();
    private JPanel pb = new JPanel();
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private Capabilities capabilities = this.guiMain.getCapabilities();
    private static ElementManagerHelperInterface elementManagerHelper = new ElementManagerHelperInterface(){

        public String extractGUID(Object element) {
            return "subsystem:" + ((GUIStorageSubsystem)element).getInternalId();
        }

        public String extractDefaultElementManager(Object element) {
            return ((GUIStorageSubsystem)element).getElementManager();
        }

        public String extractDisplayName(Object element) {
            return ((GUIStorageSubsystem)element).getName();
        }
    };

    public SubsystemListPanel(SubsystemDDI ddi) {
        this.theSSDDI = ddi;
    }

    public JComponent getComponent() {
        this.setLayout(new BorderLayout());
        JPanel mainpanel = new JPanel();
        mainpanel.setLayout(new BorderLayout());
        this.volButton = new JButton(Util.getString("DISK_VOLUMES_SUBSYS_BUTTON"));
        this.volButton.setEnabled(false);
        this.volButton.addActionListener(this);
        GuiUtil.setAccessible(this.volButton, this.volButton.getText(), this.volButton.getText());
        this.createButton = new JButton(Util.getString("DISK_CREATEVOLUMES_BUTTON"));
        this.createButton.setEnabled(false);
        this.createButton.addActionListener(this);
        GuiUtil.setAccessible(this.createButton, this.createButton.getText(), this.createButton.getText());
        this.vdiskButton = new JButton(Util.getString("DISK_VDISK_BUTTON"));
        this.vdiskButton.setEnabled(false);
        this.vdiskButton.addActionListener(this);
        GuiUtil.setAccessible(this.vdiskButton, this.vdiskButton.getText(), this.vdiskButton.getText());
        this.createVdiskButton = new JButton(Util.getString("DISK_CREATEVDISK_BUTTON"));
        this.createVdiskButton.setEnabled(false);
        this.createVdiskButton.addActionListener(this);
        GuiUtil.setAccessible(this.createVdiskButton, this.createVdiskButton.getText(), this.createVdiskButton.getText());
        this.removeSubsysButton = new JButton(Util.getString("DISK_REMOVESUBSYS_BUTTON"));
        this.removeSubsysButton.setEnabled(false);
        this.removeSubsysButton.addActionListener(this);
        GuiUtil.setAccessible(this.removeSubsysButton, this.removeSubsysButton.getText(), this.removeSubsysButton.getText());
        this.launchButton = new JButton(Util.getString("DISK_LAUNCHELEMENTMGR_BUTTON"));
        this.launchButton.setEnabled(false);
        this.launchButton.addActionListener(this);
        GuiUtil.setAccessible(this.launchButton, this.launchButton.getText(), this.launchButton.getText());
        JPanel pb_north = new JPanel();
        pb_north.setLayout(new FlowLayout(0));
        pb_north.add(this.volButton);
        pb_north.add(this.createButton);
        pb_north.add(this.vdiskButton);
        pb_north.add(this.createVdiskButton);
        pb_north.add(this.removeSubsysButton);
        JPanel pb_south = new JPanel();
        pb_south.setLayout(new FlowLayout(0));
        pb_south.add(this.launchButton);
        this.pb.setLayout(new BorderLayout());
        this.pb.add((Component)pb_north, "North");
        this.pb.add((Component)pb_south, "South");
        this.tablePanel.setLayout(new GridBagLayout());
        this.tablePanel.setBorder(new TitledBorder(Util.getString("DISK_STORAGESUBSYS_LABEL")));
        GridBagConstraints tgbc = new GridBagConstraints();
        tgbc.gridheight = 0;
        tgbc.insets.bottom = 0;
        tgbc.insets.top = 10;
        tgbc.gridwidth = 1;
        tgbc.anchor = 10;
        tgbc.fill = 1;
        tgbc.weighty = 1.0;
        tgbc.weightx = 0.5;
        tgbc.insets = new Insets(3, 3, 3, 3);
        this.buildTable();
        this.tablePanel.add((Component)this.table, tgbc);
        this.add((Component)mainpanel, "Center");
        mainpanel.add((Component)this.pb, "North");
        mainpanel.add((Component)this.tablePanel, "Center");
        return this;
    }

    public boolean select(int viewRow, int viewCol) {
        boolean selectIt = true;
        if (this.dblClick) {
            this.dblClick = false;
            selectIt = false;
        }
        return selectIt;
    }

    public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
        if (dataRow < 0 || dataCol < 0) {
            return;
        }
        int selectedRow = this.table.getPointedRow(y);
        this.table.setSelectedRows(selectedRow, selectedRow);
        this.selectionChanged(true);
        JPopupMenu menu = new JPopupMenu();
        JMenuItem mi = menu.add(ACTION_VIEW_DETAILS);
        mi.setActionCommand(ACTION_VIEW_DETAILS);
        mi.addActionListener(this);
        mi.setEnabled(true);
        menu.show(c, x, y);
        menu.requestFocus();
    }

    public void selectionChanged(boolean state) {
        if (this.tableModel.getNumRows() == 0) {
            return;
        }
        int[] selectedDataRows = this.table.getSelectedRows();
        try {
            if (selectedDataRows.length > 0 && selectedDataRows[0] != -1) {
                this.sys = (GUIStorageSubsystem)this.theSSDDI.getSubsystems().elementAt(selectedDataRows[0]);
                if (this.sys.getCapabilityData() == null) {
                    DiskDataAccessor.getInstance().getStorageSubsystemCapabilities(new GuiRequestor(){

                        public void handleResponse(short status, Response response) {
                            if (status <= 4) {
                                GUICapabilityData capdata = (GUICapabilityData)response.responseData;
                                if (capdata != null) {
                                    SubsystemListPanel.this.sys.setCapabilities(capdata);
                                }
                                SubsystemListPanel.this.chooseButtons();
                            }
                        }
                    }, this.sys.getId());
                }
                this.chooseButtons();
            } else {
                this.disableAllButtons();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayex) {
            this.disableAllButtons();
            return;
        }
    }

    public void disableAllButtons() {
        this.volButton.setEnabled(false);
        this.createButton.setEnabled(false);
        this.removeSubsysButton.setEnabled(false);
        this.createVdiskButton.setEnabled(false);
        this.vdiskButton.setEnabled(false);
        this.launchButton.setEnabled(false);
    }

    public void chooseButtons() {
        if (this.sys.getType() == 4) {
            if (this.sys.isVolumeCreationSupported() && this.capabilities.isDiskAdmin() && this.sys.getCapabilityData() != null && this.sys.isDetectable()) {
                this.createVdiskButton.setEnabled(true);
            } else {
                this.createVdiskButton.setEnabled(false);
            }
            this.vdiskButton.setEnabled(true);
            this.volButton.setEnabled(false);
            this.createButton.setEnabled(false);
        } else {
            if (this.sys.isVolumeCreationSupported() && this.capabilities.isDiskAdmin() && this.sys.getCapabilityData() != null && this.sys.isDetectable()) {
                this.createButton.setEnabled(true);
            } else {
                this.createButton.setEnabled(false);
            }
            this.volButton.setEnabled(true);
            this.createVdiskButton.setEnabled(false);
            this.vdiskButton.setEnabled(false);
        }
        if (this.capabilities.isDiskAdmin()) {
            this.removeSubsysButton.setEnabled(true);
        } else {
            this.removeSubsysButton.setEnabled(false);
        }
        this.launchButton.setEnabled(ElementManagerManager.getInstance().hasElementManager(this.sys, this.getElementManagerHelper()));
    }

    public void doubleClick(int dataRow, int dataCol) {
        this.dblClick = true;
        this.theSSDDI.showDetails(dataRow);
    }

    public void showDefaultChart(int dataRow) {
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String cmd = e.getActionCommand();
        int[] rows = this.table.getSelectedRows();
        GUIStorageSubsystem[] ss = new GUIStorageSubsystem[rows.length];
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = (GUIStorageSubsystem)this.theSSDDI.getSubsystems().elementAt(rows[i]);
        }
        if (source == this.volButton) {
            VolumeDDI theVolDDI = new VolumeDDI(ss[0]);
            ((DataDisplayInfo)theVolDDI).reDisplay();
        } else if (source == this.createButton) {
            this.openCreateVolumeWizard(ss);
        } else if (source == this.createVdiskButton) {
            this.openCreateVdiskWizard(ss);
        } else if (source == this.removeSubsysButton) {
            this.openSubsysDelete(ss);
        } else if (source == this.launchButton) {
            this.openElementManager(ss);
        } else if (cmd.equals(ACTION_VIEW_DETAILS)) {
            int[] selectedRows = this.table.getSelectedRows();
            if (selectedRows.length > 0) {
                this.theSSDDI.showDetails(selectedRows[0]);
            }
        } else if (source == this.vdiskButton) {
            VDiskDDI theVdDDI = new VDiskDDI(ss[0]);
            ((DataDisplayInfo)theVdDDI).reDisplay();
        }
    }

    public void openSubsysDelete(GUIStorageSubsystem[] sys) {
        int action = JOptionPane.showConfirmDialog(this, Util.getString("DISK_SUBSYSTEMS_DELETE_LABEL", sys[0].getDeviceId()), Util.getString("DISK_SUBSYSTEMS_DELETE_TITLE"), 1);
        switch (action) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                DiskDataAccessor.getInstance().deleteStorageSubsystems(new GuiRequestor(){

                    public void handleResponse(short status, Response response) {
                        if (status <= 4) {
                            int[] rows = SubsystemListPanel.this.table.getSelectedRows();
                            GUIStorageSubsystem[] ss = new GUIStorageSubsystem[rows.length];
                            for (int i = 0; i < ss.length; ++i) {
                                ss[i] = (GUIStorageSubsystem)SubsystemListPanel.this.theSSDDI.getSubsystems().elementAt(rows[i]);
                            }
                            int SSIntId = 0;
                            for (DataDisplayInfo ddi = DataDisplayInfo.getRoot(); ddi != null; ddi = ddi.getNext()) {
                                if (ddi.getDescription() == Util.getString("DISK_VOLUMES_LABEL")) {
                                    SSIntId = ((VolumeDDI)ddi).subsystem.getInternalId();
                                } else if (ddi.getDescription() == Util.getString("DISK_VDISKS_LABEL")) {
                                    SSIntId = ((VDiskDDI)ddi).subsystem.getInternalId();
                                }
                                if (SSIntId != ss[0].getInternalId()) continue;
                                ddi.remove();
                            }
                            SubsystemListPanel.this.theSSDDI.nullOutPanel();
                            SubsystemListPanel.this.theSSDDI.reDisplay();
                        }
                    }
                }, new String[]{sys[0].getId()}, new String[]{String.valueOf(sys[0].getInternalId())});
            }
        }
    }

    public void openCreateVolumeWizard(GUIStorageSubsystem[] ss) {
        this.crvol = new CreateVolumeWizard(ss[0]);
        this.wizardDialog = new JDialog(this.guiMain.getFrame(), Util.getString("DISK_VOLUME_WIZARD_TITLE", ss[0].getDeviceId()), true);
        this.wizardDialog.getContentPane().add(this.crvol);
        this.wizardDialog.setResizable(false);
        this.wizardDialog.pack();
        GuiUtil.centerDialog(this.wizardDialog);
        this.wizardDialog.setDefaultCloseOperation(0);
        this.wizardDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                SubsystemListPanel.this.crvol.cancel();
            }
        });
        this.wizardDialog.show();
    }

    public void openCreateVdiskWizard(GUIStorageSubsystem[] sys) {
        CreateVDiskWizard crvdisk = new CreateVDiskWizard(sys[0]);
        JFrame ff = new JFrame();
        JDialog wizardDialog = new JDialog(this.guiMain.getFrame(), Util.getString("DISK_VDISK_WIZARD_TITLE", sys[0].getDeviceId()), true);
        wizardDialog.getContentPane().add(crvdisk);
        wizardDialog.setResizable(false);
        wizardDialog.pack();
        GuiUtil.centerDialog(wizardDialog);
        wizardDialog.show();
    }

    public void openElementManager(GUIStorageSubsystem[] sys) {
        ElementManagerManager.getInstance().launchElementManager(sys[0], this.getElementManagerHelper());
    }

    public void buildTable() {
        this.table.setMouseListener(this);
        this.tableModel = new SubsystemTableModel(this.theSSDDI);
        this.table.setCellRenderer(JLabel.class, drillDownRenderer);
        this.table.setCellRenderer(Double.class, capacityRenderer);
        this.table.setFrozenColumns(1);
        this.table.setRowIcon(10, true);
        this.table.setSelectionPolicy(0);
        this.table.setBaseTableModel(this.tableModel);
        this.table.sortByColumn(0, 1);
        this.selectionChanged(true);
        this.table.updateUI();
    }

    private ElementManagerHelperInterface getElementManagerHelper() {
        return elementManagerHelper;
    }

    private static class DrillDownRenderer
    extends DefaultTableCellRenderer {
        private DrillDownRenderer() {
        }

        public void setValue(Object o) {
            String str = ((JLabel)o).getText();
            this.setText(str);
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(10);
            Icon icon = ((JLabel)o).getIcon();
            this.setIcon(icon);
        }
    }
}

