/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.disk.common.DiskConstants;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIIOGroup;
import org.eclipse.aperi.gui.disk.common.model.GUIMDiskGroup;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskSelectHostPortsStep;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskWizard;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskZoneActionStep;
import org.eclipse.aperi.request.Response;

public class CreateVDiskReviewStep
extends WizardPage {
    private JLabel titleLabel = null;
    private JTextArea descLabel = null;
    private JLabel quantityLabel = null;
    private JLabel sizeLabel = null;
    private JLabel typeLabel = null;
    private JLabel nameLabel = null;
    private JLabel vdiskListLabel = null;
    private JLabel formatLabel = null;
    private JLabel roundRobinLabel = null;
    private JLabel ioGroupLabel = null;
    private JLabel mdiskGroupLabel = null;
    private JLabel zoneActionLabel = null;
    private JLabel hostPortLabel = null;
    private JLabel ssPortLabel = null;
    private JLabel mdisksLabel = null;
    private JScrollPane mdiskScrollPanel = null;
    private JLabel quantityTextLabel = null;
    private JLabel sizeTextLabel = null;
    private JLabel typeTextLabel = null;
    private JLabel mdiskGroupTextLabel = null;
    private JLabel ioGroupTextLabel = null;
    private JTextArea mdisksTextLabel = null;
    private JLabel nameTextLabel = null;
    private JLabel formatTextLabel = null;
    private JLabel roundRobinTextLabel = null;
    private JList vdiskList = null;
    private JList zoneActionList = null;
    private JList hostPortList = null;
    private JList ssPortList = null;
    private DefaultListModel vdiskListModel = null;
    private DefaultListModel zoneActionListModel = null;
    private DefaultListModel hostPortListModel = null;
    private DefaultListModel ssPortListModel = null;
    private CreateVDiskWizard cvWizard = null;
    private HashMap vdiskData = null;
    private int width = -1;
    private int height = -1;
    private boolean isHelpSet = false;
    private String subsystemID;
    private HashMap vdisksmap = new HashMap();
    private boolean isData = false;
    private Vector vdiskNameList = new Vector();

    public CreateVDiskReviewStep(int buttonFlags, String SVC_ID) {
        super(buttonFlags);
        this.subsystemID = SVC_ID;
        this.setName("CreateVDiskReviewStep");
        Container pane = this.getContentPane();
        pane.add(this.create());
        this.setUpHelp(DiskConstants.DISK_CREATE_VDISK_REVIEW);
    }

    public Object next() {
        return null;
    }

    public Component create() {
        GridBagPanel tempPanel = new GridBagPanel();
        tempPanel.setDefaultInsets(new Insets(0, 12, 0, 8));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        this.titleLabel = new JLabel(Util.getString("DISK_VDISK_REVIEW_SETTINGS_LABEL"));
        this.titleLabel.setAlignmentX(0.0f);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 2, 5));
        titlePanel.add(this.titleLabel);
        titlePanel.add(Box.createHorizontalGlue());
        Font font = this.titleLabel.getFont();
        GuiUtil.setAccessible(this.titleLabel, this.titleLabel.getText(), this.titleLabel.getText());
        this.titleLabel.setFont(font.deriveFont(1));
        tempPanel.add((JComponent)titlePanel, 23);
        tempPanel.newRow();
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BoxLayout(descPanel, 0));
        this.descLabel = new JTextArea(Util.getString("DISK_VDISK_REVIEW_SETTINGS_DESC_LABEL"));
        this.descLabel.setEditable(false);
        this.descLabel.setLineWrap(true);
        this.descLabel.setWrapStyleWord(true);
        this.descLabel.setBackground((Color)UIManager.get("Label.background"));
        this.descLabel.setForeground((Color)UIManager.get("Label.foreground"));
        this.descLabel.setFont((Font)UIManager.get("Label.font"));
        this.descLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        descPanel.add(this.descLabel);
        tempPanel.add((JComponent)descPanel, 0, 1, 2);
        tempPanel.newRow();
        GridBagConstraints con = new GridBagConstraints();
        con.anchor = 17;
        con.insets = new Insets(1, 1, 1, 1);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 1;
        con.gridheight = 1;
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new GridBagLayout());
        this.quantityLabel = new JLabel(Util.getString("DISK_VDISK_QUANTITY_LABEL"));
        this.quantityTextLabel = new JLabel();
        con.gridx = 0;
        textPanel.add((Component)this.quantityLabel, con);
        this.quantityLabel.setAlignmentX(1.0f);
        con.gridx = 1;
        textPanel.add((Component)this.quantityTextLabel, con);
        this.quantityTextLabel.setAlignmentX(0.0f);
        this.sizeLabel = new JLabel(Util.getString("DISK_VDISK_SIZE_LABEL"));
        this.sizeTextLabel = new JLabel();
        con.gridx = 0;
        ++con.gridy;
        textPanel.add((Component)this.sizeLabel, con);
        this.sizeLabel.setAlignmentX(1.0f);
        con.gridx = 1;
        textPanel.add((Component)this.sizeTextLabel, con);
        this.sizeTextLabel.setAlignmentX(0.0f);
        this.ioGroupLabel = new JLabel(Util.getString("DISK_VDISK_IOGROUP_LABEL"));
        this.ioGroupTextLabel = new JLabel();
        con.gridx = 0;
        ++con.gridy;
        textPanel.add((Component)this.ioGroupLabel, con);
        this.ioGroupLabel.setAlignmentX(1.0f);
        con.gridx = 1;
        textPanel.add((Component)this.ioGroupTextLabel, con);
        this.ioGroupTextLabel.setAlignmentX(0.0f);
        this.mdiskGroupLabel = new JLabel(Util.getString("DISK_VDISK_MDGROUP_LABEL"));
        this.mdiskGroupTextLabel = new JLabel();
        con.gridx = 0;
        ++con.gridy;
        textPanel.add((Component)this.mdiskGroupLabel, con);
        this.mdiskGroupLabel.setAlignmentX(1.0f);
        con.gridx = 1;
        textPanel.add((Component)this.mdiskGroupTextLabel, con);
        this.mdiskGroupTextLabel.setAlignmentX(0.0f);
        this.typeLabel = new JLabel(Util.getString("DISK_TYPE_LABEL"));
        this.typeTextLabel = new JLabel();
        con.gridx = 0;
        ++con.gridy;
        textPanel.add((Component)this.typeLabel, con);
        this.typeLabel.setAlignmentX(1.0f);
        con.gridx = 1;
        textPanel.add((Component)this.typeTextLabel, con);
        this.typeTextLabel.setAlignmentX(0.0f);
        this.nameLabel = new JLabel(Util.getString("DISK_VDISK_NAME_PREFIX_LABEL"));
        this.nameTextLabel = new JLabel();
        con.gridx = 0;
        ++con.gridy;
        textPanel.add((Component)this.nameLabel, con);
        this.nameLabel.setAlignmentX(1.0f);
        con.gridx = 1;
        textPanel.add((Component)this.nameTextLabel, con);
        this.nameTextLabel.setAlignmentX(0.0f);
        this.formatLabel = new JLabel(Util.getString("DISK_VDISK_FORMAT_LABEL"));
        this.formatTextLabel = new JLabel();
        con.gridx = 0;
        ++con.gridy;
        textPanel.add((Component)this.formatLabel, con);
        this.formatLabel.setAlignmentX(1.0f);
        con.gridx = 1;
        textPanel.add((Component)this.formatTextLabel, con);
        this.formatTextLabel.setAlignmentX(0.0f);
        this.roundRobinLabel = new JLabel(Util.getString("DISK_VDISK_ROUNDROBIN_LABEL"));
        this.roundRobinTextLabel = new JLabel();
        con.gridx = 0;
        ++con.gridy;
        textPanel.add((Component)this.roundRobinLabel, con);
        this.roundRobinLabel.setAlignmentX(1.0f);
        con.gridx = 1;
        textPanel.add((Component)this.roundRobinTextLabel, con);
        this.roundRobinTextLabel.setAlignmentX(0.0f);
        this.mdisksLabel = new JLabel(Util.getString("DISK_VDISK_MANAGED_DISK_LABEL"));
        this.mdisksTextLabel = new JTextArea();
        this.mdisksTextLabel.setEditable(false);
        this.mdisksTextLabel.setLineWrap(true);
        this.mdisksTextLabel.setWrapStyleWord(true);
        this.mdisksTextLabel.setBackground((Color)UIManager.get("Label.background"));
        this.mdisksTextLabel.setForeground((Color)UIManager.get("Label.foreground"));
        this.mdisksTextLabel.setFont((Font)UIManager.get("Label.font"));
        this.mdiskScrollPanel = new JScrollPane(this.mdisksTextLabel);
        this.width = 16 * this.mdisksTextLabel.getFontMetrics(this.getFont()).charWidth(0);
        this.height = this.mdisksTextLabel.getFontMetrics(this.getFont()).getHeight() + 5;
        this.mdiskScrollPanel.setPreferredSize(new Dimension(this.width, this.height));
        con.gridx = 0;
        ++con.gridy;
        textPanel.add((Component)this.mdisksLabel, con);
        this.mdisksLabel.setAlignmentX(1.0f);
        con.gridx = 1;
        textPanel.add((Component)this.mdiskScrollPanel, con);
        this.mdisksTextLabel.setAlignmentX(0.0f);
        tempPanel.add(textPanel);
        tempPanel.newRow();
        JPanel vdiskListPanel = new JPanel();
        JPanel vdiskLabelPanel = new JPanel();
        vdiskLabelPanel.setLayout(new BoxLayout(vdiskLabelPanel, 0));
        this.vdiskListLabel = new JLabel(Util.getString("DISK_VDISK_CREATE_VDISK_LABEL"));
        vdiskLabelPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        vdiskLabelPanel.add(this.vdiskListLabel);
        vdiskLabelPanel.add(Box.createHorizontalGlue());
        vdiskListPanel.setLayout(new BoxLayout(vdiskListPanel, 0));
        this.vdiskList = new JList();
        JScrollPane vdiskScrollPanel = new JScrollPane(this.vdiskList);
        vdiskListPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        vdiskListPanel.add(vdiskScrollPanel);
        tempPanel.add(vdiskLabelPanel);
        tempPanel.newRow();
        tempPanel.add((JComponent)vdiskListPanel, 0, 1, 2);
        tempPanel.newRow();
        this.width = 16 * this.vdiskList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.vdiskList.getFontMetrics(this.getFont()).getHeight() + 4) * 3;
        vdiskListPanel.setMinimumSize(new Dimension(this.width, this.height));
        vdiskListPanel.setPreferredSize(new Dimension(this.width, this.height));
        vdiskListPanel.setMaximumSize(new Dimension(this.width * 2, this.height));
        vdiskListPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.vdiskList.setSelectionMode(0);
        GuiUtil.setAccessibleLabel(this.vdiskListLabel, this.vdiskList, "", this.vdiskListLabel.getText(), this.vdiskListLabel.getText());
        JPanel zoneListPanel = new JPanel();
        JPanel zoneLabelPanel = new JPanel();
        zoneLabelPanel.setLayout(new BoxLayout(zoneLabelPanel, 0));
        this.zoneActionLabel = new JLabel(Util.getString("DISK_ZONE_ACTIONS_LABEL"));
        zoneLabelPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        zoneLabelPanel.add(this.zoneActionLabel);
        zoneLabelPanel.add(Box.createHorizontalGlue());
        zoneListPanel.setLayout(new BoxLayout(zoneListPanel, 0));
        this.zoneActionList = new JList();
        JScrollPane zoneScrollPanel = new JScrollPane(this.zoneActionList);
        zoneListPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        zoneListPanel.add(zoneScrollPanel);
        tempPanel.add(zoneLabelPanel);
        tempPanel.newRow();
        tempPanel.add((JComponent)zoneListPanel, 0, 1, 2);
        tempPanel.newRow();
        this.width = 16 * this.zoneActionList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.zoneActionList.getFontMetrics(this.getFont()).getHeight() + 4) * 3;
        zoneListPanel.setMinimumSize(new Dimension(this.width, this.height));
        zoneListPanel.setPreferredSize(new Dimension(this.width, this.height));
        zoneListPanel.setMaximumSize(new Dimension(this.width * 2, this.height));
        zoneListPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GuiUtil.setAccessibleLabel(this.zoneActionLabel, this.zoneActionList, "", this.zoneActionLabel.getText(), this.zoneActionLabel.getText());
        JPanel portListPanel = new JPanel();
        JPanel portLabelPanel = new JPanel();
        portLabelPanel.setLayout(new BoxLayout(portLabelPanel, 0));
        this.hostPortLabel = new JLabel(Util.getString("DISK_HOSTPORTS_LABEL"));
        portLabelPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        portLabelPanel.add(this.hostPortLabel);
        portLabelPanel.add(Box.createHorizontalGlue());
        portListPanel.setLayout(new BoxLayout(portListPanel, 0));
        this.hostPortList = new JList();
        JScrollPane portScrollPanel = new JScrollPane(this.hostPortList);
        portListPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        portListPanel.add(portScrollPanel);
        tempPanel.add(portLabelPanel);
        tempPanel.newRow();
        tempPanel.add((JComponent)portListPanel, 0, 1, 2);
        tempPanel.newRow();
        this.width = 16 * this.hostPortList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.hostPortList.getFontMetrics(this.getFont()).getHeight() + 4) * 3;
        portListPanel.setMinimumSize(new Dimension(this.width, this.height));
        portListPanel.setPreferredSize(new Dimension(this.width, this.height));
        portListPanel.setMaximumSize(new Dimension(this.width * 2, this.height));
        portListPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GuiUtil.setAccessibleLabel(this.hostPortLabel, this.hostPortList, "", this.hostPortLabel.getText(), this.hostPortLabel.getText());
        JPanel ssportListPanel = new JPanel();
        JPanel ssportLabelPanel = new JPanel();
        ssportLabelPanel.setLayout(new BoxLayout(ssportLabelPanel, 0));
        this.ssPortLabel = new JLabel(Util.getString("DISK_SUBSYSTEMPORTS_LABEL"));
        ssportLabelPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        ssportLabelPanel.add(this.ssPortLabel);
        ssportLabelPanel.add(Box.createHorizontalGlue());
        ssportListPanel.setLayout(new BoxLayout(ssportListPanel, 0));
        this.ssPortList = new JList();
        JScrollPane ssportScrollPanel = new JScrollPane(this.ssPortList);
        ssportListPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        ssportListPanel.add(ssportScrollPanel);
        tempPanel.add(ssportLabelPanel);
        tempPanel.newRow();
        tempPanel.add((JComponent)ssportListPanel, 0, 1, 2);
        tempPanel.newRow();
        GuiUtil.setAccessibleLabel(this.ssPortLabel, this.ssPortList, "", this.ssPortLabel.getText(), this.ssPortLabel.getText());
        this.width = 16 * this.ssPortList.getFontMetrics(this.getFont()).charWidth(0) * 2;
        this.height = (this.ssPortList.getFontMetrics(this.getFont()).getHeight() + 4) * 3;
        ssportListPanel.setMinimumSize(new Dimension(this.width, this.height));
        ssportListPanel.setPreferredSize(new Dimension(this.width, this.height));
        ssportListPanel.setMaximumSize(new Dimension(this.width * 2, this.height));
        ssportListPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.cvWizard = (CreateVDiskWizard)this.getParent();
        this.getNextButton().setEnabled(false);
        this.getExistingVDisks();
        tempPanel.add((JComponent)new JLabel(), 1);
        return tempPanel;
    }

    public void fillData() {
        this.cvWizard = (CreateVDiskWizard)this.getParent();
        if (this.isData) {
            return;
        }
        this.vdiskData = this.cvWizard.getData();
        this.quantityTextLabel.setText(this.vdiskData.get(Util.getString("DISK_VDISK_QUANTITY_LABEL")).toString());
        this.sizeTextLabel.setText(this.vdiskData.get(Util.getString("DISK_VDISK_SIZE_LABEL")).toString() + " " + this.vdiskData.get(Util.getString("DISK_UNITS_LABEL")).toString());
        this.typeTextLabel.setText(this.vdiskData.get(Util.getString("DISK_TYPE_LABEL")).toString());
        String vName = this.vdiskData.get(Util.getString("DISK_VDISK_NAME_LABEL")).toString();
        if (vName.length() <= 0) {
            vName = Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL");
        }
        this.nameTextLabel.setText(vName);
        GUIIOGroup tempio = (GUIIOGroup)this.vdiskData.get(Util.getString("DISK_VDISK_IOGROUP_LABEL"));
        if (tempio == null) {
            this.ioGroupTextLabel.setText(Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL"));
        } else {
            this.ioGroupTextLabel.setText(tempio.toString());
        }
        GUIMDiskGroup mdg = (GUIMDiskGroup)this.vdiskData.get(Util.getString("DISK_VDISK_MDGROUP_LABEL"));
        this.mdiskGroupTextLabel.setText(mdg.getDeviceId());
        this.formatTextLabel.setText(this.vdiskData.get(Util.getString("DISK_VDISK_FORMAT_LABEL")).toString());
        this.roundRobinTextLabel.setText(this.vdiskData.get(Util.getString("DISK_VDISK_ROUNDROBIN_LABEL")).toString());
        Vector mdisks = (Vector)this.vdiskData.get(Util.getString("DISK_VDISK_MDISKS_LABEL"));
        String mdiskString = new String();
        if (mdisks != null && mdisks.size() > 0) {
            for (int i = 0; i < mdisks.size(); ++i) {
                mdiskString = mdiskString + mdisks.get(i) + ", ";
            }
            int ii = mdiskString.lastIndexOf(",");
            mdiskString = mdiskString.substring(0, ii);
        }
        this.mdisksTextLabel.setText(mdiskString);
        if (this.typeTextLabel.getText().equals(Util.getString("DISK_STRIPED_LABEL"))) {
            mdisks = new Vector();
        }
        Vector vdiskNames = this.generateVDiskList(this.nameTextLabel.getText(), Integer.valueOf(this.quantityTextLabel.getText()), mdisks);
        if (this.vdiskNameList.size() == 1) {
            this.nameTextLabel.setText(vdiskNames.get(0).toString());
        }
        if (this.vdiskNameList.size() == 0) {
            this.vdiskNameList = null;
        }
        this.cvWizard.addVDiskData(Util.getString("DISK_VDISK_CREATE_VDISK_LABEL"), this.vdiskNameList);
        this.vdiskListModel = this.addVectorToModel(vdiskNames);
        this.vdiskList.setModel(this.vdiskListModel);
        Vector hostports = (Vector)this.vdiskData.get(CreateVDiskSelectHostPortsStep.HOSTPORTS_DATA);
        Vector<String> hostportString = new Vector<String>();
        GUIPort port = null;
        String portname = new String();
        String hostname = new String();
        for (int i = 0; hostports != null && i < hostports.size(); ++i) {
            try {
                port = (GUIPort)hostports.get(i);
            }
            catch (ClassCastException ce) {
                port = null;
            }
            if (port != null) {
                portname = port.getWwpn();
                hostname = port.getHostName();
                if (hostname != null && hostname.trim().length() > 0) {
                    portname = portname + " (" + hostname + ")";
                }
                hostportString.add(portname);
                continue;
            }
            hostportString.add((String)hostports.get(i));
        }
        this.hostPortListModel = this.addVectorToModel(hostportString);
        this.hostPortList.setModel(this.hostPortListModel);
        HashMap zoneAction = (HashMap)this.vdiskData.get(CreateVDiskZoneActionStep.ZONE_LIST_DATA);
        Vector<Object> zoneVector = new Vector();
        if (zoneAction != null) {
            zoneVector = new Vector(zoneAction.values());
        }
        this.zoneActionListModel = this.addVectorToModel(zoneVector);
        this.zoneActionList.setModel(this.zoneActionListModel);
        Vector sshostports = (Vector)this.vdiskData.get(CreateVDiskSelectHostPortsStep.SUBSYSTEM_DATA);
        Vector<String> sshostportString = new Vector<String>();
        port = null;
        for (int i = 0; sshostports != null && i < sshostports.size(); ++i) {
            port = (GUIPort)sshostports.get(i);
            portname = port.getWwpn();
            hostname = port.getHostName();
            if (hostname != null && hostname.trim().length() > 0) {
                portname = portname + " (" + hostname + ")";
            }
            sshostportString.add(portname);
        }
        this.ssPortListModel = this.addVectorToModel(sshostportString);
        this.ssPortList.setModel(this.ssPortListModel);
        this.isData = true;
    }

    public boolean previousBegin() {
        this.isData = false;
        return true;
    }

    private Vector generateVDiskList(String prefix, int vdiskNo, Vector mdisks) {
        Vector<String> vdiskList = new Vector<String>();
        this.vdiskNameList = new Vector();
        if (prefix.length() == 0) {
            vdiskList.add(Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL"));
            return vdiskList;
        }
        String vdiskName = new String();
        int ipostfix = 0;
        if (vdiskNo == 1) {
            vdiskName = prefix;
            while (this.vdisksmap.get(vdiskName) != null) {
                vdiskName = prefix + ++ipostfix;
            }
            if (mdisks.size() > 0) {
                vdiskList.add(vdiskName + " (" + mdisks.get(0) + ")");
            } else {
                vdiskList.add(vdiskName);
            }
            if (!prefix.equals(Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL"))) {
                this.vdiskNameList.add(vdiskName);
            }
            return vdiskList;
        }
        String mdiskName = new String();
        ipostfix = 1;
        if (mdisks.size() > 0) {
            if (mdisks.size() == 1) {
                mdiskName = mdisks.get(0).toString();
                for (int i = 0; i < vdiskNo; ++i) {
                    vdiskName = prefix + ipostfix;
                    while (this.vdisksmap.get(vdiskName) != null) {
                        vdiskName = prefix + ++ipostfix;
                    }
                    vdiskList.add(vdiskName + " (" + mdiskName + ")");
                    this.vdiskNameList.add(vdiskName);
                    vdiskName = prefix + ++ipostfix;
                }
            } else {
                for (int i = 0; i < vdiskNo; ++i) {
                    vdiskName = prefix + ipostfix;
                    while (this.vdisksmap.get(vdiskName) != null) {
                        vdiskName = prefix + ++ipostfix;
                    }
                    vdiskList.add(vdiskName + " (" + mdisks.get(i) + ")");
                    this.vdiskNameList.add(vdiskName);
                    vdiskName = prefix + ++ipostfix;
                }
            }
        } else {
            for (int i = 0; i < vdiskNo; ++i) {
                vdiskName = prefix + ipostfix;
                while (this.vdisksmap.get(vdiskName) != null) {
                    vdiskName = prefix + ++ipostfix;
                }
                vdiskList.add(vdiskName);
                this.vdiskNameList.add(vdiskName);
                vdiskName = prefix + ++ipostfix;
            }
        }
        if (prefix.equals(Util.getString("DISK_VDISK_CREATE_IOGROUP_SYSTEM_LABEL"))) {
            this.vdiskNameList = new Vector();
        }
        return vdiskList;
    }

    private void getExistingVDisks() {
        DiskDataAccessor diskAccessor = DiskDataAccessor.getInstance();
        diskAccessor.getVolumeNamesBySubsystem(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4 && response != null) {
                    String[] vNames = (String[])response.responseData;
                    CreateVDiskReviewStep.this.vdisksmap = new HashMap();
                    for (int i = 0; vNames != null && i < vNames.length; ++i) {
                        CreateVDiskReviewStep.this.vdisksmap.put(vNames[i], vNames[i]);
                    }
                }
            }
        }, this.subsystemID);
    }

    private DefaultListModel addVectorToModel(Vector vv) {
        DefaultListModel model = new DefaultListModel();
        if (vv == null) {
            return model;
        }
        for (int i = 0; i < vv.size(); ++i) {
            model.add(i, vv.get(i));
        }
        return model;
    }
}

