/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.disk.api.VolumeID;
import org.eclipse.aperi.gui.GuiDeviceJob;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.Wizard;
import org.eclipse.aperi.gui.WizardEvent;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.DiskDataController;
import org.eclipse.aperi.gui.disk.common.model.GUIIOGroup;
import org.eclipse.aperi.gui.disk.common.model.GUIMDisk;
import org.eclipse.aperi.gui.disk.common.model.GUIMDiskGroup;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.volume.BaseZoneActionStep;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskReviewStep;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskSelectHostPortsStep;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskSetCharacteristicsStep;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskZoneActionStep;
import org.eclipse.aperi.request.Response;

public class CreateVDiskWizard
extends Wizard {
    private CreateVDiskSetCharacteristicsStep charStep = null;
    private CreateVDiskSelectHostPortsStep hostStep = null;
    private CreateVDiskZoneActionStep zoneStep = null;
    private CreateVDiskReviewStep reviewStep = null;
    private String SVC_ID = null;
    private String deviceID = null;
    private HashMap vdiskData = null;
    private Vector volumeVector = new Vector();
    private Vector hostports = new Vector();
    private Vector ssports = new Vector();
    private String[] hostportWWPNs = null;
    private String[] ssportWWPNs = null;
    private String[] volumeIDs = null;
    private GUIStorageSubsystem subSystem = null;
    private String[] vdiskTypes = new String[]{Util.getString("DISK_VDISK_TYPE_STRIPED"), Util.getString("DISK_VDISK_TYPE_SEQUENTIAL")};
    private int WIZARD_FLAGS = 31;
    private DiskDataController diskController = null;
    private HashMap unitsMap = new HashMap();
    private JDialog wizardDialog = null;

    public CreateVDiskWizard(GUIStorageSubsystem ss) {
        this.subSystem = ss;
        this.SVC_ID = this.subSystem.getId();
        this.deviceID = this.subSystem.getDeviceId();
        this.addWizardListener(this);
        this.vdiskData = new HashMap();
        this.charStep = new CreateVDiskSetCharacteristicsStep(this.WIZARD_FLAGS, this.SVC_ID);
        this.add(this.charStep);
        this.hostStep = new CreateVDiskSelectHostPortsStep(this.WIZARD_FLAGS, this.subSystem);
        this.add(this.hostStep);
        this.zoneStep = new CreateVDiskZoneActionStep(this.WIZARD_FLAGS, this.SVC_ID);
        this.add(this.zoneStep);
        this.reviewStep = new CreateVDiskReviewStep(this.WIZARD_FLAGS, this.SVC_ID);
        this.add(this.reviewStep);
        this.unitsMap.put(Util.getString("DISK_BYTES"), "0");
        this.unitsMap.put(Util.getString("DISK_KB"), "1");
        this.unitsMap.put(Util.getString("DISK_MB"), "2");
        this.unitsMap.put(Util.getString("DISK_GB"), "3");
        this.unitsMap.put(Util.getString("DISK_TB"), "4");
        this.unitsMap.put(Util.getString("DISK_PB"), "5");
    }

    public WizardPage getCurrentStep() {
        return (WizardPage)this.getCurrentPage();
    }

    public void addVDiskData(String key, Object data) {
        this.vdiskData.put(key, data);
    }

    public HashMap getData() {
        return this.vdiskData;
    }

    public CreateVDiskSelectHostPortsStep getHostPortsStep() {
        return this.hostStep;
    }

    public void nextBegin(WizardEvent e) {
        e.setAllowChange(((WizardPage)e.getCurrentPage()).nextBegin());
        if ((WizardPage)e.getCurrentPage() == this.hostStep) {
            if (this.hostStep.skipSubsystemStep()) {
                e.setNewPage(this.zoneStep);
            } else if (this.hostStep.skipToReviewStep()) {
                e.setNewPage(this.reviewStep);
            }
        }
    }

    public void nextComplete(WizardEvent e) {
        e.setAllowChange(((WizardPage)e.getCurrentPage()).nextComplete());
        if ((WizardPage)e.getNewPage() == this.reviewStep) {
            this.reviewStep.fillData();
        }
        if ((WizardPage)e.getNewPage() == this.zoneStep) {
            this.zoneStep.fillData();
        }
    }

    public void previousBegin(WizardEvent e) {
        e.setAllowChange(((WizardPage)e.getCurrentPage()).previousBegin());
        if ((WizardPage)e.getCurrentPage() == this.reviewStep) {
            if (this.hostStep.skipSubsystemStep()) {
                e.setNewPage(this.zoneStep);
            } else if (this.hostStep.skipToReviewStep()) {
                e.setNewPage(this.hostStep);
            }
        }
    }

    public void finished(WizardEvent e) {
        super.finished(e);
        if (((WizardPage)e.getCurrentPage()).equals(this.reviewStep)) {
            String s = Util.getString("DISK_VDISK_WIZARD_FINISHED");
            JOptionPane.showMessageDialog(this, s, Util.getString("DISK_CREATE_VDISK_WIZARD_LABEL", this.deviceID), 1);
            this.closeWizard();
            new VDiskThread(this).start();
        }
    }

    public void canceled(WizardEvent e) {
        int action = JOptionPane.showConfirmDialog(this, Util.getString("DISK_VDISK_WIZARD_CANCELED"), Util.getString("DISK_VDISK_WIZARD_TITLE", this.deviceID), 0);
        switch (action) {
            case 0: {
                super.canceled(e);
                this.closeWizard();
                break;
            }
        }
    }

    private void closeWizard() {
        this.wizardDialog = (JDialog)this.getParent().getParent().getParent().getParent();
        this.wizardDialog.dispose();
    }

    static /* synthetic */ String[] access$702(CreateVDiskWizard x0, String[] x1) {
        x0.hostportWWPNs = x1;
        return x1;
    }

    static /* synthetic */ String[] access$902(CreateVDiskWizard x0, String[] x1) {
        x0.ssportWWPNs = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1102(CreateVDiskWizard x0, String[] x1) {
        x0.volumeIDs = x1;
        return x1;
    }

    public class VDiskJobResultThread
    extends JobResultThread {
        public VDiskJobResultThread(int jobID) {
            super(jobID);
        }

        public void run() {
            Response jobStatusResponse = GuiDeviceJob.getJobStatus(this.jobID, true);
            if (jobStatusResponse != null) {
                int i;
                AsyncResult result = (AsyncResult)jobStatusResponse.responseData;
                if (result != null) {
                    AsyncResult[] subResults = result.getSubJobResults();
                    for (int i2 = 0; i2 < subResults.length; ++i2) {
                        Exception tpcEx = subResults[i2].getReturnException();
                        if (tpcEx != null) {
                            String errorMsg = tpcEx.getMessage();
                            if (tpcEx instanceof SRMRuntimeException) {
                                errorMsg = ((SRMRuntimeException)tpcEx).getLocalizedMessage();
                            }
                            if (errorMsg != null) {
                                // empty if block
                            }
                        }
                        if (subResults[i2] == null || subResults[i2].getResults() == null || subResults[i2].getRc() > 0) continue;
                        VolumeID[] volumeIds = (VolumeID[])subResults[i2].getResults();
                        CreateVDiskWizard.this.volumeVector.add(volumeIds[0].getStorageVolumeID());
                    }
                }
                CreateVDiskWizard.access$702(CreateVDiskWizard.this, new String[CreateVDiskWizard.this.hostports.size()]);
                for (i = 0; i < CreateVDiskWizard.this.hostports.size(); ++i) {
                    ((CreateVDiskWizard)CreateVDiskWizard.this).hostportWWPNs[i] = ((GUIPort)CreateVDiskWizard.this.hostports.get(i)).getWwpn();
                }
                if (CreateVDiskWizard.this.subSystem.isTargetPortRestrictionSupported() && 4 != CreateVDiskWizard.this.subSystem.getCapabilityData().getPortsPerView() && CreateVDiskWizard.this.ssports != null) {
                    CreateVDiskWizard.access$902(CreateVDiskWizard.this, new String[CreateVDiskWizard.this.ssports.size()]);
                    for (i = 0; i < CreateVDiskWizard.this.ssports.size(); ++i) {
                        ((CreateVDiskWizard)CreateVDiskWizard.this).ssportWWPNs[i] = ((GUIPort)CreateVDiskWizard.this.ssports.get(i)).getWwpn();
                    }
                } else {
                    CreateVDiskWizard.access$902(CreateVDiskWizard.this, null);
                }
                CreateVDiskWizard.access$1102(CreateVDiskWizard.this, CreateVDiskWizard.this.volumeVector.toArray(new String[0]));
                if (CreateVDiskWizard.this.hostportWWPNs.length > 0 && CreateVDiskWizard.this.volumeIDs.length > 0) {
                    CreateVDiskWizard.this.diskController.assignPorts(new GuiRequestor(){

                        public void handleResponse(short status, Response response) {
                            if (status <= 4) {
                                int jobID = (Integer)response.responseData;
                                new JobResultThread(jobID).start();
                            }
                        }
                    }, CreateVDiskWizard.this.volumeIDs, CreateVDiskWizard.this.ssportWWPNs, CreateVDiskWizard.this.hostportWWPNs);
                }
            }
        }
    }

    public class JobResultThread
    extends Thread {
        protected int jobID = 0;
        protected String fabricID = null;

        public JobResultThread(int jobID) {
            this.jobID = jobID;
        }

        public JobResultThread(int jobID, String fabricID) {
            this.jobID = jobID;
            this.fabricID = fabricID;
        }

        public void run() {
            AsyncResult result;
            Response jobStatusResponse = GuiDeviceJob.getJobStatus(this.jobID, true);
            if (this.fabricID != null) {
                AsyncResult result2;
                boolean errorOccured = false;
                if (jobStatusResponse != null && (result2 = (AsyncResult)jobStatusResponse.responseData) != null && (result2.getReturnException() != null || result2.getRc() > 0)) {
                    errorOccured = true;
                }
                if (errorOccured) {
                    CreateVDiskWizard.this.diskController.rollbackFabricTransaction(new GuiRequestor(){

                        public void handleResponse(short status, Response response) {
                        }
                    }, this.fabricID);
                } else {
                    CreateVDiskWizard.this.diskController.releaseFabric(new GuiRequestor(){

                        public void handleResponse(short status, Response response) {
                        }
                    }, this.fabricID);
                }
            }
            if (jobStatusResponse != null && (result = (AsyncResult)jobStatusResponse.responseData) != null) {
                AsyncResult[] subResults = result.getSubJobResults();
                for (int i = 0; subResults != null && i < subResults.length; ++i) {
                    Exception tpcEx = subResults[i].getReturnException();
                    if (tpcEx != null) {
                        String errorMsg = tpcEx.getMessage();
                        if (tpcEx instanceof SRMRuntimeException) {
                            errorMsg = ((SRMRuntimeException)tpcEx).getLocalizedMessage();
                        }
                        if (errorMsg != null) {
                            // empty if block
                        }
                    }
                    if (subResults[i] == null || subResults[i].getResults() == null || subResults[i].getRc() > 0) continue;
                    Object[] retvals = subResults[i].getResults();
                }
            }
        }
    }

    public class ZoneRequestor
    implements GuiRequestor {
        String fabricID = null;

        public ZoneRequestor(String fabricID) {
            this.fabricID = fabricID;
        }

        public void handleResponse(short status, Response response) {
            if (status <= 4) {
                int jobID = (Integer)response.responseData;
                new JobResultThread(jobID, this.fabricID).start();
            }
        }
    }

    private class VDiskThread
    extends Thread {
        private CreateVDiskWizard wizard;

        public VDiskThread(CreateVDiskWizard cvWizard) {
            this.wizard = cvWizard;
        }

        public void run() {
            this.createVDisks();
        }

        private void createVDisks() {
            int i;
            int vdiskQuantity = -1;
            long size = -1L;
            String units = new String();
            int vdiskType = -1;
            Vector vdiskList = new Vector();
            boolean format = false;
            int iogroupID = -1;
            String mdiskGroupID = new String();
            boolean roundrobin = false;
            CreateVDiskWizard.this.wizardDialog = (JDialog)this.wizard.getParent().getParent().getParent().getParent();
            CreateVDiskWizard.this.diskController = DiskDataController.getInstance();
            vdiskQuantity = Integer.valueOf(CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_VDISK_QUANTITY_LABEL")).toString());
            size = Long.valueOf(CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_VDISK_SIZE_LABEL")).toString());
            units = CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_UNITS_LABEL")).toString();
            units = (String)CreateVDiskWizard.this.unitsMap.get(units);
            size = GUIEntityUtil.convertStorageCapacity(size, Integer.valueOf(units), 0);
            String typeString = CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_TYPE_LABEL")).toString();
            vdiskType = typeString.equals(CreateVDiskWizard.this.vdiskTypes[1]) ? 1 : 0;
            vdiskList = (Vector)CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_VDISK_CREATE_VDISK_LABEL"));
            String[] vdiskNames = vdiskList != null ? vdiskList.toArray(new String[0]) : null;
            format = Boolean.valueOf(CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_VDISK_FORMAT_LABEL")).toString());
            GUIIOGroup tempio = (GUIIOGroup)CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_VDISK_IOGROUP_LABEL"));
            if (tempio != null) {
                iogroupID = Integer.valueOf(tempio.getId());
            }
            Vector mdisks = (Vector)CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_VDISK_MDISKS_LABEL"));
            Vector<String> mdiskids = new Vector<String>();
            roundrobin = Boolean.valueOf(CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_VDISK_ROUNDROBIN_LABEL")).toString());
            if (vdiskType == 1 && !roundrobin) {
                if (!roundrobin) {
                    String mdiskid = ((GUIMDisk)mdisks.get(0)).getId();
                    for (i = 0; i < vdiskQuantity; ++i) {
                        mdiskids.add(mdiskid);
                    }
                }
            } else {
                for (int i2 = 0; i2 < mdisks.size(); ++i2) {
                    mdiskids.add(((GUIMDisk)mdisks.get(i2)).getId());
                }
            }
            String[] mdiskIDs = mdiskids.toArray(new String[0]);
            GUIMDiskGroup tempmdg = (GUIMDiskGroup)CreateVDiskWizard.this.vdiskData.get(Util.getString("DISK_VDISK_MDGROUP_LABEL"));
            mdiskGroupID = tempmdg != null ? tempmdg.getId() : null;
            CreateVDiskWizard.this.hostports = (Vector)CreateVDiskWizard.this.vdiskData.get(CreateVDiskSelectHostPortsStep.HOSTPORTS_DATA);
            CreateVDiskWizard.this.ssports = (Vector)CreateVDiskWizard.this.vdiskData.get(CreateVDiskSelectHostPortsStep.SUBSYSTEM_DATA);
            CreateVDiskWizard.access$702(CreateVDiskWizard.this, new String[CreateVDiskWizard.this.hostports.size()]);
            for (i = 0; i < CreateVDiskWizard.this.hostports.size(); ++i) {
                ((CreateVDiskWizard)CreateVDiskWizard.this).hostportWWPNs[i] = ((GUIPort)CreateVDiskWizard.this.hostports.get(i)).getWwpn();
            }
            if (CreateVDiskWizard.this.subSystem.isTargetPortRestrictionSupported() && 4 != CreateVDiskWizard.this.subSystem.getCapabilityData().getPortsPerView() && CreateVDiskWizard.this.ssports != null) {
                CreateVDiskWizard.access$902(CreateVDiskWizard.this, new String[CreateVDiskWizard.this.ssports.size()]);
                for (i = 0; i < CreateVDiskWizard.this.ssports.size(); ++i) {
                    ((CreateVDiskWizard)CreateVDiskWizard.this).ssportWWPNs[i] = ((GUIPort)CreateVDiskWizard.this.ssports.get(i)).getWwpn();
                }
            } else {
                CreateVDiskWizard.access$902(CreateVDiskWizard.this, null);
            }
            HashMap zoneActionSteps = (HashMap)CreateVDiskWizard.this.vdiskData.get(CreateVDiskZoneActionStep.ZONE_ACTION_DATA);
            if (zoneActionSteps != null) {
                Iterator iter = zoneActionSteps.values().iterator();
                Vector vv = new Vector(zoneActionSteps.values());
                while (iter.hasNext()) {
                    int i3;
                    String[] portWWpn;
                    Vector ports;
                    BaseZoneActionStep.ZoneAction zoneAction = (BaseZoneActionStep.ZoneAction)iter.next();
                    if (zoneAction.action == 0) {
                        zoneAction.hostPorts.addAll(zoneAction.ssPorts);
                        ports = zoneAction.hostPorts;
                        portWWpn = new String[ports.size()];
                        for (i3 = 0; i3 < ports.size(); ++i3) {
                            portWWpn[i3] = ((GUIPort)ports.get(i3)).getWwpn();
                        }
                        CreateVDiskWizard.this.diskController.createZone(new ZoneRequestor(zoneAction.fabricID), zoneAction.fabricID, zoneAction.zoneset.getName(), zoneAction.zoneName, portWWpn);
                        continue;
                    }
                    if (zoneAction.action != 1) continue;
                    zoneAction.hostPorts.addAll(zoneAction.ssPorts);
                    ports = zoneAction.hostPorts;
                    portWWpn = new String[ports.size()];
                    for (i3 = 0; i3 < ports.size(); ++i3) {
                        portWWpn[i3] = ((GUIPort)ports.get(i3)).getWwpn();
                    }
                    CreateVDiskWizard.this.diskController.updateZone(new ZoneRequestor(zoneAction.fabricID), zoneAction.fabricID, zoneAction.zoneset.getName(), zoneAction.zoneName, portWWpn);
                }
            }
            if (CreateVDiskWizard.this.hostportWWPNs == null || CreateVDiskWizard.this.hostportWWPNs.length == 0) {
                CreateVDiskWizard.this.diskController.createVDisks(new GuiRequestor(){

                    public void handleResponse(short status, Response response) {
                    }
                }, size, mdiskGroupID, vdiskNames, format, vdiskType, iogroupID, mdiskIDs, vdiskQuantity, false);
            } else {
                CreateVDiskWizard.this.diskController.createVDisksAndAssignPorts(new GuiRequestor(){

                    public void handleResponse(short status, Response response) {
                    }
                }, size, mdiskGroupID, vdiskNames, format, vdiskType, iogroupID, mdiskIDs, vdiskQuantity, CreateVDiskWizard.this.ssportWWPNs, CreateVDiskWizard.this.hostportWWPNs);
            }
        }
    }
}

